/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.OptimizedObject;
import com.streamscape.sef.exchange.FabricAddress;

public abstract class AbstractFabricAddress
extends OptimizedObject
implements Comparable<AbstractFabricAddress> {
    public static final int BINARY_SIZE = 6;
    private byte domainNumber = 0;
    private byte clusterNumber = 0;
    private short nodeNumber = 0;
    private short componentNumber = 0;
    private transient FabricAddress nodeAddress = null;

    public byte getDomainNumber() {
        return this.domainNumber;
    }

    public byte getClusterNumber() {
        return this.clusterNumber;
    }

    public short getNodeNumber() {
        return this.nodeNumber;
    }

    public short getComponentNumber() {
        return this.componentNumber;
    }

    @Override
    public int compareTo(AbstractFabricAddress other) {
        if (this.domainNumber < other.domainNumber) {
            return -1;
        }
        if (this.domainNumber > other.domainNumber) {
            return 1;
        }
        if (this.clusterNumber < other.clusterNumber) {
            return -1;
        }
        if (this.clusterNumber > other.clusterNumber) {
            return 1;
        }
        if (this.nodeNumber < other.nodeNumber) {
            return -1;
        }
        if (this.nodeNumber > other.nodeNumber) {
            return 1;
        }
        if (this.componentNumber < other.componentNumber) {
            return -1;
        }
        if (this.componentNumber > other.componentNumber) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this != other) {
            if (!(other instanceof AbstractFabricAddress)) {
                return false;
            }
            AbstractFabricAddress otherAddress = (AbstractFabricAddress)other;
            return this.domainNumber == otherAddress.domainNumber && this.clusterNumber == otherAddress.clusterNumber && this.nodeNumber == otherAddress.nodeNumber && this.componentNumber == otherAddress.componentNumber;
        }
        return true;
    }

    public int hashCode() {
        return this.nodeNumber << 16 | this.componentNumber & 0xFFFF;
    }

    public boolean isNull() {
        return this.domainNumber == 0 && this.clusterNumber == 0 && this.nodeNumber == 0 && this.componentNumber == 0;
    }

    public boolean belongsToSameNode(AbstractFabricAddress other) {
        return this.domainNumber == other.domainNumber && this.clusterNumber == other.clusterNumber && this.nodeNumber == other.nodeNumber;
    }

    public boolean matchesCluster(AbstractFabricAddress other) {
        return this.domainNumber == other.domainNumber && this.clusterNumber == other.clusterNumber;
    }

    public boolean matchesCluster(byte clusterNumber) {
        return this.clusterNumber == clusterNumber;
    }

    public FabricAddress getNodeAddress() {
        if (this.nodeAddress == null) {
            this.nodeAddress = this.componentNumber == 0 ? (FabricAddress)this : new FabricAddress(this.domainNumber, this.clusterNumber, this.nodeNumber, 0);
        }
        return this.nodeAddress;
    }

    protected AbstractFabricAddress() {
    }

    protected AbstractFabricAddress(byte domainNumber, byte clusterNumber, short nodeNumber, short componentNumber) {
        this.domainNumber = domainNumber;
        this.clusterNumber = clusterNumber;
        this.nodeNumber = nodeNumber;
        this.componentNumber = componentNumber;
    }

    protected AbstractFabricAddress(byte[] binaryForm) {
        if (binaryForm.length == 6) {
            this.domainNumber = binaryForm[0];
            this.clusterNumber = binaryForm[1];
            this.nodeNumber = (short)(binaryForm[2] << 8 | binaryForm[3] & 0xFF);
            this.componentNumber = (short)(binaryForm[4] << 8 | binaryForm[5] & 0xFF);
            this.binaryForm = binaryForm;
        }
    }

    protected AbstractFabricAddress(AbstractFabricAddress nodeAddress, short componentNumber) {
        this(nodeAddress.domainNumber, nodeAddress.clusterNumber, nodeAddress.nodeNumber, componentNumber);
        this.nodeAddress = (FabricAddress)nodeAddress;
    }

    protected void setDomainNumber(byte domainNumber) {
        this.domainNumber = domainNumber;
        this.doSetNumber(() -> this.nodeAddress.setDomainNumber(domainNumber));
    }

    protected void setClusterNumber(byte clusterNumber) {
        this.clusterNumber = clusterNumber;
        this.doSetNumber(() -> this.nodeAddress.setClusterNumber(clusterNumber));
    }

    protected void setNodeNumber(short nodeNumber) {
        this.nodeNumber = nodeNumber;
        this.doSetNumber(() -> this.nodeAddress.setNodeNumber(nodeNumber));
    }

    protected void setNumbers(byte clusterNumber, short nodeNumber) {
        if (clusterNumber > 0) {
            this.clusterNumber = clusterNumber;
        }
        this.nodeNumber = nodeNumber;
        this.doSetNumber(() -> this.nodeAddress.setNumbers(clusterNumber, nodeNumber));
    }

    private void doSetNumber(Runnable setter) {
        if (this.nodeAddress != null && this.nodeAddress != this) {
            setter.run();
        }
        this.reset();
    }

    protected void setComponentNumber(short componentNumber) {
        this.componentNumber = componentNumber;
        this.reset();
    }

    protected boolean needUpdate(byte clusterNumber, short nodeNumber) {
        return this.nodeNumber != nodeNumber || clusterNumber > 0 && this.clusterNumber != clusterNumber;
    }

    @Override
    protected String toStringForm() {
        return this.domainNumber + "." + this.clusterNumber + "." + this.nodeNumber + "." + this.componentNumber;
    }

    @Override
    protected byte[] toBinaryForm() {
        byte[] binaryForm = new byte[]{this.domainNumber, this.clusterNumber, (byte)(this.nodeNumber >> 8), (byte)this.nodeNumber, (byte)(this.componentNumber >> 8), (byte)this.componentNumber};
        return binaryForm;
    }
}

