/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractExportImportOperation
extends AbstractRepositoryOperation {
    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.setAction(name);
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("IMPORT_CHOICE").addModifier(new CompoundModifier("IMPORT_CHOICE_COMP_1").addParameter(new EnumParameter("ArtifactType").addPossibleValues(FrmEntityType.CLIENT_FACTORY.getSlangName(), FrmEntityType.JDBC_FACTORY.getSlangName(), FrmEntityType.TRANSPORT_FACTORY.getSlangName(), FrmEntityType.SERVICE.getSlangName(), FrmEntityType.PACKAGE.getSlangName(), FrmEntityType.ARCHIVE.getSlangName(), FrmEntityType.EXT_ARCHIVE.getSlangName(), "sdo", FrmEntityType.EVENT_PROTOTYPE.getSlangName(), FrmEntityType.FILE_DESCRIPTOR.getSlangName(), FrmEntityType.JOB.getSlangName(), FrmEntityType.TASKLIST.getSlangName(), FrmEntityType.MLCACHE.getSlangName(), FrmEntityType.FACETS.getSlangName(), FrmEntityType.ASPECTS.getSlangName()).setCaseSensitive(false)).addParameter(new SetParameter("ArtifactNameSet").addParameter(new ExpressionParameter("ArtifactName")).addParameter((AbstractParameter)new StringParameter("NamespaceName").setRequired(false))))).addModifier(((CompoundModifier)new CompoundModifier("IMPORT_CHOICE_COMP_2").setSyntaxHint(new SyntaxHint("  ", true))).addModifier(new Modifier("OBJECT")).addParameter((AbstractParameter)new ExpressionParameter("source path", '(', ')').setCompactSyntax("(source path [, source path, ...])")).addParameter((AbstractParameter)new ExpressionParameter("target path", '(', ')').setRequired(false))));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier(this.getDirection()).addParameter(new SLFilePathParameter("Location"))).setSyntaxHintSpace());
        this.addOptionalParameters();
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
    }

    protected abstract String getDirection();

    protected void addOptionalParameters() {
        this.syntax.addModifier(new Modifier("WITH ANCESTORS", false));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        String type = statement.getParameter("ArtifactType").getValue();
        HashMap<String, List<String>> namespaceArtifactNamesMap = new HashMap<String, List<String>>();
        String targetPath = null;
        if (type != null) {
            List<String> artifactNames = SetParameter.getValue(statement, "ArtifactNameSet", "ArtifactName");
            List<String> namespaceNames = SetParameter.getValue(statement, "ArtifactNameSet", "NamespaceName");
            for (int i = 0; i < artifactNames.size(); ++i) {
                String artifactName = artifactNames.get(i);
                String namespaceName = namespaceNames.get(i);
                if (namespaceName == null || namespaceName.trim().length() == 0) {
                    namespaceName = "";
                }
                List namespaceArtifactNames = namespaceArtifactNamesMap.computeIfAbsent(namespaceName, k -> new ArrayList());
                if (artifactName.equalsIgnoreCase("ALL") || artifactName.equalsIgnoreCase("*")) {
                    namespaceArtifactNames.clear();
                    namespaceArtifactNames.add("*");
                    break;
                }
                if (namespaceArtifactNames.contains(artifactName)) continue;
                namespaceArtifactNames.add(artifactName);
            }
        } else {
            type = "object";
            targetPath = statement.getParameter("target path").getValue();
            List sourcePaths = Stream.of(statement.getParameter("source path").getValue().trim().split(",")).map(String::trim).filter(p -> p.length() > 0).collect(Collectors.toList());
            for (String sourcePath : sourcePaths) {
                this.validateSourcePath(sourcePath);
                namespaceArtifactNamesMap.put(sourcePath, Arrays.asList("*"));
            }
            if (targetPath != null && targetPath.contains("*")) {
                throw new ParsingException("Target path can not contain *.");
            }
            if (sourcePaths.size() > 1 && targetPath != null) {
                throw new ParsingException("Only one source path is allowed if there target path is specified.");
            }
        }
        return this.completeDefinition(statement, new Definition(this.getName(), type.equalsIgnoreCase("SDO") ? FrmEntityType.SEMANTIC_TYPE : FrmEntityType.slangNameToType(type), namespaceArtifactNamesMap, targetPath, statement.getParameter("Location").getValue(), statement.existsModifier("WithWait")));
    }

    private void validateSourcePath(String sourcePath) throws ParsingException {
        String sourcePathNoStar = sourcePath;
        if (sourcePath.endsWith("*")) {
            sourcePathNoStar = sourcePath.substring(0, sourcePath.length() - 1);
            if (!sourcePath.endsWith("/*")) {
                throw new ParsingException(String.format("Wildcard source %s should end with /*.", sourcePath));
            }
        }
        if (sourcePathNoStar.contains("*")) {
            throw new ParsingException(String.format("Source path %s can contain * only in the end", sourcePath));
        }
    }

    protected Definition completeDefinition(DSLStatement statement, Definition definition) throws ParsingException {
        if (statement.existsModifier("WITH ANCESTORS")) {
            if (definition.type != FrmEntityType.SEMANTIC_TYPE) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'with ancestors' is only applicable for SDO type."));
            }
            definition.withAncestors = true;
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.checkArtifactNames(definition);
        if (definition.withWait) {
            return this.doInvoke(definition, session, timeout);
        }
        SLOperationLogger.SLOperationLoggerContext currentContext = SLOperationLogger.getCurrentContext();
        FabricThreadManager.getInstance().createThread("FSYS:SLANG.ExportImport", "Exports or import artifacts.", () -> {
            com.streamscape.sef.utils.Utils.sleep(500L);
            try {
                SLOperationLogger.setCurrentContext(currentContext);
                this.doInvoke(definition, session, timeout);
                this.raiseSLMessage(null, session);
            }
            catch (Throwable exception) {
                this.processError(exception, session);
            }
            finally {
                SLOperationLogger.unsetCurrentSession(session);
            }
        }).start();
        return new PseudoSLResponse();
    }

    protected abstract SLResponse doInvoke(Definition var1, MFSession var2, long var3) throws Exception;

    protected boolean checkLocation(Definition definition, SLFileUtils file) throws Exception {
        boolean isFrmFile = definition.location.toLowerCase().endsWith(".frm");
        if (file.supportsExistsOperation()) {
            if (!isFrmFile) {
                if (!file.isDirectory()) {
                    if (file.exists()) {
                        throw new Exception("Location is not FRM file.");
                    }
                    definition.location = definition.location + ".frm";
                } else if (definition.type != FrmEntityType.ARCHIVE && definition.type != FrmEntityType.EXT_ARCHIVE) {
                    throw new Exception("Location is not FRM file.");
                }
            }
        } else if (!isFrmFile) {
            definition.location = definition.location + ".frm";
        }
        file.setFilename(definition.location);
        return definition.location.toLowerCase().endsWith(".frm");
    }

    @Override
    protected void raiseSLMessage(String message, MFSession session) {
        AbstractExportImportOperation.raiseSLMessage(new SLMessage(message, session));
        com.streamscape.sef.utils.Utils.sleep(50L);
    }

    protected void processError(Throwable exception, MFSession session) {
        try {
            this.raiseSLMessageError(Utils.formatException(exception, "\n       "), session);
            this.raiseSLMessage(null, session);
        }
        catch (Throwable error) {
            Trace.logException(this, exception, true);
            Trace.logException(this, error, true);
        }
    }

    protected static InputStream openInputStream(SLFileUtils utils, String filename) throws Exception {
        return AbstractExportImportOperation.doOpenInputStream(utils, utils.createSLFileInputStream(filename));
    }

    protected static InputStream openInputStream(SLFileUtils utils) throws Exception {
        return AbstractExportImportOperation.doOpenInputStream(utils, utils.createSLFileInputStream());
    }

    private static InputStream doOpenInputStream(SLFileUtils utils, SLFileInputStream inputStream) throws Exception {
        try {
            inputStream.open();
        }
        catch (IOException exception) {
            if (exception instanceof FileNotFoundException) {
                throw new Exception("File '" + utils.getFilename() + "' not found.");
            }
            throw new Exception("Opening file '" + utils.getFilename() + "' failed.", exception);
        }
        return new BufferedInputStream(inputStream, utils.getTransferBufferSize());
    }

    protected static String getFilename(FrmEntityType type, String artifactName) {
        return !artifactName.toLowerCase().endsWith(type.getExtension()) ? artifactName + type.getExtension() : artifactName;
    }

    protected static String getArchiveEntryName(FrmEntityType type, String name) {
        return type.getRelativePath() + File.separator + AbstractExportImportOperation.getFilename(type, name);
    }

    protected File createTempDir() throws Exception {
        return FileIOUtils.createTempDir(new File(((RuntimeContext)this.callable).getStartupDir()));
    }

    public static List<String> listMlcache(File rootDir) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FileIOUtils.directoryListRecursive(rootDir, file -> {
            if (file.getName().endsWith(".dic") || file.getName().endsWith(".mlm") || file.getName().endsWith(".swl")) {
                result.add(FrmFileReader.toFrmPath(rootDir.toPath().relativize(file.toPath()).toString()));
            }
        }, f -> true);
        return result;
    }

    protected static List<String> doListMlcache(List<String> filterNames, List<String> fileNames) throws IOException {
        return fileNames.stream().filter(fileName -> filterNames.stream().anyMatch(filterName -> fileName.contains(FrmFileReader.toFrmPath(filterName)))).collect(Collectors.toList());
    }

    public static List<String> listObjects(File baseDir, String namespace) throws IOException {
        if (namespace != null && namespace.endsWith("*")) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        File rootDir = new File(baseDir, namespace != null ? namespace : "");
        ArrayList<String> result = new ArrayList<String>();
        if (rootDir.isDirectory()) {
            FileIOUtils.directoryListRecursive(rootDir, file -> {
                if (file.getName().endsWith(".xdo")) {
                    result.add(FrmFileReader.toFrmPath(baseDir.toPath().relativize(file.toPath()).toString()));
                }
            }, f -> !f.getName().equals("sys"));
        } else if (rootDir.getName().endsWith(".xdo")) {
            result.add(FrmFileReader.toFrmPath(baseDir.toPath().relativize(rootDir.toPath()).toString()));
        }
        return result;
    }

    public static List<String> doListObjects(List<String> filterNames, List<String> fileNames) throws IOException {
        return fileNames.stream().filter(n -> {
            String fileName = new File((String)n).getName();
            return filterNames.stream().anyMatch(filterName -> n.endsWith((String)filterName) || fileName.equals(filterName) || fileName.startsWith(filterName + ".") || fileName.contains("." + filterName + "."));
        }).collect(Collectors.toList());
    }

    protected List<SemanticType> getRelatedSemanticTypes(List<URL> urls) throws Exception {
        return SemanticUtils.getRelatedSemanticTypes(urls, (FabricContext)((Object)this.callable));
    }

    protected void checkArtifactNames(Definition definition) throws Exception {
        for (Map.Entry<String, List<String>> entry : definition.namespaceArtifactNames.entrySet()) {
            this.checkArtifactNames(definition.type, entry.getValue(), entry.getKey());
        }
    }

    protected void checkArtifactNames(FrmEntityType type, List<String> artifactNames, String namespace) throws Exception {
        if (namespace != null && namespace.length() > 0 && type != FrmEntityType.OBJECT) {
            throw new Exception("Namespace can be specified for OBJECT type only.");
        }
        if (type == FrmEntityType.OBJECT) {
            if (namespace == null || namespace.length() == 0) {
                throw new Exception("Namespace should be specified for OBJECT type.");
            }
            if (namespace.startsWith("/sys") || namespace.startsWith("sys")) {
                throw new Exception("It is not allowed to import/export sys objects.");
            }
        }
        if (!AbstractExportImportOperation.isWildcard(artifactNames)) {
            for (String name : artifactNames) {
                switch (type) {
                    case CLIENT_FACTORY: 
                    case JDBC_FACTORY: 
                    case TRANSPORT_FACTORY: 
                    case SERVICE: {
                        AbstractExportImportOperation.checkArtifactName(name);
                        break;
                    }
                    case PACKAGE: {
                        Prototype prototype = AbstractExportImportOperation.checkArtifactName(name);
                        AbstractExportImportOperation.getPackageType(prototype.getModelName());
                        break;
                    }
                    case ARCHIVE: 
                    case EXT_ARCHIVE: {
                        if (name.endsWith(type.getExtension())) break;
                        throw new Exception("Invalid extension in archive name '" + name + "'.");
                    }
                    case SEMANTIC_TYPE: {
                        AbstractExportImportOperation.checkTypeName(name);
                    }
                }
            }
        }
    }

    protected static Prototype checkArtifactName(String name) throws Exception {
        return Prototype.parseName(name, false);
    }

    protected static String checkTypeName(String typeName) throws Exception {
        if (!StringUtils.validateSemanticName(typeName)) {
            throw new Exception("Semantic type name '" + typeName + "' is invalid.");
        }
        return typeName;
    }

    protected static PackageType getPackageType(String type) throws Exception {
        try {
            return PackageType.valueOf(type);
        }
        catch (IllegalArgumentException exception) {
            throw new Exception("Invalid package type '" + type + "'.");
        }
    }

    protected static boolean isWildcard(List<String> names) {
        return names.size() == 1 && names.get(0).equals("*");
    }

    protected static boolean isWildcard(String name) {
        return name != null && name.equals("*");
    }

    protected DataspaceStore getStore() {
        return (DataspaceStore)((RuntimeContext)this.callable).getDataspaceStore();
    }

    public static class Definition
    extends AbstractSLStatement {
        public FrmEntityType type;
        public Map<String, List<String>> namespaceArtifactNames;
        public String targetPath;
        public String location;
        public boolean withWait = false;
        public boolean noLoad = false;
        public Boolean global = null;
        public boolean force = false;
        public boolean enable = false;
        public boolean model = false;
        public String newName;
        public boolean noOverwrite = false;
        public boolean withAncestors = false;

        public Definition(boolean force) {
            super(null);
            this.enable = true;
            this.force = force;
        }

        protected Definition(String operationName, FrmEntityType type, Map<String, List<String>> namespaceArtifactNames, String targetPath, String location, boolean withWait) {
            super(operationName);
            this.type = type;
            this.namespaceArtifactNames = namespaceArtifactNames;
            this.targetPath = targetPath;
            this.location = location;
            this.withWait = withWait;
        }
    }

    protected static class TaskListArtifact
    extends Artifact {
        public String oid;

        public TaskListArtifact(String name, String oid, byte[] data) {
            super(FrmEntityType.TASKLIST, name, data);
            this.oid = oid;
        }

        public TaskListArtifact(String fileName, byte[] data) {
            super(FrmEntityType.TASKLIST, TaskListArtifact.extractName(fileName), data);
            this.oid = TaskListArtifact.extractOid(fileName);
        }

        public static String extractName(String fileName) {
            int iDelimiter = fileName.lastIndexOf(".");
            return iDelimiter == -1 ? fileName : fileName.substring(0, iDelimiter);
        }

        public static String extractOid(String fileName) {
            int iDelimiter = fileName.lastIndexOf(".");
            return iDelimiter == -1 ? fileName : fileName.substring(iDelimiter + 1);
        }

        @Override
        public String getFilename() {
            return AbstractExportImportOperation.getFilename(this.type, Prototype.toString(this.name, this.oid));
        }
    }

    protected static class PackageArtifact
    extends ExtArchiveArtifact {
        public Package pkg;
        public List<Artifact> jars = new ArrayList<Artifact>();

        public PackageArtifact(FrmEntityType type, String name, byte[] data) {
            super(type, name, data);
        }

        public void setPackage(Package pkg) {
            this.pkg = pkg;
        }

        public void addJar(Artifact jar) {
            this.jars.add(jar);
        }
    }

    protected static class ExtArchiveArtifact
    extends Artifact {
        public List<TypeArtifact> types = new ArrayList<TypeArtifact>();

        public ExtArchiveArtifact(FrmEntityType type, String name, byte[] data) {
            super(type, name, data);
        }

        public ExtArchiveArtifact(FrmEntityType type, String name, File file) {
            super(type, name, file);
        }

        public void addSemanticType(TypeArtifact type) {
            this.types.add(type);
        }
    }

    protected static class EventPrototypeArtifact
    extends Artifact {
        public ImmutableEventDatagram eventDatagram;
        private String filename;

        public EventPrototypeArtifact(FrmEntityType type, String name, ImmutableEventDatagram eventDatagram, String filename) {
            super(type, name);
            this.eventDatagram = eventDatagram;
            this.filename = filename;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }
    }

    protected static class TypeArtifact
    extends Artifact {
        public SemanticType semanticType;

        public TypeArtifact(FrmEntityType type, String name, SemanticType semanticType) {
            super(type, name);
            this.semanticType = semanticType;
        }
    }

    public static class Artifact {
        public FrmEntityType type;
        public String name;
        private byte[] data;
        private File file;

        public Artifact(FrmEntityType type, String name) {
            this.type = type;
            this.name = name;
        }

        public Artifact(FrmEntityType type, String name, byte[] data) {
            this(type, name);
            this.data = data;
        }

        public Artifact(FrmEntityType type, String name, File file) {
            this(type, name);
            this.file = file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getFilename() {
            return AbstractExportImportOperation.getFilename(this.type, this.name);
        }

        public String getArchiveEntryName() {
            return AbstractExportImportOperation.getArchiveEntryName(this.type, this.getFilename());
        }

        public static String toString(FrmEntityType type, String name) {
            return type.getPrintName() + " '" + name + "'";
        }

        public String toString() {
            return Artifact.toString(this.type, this.name);
        }

        public static String toCapitalizedString(FrmEntityType type, String name) {
            return StringUtils.toCapitalized(Artifact.toString(type, name));
        }

        public String toCapitalizedString() {
            return Artifact.toCapitalizedString(this.type, this.name);
        }

        public byte[] getData() throws UtilitiesException {
            if (this.data == null) {
                if (this.file == null) {
                    throw new IllegalArgumentException("Neither data of filename are specified.");
                }
                this.data = FileIOUtils.getFileContent(this.file);
            }
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public File getFile() {
            return this.file;
        }
    }

    protected static interface Function<T, R> {
        public R apply(T var1) throws Exception;
    }

    protected static interface Consumer<T> {
        public void accept(T var1) throws Exception;
    }
}

