/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.dispatcher.RequestException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterMap;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.lib.selector.SelectorInValues;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.java.AbstractSerialSupport;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.java.Utils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.Version;
import com.streamscape.sef.coherence.CoherenceAgentAdvisory;
import com.streamscape.sef.dispatcher.AbstractClientComponent;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.dispatcher.AbstractFabricDataConstraint;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.dispatcher.AbstractFabricGroupManager;
import com.streamscape.sef.dispatcher.AsyncConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ClusteredEntity;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DirectConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.DomainConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.EntityReferenceImpl;
import com.streamscape.sef.dispatcher.EventCacheReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeByteArrayOutputStream;
import com.streamscape.sef.dispatcher.ExchangeDataConstraintStore;
import com.streamscape.sef.dispatcher.ExchangeEventDispatcher;
import com.streamscape.sef.dispatcher.ExchangeEventPublisher;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExtendedEventDispatcher;
import com.streamscape.sef.dispatcher.FabricDomainConstraintImpl;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventReceiverImpl;
import com.streamscape.sef.dispatcher.FabricEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.FabricRangeConstraintImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.ModeratorImpl;
import com.streamscape.sef.dispatcher.NetworkExchangeConsumer;
import com.streamscape.sef.dispatcher.RangeConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.ReceiverReferenceImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.exchange.FabricExchange;
import com.streamscape.sef.exchange.FabricExchangeException;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.group.FabricGroupManagerException;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.EntityReference;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.ExchangeRole;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.ConnectionFactory;
import com.streamscape.sef.network.tlp.ConnectionStateHandler;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.impl.ConnectionChannelFactory;
import com.streamscape.sef.network.tlp.impl.ConnectionFactoryImpl;
import com.streamscape.sef.network.tlp.impl.ConnectionImpl;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.TLPPacketHandler;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;

abstract class AbstractExchange
extends AbstractFabricContextFactory
implements ExchangeEventPublisher {
    Integer workerPoolSize = 100;
    ThreadPoolType workerPoolType = FabricExchange.DEFAULT_WORKER_POOL_TYPE;
    Integer workerPoolSizeThreshold = 50;
    Integer workerQueueSizeThreshold = 10;
    Integer systemWorkerPoolSize = 25;
    ThreadPoolType systemWorkerPoolType = FabricExchange.DEFAULT_SYSTEM_WORKER_POOL_TYPE;
    transient long connectionTimeout = 10L;
    transient long replyTimeout = 10L;
    transient long fastReplyTimeout = 5L;
    transient long longReplyTimeout = 30L;
    transient FabricNode node;
    private transient Map<FabricAddress, FabricNode> fabricNodes;
    private transient Map<String, FabricNode> fabricNodesByName;
    transient Object fabricNodesMutex;
    transient ExchangeDataConstraintStore globalDataConstraintStore;
    transient Map<String, DomainConstraintReferenceImpl> globalDomainConstraints;
    transient Map<String, RangeConstraintReferenceImpl> globalRangeConstraints;
    transient ModeratorImpl moderator;
    transient ExchangeEventDispatcher dispatcher;
    transient Map<Integer, InternalEventListener> internalEventListeners;
    transient Map<Integer, InternalRequestListener> internalRequestListeners;
    transient FabricThreadPool systemThreadPool;
    transient JSerializer serializer;
    transient ConnectionFactory connectionFactory;
    transient long accessorMonitorInterval = 60L;
    transient AccessorMonitor accessorMonitor;
    transient Object accessorsMutex;
    transient boolean isInitialized = false;
    transient boolean isStarted = false;
    static final int DETACH_FROM_SYSPLEX_ID = 1;
    static final int CLIENT_CONNECT_ID = 2;
    static final int CLIENT_DISCONNECT_ID = 3;
    static final int CLIENT_CONNECT_CONFIRM_ID = 4;
    static final int NODE_DISCONNECT_ID = 5;
    static final int ADD_NODE_ID = 6;
    static final int REMOVE_NODE_ID = 7;
    static final int NODE_ADD_ENDPOINT_ID = 8;
    static final int NODE_REMOVE_ENDPOINT_ID = 9;
    static final int NODE_ADD_COMPONENT_ID = 10;
    static final int NODE_CHANGE_COMPONENT_ID = 11;
    static final int NODE_CHANGE_CONSUMER_ID = 12;
    static final int NODE_CHANGE_EVENT_CACHE_ID = 13;
    static final int CLIENT_ADD_ENDPOINT_ID = 14;
    static final int CLIENT_REMOVE_ENDPOINT_ID = 15;
    static final int CLIENT_CHANGE_COMPONENT_ID = 16;
    static final int CLIENT_CHANGE_CONSUMER_ID = 17;
    static final int NODE_ADD_DATA_CONSTRAINT_ID = 18;
    static final int NODE_REMOVE_DATA_CONSTRAINT_ID = 19;
    static final int NODE_CHANGE_DATA_CONSTRAINT_ID = 20;
    static final int CLIENT_ADD_DATA_CONSTRAINT_ID = 21;
    static final int CLIENT_REMOVE_DATA_CONSTRAINT_ID = 22;
    static final int CLIENT_CHANGE_DATA_CONSTRAINT_ID = 23;
    static final int ADD_REPLICATION_ENTITY_ID = 24;
    static final int REMOVE_REPLICATION_ENTITY_ID = 25;
    static final int CHANGE_REPLICATION_ENTITY_ID = 26;
    static final int NODE_GET_CACHED_EVENTS_ID = 27;
    static final int CLIENT_GET_CACHED_EVENTS_ID = 28;
    static final int UPDATE_NODE_ADDRESS_ID = 29;
    static final int PING_ID = 30;
    static final int IS_SECURITY_ENABLED_ID = 31;
    static final int SECURITY_MANAGER_OPERATION_ID = 32;
    static final int ANONYMOUS_REGISTRATION_ID = 33;
    static final int REPOSITORY_ACCESSOR_OPERATION_ID = 34;
    static final int START_ACCEPTOR_ID = 35;
    static final int STOP_ACCEPTOR_ID = 36;
    static final int EXPORT_SEMANTIC_TYPE_ID = 37;
    static final int IMPORT_SEMANTIC_TYPE_ID = 38;
    static final int EXPORT_EVENT_PROTOTYPE_ID = 39;
    static final int IMPORT_EVENT_PROTOTYPE_ID = 40;
    static final int EVENT_CONSUMER_OPERATION_ID = 41;
    static final int EVENT_CACHE_OPERATION_ID = 42;
    static final int COHERENCE_AGENT_ADVISORY_ID = 43;
    static final int CREATE_GROUP_ID = 44;
    static final int DROP_GROUP_ID = 45;
    static final int ADD_GROUP_MEMBER_ID = 46;
    static final int REMOVE_GROUP_MEMBER_ID = 47;
    static final int UPDATE_GROUPS_ID = 48;
    static final int BROADCAST_ACK_ID = 49;
    static final int CLIENT_BROADCAST_ACK_ID = 50;
    static final int USER_BROADCAST_ACK_ID = 51;
    static final int CREATE_FACTORY_CONNECTION_COMPONENT_ID = 52;
    static final int FACTORY_CONNECTION_ACCESSOR_CREATED_ID = 53;
    static final int MODERATOR_OPERATION_ID = 54;
    static final int CLIENT_KILL_ID = 55;
    static final int CLOSE_ACCESSORS_ID = 56;
    static final int GLOBAL_COUNTER_OPERATION_ID = 57;
    static final int DROPBOX_ITEM_JOIN_ID = 58;
    static final Map<Integer, String> INTERNAL_EVENT_NAMES = new HashMap<Integer, String>();
    static final byte STANDARD_EVENT = 0;
    static final byte SPECIAL_EVENT = 1;
    static final byte BROADCAST_EVENT = 2;
    static final byte BROADCAST_EVENT_SPECIAL = 3;
    static final byte DISCONNECT_EVENT = 4;
    static final byte DISCONNECT_EVENT_ACK = 5;
    static final byte TOKEN_EVENT = 6;
    static final byte LATENCY_REQUEST = 7;
    static final byte LATENCY_REPLY = 8;
    static final byte GROUP_EVENT = 9;
    static final byte HEARTBEAT_EVENT = 10;
    static final int SHORT_SIZE = 2;
    static final int INT_SIZE = 4;
    static final int LONG_SIZE = 8;
    static final int TYPE_SIZE = 1;
    static final int LENGTH_SIZE = 4;
    static final int PACKET_HEADER_SIZE = 10;
    static final int TYPED_PACKET_HEADER_SIZE = 11;
    static final int SIMPLE_INTERNAL_PACKET_HEADER_SIZE = 17;
    static final int INTERNAL_PACKET_HEADER_SIZE = 18;
    static final int GROUP_EVENT_POSITION = 3;
    static final ModeratorAdvisoryType[][] MODERATOR_ADVISORY_TYPES;
    static final byte DIAGNOSTIC_CONNECT_ID = 1;
    static final byte DIAGNOSTIC_REQUEST_ID = 2;

    AbstractExchange() {
    }

    static void addInternalEventName(int eventId, String eventName) {
        INTERNAL_EVENT_NAMES.put(eventId, "e.sys.exchange." + eventName);
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public synchronized void setWorkerPoolSize(int poolSize) throws FabricExchangeException {
        this.checkWorkerPoolSize(poolSize, "workerPoolSize");
        if (this.workerPoolSize != poolSize) {
            this.workerPoolSize = poolSize;
            this.updateConnectionFactory();
        }
    }

    public ThreadPoolType getWorkerPoolType() {
        return this.workerPoolType;
    }

    public synchronized void setWorkerPoolType(ThreadPoolType poolType) {
        if (this.workerPoolType != poolType) {
            this.workerPoolType = poolType;
            this.updateConnectionFactory();
        }
    }

    public int getWorkerPoolSizeThreshold() {
        return this.workerPoolSizeThreshold;
    }

    public int getWorkerQueueSizeThreshold() {
        return this.workerQueueSizeThreshold;
    }

    public int getSystemWorkerPoolSize() {
        return this.systemWorkerPoolSize;
    }

    public synchronized void setSystemWorkerPoolSize(int poolSize) throws FabricExchangeException {
        this.checkWorkerPoolSize(poolSize, "systemWorkerPoolSize");
        if (this.systemWorkerPoolSize != poolSize) {
            this.systemWorkerPoolSize = poolSize;
            this.updateSystemThreadPool();
        }
    }

    public ThreadPoolType getSystemWorkerPoolType() {
        return this.systemWorkerPoolType;
    }

    public synchronized void setSystemWorkerPoolType(ThreadPoolType poolType) {
        if (this.systemWorkerPoolType != poolType) {
            this.systemWorkerPoolType = poolType;
            this.updateSystemThreadPool();
        }
    }

    protected synchronized boolean initCore() throws Exception {
        boolean needSave = false;
        if (this.serializer == null) {
            this.connectionTimeout *= 1000L;
            this.replyTimeout *= 1000L;
            this.fastReplyTimeout *= 1000L;
            this.longReplyTimeout *= 1000L;
            needSave = this.initConfigurationParameters();
            this.initSerializer();
            this.initConnectionFactory();
            EmptyEvent.binaryForm = this.doPack(EmptyEvent.defaultInstance);
        }
        return needSave;
    }

    protected boolean init() throws Exception {
        boolean needSave = false;
        if (!this.isInitialized) {
            needSave = this.initCore();
            this.initSystemThreadPool();
            this.fabricNodes = new ConcurrentHashMap<FabricAddress, FabricNode>();
            this.fabricNodesByName = new ConcurrentHashMap<String, FabricNode>();
            this.fabricNodesMutex = new Object();
            this.globalDataConstraintStore = this.createDataConstraintStore();
            this.globalDomainConstraints = new ConcurrentHashMap<String, DomainConstraintReferenceImpl>();
            this.globalRangeConstraints = new ConcurrentHashMap<String, RangeConstraintReferenceImpl>();
            this.internalEventListeners = new HashMap<Integer, InternalEventListener>();
            this.internalRequestListeners = new HashMap<Integer, InternalRequestListener>();
            this.addInternalListeners();
            this.accessorsMutex = new Object();
            this.isInitialized = true;
        }
        return needSave;
    }

    boolean initConfigurationParameters() throws FabricExchangeException {
        boolean needSave = false;
        if (this.workerPoolSize == null) {
            needSave = this.logWarningOnNullParameter("workerPoolSize", 100);
            this.workerPoolSize = 100;
        }
        this.checkWorkerPoolSize(this.workerPoolSize, "workerPoolSize");
        if (this.workerPoolType == null) {
            needSave = this.logWarningOnNullParameter("workerPoolType", (Object)FabricExchange.DEFAULT_WORKER_POOL_TYPE);
            this.workerPoolType = FabricExchange.DEFAULT_WORKER_POOL_TYPE;
        }
        if (this.workerPoolSizeThreshold == null) {
            needSave = this.logWarningOnNullParameter("workerPoolSizeThreshold", 50);
            this.workerPoolSizeThreshold = 50;
        }
        if (this.workerQueueSizeThreshold == null) {
            needSave = this.logWarningOnNullParameter("workerQueueSizeThreshold", 10);
            this.workerQueueSizeThreshold = 10;
        }
        if (this.systemWorkerPoolSize == null) {
            needSave = this.logWarningOnNullParameter("systemWorkerPoolSize", 25);
            this.systemWorkerPoolSize = 25;
        }
        this.checkWorkerPoolSize(this.systemWorkerPoolSize, "systemWorkerPoolSize");
        if (this.systemWorkerPoolType == null) {
            needSave = this.logWarningOnNullParameter("systemWorkerPoolType", (Object)FabricExchange.DEFAULT_SYSTEM_WORKER_POOL_TYPE);
            this.systemWorkerPoolType = FabricExchange.DEFAULT_SYSTEM_WORKER_POOL_TYPE;
        }
        return needSave;
    }

    private void checkWorkerPoolSize(int poolSize, String parameterName) throws FabricExchangeException {
        if (poolSize <= 0) {
            throw new FabricExchangeException(6007, "Parameter '" + parameterName + "' must be positive.");
        }
    }

    boolean logWarningOnNullParameter(String parameterName, Object parameterValue) {
        return this.logWarningOnNullParameter(parameterName, parameterValue, false);
    }

    boolean logWarningOnNullParameter(String parameterName, Object parameterValue, boolean advanced) {
        this.logWarning((advanced ? "Advanced parameter" : "Parameter") + " '" + parameterName + "' is not specified. Default value '" + String.valueOf(parameterValue) + "' will be used.");
        return true;
    }

    abstract void initConnectionFactory();

    private void updateConnectionFactory() {
        this.connectionFactory.setRequestThreadPool(this.workerPoolType, this.workerPoolSize);
    }

    private void initSystemThreadPool() {
        this.systemThreadPool = FabricThreadManager.getInstance().createThreadPool(this.systemWorkerPoolType, "EXCH:System", "Executes system tasks.", this.systemWorkerPoolSize);
    }

    private void updateSystemThreadPool() {
        if (this.systemThreadPool != null) {
            this.systemThreadPool.stop();
        }
        this.initSystemThreadPool();
    }

    void initSerializer() throws FabricException {
        try {
            this.serializer = JSerializerFactory.getInstance().createSerializer("FabricExchange$serializer");
        }
        catch (Exception exception) {
            throw new ExchangeException("Initialization of JSerializer failed.", (Throwable)exception);
        }
    }

    abstract void addInternalListeners();

    void addInternalEventListener(int eventId, InternalEventListener listener) {
        listener.init(eventId, this.getInternalEventName(eventId));
        this.internalEventListeners.put(eventId, listener);
    }

    void addInternalRequestListener(int eventId, InternalRequestListener listener) {
        listener.init(eventId, this.getInternalEventName(eventId));
        this.internalRequestListeners.put(eventId, listener);
    }

    protected abstract ExchangeDataConstraintStore createDataConstraintStore();

    protected abstract boolean isRuntime();

    protected void destroy() {
        if (this.isInitialized) {
            this.connectionFactory.destroy();
            this.systemThreadPool.stop();
            this.doDestroy();
            this.isInitialized = false;
        }
    }

    protected void doDestroy() {
    }

    protected void clear() {
        this.clearFabricNodes();
        this.globalDataConstraintStore.clear();
        this.globalDomainConstraints.clear();
        this.globalRangeConstraints.clear();
    }

    protected boolean isStarted() {
        return this.isStarted;
    }

    protected void start() {
        if (!this.isStarted) {
            this.doStart();
            this.isStarted = true;
        }
    }

    abstract void doStart();

    protected void stop() {
        if (this.isStarted) {
            this.isStarted = false;
            this.doStop();
        }
    }

    void doStop() {
        this.systemThreadPool.stop();
    }

    String getDomain() {
        return AbstractExchange.getContext().getDomain();
    }

    String getSysplexPrintName() {
        return this.getSysplexPrintName("Sysplex");
    }

    String getSysplexPrintName(String prefix) {
        return prefix + " [" + this.getDomain() + "]";
    }

    FabricNode getNode() {
        return this.node;
    }

    String getNodeName() {
        return this.node.getName();
    }

    String getNodePrintName() {
        return this.node.getPrintName();
    }

    FabricAddress getNodeAddress() {
        return this.node.getFabricAddress();
    }

    int getFabricNodesNumber() {
        return this.fabricNodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMNodesNumber() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            return (int)this.fabricNodes.values().stream().filter(fabricNode -> fabricNode.getRole() == FabricNodeRole.MANAGEMENT_NODE).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FabricNode> getFabricNodes() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            return new ArrayList<FabricNode>(this.fabricNodes.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FabricNodeReference> getMNodes() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            return this.fabricNodes.values().stream().filter(node1 -> node1.getRole() == FabricNodeRole.MANAGEMENT_NODE).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<FabricAddress> getNodeAddresses() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            return new HashSet<FabricAddress>(this.fabricNodes.keySet());
        }
    }

    FabricNode getFabricNode(FabricAddress address) {
        return this.fabricNodes.get(address.getNodeAddress());
    }

    FabricNode getFabricNode(String name) {
        return this.fabricNodesByName.get(name);
    }

    boolean containsFabricNode(FabricAddress address) {
        return this.fabricNodes.containsKey(address);
    }

    boolean containsFabricNode(String name) {
        return this.fabricNodesByName.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFabricNodeInstance(FabricNode fabricNode) {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            this.fabricNodes.put(fabricNode.getFabricAddress(), fabricNode);
            this.fabricNodesByName.put(fabricNode.getName(), fabricNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFabricNodeInstance(FabricNode fabricNode) {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            this.fabricNodes.remove(fabricNode.getFabricAddress());
            this.fabricNodesByName.remove(fabricNode.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFabricNodes() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            this.fabricNodes.clear();
            this.fabricNodesByName.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recreateFabricNodes() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            com.streamscape.sef.utils.Utils.recreate(this.fabricNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inSysplex() {
        Object object = this.fabricNodesMutex;
        synchronized (object) {
            return !this.fabricNodes.isEmpty();
        }
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    ModeratorImpl getModerator() {
        return this.moderator;
    }

    abstract AbstractExchangeConnection establishConnection(LinkAddress var1, long var2) throws FabricException;

    AbstractExchangeConnection establishConnection(LinkAddress address, long timeout, byte connectionType) throws FabricException {
        this.logInfo("Connecting to " + String.valueOf(address) + "...");
        AbstractExchangeConnection result = this.createConnection(this.connectionFactory.createConnection(address, timeout, connectionType));
        result.networkConnection.open(true);
        this.logInfo("Connection to " + String.valueOf(address) + " established.");
        return result;
    }

    abstract AbstractExchangeConnection createConnection(Connection var1);

    void addComponent(AbstractFabricComponent component, boolean fromClient) {
        ComponentReferenceImpl reference = new ComponentReferenceImpl(ModeratorUtils.makeComponentFullName(this.node.getName(), component), component, fromClient);
        reference.bind(this);
        component.bind(this, reference);
        this.node.addComponent(reference);
        this.notifyOnAddComponent(reference);
        this.logInfo("Component '" + reference.getName() + "' added.");
    }

    void notifyOnAddComponent(ComponentReferenceImpl component) {
    }

    void removeComponent(FabricAddress address) {
        ComponentReferenceImpl component = this.node.removeComponent(address);
        if (component != null) {
            this.notifyOnRemoveComponent(component);
            this.logDebug("Component '" + component.getName() + "' removed.");
        }
    }

    void notifyOnRemoveComponent(ComponentReferenceImpl component) {
    }

    abstract void changeComponent(ComponentReferenceImpl var1, ModeratorAdvisoryType var2, Object var3);

    void doChangeComponent(ComponentReferenceImpl reference, ModeratorAdvisoryType type, Object parameter, boolean notifyNodes) {
        reference.update(type, parameter);
        this.notifyOnChangeComponent(new ChangeComponentData(reference.address, type, parameter), reference, notifyNodes);
    }

    abstract void notifyOnChangeComponent(ChangeComponentData var1, ComponentReferenceImpl var2, boolean var3);

    void addDirectConsumer(FabricEventDirectConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, boolean isHidden, FabricGroupLinkImpl groupLink) throws Exception {
        if (isHidden) {
            this.dispatcher.addConsumer((NamedObject)consumer.underlyingConsumer, isSystem);
        } else {
            this.addDirectConsumer(consumer, componentAddress, scope, noLocal, isSystem, groupLink);
        }
    }

    abstract void addDirectConsumer(FabricEventDirectConsumerImpl var1, FabricAddress var2, EventScope var3, boolean var4, boolean var5, FabricGroupLinkImpl var6) throws Exception;

    void addAsyncConsumer(FabricEventAsyncConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, boolean isHidden, FabricGroupLinkImpl groupLink) throws Exception {
        if (isHidden) {
            this.dispatcher.addConsumer((NamedObject)consumer.underlyingConsumer, isSystem);
        } else {
            this.addAsyncConsumer(consumer, componentAddress, scope, noLocal, isSystem, groupLink);
        }
    }

    abstract void addAsyncConsumer(FabricEventAsyncConsumerImpl var1, FabricAddress var2, EventScope var3, boolean var4, boolean var5, FabricGroupLinkImpl var6) throws Exception;

    abstract void addRequestConsumer(FabricEventRequestConsumerImpl var1, FabricAddress var2, EventScope var3, boolean var4) throws Exception;

    abstract void addReceiver(FabricEventReceiverImpl var1, FabricAddress var2, EventScope var3, boolean var4, boolean var5, FabricGroupLinkImpl var6) throws Exception;

    abstract void removeDirectConsumer(FabricEventDirectConsumerImpl var1, FabricGroupLinkImpl var2);

    abstract void removeAsyncConsumer(FabricEventAsyncConsumerImpl var1, FabricGroupLinkImpl var2);

    abstract void removeRequestConsumer(FabricEventRequestConsumerImpl var1);

    abstract void removeReceiver(FabricEventReceiverImpl var1, FabricGroupLinkImpl var2);

    abstract EndpointReferenceImpl changeConsumer(ChangeConsumerData var1);

    EndpointReferenceImpl doChangeConsumer(FabricNode fabricNode, ChangeConsumerData data, boolean notifyNodes) {
        EndpointReferenceImpl result = fabricNode.changeConsumer(data.reference);
        this.notifyOnChangeConsumer(data, notifyNodes);
        return result;
    }

    abstract void notifyOnChangeConsumer(ChangeConsumerData var1, boolean var2);

    abstract void addEventCache(Filter var1, int var2, CacheThresholdAction var3, FabricAddress var4) throws Exception;

    abstract void removeEventCache(String var1);

    EventCache getEventCache(String eventFilter) {
        EventCacheReferenceImpl result = this.node.getEventCache(eventFilter);
        if (result == null) {
            for (FabricNode fabricNode : this.getFabricNodes()) {
                result = fabricNode.getEventCache(eventFilter);
                if (result == null) continue;
                return result;
            }
            return result;
        }
        return result;
    }

    void checkEventCacheUniqueness(Filter eventFilter) throws ExchangeException {
        if (this.existsEventCache(eventFilter.toString())) {
            throw new ExchangeException(6056, "Event cache with filter '" + String.valueOf(eventFilter) + "' already exists.");
        }
    }

    boolean existsEventCache(String eventFilter) {
        return this.node.existsEventCache(eventFilter) || this.getFabricNodes().stream().anyMatch(fabricNode -> fabricNode.existsEventCache(eventFilter));
    }

    EventCacheReferenceImpl removeEventCacheReference(String eventFilter) {
        EventCacheReferenceImpl result = this.node.removeEventCache(eventFilter);
        if (result == null) {
            for (FabricNode fabricNode : this.getFabricNodes()) {
                result = fabricNode.removeEventCache(eventFilter);
                if (result == null) continue;
                return result;
            }
            return result;
        }
        return result;
    }

    void onSysplexUpdate(EntityReference entity, UpdateType updateType) {
        this.onSysplexUpdate(entity.getName(), entity.getExchangeRole(), updateType);
    }

    void onSysplexUpdate(String entity, ExchangeRole entityRole, UpdateType updateType) {
        this.onSysplexUpdate(this.getModeratorAdvisoryType(entityRole, updateType), entity);
    }

    void onSysplexUpdate(ModeratorAdvisoryType type, String entity) {
        this.onSysplexUpdate(type, entity, true);
    }

    void onSysplexUpdate(ModeratorAdvisoryType type, String entity, boolean useSystemThread) {
        this.onSysplexUpdate(type, entity, null, useSystemThread);
    }

    void onSysplexUpdate(ModeratorAdvisoryType type, String entity, String info) {
        this.onSysplexUpdate(type, entity, info, true);
    }

    void onSysplexUpdate(ModeratorAdvisoryType type, String entity, String info, boolean useSystemThread) {
        FabricModeratorAdvisory advisory = new FabricModeratorAdvisory(type, entity, info);
        if (useSystemThread) {
            this.executeInSystemThreadPool(() -> this.onSysplexUpdate(advisory));
        } else {
            this.onSysplexUpdate(advisory);
        }
    }

    private void onSysplexUpdate(FabricModeratorAdvisory advisory) {
        this.doOnUpdate(advisory, "advisory");
    }

    static ModeratorAdvisoryType getNodeDisconnectAdvisoryType(boolean normal, boolean joinInterrupted) {
        return normal ? ModeratorAdvisoryType.NODE_DISCONNECTED : (joinInterrupted ? ModeratorAdvisoryType.NODE_JOIN_INTERRUPTED : ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY);
    }

    void onCoherenceUpdate(CoherenceAgentAdvisory advisory) {
        this.executeInSystemThreadPool(() -> this.doOnCoherenceUpdate(advisory));
    }

    void onCoherenceUpdate(CoherenceAgentAdvisory advisory1, CoherenceAgentAdvisory advisory2) {
        this.executeInSystemThreadPool(() -> {
            this.doOnCoherenceUpdate(advisory1);
            this.doOnCoherenceUpdate(advisory2);
        });
    }

    private void doOnCoherenceUpdate(CoherenceAgentAdvisory advisory) {
        this.doOnUpdate(advisory, "advisory");
    }

    void onError(Throwable exception, String errorMessage) {
        this.logException(exception, true, errorMessage);
        this.executeInSystemThreadPool(() -> this.doOnUpdate(new FabricExchangeException(6011, errorMessage, exception), "exception"));
    }

    void executeInSystemThreadPool(Runnable runnable) {
        try {
            this.systemThreadPool.addTask(runnable);
        }
        catch (RejectedExecutionException exc) {
            runnable.run();
        }
    }

    private void doOnUpdate(ImmutableEventDatagram event, String eventType) {
        if (this.isStarted) {
            try {
                if (this.node != null && this.dispatcher != null) {
                    this.coalesce(event);
                    this.dispatcher.raiseEvent(event);
                }
            }
            catch (Throwable exception) {
                this.logException(exception, true, "Raising system " + eventType + " [" + event.getEventId() + "] failed.");
            }
        }
    }

    void coalesce(ImmutableEventDatagram event) {
        try {
            FabricEventSourceFactoryImpl.coalesce(event, this.node.getFabricAddress());
        }
        catch (FabricEventSourceException fabricEventSourceException) {
            // empty catch block
        }
    }

    void raiseDirectEventLocal(FabricAddress address, ImmutableEventDatagram event) throws FabricException {
        try {
            DirectConsumerReferenceImpl consumer = this.node.getDirectConsumer(address);
            if (consumer != null && this.matchesClusterEventScope(consumer, event)) {
                consumer.underlyingConsumer.processEvent(event);
            }
        }
        catch (EventDispatcherException exception) {
            throw new ExchangeException("Raising direct event [" + event.getEventId() + "] failed.", (Throwable)exception);
        }
        catch (EventException e) {
            throw new RuntimeException(e);
        }
    }

    ImmutableEventDatagram raiseRequestLocal(FabricAddress consumerAddress, ImmutableEventDatagram request) {
        RequestConsumerReferenceImpl consumer = this.getRequestConsumer(consumerAddress);
        if (consumer != null) {
            try {
                return this.raiseRequestLocal(consumer, request, 0L);
            }
            catch (RequestException exception) {
                return (FabricRequestException)exception.getCause();
            }
            catch (EventDispatcherException exception) {
                return AbstractExchange.createSourceException(exception);
            }
        }
        return new FabricEventSourceException(6041, "Request consumer not found.");
    }

    RequestConsumerReferenceImpl getRequestConsumer(FabricAddress consumerAddress) {
        return this.node.getRequestConsumer(consumerAddress);
    }

    static FabricEventSourceException createSourceException(EventDispatcherException exception) {
        return new FabricEventSourceException(exception.getCause() instanceof TimeoutException ? 6042 : 6013, (Throwable)exception);
    }

    ImmutableEventDatagram raiseRequestLocal(RequestConsumerReferenceImpl consumer, ImmutableEventDatagram request, long timeout) throws EventDispatcherException, RequestException {
        ImmutableEventDatagram reply = this.dispatcher.raiseRequest(consumer.underlyingConsumer, request, timeout);
        try {
            if (reply != null && !FabricEventSourceFactoryImpl.isCoalesced(reply)) {
                FabricEventSourceFactoryImpl.coalesce(reply, consumer.getComponentAddress());
            }
        }
        catch (FabricEventSourceException exception) {
            return exception;
        }
        return reply;
    }

    abstract ImmutableEventDatagram raiseRequest(RequestConsumerReferenceImpl var1, ImmutableEventDatagram var2, long var3) throws EventDispatcherException, RequestException, FabricException, TimeoutException;

    ExtendedEventDispatcher.ReplyConsumer createReplyConsumer(EventDatagram request, ReplyMatchStrategy matchStrategy) throws EventDispatcherException {
        return this.dispatcher.createReplyConsumer(request, matchStrategy);
    }

    abstract void addReplyConsumer(ExtendedEventDispatcher.ReplyConsumer var1, FabricAddress var2, EventScope var3) throws Exception;

    abstract void removeReplyConsumer(ExtendedEventDispatcher.ReplyConsumer var1) throws Exception;

    abstract void deliverEvent(EventDatagram var1, FabricAddress var2, EventScope var3) throws FabricException, EventException, FabricEventSourceException, FabricEventException;

    void raiseException(ExceptionEventDatagram event, EventScope scope, FabricAddress componentAddress, boolean async) {
        if (async) {
            this.systemThreadPool.addTask(() -> this.doRaiseException(event, scope, componentAddress));
        } else {
            this.doRaiseException(event, scope, componentAddress);
        }
    }

    protected void doRaiseException(ExceptionEventDatagram event, EventScope scope, FabricAddress componentAddress) {
        try {
            this.raiseEvent(event, componentAddress, scope);
        }
        catch (Throwable exception) {
            this.logException(exception, true);
            this.logError("Raising exception event [" + event.getEventId() + "] failed.");
        }
    }

    <Data> InternalEvent<Data> createInternalEvent(Data data) {
        return this.createInternalEvent(-1, data);
    }

    <Data> InternalEvent<Data> createInternalEvent(int eventId, Data data) {
        return new InternalEvent<Data>(eventId, data);
    }

    <Data> ConcurrentInternalEvent<Data> createConcurrentInternalEvent(int eventId, Data data, long iEvent) {
        return this.createConcurrentInternalEvent(eventId, data, iEvent, false);
    }

    <Data> ConcurrentInternalEvent<Data> createConcurrentInternalEvent(int eventId, Data data, long iEvent, boolean forMnode) {
        return new ConcurrentInternalEvent<Data>(eventId, data, iEvent, forMnode);
    }

    void onInternalEvent(FabricAddress sourceAddress, InternalEvent event, AbstractExchangeConnection connection) throws ExchangeException {
        if (this.isAcceptable(event)) {
            InternalEventListener listener = this.internalEventListeners.get(event.eventId);
            if (listener == null) {
                throw new ExchangeException("Unknown internal event [" + event.eventId + "] received.");
            }
            listener.logReceived(sourceAddress, event.data);
            listener.processEvent(sourceAddress, event, connection);
        }
    }

    private boolean isAcceptable(InternalEvent event) {
        return !(event instanceof ConcurrentInternalEvent) || !((ConcurrentInternalEvent)event).forMnode || this.node.getRole() == FabricNodeRole.MANAGEMENT_NODE;
    }

    InternalEvent onInternalRequest(FabricAddress sourceAddress, InternalEvent request, AbstractExchangeConnection connection) throws Exception {
        InternalRequestListener listener = this.internalRequestListeners.get(request.eventId);
        if (listener == null) {
            throw new ExchangeException("Unknown internal request [" + request.eventId + "] received.");
        }
        listener.logReceived(sourceAddress, request.data);
        InternalEvent reply = listener.onRequest(sourceAddress, request.data, connection);
        listener.logReplied(request.data);
        return reply;
    }

    <TReplyData> TReplyData raiseInternalRequest(String nodeName, int eventId, Object data) throws Exception {
        return this.raiseInternalRequest(nodeName, eventId, data, this.replyTimeout);
    }

    <TReplyData> TReplyData raiseInternalRequest(String nodeName, int eventId, Object data, long timeout) throws Exception {
        FabricAddress nodeAddress = FabricAddress.NULL;
        if (nodeName != null) {
            FabricNode fabricNode = this.getFabricNode(nodeName);
            if (fabricNode == null) {
                throw new ExchangeException(6018, "Node " + FabricNode.getPrintName(nodeName) + " not found.");
            }
            if (!fabricNode.isReady()) {
                throw new ExchangeException(6134, "Node " + FabricNode.getPrintName(nodeName) + " not ready.");
            }
            nodeAddress = fabricNode.getFabricAddress();
        }
        return this.raiseInternalRequest(nodeAddress, eventId, data, timeout);
    }

    <TReplyData> TReplyData raiseInternalRequest(FabricAddress nodeAddress, int eventId, Object data) throws Exception {
        return this.raiseInternalRequest(nodeAddress, eventId, data, this.replyTimeout);
    }

    <TReplyData> TReplyData raiseFastInternalRequest(FabricAddress nodeAddress, int eventId, Object data) throws Exception {
        return this.raiseInternalRequest(nodeAddress, eventId, data, this.fastReplyTimeout);
    }

    <TReplyData> TReplyData raiseLongInternalRequest(FabricAddress nodeAddress, int eventId, Object data) throws Exception {
        return this.raiseInternalRequest(nodeAddress, eventId, data, this.longReplyTimeout);
    }

    <TReplyData> TReplyData raiseInternalRequest(FabricAddress nodeAddress, int eventId, Object data, long timeout) throws Exception {
        return (TReplyData)this.getConnection((FabricAddress)nodeAddress).raiseInternalRequest((FabricAddress)nodeAddress, this.createInternalEvent((int)eventId, data), (long)timeout).data;
    }

    void raiseInternalEvent(FabricAddress nodeAddress, int eventId, Object data) throws FabricException {
        this.getConnection(nodeAddress).raiseInternalEvent(nodeAddress, this.createInternalEvent(eventId, data));
    }

    void logInternalRequest(FabricAddress address, InternalEvent request, String eventName) {
        if (!this.suppressLog(request.data)) {
            FabricNode fabricNode;
            FabricNode fabricNode2 = fabricNode = address.isNull() ? null : this.getFabricNode(address);
            if (fabricNode != null) {
                this.logInternalRequest(eventName, fabricNode.getName());
            } else {
                this.logInternalRequest(eventName);
            }
        }
    }

    void logInternalRequest(String eventName) {
        this.logDebug("Raising internal request [" + eventName + "]...");
    }

    void logInternalRequest(String eventName, String nodeName) {
        this.logDebug("Raising internal request [" + eventName + "] to node '" + nodeName + "'...");
    }

    void logInternalRequestError(Throwable exception, int eventId) {
        this.logException(exception, true, "Raising internal request [" + this.getInternalEventName(eventId) + "] failed.");
    }

    void logInternalReply(InternalEvent request, String eventName) {
        if (!this.suppressLog(request.data)) {
            this.logDebug("Reply on internal request [" + eventName + "] received.");
        }
    }

    void logInternalEventError(Throwable exception, int eventId) {
        this.logException(exception, true, "Raising internal event [" + this.getInternalEventName(eventId) + "] failed.");
    }

    String getInternalEventName(int eventId) {
        return INTERNAL_EVENT_NAMES.get(eventId);
    }

    boolean suppressLog(Object data) {
        return false;
    }

    NetworkConsumersStore getNetworkDispatcher(NetworkExchangeConsumer consumer) {
        AbstractFabricGroup group;
        if (consumer.getGroupName() != null && (group = (AbstractFabricGroup)this.getGroupManager().lookupGroup(consumer.getGroupName())) != null) {
            return group.getNetworkDispatcher();
        }
        return this.getNetworkDispatcher();
    }

    abstract NetworkConsumersStore getNetworkDispatcher();

    protected abstract AbstractExchangeConnection getConnection(FabricAddress var1) throws FabricException;

    byte[] doPack(ImmutableEventDatagram event) throws ExchangeException {
        byte[] eventBytes = this.serialize(event);
        return ByteBuffer.allocate(4 + eventBytes.length).putInt(eventBytes.length).put(eventBytes).array();
    }

    byte[] pack(byte eventType, FabricAddress destination, FabricAddress source, byte[] eventBytes) {
        return ByteBuffer.allocate(18 + eventBytes.length).put(eventType).put(destination.toBinary()).put(source.toBinary()).putInt(eventBytes.length).put(eventBytes).array();
    }

    byte[] serialize(ImmutableEventDatagram event) throws ExchangeException {
        try {
            return this.serializer.serialize(event);
        }
        catch (Exception exception) {
            throw new ExchangeException(3014, "Serialization of 'ImmutableEventDatagram' failed.", exception);
        }
    }

    ByteBuffer serialize(ImmutableEventDatagram event, ByteBuffer header) throws ExchangeException {
        try {
            ExchangeByteArrayOutputStream stream = new ExchangeByteArrayOutputStream(header.array());
            this.serializer.serialize(event, new DataOutputStream(stream));
            return stream.byteBuffer();
        }
        catch (Exception exception) {
            throw new ExchangeException(3014, "Serialization of 'ImmutableEventDatagram' failed.", exception);
        }
    }

    boolean isLocal(FabricAddress fabricAddress) {
        return fabricAddress.belongsToSameNode(this.node.getFabricAddress());
    }

    Class[] getParameterTypes(OperationData data) {
        return data.parameterTypes != null ? data.parameterTypes : this.getParameterTypes(data.parameters);
    }

    Class[] getParameterTypes(Object[] parameters) {
        return InternalUtils.getParameterTypes(parameters);
    }

    ModeratorAdvisoryType getModeratorAdvisoryType(ExchangeRole role, UpdateType updateType) {
        return MODERATOR_ADVISORY_TYPES[role.ordinal()][updateType.ordinal()];
    }

    DomainConstraint createDomainConstraint(String name, FabricAddress componentAddress, String description, Set<Object> values) throws Exception {
        return ((DomainConstraintReferenceImpl)this.addDataConstraint((DataConstraintReferenceCreator)(AbstractExchange)this.new DomainReferenceCreator((String)name, (FabricAddress)componentAddress, (String)description, values))).underlyingDomain;
    }

    RangeConstraint createRangeConstraint(String name, FabricAddress componentAddress, String description, Object minValue, Object maxValue) throws Exception {
        return ((RangeConstraintReferenceImpl)this.addDataConstraint((DataConstraintReferenceCreator)(AbstractExchange)this.new RangeReferenceCreator((String)name, (FabricAddress)componentAddress, (String)description, (Object)minValue, (Object)maxValue))).underlyingRange;
    }

    abstract EntityReferenceImpl addDataConstraint(DataConstraintReferenceCreator var1) throws Exception;

    void dropDomainConstraint(String name) {
        this.removeDataConstraint(name, ExchangeRole.DOMAIN_CONSTRAINT);
    }

    void dropRangeConstraint(String name) {
        this.removeDataConstraint(name, ExchangeRole.RANGE_CONSTRAINT);
    }

    abstract void removeDataConstraint(String var1, ExchangeRole var2);

    void setDomainConstraint(FabricDomainConstraintImpl.Updater updater) throws Exception {
        this.changeDataConstraint(updater, true);
    }

    void setRangeConstraint(FabricRangeConstraintImpl.Updater updater) throws Exception {
        this.changeDataConstraint(updater, true);
    }

    abstract void changeDataConstraint(AbstractFabricDataConstraint.Updater var1, boolean var2) throws Exception;

    ExchangeDataConstraintStore getDataConstraintStore() {
        return this.globalDataConstraintStore;
    }

    DataConstraintReferenceCreator createDataConstraintReferenceCreator(EntityReferenceImpl reference) {
        if (reference instanceof DomainConstraintReferenceImpl) {
            return new DomainReferenceCreator(reference);
        }
        return new RangeReferenceCreator(reference);
    }

    void addDataConstraintReference(EntityReferenceImpl reference) {
        if (reference instanceof DomainConstraintReferenceImpl) {
            this.globalDomainConstraints.put(reference.getName(), (DomainConstraintReferenceImpl)reference);
        } else if (reference instanceof RangeConstraintReferenceImpl) {
            this.globalRangeConstraints.put(reference.getName(), (RangeConstraintReferenceImpl)reference);
        }
    }

    EntityReferenceImpl removeDataConstraintReference(String name, ExchangeRole role) {
        switch (role) {
            case DOMAIN_CONSTRAINT: {
                return this.globalDomainConstraints.remove(name);
            }
            case RANGE_CONSTRAINT: {
                return this.globalRangeConstraints.remove(name);
            }
        }
        return null;
    }

    void removeDataConstraintFromStore(String name, ExchangeRole role) {
        switch (role) {
            case DOMAIN_CONSTRAINT: {
                this.getDataConstraintStore().dropDomain(name);
                break;
            }
            case RANGE_CONSTRAINT: {
                this.getDataConstraintStore().dropRange(name);
            }
        }
    }

    boolean updateDataConstraintInStore(AbstractFabricDataConstraint.Updater updater) throws EventDispatcherException, ExchangeException {
        if (updater instanceof FabricDomainConstraintImpl.Updater) {
            return this.getDataConstraintStore().setDomain((FabricDomainConstraintImpl.Updater)updater);
        }
        return this.getDataConstraintStore().setRange((FabricRangeConstraintImpl.Updater)updater);
    }

    DomainConstraint getDomainConstraint(String name) {
        return this.getDataConstraintStore().getDomainConstraint(name);
    }

    RangeConstraint getRangeConstraint(String name) {
        return this.getDataConstraintStore().getRangeConstraint(name);
    }

    abstract AbstractFabricGroupManager getGroupManager();

    abstract AbstractFabricGroup addGroupMember(String var1, ComponentReferenceImpl var2, boolean var3) throws FabricGroupManagerException;

    AbstractFabricGroup doAddGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        AbstractFabricGroup group = (AbstractFabricGroup)this.getGroupManager().lookupGroup(groupName);
        if (group == null) {
            throw new FabricGroupManagerException(6126, "Group '" + groupName + "' does not exist.");
        }
        group.addMember(component.getName());
        component.addGroup(groupName);
        this.notifyOnChangeGroupMember(46, groupName, component, notifyNodes, ModeratorAdvisoryType.GROUP_MEMBER_ADDED);
        return group;
    }

    abstract void removeGroupMember(String var1, ComponentReferenceImpl var2, boolean var3) throws FabricGroupManagerException;

    void doRemoveGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        AbstractFabricGroup group = (AbstractFabricGroup)this.getGroupManager().lookupGroup(groupName);
        if (group == null) {
            throw new FabricGroupManagerException(6126, "Group '" + groupName + "' does not exist.");
        }
        group.removeMember(component.getName());
        component.removeGroup(groupName);
        this.notifyOnChangeGroupMember(47, groupName, component, notifyNodes, ModeratorAdvisoryType.GROUP_MEMBER_REMOVED);
    }

    abstract void notifyOnChangeGroupMember(int var1, String var2, ComponentReferenceImpl var3, boolean var4, ModeratorAdvisoryType var5);

    EventFlowMap getEventFlowMap(boolean all) {
        return null;
    }

    abstract EventFlowMap getMergedEventFlowMap(boolean var1);

    <TReply> TReply invokeModeratorRequest(FabricAddress address, boolean fromLocalClient, String methodName, Object ... parameters) {
        Class[] parameterTypes;
        if (fromLocalClient) {
            Object[] newParameters = new Object[parameters.length + 1];
            System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
            parameters = newParameters;
            parameters[0] = null;
            parameterTypes = this.getParameterTypes(parameters);
            parameterTypes[0] = FabricAddress.class;
        } else {
            parameterTypes = this.getParameterTypes(parameters);
        }
        return this.invokeModeratorRequest(address, methodName, parameterTypes, parameters);
    }

    <TReply> TReply invokeModeratorRequest(FabricAddress address, String methodName, Class[] parameterTypes, Object ... parameters) {
        TReply reply = null;
        try {
            reply = (TReply)this.raiseInternalRequest(address, 54, (Object)new ModeratorOperationData(methodName, parameterTypes, parameters));
        }
        catch (Throwable exception) {
            this.logInternalEventError(exception, 54);
        }
        return reply;
    }

    void setAccessorMonitor(boolean start) {
        try {
            if (this.accessorMonitor != null) {
                if (this.accessorMonitorInterval <= 0L) {
                    this.destroyAccessorMonitor();
                } else {
                    this.accessorMonitor.setTimeout(this.accessorMonitorInterval * 1000L);
                }
            } else if (this.accessorMonitorInterval > 0L) {
                this.accessorMonitor = new AccessorMonitor(this.accessorMonitorInterval * 1000L);
                if (start) {
                    this.accessorMonitor.start();
                }
            }
        }
        catch (FabricException fabricException) {
            // empty catch block
        }
    }

    void startAccessorMonitor() {
        if (this.accessorMonitor != null) {
            this.accessorMonitor.start();
        }
    }

    void destroyAccessorMonitor() {
        if (this.accessorMonitor != null) {
            this.accessorMonitor.stop();
            this.accessorMonitor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resyncAccessors() {
        Object object = this.accessorsMutex;
        synchronized (object) {
            if (this.node != null) {
                for (AccessorReference accessor : this.node.doGetAccessors()) {
                    try {
                        if (!((AbstractComponentAccessor)accessor).doResync(true)) continue;
                        this.logInfo("Resynchronizing accessor '" + accessor.getName() + "'...");
                    }
                    catch (Throwable exception) {
                        this.logException(exception, true);
                        this.logError("Resynchronization of accessor '" + accessor.getName() + "' failed.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLocalAccessors(ComponentReferenceImpl component, List<String> accessors) {
        Object object = this.accessorsMutex;
        synchronized (object) {
            for (String accessorFullName : accessors) {
                AccessorReference accessor = component.doLookupAccessor(ModeratorUtils.extractConsumerName(accessorFullName));
                if (accessor == null) continue;
                this.logInfo("Forcibly closing accessor '" + accessor.getName() + "'...");
                ((AbstractComponentAccessor)accessor).close();
            }
        }
    }

    abstract boolean isClustered();

    boolean matchesCluster(ClusteredEntity entity) {
        return !this.isClustered() || entity.matchesCluster(this.node.getFabricAddress());
    }

    boolean matchesClusterEventScope(ClusteredEntity entity) {
        return !this.isClustered() || entity.getEventScope() != EventScope.CLUSTER || entity.matchesCluster(this.node.getFabricAddress());
    }

    boolean matchesClusterEventScope(ClusteredEntity entity, ImmutableEventDatagram event) {
        return !this.isClustered() || entity.getEventScope() != EventScope.CLUSTER || entity.matchesCluster(event);
    }

    void logException(Throwable exception, boolean printStackTrace) {
        Trace.logException(this, exception, printStackTrace);
    }

    void logException(Throwable exception, boolean printStackTrace, String message) {
        this.logException(exception, printStackTrace && !(exception instanceof ExchangeException));
        this.logError(message);
    }

    void logError(String message) {
        Trace.logError(this, message);
    }

    void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    void logWarning(String message) {
        this.logInfo("WARNING: " + message);
    }

    static {
        AbstractExchange.addInternalEventName(1, "DetachFromSysplex");
        AbstractExchange.addInternalEventName(2, "ClientConnect");
        AbstractExchange.addInternalEventName(3, "ClientDisconnect");
        AbstractExchange.addInternalEventName(4, "ClientConnectConfirm");
        AbstractExchange.addInternalEventName(5, "NodeDisconnect");
        AbstractExchange.addInternalEventName(6, "AddNode");
        AbstractExchange.addInternalEventName(7, "RemoveNode");
        AbstractExchange.addInternalEventName(8, "NodeAddEndpoint");
        AbstractExchange.addInternalEventName(9, "NodeRemoveEndpoint");
        AbstractExchange.addInternalEventName(10, "NodeAddComponent");
        AbstractExchange.addInternalEventName(11, "NodeChangeComponent");
        AbstractExchange.addInternalEventName(12, "NodeChangeConsumer");
        AbstractExchange.addInternalEventName(13, "NodeChangeEventCache");
        AbstractExchange.addInternalEventName(14, "ClientAddEndpoint");
        AbstractExchange.addInternalEventName(15, "ClientRemoveEndpoint");
        AbstractExchange.addInternalEventName(16, "ClientChangeComponent");
        AbstractExchange.addInternalEventName(17, "ClientChangeConsumer");
        AbstractExchange.addInternalEventName(18, "NodeAddDataConstraint");
        AbstractExchange.addInternalEventName(19, "NodeRemoveDataConstraint");
        AbstractExchange.addInternalEventName(20, "NodeChangeDataConstraint");
        AbstractExchange.addInternalEventName(21, "ClientAddDataConstraint");
        AbstractExchange.addInternalEventName(22, "ClientRemoveDataConstraint");
        AbstractExchange.addInternalEventName(23, "ClientChangeDataConstraint");
        AbstractExchange.addInternalEventName(24, "AddReplicationEntity");
        AbstractExchange.addInternalEventName(25, "RemoveReplicationEntity");
        AbstractExchange.addInternalEventName(26, "ChangeReplicationEntity");
        AbstractExchange.addInternalEventName(27, "NodeGetCachedEvents");
        AbstractExchange.addInternalEventName(28, "NodeGetCachedEvents");
        AbstractExchange.addInternalEventName(29, "UpdateNodeAddress");
        AbstractExchange.addInternalEventName(30, "PingRequest");
        AbstractExchange.addInternalEventName(31, "IsSecurityEnabled");
        AbstractExchange.addInternalEventName(32, "SecurityManagerOperation");
        AbstractExchange.addInternalEventName(33, "AnonymousRegistration");
        AbstractExchange.addInternalEventName(34, "RepositoryAccessorOperation");
        AbstractExchange.addInternalEventName(35, "StartAcceptor");
        AbstractExchange.addInternalEventName(36, "StopAcceptor");
        AbstractExchange.addInternalEventName(37, "ExportSemanticType");
        AbstractExchange.addInternalEventName(38, "ImportSemanticType");
        AbstractExchange.addInternalEventName(39, "ExportEventPrototype");
        AbstractExchange.addInternalEventName(40, "ImportEventPrototype");
        AbstractExchange.addInternalEventName(41, "EventConsumerOperation");
        AbstractExchange.addInternalEventName(42, "EventCacheOperation");
        AbstractExchange.addInternalEventName(43, "CoherenceAgentAdvisory");
        AbstractExchange.addInternalEventName(44, "CreateGroup");
        AbstractExchange.addInternalEventName(45, "DropGroup");
        AbstractExchange.addInternalEventName(46, "AddGroupMember");
        AbstractExchange.addInternalEventName(47, "RemoveGroupMember");
        AbstractExchange.addInternalEventName(48, "UpdateGroups");
        AbstractExchange.addInternalEventName(49, "BroadcastAck");
        AbstractExchange.addInternalEventName(50, "ClientBroadcastAck");
        AbstractExchange.addInternalEventName(51, "UserBroadcastAck");
        AbstractExchange.addInternalEventName(52, "CreateFactoryConnectionComponent");
        AbstractExchange.addInternalEventName(53, "FactoryConnectionAccessorCreated");
        AbstractExchange.addInternalEventName(54, "ModeratorOperation");
        AbstractExchange.addInternalEventName(55, "ClientKill");
        AbstractExchange.addInternalEventName(56, "CloseAccessors");
        AbstractExchange.addInternalEventName(57, "GlobalCounterOperation");
        AbstractExchange.addInternalEventName(58, "DropBoxItemJoin");
        MODERATOR_ADVISORY_TYPES = new ModeratorAdvisoryType[][]{{ModeratorAdvisoryType.COMPONENT_ADDED, ModeratorAdvisoryType.COMPONENT_REMOVED, ModeratorAdvisoryType.COMPONENT_CHANGED}, {ModeratorAdvisoryType.DIRECT_CONSUMER_ADDED, ModeratorAdvisoryType.DIRECT_CONSUMER_REMOVED, ModeratorAdvisoryType.DIRECT_CONSUMER_CHANGED}, {ModeratorAdvisoryType.ASYNC_CONSUMER_ADDED, ModeratorAdvisoryType.ASYNC_CONSUMER_REMOVED, ModeratorAdvisoryType.ASYNC_CONSUMER_CHANGED}, {ModeratorAdvisoryType.REQUEST_CONSUMER_ADDED, ModeratorAdvisoryType.REQUEST_CONSUMER_REMOVED, ModeratorAdvisoryType.REQUEST_CONSUMER_CHANGED}, {ModeratorAdvisoryType.RECEIVER_ADDED, ModeratorAdvisoryType.RECEIVER_REMOVED, ModeratorAdvisoryType.RECEIVER_CHANGED}, {ModeratorAdvisoryType.EVENT_CACHE_ADDED, ModeratorAdvisoryType.EVENT_CACHE_REMOVED, ModeratorAdvisoryType.EVENT_CACHE_CHANGED}, {ModeratorAdvisoryType.DOMAIN_CONSTRAINT_ADDED, ModeratorAdvisoryType.DOMAIN_CONSTRAINT_REMOVED, ModeratorAdvisoryType.DOMAIN_CONSTRAINT_CHANGED}, {ModeratorAdvisoryType.NUMERIC_RANGE_CONSTRAINT_ADDED, ModeratorAdvisoryType.NUMERIC_RANGE_CONSTRAINT_REMOVED, ModeratorAdvisoryType.NUMERIC_RANGE_CONSTRAINT_CHANGED}, {ModeratorAdvisoryType.DATE_RANGE_CONSTRAINT_ADDED, ModeratorAdvisoryType.DATE_RANGE_CONSTRAINT_REMOVED, ModeratorAdvisoryType.DATE_RANGE_CONSTRAINT_CHANGED}, {ModeratorAdvisoryType.REPLICATION_SOURCE_ADDED, ModeratorAdvisoryType.REPLICATION_SOURCE_REMOVED, ModeratorAdvisoryType.REPLICATION_SOURCE_CHANGED}, {ModeratorAdvisoryType.REPLICATION_TARGET_ADDED, ModeratorAdvisoryType.REPLICATION_TARGET_REMOVED, ModeratorAdvisoryType.REPLICATION_TARGET_CHANGED}};
    }

    static class EmptyEvent
    extends InternalEvent {
        static final EmptyEvent defaultInstance = new EmptyEvent();
        static byte[] binaryForm;

        private EmptyEvent() {
            super(0, null);
        }
    }

    abstract class InternalEventListener<TEventData, TConnection extends AbstractExchangeConnection>
    extends AbstractInternalListener<TEventData> {
        InternalEventListener() {
        }

        void onEvent(FabricAddress sourceAddress, TEventData data, TConnection connection) throws Exception {
        }

        void processEvent(FabricAddress sourceAddress, InternalEvent<TEventData> event, TConnection connection) {
            try {
                this.onEvent(sourceAddress, event.data, connection);
            }
            catch (Exception exception) {
                AbstractExchange.this.logException(exception, true, "Processing internal event [" + this.eventName + "] failed.");
            }
        }

        void acknowledgeBroadcast(TEventData eventData, TConnection connection, FabricAddress nodeAddress) throws FabricException {
            this.acknowledgeBroadcast(eventData, connection, nodeAddress, null);
        }

        void acknowledgeBroadcast(TEventData eventData, TConnection connection, FabricAddress nodeAddress, Object data) throws FabricException {
            this.doAcknowledgeBroadcast(eventData, connection, nodeAddress, 49, data);
        }

        void doAcknowledgeBroadcast(TEventData eventData, TConnection connection, FabricAddress nodeAddress, int eventId, Object ackData) throws FabricException {
            ((AbstractExchangeConnection)connection).raiseInternalEvent(nodeAddress, AbstractExchange.this.createInternalEvent(eventId, ackData));
            this.logReplied(eventData);
        }

        @Override
        String getRequestType() {
            return "event";
        }

        @Override
        String getReplyType() {
            return "Acknowledgement";
        }
    }

    abstract class InternalRequestListener<TRequestData, TConnection extends AbstractExchangeConnection>
    extends AbstractInternalListener<TRequestData> {
        InternalRequestListener(AbstractExchange this$0) {
        }

        abstract InternalEvent onRequest(FabricAddress var1, TRequestData var2, TConnection var3) throws Exception;

        @Override
        String getRequestType() {
            return "request";
        }

        @Override
        String getReplyType() {
            return "Reply";
        }
    }

    abstract class AbstractExchangeConnection {
        boolean isValid = true;
        boolean isDisconnected = false;
        NetworkConnectionImpl networkConnection;
        FabricAddress address;
        int latency;
        private static final int SHORT_INTERNAL_PACKET_HEADER_SIZE = 5;
        private static final int SPECIAL_INTERNAL_PACKET_HEADER_SIZE = 13;
        private final Object LATENCY_MUTEX = new Object();
        private long latencyReplyTime = 0L;

        AbstractExchangeConnection(Connection networkConnection) {
            if (networkConnection != null) {
                this.networkConnection = (NetworkConnectionImpl)networkConnection;
                this.networkConnection.exchangeConnection = this;
                this.networkConnection.setPacketHandler(this.createPacketHandler());
            }
        }

        String getNodeName() {
            return AbstractExchange.this.getNodeName();
        }

        LinkAddress getLinkAddress() {
            return this.networkConnection.getLinkAddress();
        }

        Address getNetworkAddress() {
            return this.networkConnection.getAddress();
        }

        boolean isOpened() {
            return this.networkConnection.isOpened();
        }

        boolean isSuitableForBroadcast(FabricAddress excludedAddress) {
            return this.isOpened() && this.isValid && (excludedAddress == null || !this.address.equals(excludedAddress));
        }

        abstract PacketHandler createPacketHandler();

        void bind(FabricAddress address) {
            this.address = address;
        }

        void close(boolean isNormal) {
            this.networkConnection.close(isNormal);
        }

        void raiseInternalEvent(FabricAddress address, InternalEvent event) throws FabricException {
            this.raiseInternalEvent(AbstractExchange.this.pack((byte)0, address, this.getSourceAddress(), AbstractExchange.this.serialize(event)));
        }

        void raiseInternalAck(FabricAddress address, InternalEvent event) throws FabricException {
            this.raiseInternalEvent(AbstractExchange.this.pack((byte)0, address, this.getSourceAddress(), AbstractExchange.this.serialize(event)));
        }

        void raiseInternalEventShort(byte eventType, byte[] eventBytes) throws FabricException {
            ByteBuffer packet = ByteBuffer.allocate(5 + eventBytes.length);
            packet.put(eventType).putInt(eventBytes.length).put(eventBytes);
            this.raiseInternalEvent(packet.array());
        }

        void raiseInternalEventSpecial(byte eventType, String nodeName, InternalEvent event) throws FabricException {
            byte[] destination = nodeName.getBytes();
            byte[] source = AbstractExchange.this.node.getName().getBytes();
            byte[] eventBytes = AbstractExchange.this.serialize(event);
            ByteBuffer packet = ByteBuffer.allocate(13 + destination.length + source.length + eventBytes.length).put(eventType).putInt(destination.length).put(destination).putInt(source.length).put(source).putInt(eventBytes.length).put(eventBytes);
            this.raiseInternalEvent(packet.array());
        }

        void raiseInternalEvent(byte[] packet) throws FabricException {
            this.networkConnection.send(packet);
        }

        void raiseInternalEvent(ByteBuffer packet) throws FabricException {
            this.networkConnection.send(packet);
        }

        <TReplyData> TReplyData raiseInternalRequest(int eventId, Object data) throws Exception {
            InternalEvent<TReplyData> reply = this.raiseInternalRequest(AbstractExchange.this.createInternalEvent(eventId, data));
            return reply != null ? (TReplyData)reply.data : null;
        }

        <TReplyData> InternalEvent<TReplyData> raiseInternalRequest(InternalEvent request) throws Exception {
            return this.raiseInternalRequest(FabricAddress.NULL, request, AbstractExchange.this.replyTimeout);
        }

        <TReplyData> TReplyData raiseLongInternalRequest(int eventId, Object data) throws Exception {
            return this.raiseInternalRequest(eventId, data, AbstractExchange.this.longReplyTimeout);
        }

        <TReplyData> TReplyData raiseInternalRequest(int eventId, Object data, long timeout) throws Exception {
            return this.raiseInternalRequest(FabricAddress.NULL, eventId, data, timeout);
        }

        <TReplyData> TReplyData raiseInternalRequest(FabricAddress address, int eventId, Object data, long timeout) throws Exception {
            InternalEvent<TReplyData> reply = this.raiseInternalRequest(address, AbstractExchange.this.createInternalEvent(eventId, data), timeout);
            return reply != null ? (TReplyData)reply.data : null;
        }

        <TReplyData> InternalEvent<TReplyData> raiseInternalRequest(FabricAddress address, InternalEvent request, long timeout) throws Exception {
            return this.raiseInternalRequest(address, request, timeout, this.packRequest(request, timeout, 17, header -> header.put(address.toBinary()).put((byte)0).put(this.getSourceAddress().toBinary())));
        }

        FabricAddress getSourceAddress() {
            return AbstractExchange.this.node.getFabricAddress();
        }

        <TReplyData> InternalEvent<TReplyData> raiseInternalRequest(FabricAddress address, InternalEvent request, long timeout, Pair<Long, ByteBuffer> packet) throws Exception {
            return this.processInternalReply(this.getEventName(address, request), request, this.raiseRequestDirect(packet, timeout));
        }

        private String getEventName(FabricAddress address, InternalEvent request) {
            String eventName = AbstractExchange.this.getInternalEventName(request.eventId);
            AbstractExchange.this.logInternalRequest(address, request, eventName);
            return eventName;
        }

        private <TReplyData> InternalEvent<TReplyData> processInternalReply(String eventName, InternalEvent request, ImmutableEventDatagram reply) throws Exception {
            if (reply instanceof FabricRequestException) {
                throw (FabricException)((FabricRequestException)reply).getCause();
            }
            if (reply instanceof FabricEventSourceException) {
                Throwable cause = ((FabricEventSourceException)reply).getCause();
                if (cause instanceof FabricException) {
                    throw (FabricException)cause;
                }
                if (cause instanceof SecurityManagerException) {
                    throw (SecurityManagerException)cause;
                }
                throw new ExchangeException("Raising internal request [" + eventName + "] failed.", cause);
            }
            AbstractExchange.this.logInternalReply(request, eventName);
            return (InternalEvent)reply;
        }

        ImmutableEventDatagram raiseRequest(FabricAddress address, ImmutableEventDatagram request, long timeout) throws FabricException, TimeoutException {
            return this.raiseRequestDirect(this.packRequest(request, timeout, 10, header -> header.put(address.toBinary())), timeout);
        }

        ImmutableEventDatagram raiseRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
            return this.unpackEvent(this.networkConnection.sendRequest(packet, timeout));
        }

        ImmutableEventDatagram raiseRequestDirect(Pair<Long, ByteBuffer> packet, long timeout) throws FabricException, TimeoutException {
            return this.unpackEvent(this.networkConnection.sendRequestDirect((Long)packet.first, (ByteBuffer)packet.second, timeout));
        }

        byte[] raiseRoutedRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
            return this.networkConnection.sendRequest(packet, timeout);
        }

        ImmutableEventDatagram publishRequestDirect(Pair<Long, ByteBuffer> packet) throws FabricException, FabricEventSourceException, FabricEventException {
            this.checkPublishReply(this.networkConnection.publishRequestDirect((Long)packet.first, (ByteBuffer)packet.second));
            return null;
        }

        private void checkPublishReply(byte[] reply) throws ExchangeException, FabricEventSourceException, FabricEventException {
            if (reply != null) {
                ImmutableEventDatagram event = this.unpackEvent(reply);
                if (event instanceof FabricEventSourceException) {
                    throw (FabricEventSourceException)event;
                }
                if (event instanceof FabricEventException) {
                    throw (FabricEventException)event;
                }
                throw new ExchangeException("Unexpected unknown exception.");
            }
        }

        byte[] publishRoutedRequest(byte[] packet) throws FabricException {
            return this.networkConnection.publishRequest(packet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void calculateLatency() throws Exception {
            ArrayList<Integer> latencies = new ArrayList<Integer>();
            byte[] eventBytes = new byte[1];
            for (int i = 0; i < 5; ++i) {
                this.latencyReplyTime = 0L;
                long latencyRequestTime = System.nanoTime();
                this.raiseInternalEventShort((byte)7, eventBytes);
                Object object = this.LATENCY_MUTEX;
                synchronized (object) {
                    while (this.networkConnection.isOpened() && this.latencyReplyTime == 0L) {
                        try {
                            this.LATENCY_MUTEX.wait();
                        }
                        catch (InterruptedException exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                }
                latencies.add((int)((this.latencyReplyTime - latencyRequestTime) / 2000L));
            }
            this.latency = (int)com.streamscape.sef.utils.Utils.calculateMeanValue(latencies);
        }

        void onLatencyRequest() throws FabricException {
            this.raiseInternalEventShort((byte)8, new byte[1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onLatencyReply() {
            Object object = this.LATENCY_MUTEX;
            synchronized (object) {
                this.latencyReplyTime = System.nanoTime();
                this.LATENCY_MUTEX.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelLatencyCalculation() {
            Object object = this.LATENCY_MUTEX;
            synchronized (object) {
                this.LATENCY_MUTEX.notifyAll();
            }
        }

        byte[] pack(ImmutableEventDatagram event) throws ExchangeException {
            return event instanceof EmptyEvent ? EmptyEvent.binaryForm : AbstractExchange.this.doPack(event);
        }

        Pair<Long, ByteBuffer> packRequest(ImmutableEventDatagram event, long timeout, int headerSize, Consumer<ByteBuffer> headerUpdater) throws FabricException, TimeoutException {
            Pair<Long, ByteBuffer> header = this.networkConnection.createPacketForSendRequest(timeout, headerSize);
            headerUpdater.accept((ByteBuffer)header.second);
            header.second = this.doPackRequestOrReply((ByteBuffer)header.second, headerSize, event);
            return header;
        }

        ByteBuffer packReply(long requestId, ImmutableEventDatagram event) throws ExchangeException {
            ByteBuffer header = this.networkConnection.createPacketForSendReply(requestId, 4);
            return this.doPackRequestOrReply(header, 4, event);
        }

        ByteBuffer packReply(long requestId, byte[] reply) throws ExchangeException {
            return this.networkConnection.createPacketForSendReply(requestId, reply.length).put(reply);
        }

        private ByteBuffer doPackRequestOrReply(ByteBuffer header, int headerSize, ImmutableEventDatagram event) throws ExchangeException {
            int iBodyLength = header.limit() - headerSize - 4;
            int iEventLength = header.limit() - 4;
            ByteBuffer packet = AbstractExchange.this.serialize(event, header);
            int eventBytesLength = packet.limit() - header.limit();
            return packet.putInt(iBodyLength, headerSize + eventBytesLength).putInt(iEventLength, eventBytesLength);
        }

        ImmutableEventDatagram unpackEvent(ByteBuffer buffer) throws ExchangeException {
            return (ImmutableEventDatagram)this.unpack(buffer);
        }

        ImmutableEventDatagram unpackEvent(byte[] packet) throws ExchangeException {
            return this.unpackEvent(ByteBuffer.wrap(packet));
        }

        InternalEvent unpackInternalEvent(ByteBuffer buffer) throws ExchangeException {
            try {
                return (InternalEvent)this.unpack(buffer);
            }
            catch (ExchangeException exception) {
                throw new ExchangeException("Possible protocol version incompatibility.", (Throwable)exception);
            }
        }

        EventScope unpackEventScope(ByteBuffer buffer) throws ExchangeException {
            try {
                return EventScope.values()[buffer.getInt()];
            }
            catch (Exception exception) {
                throw new ExchangeException("Deserialization of EventScope failed.", (Throwable)exception);
            }
        }

        FabricAddress unpackAddress(ByteBuffer buffer) throws ExchangeException {
            this.checkPacketFormat(buffer.remaining() >= 6);
            byte[] addressBinaryForm = new byte[6];
            buffer.get(addressBinaryForm);
            return new FabricAddress(addressBinaryForm);
        }

        private Object unpack(ByteBuffer buffer) throws ExchangeException {
            return this.deserialize(this.unpackObjectBytes(buffer));
        }

        byte[] unpackObjectBytes(ByteBuffer buffer) throws ExchangeException {
            this.checkPacketFormat(buffer.remaining() >= 4);
            int objectLength = buffer.getInt();
            this.checkPacketFormat(buffer.remaining() >= objectLength);
            byte[] objectBytes = new byte[objectLength];
            buffer.get(objectBytes);
            return objectBytes;
        }

        void checkPacketFormat(boolean condition) throws ExchangeException {
            if (!condition) {
                throw new ExchangeException("Invalid packet format.");
            }
        }

        private Object deserialize(byte[] bytes) throws ExchangeException {
            try {
                return AbstractExchange.this.serializer.deserialize(bytes);
            }
            catch (Exception exception) {
                throw new ExchangeException(3015, "Deserialization of packet failed.", exception);
            }
        }
    }

    static class NetworkConnectionImpl
    extends ConnectionImpl {
        AbstractExchangeConnection exchangeConnection;

        NetworkConnectionImpl(ExchangeConnectionFactory factory, ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionStateHandler stateHandler) throws FabricException {
            super(factory, clientChannel, serverChannel, stateHandler);
        }

        @Override
        protected LinkAddress getLinkAddress() {
            return super.getLinkAddress();
        }

        @Override
        protected String getNodeName() {
            return this.exchangeConnection.getNodeName();
        }
    }

    static class ChangeComponentData
    extends CloneableDataObject {
        FabricAddress address;
        ModeratorAdvisoryType type;
        Object parameter;

        ChangeComponentData(FabricAddress address, ModeratorAdvisoryType type, Object parameter) {
            this.address = address;
            this.type = type;
            this.parameter = parameter;
        }
    }

    static class ChangeConsumerData
    extends CloneableDataObject {
        EndpointReferenceImpl reference;
        boolean deepChange;

        ChangeConsumerData(EndpointReferenceImpl reference, boolean deepChange) {
            this.reference = reference;
            this.deepChange = deepChange;
        }
    }

    static enum UpdateType {
        ADD,
        REMOVE,
        CHANGE;

    }

    static class InternalEvent<Data>
    extends PseudoEvent {
        int eventId;
        Data data;

        InternalEvent(int eventId, Data data) {
            this.eventId = eventId;
            this.data = data;
        }
    }

    static class ConcurrentInternalEvent<Data>
    extends InternalEvent<Data> {
        long iEvent;
        boolean forMnode;

        ConcurrentInternalEvent(int eventId, Data data, long iEvent, boolean forMnode) {
            super(eventId, data);
            this.iEvent = iEvent;
            this.forMnode = forMnode;
        }
    }

    class NetworkConsumersStore {
        FilterMap<NetworkExchangeConsumer> consumers = new FilterMap();

        NetworkConsumersStore() {
        }

        synchronized void addConsumer(NetworkExchangeConsumer consumer) {
            this.initSelectorExpression(consumer);
            this.consumers.put(consumer.getCompositeFilter(), consumer);
        }

        private void initSelectorExpression(NetworkExchangeConsumer consumer) {
            consumer.initSelectorExpression(new SelectorExternalDataSource(){

                @Override
                public SelectorInValues getInValues() {
                    return AbstractExchange.this.getDataConstraintStore();
                }

                @Override
                public Moderator getModerator() {
                    return AbstractExchange.this.moderator;
                }
            });
        }

        synchronized void removeConsumer(NetworkExchangeConsumer consumer) {
            this.consumers.remove(consumer.getCompositeFilter(), consumer);
        }

        synchronized void changeConsumer(NetworkExchangeConsumer consumer) {
            this.addConsumer(consumer);
        }

        synchronized void clear() {
            this.consumers.clear();
        }

        synchronized Collection<NetworkExchangeConsumer> getConsumers(ImmutableEventDatagram event) {
            return this.consumers.get(event.getEventId());
        }

        Collection<NetworkExchangeConsumer> getConsumersWithCheckCluster(ImmutableEventDatagram event, EventScope eventScope) {
            Collection<NetworkExchangeConsumer> result = this.getConsumers(event);
            if (result != null && eventScope == EventScope.CLUSTER) {
                result.removeIf(consumer -> !consumer.matchesCluster(event));
            }
            return result != null && !result.isEmpty() ? result : null;
        }
    }

    static class OperationData
    extends CloneableDataObject {
        String methodName;
        Object[] parameters;
        Class[] parameterTypes;

        OperationData(String methodName, Object ... parameters) {
            this.methodName = methodName;
            this.parameters = parameters;
        }

        OperationData(String methodName, Class[] parameterTypes, Object[] parameters) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.parameters = parameters;
        }
    }

    class DomainReferenceCreator
    extends DataConstraintReferenceCreator {
        Set<Object> values;

        DomainReferenceCreator(EntityReferenceImpl reference) {
            super(reference);
        }

        DomainReferenceCreator(String name, FabricAddress componentAddress, String description, Set<Object> values) {
            super(name, componentAddress, description);
            this.values = values;
        }

        @Override
        void doProcessReference() throws EventDispatcherException, ExchangeException {
            AbstractExchange.this.getDataConstraintStore().addDomain(((DomainConstraintReferenceImpl)this.reference).underlyingDomain);
        }

        @Override
        EntityReferenceImpl doCreateReference() throws EventDispatcherException, ExchangeException {
            return new DomainConstraintReferenceImpl(AbstractExchange.this.getDataConstraintStore().createDomainConstraint(this.name, this.description, this.values), this.componentAddress);
        }

        @Override
        void drop() {
            AbstractExchange.this.getDataConstraintStore().dropDomain(this.reference.getName());
        }
    }

    static abstract class DataConstraintReferenceCreator {
        EntityReferenceImpl reference;
        String name;
        FabricAddress componentAddress;
        String description;

        DataConstraintReferenceCreator(EntityReferenceImpl reference) {
            this.reference = reference;
        }

        DataConstraintReferenceCreator(String name, FabricAddress componentAddress, String description) {
            this.name = name;
            this.componentAddress = componentAddress;
            this.description = description;
        }

        EntityReferenceImpl create() throws EventDispatcherException, ExchangeException {
            if (this.reference != null) {
                this.doProcessReference();
            } else {
                this.reference = this.doCreateReference();
            }
            return this.reference;
        }

        abstract void doProcessReference() throws EventDispatcherException, ExchangeException;

        abstract EntityReferenceImpl doCreateReference() throws EventDispatcherException, ExchangeException;

        abstract void drop();
    }

    class RangeReferenceCreator
    extends DataConstraintReferenceCreator {
        Object minValue;
        Object maxValue;

        RangeReferenceCreator(EntityReferenceImpl reference) {
            super(reference);
        }

        RangeReferenceCreator(String name, FabricAddress componentAddress, String description, Object minValue, Object maxValue) {
            super(name, componentAddress, description);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        void doProcessReference() throws EventDispatcherException, ExchangeException {
            AbstractExchange.this.getDataConstraintStore().addRange(((RangeConstraintReferenceImpl)this.reference).underlyingRange);
        }

        @Override
        EntityReferenceImpl doCreateReference() throws EventDispatcherException, ExchangeException {
            return new RangeConstraintReferenceImpl(AbstractExchange.this.getDataConstraintStore().createRangeConstraint(this.name, this.description, this.minValue, this.maxValue), this.componentAddress);
        }

        @Override
        void drop() {
            AbstractExchange.this.getDataConstraintStore().dropRange(this.reference.getName());
        }
    }

    static class ModeratorOperationData
    extends OperationData {
        boolean generic;

        ModeratorOperationData(String methodName, Class[] parameterTypes, Object ... parameters) {
            this(false, methodName, parameterTypes, parameters);
        }

        ModeratorOperationData(boolean generic, String methodName, Class[] parameterTypes, Object ... parameters) {
            super(methodName, parameterTypes, parameters);
            this.generic = generic;
        }
    }

    class AccessorMonitor
    extends MonitorWorker {
        AccessorMonitor(long timeout) throws FabricException {
            super("EXCH:AccessorMonitor", "Monitors a state of all accessors.", timeout);
        }

        @Override
        protected void doExecute() throws FabricException {
            AbstractExchange.this.resyncAccessors();
        }
    }

    static class VersionData
    extends CloneableDataObject
    implements Comparable<VersionData> {
        private int majorVersion;
        private int minorVersion;
        private int majorBuild;
        private int minorBuild;

        VersionData(int majorVersion, int minorVersion, int majorBuild, int minorBuild) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.majorBuild = majorBuild;
            this.minorBuild = minorBuild;
        }

        static VersionData fromRuntimeVersion() {
            return new VersionData(Version.getMajorVersion(), Version.getMinorVersion(), Version.getMajorBuild(), Version.getMinorBuild());
        }

        @Override
        public int compareTo(VersionData other) {
            if (this.majorVersion < other.majorVersion) {
                return -1;
            }
            if (this.majorVersion > other.majorVersion) {
                return 1;
            }
            if (this.minorVersion < other.minorVersion) {
                return -1;
            }
            if (this.minorVersion > other.minorVersion) {
                return 1;
            }
            if (this.majorBuild < other.majorBuild) {
                return -1;
            }
            if (this.majorBuild > other.majorBuild) {
                return 1;
            }
            if (this.minorBuild < other.minorBuild) {
                return -1;
            }
            if (this.minorBuild > other.minorBuild) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return Version.formatVersionWithBuild(this.majorVersion, this.minorVersion, this.majorBuild, this.minorBuild);
        }
    }

    static enum GlobalCounterOperation {
        NEXT,
        SHOW,
        RESET;

    }

    static class GroupMemberData
    extends CloneableDataObject {
        String groupName;
        FabricAddress memberAddress;

        GroupMemberData(String groupName, FabricAddress memberAddress) {
            this.groupName = groupName;
            this.memberAddress = memberAddress;
        }
    }

    static class ImportEventPrototypeData
    extends CloneableDataObject {
        String eventId;
        Map<String, Long> archiveTimestamps;

        ImportEventPrototypeData(String eventId, Map<String, Long> archiveTimestamps) {
            this.eventId = eventId;
            this.archiveTimestamps = archiveTimestamps;
        }
    }

    static class ImportSemanticTypeData
    extends CloneableDataObject {
        Set<SemanticType> types;
        Map<String, Pair<byte[], Long>> archives;

        ImportSemanticTypeData(Set<SemanticType> types, Map<String, Pair<byte[], Long>> archives) {
            this.types = types;
            this.archives = archives;
        }
    }

    static class EventPrototypeData
    extends CloneableDataObject {
        Prototype prototype;
        ImmutableEventDatagram event;

        EventPrototypeData(Prototype prototype, ImmutableEventDatagram event) {
            this.prototype = prototype;
            this.event = event;
        }

        EventPrototypeData(Pair<Prototype, ImmutableEventDatagram> data) {
            this((Prototype)data.first, (ImmutableEventDatagram)data.second);
        }
    }

    static class ChangeAcceptorData
    extends CloneableDataObject {
        FabricAddress nodeAddress;
        LinkAddress linkAddress;

        ChangeAcceptorData(FabricAddress nodeAddress, LinkAddress linkAddress) {
            this.nodeAddress = nodeAddress;
            this.linkAddress = linkAddress;
        }
    }

    static class ClientGetCachedEventsRequestData
    extends CloneableDataObject {
        CompositeFilter filter;
        EventScope scope;

        ClientGetCachedEventsRequestData(CompositeFilter filter, EventScope scope) {
            this.filter = filter;
            this.scope = scope;
        }
    }

    static class AnonymousRegistrationRequestData
    extends CloneableDataObject {
        String userName;
        String password;
        String description;
        vCard vcard;

        AnonymousRegistrationRequestData(String userName, String password, String description, vCard vcard) {
            this.userName = userName;
            this.password = password;
            this.description = description;
            this.vcard = vcard;
        }
    }

    static class EndpointOperationData
    extends OperationData {
        FabricAddress address;

        EndpointOperationData(FabricAddress address, String methodName, Class[] parameterTypes, Object[] parameters) {
            super(methodName, parameterTypes, parameters);
            this.address = address;
        }
    }

    static class ReAddComponentData
    extends CloneableDataObject {
        ComponentReferenceImpl reference;
        Map<String, DirectConsumerReferenceImpl> directConsumers;
        Map<String, AsyncConsumerReferenceImpl> asyncConsumers;
        Map<String, RequestConsumerReferenceImpl> requestConsumers;
        Map<String, ReceiverReferenceImpl> receivers;

        ReAddComponentData(ComponentReferenceImpl reference) {
            this.reference = reference;
        }

        ReAddComponentData(ComponentReferenceImpl reference, Collection<DirectConsumerReferenceImpl> directConsumers, Collection<AsyncConsumerReferenceImpl> asyncConsumers, Collection<RequestConsumerReferenceImpl> requestConsumers, Collection<ReceiverReferenceImpl> receivers) {
            this(reference);
            this.directConsumers = ReAddComponentData.convert(directConsumers);
            this.asyncConsumers = ReAddComponentData.convert(asyncConsumers);
            this.requestConsumers = ReAddComponentData.convert(requestConsumers);
            this.receivers = ReAddComponentData.convert(receivers);
        }

        private static <T extends EndpointReferenceImpl> Map<String, T> convert(Collection<T> values) {
            HashMap<String, EndpointReferenceImpl> result = null;
            if (values != null) {
                result = new HashMap<String, EndpointReferenceImpl>();
                for (EndpointReferenceImpl value : values) {
                    result.put(ModeratorUtils.extractConsumerName(value.getName()), value);
                }
            }
            return result;
        }

        ReAddComponentData copyWithGlobalScope() {
            ReAddComponentData result = this;
            if (this.reference.eventScope == EventScope.GLOBAL) {
                result = new ReAddComponentData(this.reference);
                result.directConsumers = ReAddComponentData.copyWithGlobalScope(this.directConsumers);
                result.asyncConsumers = ReAddComponentData.copyWithGlobalScope(this.asyncConsumers);
                result.requestConsumers = ReAddComponentData.copyWithGlobalScope(this.requestConsumers);
                result.receivers = ReAddComponentData.copyWithGlobalScope(this.receivers);
            }
            return result;
        }

        private static <T extends EndpointReferenceImpl> Map<String, T> copyWithGlobalScope(Map<String, T> consumers) {
            if (consumers != null) {
                HashMap result = new HashMap();
                consumers.entrySet().stream().filter(entry -> ((EndpointReferenceImpl)entry.getValue()).getEventScope() == EventScope.GLOBAL).forEach(entry -> result.put((String)entry.getKey(), (EndpointReferenceImpl)entry.getValue()));
                return result;
            }
            return consumers;
        }
    }

    static class ClientConnectReplyData
    extends CloneableDataObject {
        String domain;
        UUID fabricUid;
        AbstractClientComponent component;
        ReAddComponentData reAddData;
        User currentUser;
        List<FabricNode> fabricNodes;
        List<FabricGroup> fabricGroups;
        Map<String, DomainConstraintReferenceImpl> domainConstraints;
        Map<String, RangeConstraintReferenceImpl> rangeConstraints;
        String hostTimezone;
        String nodeTimezone;
        String ccsid;
        String banner;
        String nodeName;

        ClientConnectReplyData(String domain, UUID fabricUid, AbstractClientComponent component, ReAddComponentData reAddData, User currentUser, TimeZone hostTimezone, TimeZone nodeTimezone, Charset ccsid) {
            this.domain = domain;
            this.fabricUid = fabricUid;
            this.component = component;
            this.reAddData = reAddData;
            this.currentUser = currentUser;
            this.hostTimezone = hostTimezone.getID();
            this.nodeTimezone = nodeTimezone.getID();
            this.ccsid = ccsid.name();
        }
    }

    static class ClientConnectRequestData
    extends CloneableDataObject {
        VersionData version;
        String domain;
        UUID fabricUid;
        AbstractClientComponent component;
        ReAddComponentData reAddData;
        boolean forSlangTool;
        boolean anonymous;
        String userName;
        String digest;

        ClientConnectRequestData(VersionData version, String domain, UUID fabricUid, AbstractClientComponent component, boolean forSlangTool) {
            this(version, domain, fabricUid, component, null, forSlangTool, true);
        }

        ClientConnectRequestData(VersionData version, String domain, UUID fabricUid, AbstractClientComponent component, ReAddComponentData reAddData, boolean forSlangTool, String userName, String digest) {
            this(version, domain, fabricUid, component, reAddData, forSlangTool, false);
            this.userName = userName;
            this.digest = digest;
        }

        private ClientConnectRequestData(VersionData version, String domain, UUID fabricUid, AbstractClientComponent component, ReAddComponentData reAddData, boolean forSlangTool, boolean anonymous) {
            this.version = version;
            this.domain = domain;
            this.fabricUid = fabricUid;
            this.component = component;
            this.reAddData = reAddData;
            this.forSlangTool = forSlangTool;
            this.anonymous = anonymous;
        }
    }

    static class LinkAddressSerialSupport
    extends AbstractSerialSupport {
        LinkAddressSerialSupport() {
        }

        @Override
        public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
            Utils.serialize(obj.toString(), output);
        }

        @Override
        public Object instantiate(DataInputStream input, JSerializer factory) throws JSerializerException {
            try {
                return new LinkAddress(Utils.deserialize(input));
            }
            catch (FabricException exception) {
                throw new JSerializerException(3015, (Throwable)exception);
            }
        }

        @Override
        public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
        }
    }

    static class FabricAddressSerialSupport
    extends AbstractSerialSupport {
        FabricAddressSerialSupport() {
        }

        @Override
        public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
        }

        @Override
        public Object instantiate(DataInputStream input, JSerializer factory) throws JSerializerException {
            byte[] addressBytes = new byte[6];
            try {
                input.readFully(addressBytes);
            }
            catch (IOException exception) {
                throw new JSerializerException(3015, (Throwable)exception);
            }
            return new FabricAddress(addressBytes);
        }

        @Override
        public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
            FabricAddress address = (FabricAddress)obj;
            try {
                output.write(address.toBinary());
            }
            catch (IOException exception) {
                throw new JSerializerException(3014, (Throwable)exception);
            }
        }
    }

    static class AddressSerialSupport
    extends AbstractSerialSupport {
        AddressSerialSupport() {
        }

        @Override
        public void serialize(Object obj, DataOutputStream output, JSerializer serializer) throws JSerializerException {
            Utils.serialize(obj.toString(), output);
        }

        @Override
        public Object instantiate(DataInputStream input, JSerializer serializer) throws JSerializerException {
            try {
                return new Address(Utils.deserialize(input));
            }
            catch (FabricException exception) {
                throw new JSerializerException(3015, (Throwable)exception);
            }
        }

        @Override
        public void deserialize(Object obj, DataInputStream input, JSerializer serializer) throws JSerializerException {
        }
    }

    static class ExchangeConnectionChannelFactory
    extends ConnectionChannelFactory {
        ExchangeConnectionChannelFactory() {
        }

        @Override
        protected TLPPacketHandler createTlpPacketHandler(ServerConnectionChannelImpl channel) throws FabricException {
            return this.createTlpPacketHandler(channel, true);
        }
    }

    static class ExchangeConnectionFactory
    extends ConnectionFactoryImpl {
        ExchangeConnectionFactory(ThreadPoolType requestThreadPoolType, int requestThreadPoolSize) {
            super(requestThreadPoolType, requestThreadPoolSize);
        }

        @Override
        protected ConnectionImpl createConnection(ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionStateHandler stateHandler) throws FabricException {
            return new NetworkConnectionImpl(this, clientChannel, serverChannel, stateHandler);
        }

        @Override
        protected ConnectionChannelFactory createConnectionChannelFactory() {
            return new ExchangeConnectionChannelFactory();
        }
    }

    static class ClientRequestConsumer
    extends RequestConsumerReferenceImpl {
        private transient AbstractExchangeConnection connection;

        ClientRequestConsumer(FabricEventRequestConsumerImpl fabricImpl, FabricAddress componentAddress, EventScope eventScope, FabricAddress address) {
            super(fabricImpl, componentAddress, eventScope, address);
        }

        void bind(AbstractExchangeConnection connection) {
            this.connection = connection;
        }

        ImmutableEventDatagram raiseRequest(FabricAddress address, ImmutableEventDatagram request, long timeout) throws FabricException, TimeoutException {
            return this.connection.raiseRequest(address, request, timeout);
        }

        byte[] raiseRoutedRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
            return this.connection.raiseRoutedRequest(packet, timeout);
        }
    }

    abstract class ConcurrentInternalEventListenerWithAck<TEventData, TConnection extends AbstractExchangeConnection>
    extends InternalEventListenerWithAck<TEventData, TConnection> {
        ConcurrentInternalEventListenerWithAck() {
        }

        @Override
        void processEvent(FabricAddress sourceAddress, InternalEvent<TEventData> event, TConnection connection) {
            Object ack = this.doProcessEvent(sourceAddress, event, connection);
            this.acknowledgeBroadcast((ConcurrentInternalEvent)event, connection, sourceAddress, ack);
        }

        @Override
        void acknowledgeBroadcast(ConcurrentInternalEvent<TEventData> event, TConnection connection, FabricAddress sourceAddress, Object ackData) {
            try {
                ((AbstractExchangeConnection)connection).raiseInternalAck(sourceAddress, AbstractExchange.this.createConcurrentInternalEvent(this.getAckEventId(), ackData, event.iEvent));
                this.logReplied(event.data);
            }
            catch (Exception exception) {
                AbstractExchange.this.logException(exception, true, "Raising acknowledgement on internal event [" + this.eventName + "] failed.");
            }
        }

        abstract int getAckEventId();
    }

    abstract class InternalEventListenerWithAck<TEventData, TConnection extends AbstractExchangeConnection>
    extends InternalEventListener<TEventData, TConnection> {
        InternalEventListenerWithAck() {
        }

        @Override
        void processEvent(FabricAddress sourceAddress, InternalEvent<TEventData> event, TConnection connection) {
            Object ack = this.doProcessEvent(sourceAddress, event, connection);
            try {
                this.acknowledgeBroadcast(event.data, connection, sourceAddress, ack);
            }
            catch (Exception exception) {
                AbstractExchange.this.logException(exception, true, "Raising acknowledgement on internal event [" + this.eventName + "] failed.");
            }
        }

        Object doProcessEvent(FabricAddress sourceAddress, InternalEvent<TEventData> event, TConnection connection) {
            try {
                return this.onEventWithAck(sourceAddress, event.data, connection);
            }
            catch (Throwable exception) {
                AbstractExchange.this.logException(exception, true, "Processing internal event [" + this.eventName + "] failed.");
                return exception;
            }
        }

        Object onEventWithAck(FabricAddress sourceAddress, TEventData data, TConnection connection) throws Exception {
            this.onEvent(sourceAddress, data, connection);
            return null;
        }
    }

    abstract class AbstractInternalListener<TEventData> {
        int eventId;
        String eventName;

        AbstractInternalListener() {
        }

        void init(int eventId, String eventName) {
            this.eventId = eventId;
            this.eventName = eventName;
        }

        void logReceived(String recipient) {
            AbstractExchange.this.logDebug("Internal " + this.getRequestType() + " '" + this.eventName + "' received" + (String)(recipient != null ? " from node " + FabricNode.getPrintName(recipient) + "." : "."));
        }

        void logReceived(FabricAddress sourceAddress, TEventData data) {
            if (!AbstractExchange.this.suppressLog(data)) {
                this.logReceived(this.getNodeName(sourceAddress, data));
            }
        }

        void logReplied(TEventData data) {
            if (!AbstractExchange.this.suppressLog(data)) {
                AbstractExchange.this.logDebug(this.getReplyType() + " on internal " + this.getRequestType() + " '" + this.eventName + "' sent.");
            }
        }

        String getNodeName(FabricAddress sourceAddress, TEventData data) {
            FabricNode fabricNode = AbstractExchange.this.getFabricNode(sourceAddress);
            return fabricNode != null ? fabricNode.getName() : null;
        }

        String getNodeRecipient(FabricAddress sourceAddress) {
            FabricNode fabricNode = AbstractExchange.this.getFabricNode(sourceAddress);
            return fabricNode != null ? "node " + fabricNode.getPrintName() + "." : "unknown node (address=" + String.valueOf(sourceAddress) + ").";
        }

        String getNodePrintName() {
            return AbstractExchange.this.getNodePrintName();
        }

        String getNodePrintName(FabricAddress sourceAddress) {
            FabricNode fabricNode = AbstractExchange.this.getFabricNode(sourceAddress);
            return fabricNode != null ? fabricNode.getFullPrintName() : null;
        }

        abstract String getRequestType();

        abstract String getReplyType();
    }

    static abstract class PseudoEvent
    extends CloneableDataObject
    implements ImmutableEventDatagram {
        PseudoEvent() {
        }

        @Override
        public String getEventId() {
            return null;
        }

        @Override
        public byte[] getEventSource() {
            return null;
        }

        @Override
        public Date getTimestamp() {
            return null;
        }

        @Override
        public byte getTransmitAccess() {
            return 0;
        }

        @Override
        public boolean getDurable() {
            return false;
        }

        @Override
        public String getEventKey() {
            return null;
        }

        @Override
        public String getEventGroupId() {
            return null;
        }

        @Override
        public ImmutableEventDatagram clone() {
            return (ImmutableEventDatagram)super.clone();
        }
    }

    static class NodeChangeEventData
    extends CloneableDataObject {
        FabricNode fabricNode;
        ModeratorAdvisoryType advisoryType;

        NodeChangeEventData(FabricNode fabricNode, ModeratorAdvisoryType advisoryType) {
            this.fabricNode = fabricNode;
            this.advisoryType = advisoryType;
        }
    }

    static class DetachFromSysplexData
    extends CloneableDataObject {
        boolean isNormal;
        boolean isShuttingDown;
        boolean joinInterrupted;

        DetachFromSysplexData(boolean isNormal, boolean isShuttingDown, boolean joinInterrupted) {
            this.isNormal = isNormal;
            this.isShuttingDown = isShuttingDown;
            this.joinInterrupted = joinInterrupted;
        }
    }
}

