/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.EventTrigger;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.dispatcher.TriggerFunctionContextImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.evtrigger.function.TriggerFunctionDisableException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionInvalidateException;
import com.streamscape.sef.evtrigger.function.TriggerScript;
import java.util.List;

abstract class AbstractEventTrigger
implements EventTrigger,
FabricEventListener {
    protected EventTriggerState state = EventTriggerState.NOT_INITIALIZED;
    protected String lastError;
    protected Exception lastErrorException;
    protected transient AbstractFabricComponent component;
    protected transient TriggerScript triggerScript;
    protected transient SinkEventFlowImpl eventFlow;
    private long executionWindowMs = -1L;
    private TriggerFunctionContextImpl.DataspaceAccessorProvider dataspaceAccessorProvider;

    protected AbstractEventTrigger(AbstractFabricComponent component) {
        this.component = component;
    }

    public void init(EventTriggerDefinition definition, RuntimeContext context) {
        this.logDebug("Initializing event trigger '" + definition.getName() + "'...");
        this.initInternal(definition, null, context);
    }

    public void init(TriggerScript triggerScript, RuntimeContext context) {
        this.logDebug("Initializing event trigger '" + triggerScript.getDefinition().getName() + "' from script...");
        this.initInternal(null, triggerScript, context);
    }

    private void initInternal(EventTriggerDefinition definition, TriggerScript triggerScript, RuntimeContext context) {
        try {
            if (triggerScript == null) {
                triggerScript = TriggerScript.parseAndCompile(definition, this.component, context);
            }
            triggerScript.validate();
            this.triggerScript = triggerScript;
            this.state = EventTriggerState.INITIALIZED;
            this.lastError = null;
            this.logDebug("Event trigger '" + triggerScript.getDefinition().getName() + "' initialized.");
        }
        catch (Exception exception) {
            this.state = EventTriggerState.INVALID;
            this.lastError = "Initialization of event trigger failed. Cause: " + exception.getMessage();
            this.lastErrorException = exception;
            this.logError(this.lastError);
        }
    }

    private void bindEvents() throws FabricEventDispatcherException {
        if (this.triggerScript.getDefinition().isAdvisoryCapable()) {
            this.component.boundEventIds.bindEventId("advisory.exec.EventTrigger", true, false);
        }
        for (String triggerEID : this.triggerScript.getDefinition().getRaisedEventIds()) {
            this.component.boundEventIds.bindEventId(triggerEID, false, false);
            this.onBindEvent(triggerEID);
        }
    }

    abstract void onBindEvent(String var1);

    private void unbindEvents() throws FabricEventDispatcherException {
        for (String triggerEID : this.triggerScript.getDefinition().getRaisedEventIds()) {
            this.component.boundEventIds.unbindEventId(triggerEID, false);
            this.onUnbindEvent(triggerEID);
        }
        if (this.triggerScript.getDefinition().isAdvisoryCapable()) {
            this.component.boundEventIds.unbindEventId("advisory.exec.EventTrigger", false);
        }
    }

    abstract void onUnbindEvent(String var1);

    @Override
    public void enable() {
        if (this.triggerScript == null) {
            throw new IllegalTriggerStateException("Trigger script is not compiled.");
        }
        if (this.state != EventTriggerState.INITIALIZED && this.state != EventTriggerState.DISABLED) {
            throw new IllegalTriggerStateException("Trigger state is not initialized. Initialize first.");
        }
        try {
            this.bindEvents();
        }
        catch (FabricEventDispatcherException exception) {
            try {
                this.unbindEvents();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.logError("Enabling event trigger '" + this.getName() + "' failed.");
            Trace.logException(this, exception, true);
            this.state = EventTriggerState.INVALID;
            this.lastError = "Binding trigger events failed. " + exception.getMessage();
            this.lastErrorException = exception;
            return;
        }
        this.state = EventTriggerState.ENABLED;
    }

    @Override
    public void disable() {
        try {
            if (this.triggerScript != null) {
                this.unbindEvents();
            }
        }
        catch (FabricEventDispatcherException exception) {
            this.state = EventTriggerState.INVALID;
            this.lastError = "Unbinding trigger events failed. " + exception.getMessage();
            this.lastErrorException = exception;
            this.logError(this.lastError);
            Trace.logException(this, exception, true);
        }
        if (this.eventFlow != null) {
            this.component.removeEventFlow(this.eventFlow);
        }
        if (this.triggerScript != null) {
            this.triggerScript.disable();
        }
        if (this.state != EventTriggerState.INVALID) {
            this.state = EventTriggerState.DISABLED;
        }
    }

    protected void setEventFlow(SinkEventFlowImpl eventFlow) {
        this.eventFlow = eventFlow;
    }

    @Override
    public synchronized void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        try {
            ImmutableEventDatagram sourceEvent = null;
            if (this.component instanceof ServiceContextImpl) {
                sourceEvent = ((ServiceContextImpl)this.component).getServicePool().getEvent();
            }
            this.triggerScript.execute(event, sourceEvent, this.executionWindowMs, this.dataspaceAccessorProvider);
        }
        catch (TriggerFunctionDisableException exception) {
            this.onDisableException();
        }
        catch (TriggerFunctionInvalidateException exception) {
            this.onInvalidateException(exception.getErrorMessage());
        }
        catch (TriggerFunctionException exception) {
            String error = this.getOnEventErrorMessage();
            this.lastError = error + " Cause: " + exception.getMessage();
            this.lastErrorException = exception;
            this.logException(exception);
            this.logError(error);
            throw new FabricEventException(error, (Throwable)exception);
        }
    }

    protected String getOnEventErrorMessage() {
        return "Trigger '" + this.getName() + "' script execution failed.";
    }

    protected abstract void onDisableException();

    protected abstract void onInvalidateException(String var1);

    @Override
    public EventTriggerState getState() {
        return this.state;
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    public Exception getLastErrorException() {
        return this.lastErrorException;
    }

    public void invalidate(String error) {
        this.state = EventTriggerState.INVALID;
        this.lastError = error;
        this.lastErrorException = null;
    }

    @Override
    public String getName() {
        return this.triggerScript.getDefinition().getName();
    }

    @Override
    public List<String> getTriggerEventIds() {
        return this.triggerScript.getDefinition().getRaisedEventIds();
    }

    @Override
    public String getEventSelector() {
        return this.triggerScript.getDefinition().getEventSelector();
    }

    @Override
    public boolean hasEventSelector() {
        return this.triggerScript.getDefinition().hasEventSelector();
    }

    @Override
    public String getActionableEventId() {
        return this.triggerScript.getDefinition().getActionableEventId();
    }

    @Override
    public boolean isAdvisoryCapable() {
        return this.triggerScript.getDefinition().isAdvisoryCapable();
    }

    @Override
    public boolean isEventCapable() {
        return this.triggerScript.getDefinition().isEventCapable();
    }

    public String toString() {
        return this.triggerScript.getDefinition().toString();
    }

    @Override
    public EventScope getEventScope() {
        return this.triggerScript.getDefinition().getEventScope();
    }

    @Override
    public TriggerActionTime getTriggerActionTime() {
        return this.triggerScript.getDefinition().getTriggerActionTime();
    }

    public void setExecutionWindowMs(long executionWindowMs) {
        this.executionWindowMs = executionWindowMs;
    }

    public long getExecutionWindowMs() {
        return this.executionWindowMs;
    }

    public AbstractEventTrigger setDataspaceAccessorProvider(TriggerFunctionContextImpl.DataspaceAccessorProvider dataspaceAccessorProvider) {
        this.dataspaceAccessorProvider = dataspaceAccessorProvider;
        return this;
    }

    protected String getEventHandlerName() {
        return this.triggerScript.getDefinition().getEventHandlerName();
    }

    protected String getTracePrefix() {
        if (this.triggerScript != null) {
            return "[ " + this.triggerScript.getDefinition().getName() + " ] ";
        }
        return "";
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, this.getTracePrefix() + message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, this.getTracePrefix() + message);
    }

    protected void logError(String message) {
        Trace.logError(this, this.getTracePrefix() + message);
    }

    protected void logException(Throwable exception) {
        this.logError(exception.getMessage());
    }
}

