/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.dropbox.DropBoxTableManager;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.FabricNodeRole;
import java.util.List;

public abstract class AbstractDropBoxTableManager {
    protected static final String DROPBOX_MODERATOR_ADVISORY_LISTENER = "sys$DropBoxModeratorAdvisoryListener";
    private RuntimeContext context;

    protected AbstractDropBoxTableManager(RuntimeContext context) {
        this.context = context;
    }

    protected void sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableManager.DropBoxTableOperation operation, List<DropBoxTable.DropBoxTableItem> items) throws Exception {
        DropBoxTableManager.DropBoxTableSynchronizationData data = new DropBoxTableManager.DropBoxTableSynchronizationData();
        data.operation = operation;
        data.items = items;
        this.context.exchange.invokeDropBoxTableSynchronizationEvent(data);
    }

    protected Object sendDropBoxTableSynchronizationRequestToNode(String nodeName, DropBoxTableManager.DropBoxTableOperation operation, List<DropBoxTable.DropBoxTableItem> items) throws Exception {
        DropBoxTableManager.DropBoxTableSynchronizationData data = new DropBoxTableManager.DropBoxTableSynchronizationData();
        data.operation = operation;
        data.items = items;
        FabricNode node = this.context.exchange.getFabricNode(nodeName);
        if (node == null || !node.isReady()) {
            return null;
        }
        return this.context.exchange.invokeDropBoxTableSynchronizationRequest(node, data);
    }

    protected boolean isFabricNodeAttached(String nodeName) {
        FabricNode node = this.context.exchange.getFabricNode(nodeName);
        return node != null && node.isReady();
    }

    protected List<DropBoxTable.DropBoxTableItem> sendDropBoxItemJoinTableToMnode(DropBoxTableManager.DropBoxTableOperation operation, List<DropBoxTable.DropBoxTableItem> items) throws Exception {
        DropBoxTableManager.DropBoxTableSynchronizationData data = new DropBoxTableManager.DropBoxTableSynchronizationData();
        data.operation = operation;
        data.items = items;
        FabricNode mnode = null;
        DirectoryTable.Node node = this.context.getDiscoveryModule().getDirectoryTable().getNode(this.context.getName());
        if (node == null) {
            return null;
        }
        for (DiscoveryLink link : node.getLinks()) {
            FabricNode linkNode = this.context.exchange.getFabricNode(link.getNodeName());
            if (linkNode == null || linkNode.getRole() != FabricNodeRole.MANAGEMENT_NODE) continue;
            mnode = linkNode;
            break;
        }
        if (mnode == null) {
            return null;
        }
        return this.context.exchange.invokeDropBoxItemJoinToMNodeRequest(mnode, data);
    }

    protected void open() {
        try {
            this.context.dispatcher.createHiddenEventAsyncConsumer(DROPBOX_MODERATOR_ADVISORY_LISTENER, new FabricEventListener(){

                @Override
                public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
                    AbstractDropBoxTableManager.this.onModeratorAdvisory((FabricModeratorAdvisory)event);
                }
            }, "advisory.fabric.Moderator", "type='DETACHED_FROM_SYSPLEX' or type='DETACHED_FROM_SYSPLEX_FORCIBLY' or type = 'NODE_DISCONNECTED' or type = 'NODE_DISCONNECTED_FORCIBLY'").start();
        }
        catch (FabricEventDispatcherException e) {
            Trace.logException(this, e, true);
        }
    }

    protected void destroy() {
        this.context.dispatcher.dropSystemConsumer(DROPBOX_MODERATOR_ADVISORY_LISTENER);
    }

    protected abstract void onModeratorAdvisory(FabricModeratorAdvisory var1);

    protected long nextGlobalCount() {
        return this.context.exchange.nextGlobalCountNotSync();
    }
}

