/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtModifier;
import com.streamscape.runtime.mf.operation.dropbox.AbstractDescribeDropBoxOperation;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.RuntimeSecurityManagerProxy;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;

public abstract class AbstractDropBoxOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.dropbox);
    }

    protected void addNameAtNodeNameParameter(AbstractDescribeDropBoxOperation.DropBoxNameAdviser nameAdviser) {
        this.syntax.addActionParameter((SyntaxParameter)new IdentifierParameter("name").setCompletionAdviser(nameAdviser));
        this.syntax.addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier("AT_NODE_MODIF").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE)).addModifier(new AtModifier()).addParameter((AbstractParameter)new IdentifierParameter("NodeName").setCompletionAdviser(new DropBoxNodeCompletionAdviser())));
    }

    protected String getParameterName(DSLStatement statement) {
        return statement.getParameter("name").getValue();
    }

    protected String getParameterNodeName(DSLStatement statement) {
        return statement.getParameter("NodeName").getValue();
    }

    protected RuntimeContext getRuntimeContext() {
        return this.callable instanceof RuntimeContext ? (RuntimeContext)this.callable : RuntimeContext.getInstance();
    }

    protected SLResponse invokeDropBox(DSLStatement statement, MFSession session, long timeout) throws Exception {
        String dropBoxName = this.getParameterName(statement);
        String nodeName = this.getParameterNodeName(statement);
        if (nodeName == null) {
            List<DropBoxTable.DropBoxTableItem> items = this.getRuntimeContext().getDropBoxManagerRemote().getDropBoxTableManager().getDropBoxTable().listDropBoxTableItemsSortedDesc(dropBoxName);
            if (items.size() > 1) {
                throw new Exception("There are several dropboxes with specified name. Please specify NodeName.");
            }
            if (items.size() == 1) {
                nodeName = items.get(0).getDropBoxNodeName();
            }
        }
        if (nodeName == null || RuntimeContext.getInstance().getName().equals(nodeName)) {
            return this.invokeLocal(statement, session, timeout, dropBoxName);
        }
        if (!statement.existsParameter("name")) {
            statement.addParameter("name", dropBoxName);
        }
        statement.addParameter("NodeName", nodeName);
        return this.invokeRemote(statement, session, timeout, dropBoxName, nodeName);
    }

    protected SLResponse invokeRemote(DSLStatement statement, MFSession session, long timeout, String dropBoxName, String nodeName) throws Exception {
        throw new RuntimeException();
    }

    protected SLResponse invokeLocal(DSLStatement statement, MFSession session, long timeout, String dropBoxName) throws Exception {
        throw new RuntimeException();
    }

    protected SLResponse invokeRemote(SLStatement statement, MFSession session, long timeout, String nodeName) throws Exception {
        FabricNodeReference node;
        FabricNodeReference fabricNodeReference = node = nodeName != null ? RuntimeContext.getInstance().getModerator().lookupFabricNode(nodeName) : RuntimeContext.getInstance().getModerator().getFabricNode();
        if (node == null) {
            return new SLResponse("Specified node not found.", false);
        }
        return RuntimeContext.getInstance().exchange.invokeSlangRequest(nodeName, statement, session, timeout);
    }

    protected SecurityManager getSecurityManager(MFSession session) {
        return this.getSecurityManager((User)session.getOwner());
    }

    protected SecurityManager getSecurityManager(User user) {
        return new RuntimeSecurityManagerProxy(this.getAbstractRuntimeContext().securityManagerImpl, user);
    }

    protected AbstractRuntimeContext getAbstractRuntimeContext() {
        if (this.callable instanceof RuntimeContext) {
            return (AbstractRuntimeContext)this.callable;
        }
        return ((DropBoxConnectionService)this.callable).getContext();
    }

    public static class DropBoxNodeCompletionAdviser
    implements CompletionAdviser {
        public List<String> getCompletions(String script, String processedScript, Object callable, MFSession session) {
            return RuntimeContext.getInstance().getModerator().listFabricNodes();
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }
}

