/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;

public abstract class AbstractDropBoxManagerRemote
implements FabricRequestListener {
    protected static final String DROPBOX_MANAGER_RPC_EVENT_ID = "e.sys.dropbox.manager.rpc.request";
    protected static final String DROPBOX_MANAGER_RPC_REQUESTS_LISTENER = "sys$DropBoxManagerRpcRequestsListener";
    protected final RuntimeContext context;

    protected AbstractDropBoxManagerRemote(RuntimeContext context) {
        this.context = context;
    }

    protected void open() {
        try {
            this.context.dispatcher.createSystemRequestConsumer(DROPBOX_MANAGER_RPC_REQUESTS_LISTENER, this, EventScope.INHERITED);
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to created request consumer {}.", DROPBOX_MANAGER_RPC_REQUESTS_LISTENER);
            Trace.logException(this, exception, true);
        }
    }

    protected void destroy() {
        if (this.context.dispatcher != null) {
            this.context.dispatcher.dropSystemConsumer(DROPBOX_MANAGER_RPC_REQUESTS_LISTENER);
        }
    }

    public <T> T invokeDropBoxManagerRpcUnwrap(String nodeName, DropBoxManagerRpcRequest data) {
        return (T)this.invokeDropBoxManagerRpc(nodeName, data).getData();
    }

    public DropBoxManagerRpcResponse invokeDropBoxManagerRpc(String nodeName, DropBoxManagerRpcRequest data) {
        return this.invokeDropBoxManagerRpc(nodeName, data, 30000L);
    }

    public DropBoxManagerRpcResponse invokeDropBoxManagerRpc(String nodeName, DropBoxManagerRpcRequest data, long timeout) {
        try {
            OpaqueEvent requestEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance("OpaqueEvent");
            FabricEventSourceFactoryImpl.setEventId(requestEvent, DROPBOX_MANAGER_RPC_EVENT_ID);
            requestEvent.setData(data);
            ImmutableEventDatagram responseEvent = this.invokeDropBoxManagerRequest(nodeName, requestEvent, timeout);
            DropBoxManagerRpcResponse response = (DropBoxManagerRpcResponse)((OpaqueEvent)responseEvent).getData();
            if (response.errorString != null) {
                throw new DropBoxException(response.errorString);
            }
            return response;
        }
        catch (SDOException | DatagramFactoryException | FabricEventSourceException exception) {
            throw new DropBoxException(Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    public ImmutableEventDatagram invokeDropBoxManagerRequest(String nodeName, ImmutableEventDatagram request, long timeout) {
        if (Trace.isDebugEnabled(this.getClass())) {
            try {
                Trace.logDebug(this, "Invoking on node {}, request: {}", nodeName, ((OpaqueEvent)request).getData());
            }
            catch (SDOException sDOException) {
                // empty catch block
            }
        }
        String consumerName = ModeratorUtils.makeConsumerFullName(nodeName, "RuntimeContext", nodeName, DROPBOX_MANAGER_RPC_REQUESTS_LISTENER);
        FabricNodeReference node = this.context.getModerator().lookupFabricNode(nodeName);
        if (node == null) {
            throw new DropBoxException("Node '" + nodeName + "' not found.");
        }
        RequestConsumerReference consumer = node.lookupRequestConsumer(consumerName);
        if (consumer == null) {
            throw new DropBoxException("Consumer '" + consumerName + "' not found.");
        }
        try {
            return this.context.dispatcher.raiseSystemRequest(consumer, request, timeout);
        }
        catch (Exception exception) {
            throw new DropBoxException(Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
        Object requestData = null;
        try {
            requestData = ((OpaqueEvent)event).getData();
            Trace.logDebug(this, "onRequest: {}", requestData);
            Object response = null;
            if (event.getEventId().equals(DROPBOX_MANAGER_RPC_EVENT_ID)) {
                try {
                    response = this.onDropBoxManagerRcpRequest((DropBoxManagerRpcRequest)requestData);
                }
                catch (Exception exception) {
                    response = new DropBoxManagerRpcResponse(exception);
                }
            } else if (event.getEventId().equals("e.sys.sl.DataspaceCall")) {
                response = this.onSLDataspaceCall((SLDataspaceCall)requestData);
            } else {
                throw new Exception("Unknown event id [" + event.getEventId() + "].");
            }
            Trace.logDebug(this, "onRequest response: {}", response);
            OpaqueEvent responseEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance("OpaqueEvent");
            responseEvent.setData(response);
            return responseEvent;
        }
        catch (Exception exception) {
            Trace.logDebug(this, "onRequest {}, exception: {}", requestData, Utils.formatExceptionWithUnrepeatedCauses(exception));
            throw new FabricRequestException("Internal Error: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected abstract DropBoxManagerRpcResponse onDropBoxManagerRcpRequest(DropBoxManagerRpcRequest var1);

    protected abstract Object onSLDataspaceCall(SLDataspaceCall var1);

    public static class DropBoxManagerRpcRequest {
        public static final int OPERATION_ENABLE = 0;
        public static final int OPERATION_LOOKUP_DROPBOX = 1;
        public static final int OPERATION_IS_ENABLED = 2;
        public static final int OPERATION_DISABLE = 3;
        public static final int OPERATION_GET_DROPBOXES = 4;
        public static final int OPERATION_RMC = 5;
        public static final int OPERATION_LOOKUP_DROPBOX_ACCESSOR = 6;
        private int operation;
        private String dropBoxName;

        public int getOperation() {
            return this.operation;
        }

        public DropBoxManagerRpcRequest setOperation(int operation) {
            this.operation = operation;
            return this;
        }

        public String getDropBoxName() {
            return this.dropBoxName;
        }

        public DropBoxManagerRpcRequest setDropBoxName(String dropBoxName) {
            this.dropBoxName = dropBoxName;
            return this;
        }

        public String toString() {
            return "DropBoxManagerRpcRequest{operation=" + this.operation + ", dropBoxName='" + this.dropBoxName + "'}";
        }
    }

    public static class DropBoxManagerRpcResponse {
        private Object data;
        private String errorString;

        public DropBoxManagerRpcResponse(Exception exception) {
            this.errorString = Utils.formatExceptionWithUnrepeatedCauses(exception);
        }

        public DropBoxManagerRpcResponse() {
        }

        public DropBoxManagerRpcResponse(Object data) {
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public DropBoxManagerRpcResponse setData(Object data) {
            this.data = data;
            return this;
        }

        public String toString() {
            return "DropBoxManagerRpcResponse{data=" + String.valueOf(this.data) + ", errorString='" + this.errorString + "'}";
        }
    }
}

