/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.discovery.DiscoveryModuleException;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.moderator.FabricNodeRole;
import java.lang.reflect.Method;

public abstract class AbstractDirectoryTable {
    protected transient AbstractRuntimeContext context;
    protected static final Method REPLACE_METHOD;
    protected static final Method ADD_LINK_METHOD;
    protected static final Method REMOVE_LINK_METHOD;
    protected static final Method ADD_NODE_METHOD;
    protected static final Method REMOVE_NODE_METHOD;

    protected AbstractDirectoryTable() {
    }

    protected void init(FabricContext context) {
        this.context = (AbstractRuntimeContext)context;
    }

    protected abstract boolean merge(DirectoryTable var1);

    protected abstract boolean doReplace(DirectoryTable var1) throws DiscoveryModuleException;

    protected abstract boolean doAddLink(String var1, FabricNodeRole var2, DiscoveryLink var3) throws DiscoveryModuleException;

    protected abstract boolean doRemoveLink(String var1, DiscoveryLink var2) throws DiscoveryModuleException;

    protected abstract boolean doAddNode(String var1, FabricNodeRole var2) throws DiscoveryModuleException;

    protected abstract boolean doRemoveNode(String var1) throws DiscoveryModuleException;

    protected void update(Method method, Object ... parameters) throws DiscoveryModuleException {
        this.context.exchange.updateDirectoryTable(this, method, parameters);
    }

    static {
        try {
            REPLACE_METHOD = AbstractDirectoryTable.class.getDeclaredMethod("doReplace", DirectoryTable.class);
            REPLACE_METHOD.setAccessible(true);
            ADD_LINK_METHOD = AbstractDirectoryTable.class.getDeclaredMethod("doAddLink", String.class, FabricNodeRole.class, DiscoveryLink.class);
            ADD_LINK_METHOD.setAccessible(true);
            REMOVE_LINK_METHOD = AbstractDirectoryTable.class.getDeclaredMethod("doRemoveLink", String.class, DiscoveryLink.class);
            REMOVE_LINK_METHOD.setAccessible(true);
            ADD_NODE_METHOD = AbstractDirectoryTable.class.getDeclaredMethod("doAddNode", String.class, FabricNodeRole.class);
            ADD_NODE_METHOD.setAccessible(true);
            REMOVE_NODE_METHOD = AbstractDirectoryTable.class.getDeclaredMethod("doRemoveNode", String.class);
            REMOVE_NODE_METHOD.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of DirectoryTable failed.");
        }
    }
}

