/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.mf.DataspaceSessionManager;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.ds.utils.SourceEventFlowDataImpl;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.advisory.ComponentStateChangeAdvisory;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventRequestConsumer;
import com.streamscape.sef.EventTrigger;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.IllegalComponentStateException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.advisories.StateAdvisoryFactory;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractEventTrigger;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.AbstractSessionManager;
import com.streamscape.sef.dispatcher.AccessorParentSessionLink;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.LocalFabricComponent;
import com.streamscape.sef.dispatcher.SLAudioMessageListener;
import com.streamscape.sef.dispatcher.SLAudioMessageRaiserRemote;
import com.streamscape.sef.dispatcher.SLFileMessageListener;
import com.streamscape.sef.dispatcher.SLFileMessageRaiserRemote;
import com.streamscape.sef.dispatcher.SourceEventFlowImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.pool.AccessorsPool;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.SemanticLexiconProcessor;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;

public abstract class AbstractDataspaceComponent
extends LocalFabricComponent
implements DataspaceComponent,
EventTriggerManagerDelegate {
    protected boolean isComponent = true;
    protected transient Map<String, EventTrigger> eventTriggers = new HashMap<String, EventTrigger>();
    protected transient StateAdvisoryFactory advisoriesFactory = null;
    protected transient DataspaceSessionManager sessionManager = null;
    protected transient SemanticLexiconProcessor lexiconProcessor = null;
    private DataspaceType type;

    public AbstractDataspaceComponent(DataspaceType type, String name) throws FabricNamingException {
        this.type = type;
        this.setType(type.name());
        this.setName(name);
        this.setModel(ComponentModel.CTX_DATASPACE);
    }

    @Override
    public DataspaceType getDataspaceType() {
        return this.type;
    }

    protected final void init() throws IllegalComponentStateException {
        try {
            if (this.isComponent) {
                this.accessorsPool = new AccessorsPool(this, DataspaceStoreManager.getRuntimeContext());
                this.accessorsPool.init();
                this.context = DataspaceStoreManager.getRuntimeContext();
                this.initInternal(this.context.getDatagramPrototypeCache());
                try {
                    this.context.bind(this);
                }
                catch (RuntimeContextException error) {
                    throw new DataspaceException("Dataspace opening failed." + error.getMessage());
                }
                this.initPackageManifestManager();
                this.loadPackageManifest();
            }
            this.initializeCollectionFactories();
            this.authenticate();
            if (this.isComponent) {
                this.createSLFileRequestConsumerProxy();
                this.createSLAudioRequestConsumerProxy();
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new IllegalComponentStateException(error.getMessage());
        }
    }

    protected final void destroy() {
        this.destroySessionManager();
        this.destroyInternal();
        if (this.isComponent) {
            try {
                this.unloadPackageManifest();
                if (this.context != null) {
                    this.context.unbind(this.contextId);
                }
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
                Trace.logError(this, "Unbinding component failed.");
            }
        }
    }

    private void authenticate() throws Exception {
        ComponentOwner owner = this.context.securityManagerImpl.getComponentOwner(this.findCurrentOwnerName(), false);
        if (owner instanceof User) {
            this.bindUser(this.context.securityManagerImpl, (User)owner);
        } else if (owner instanceof Group) {
            this.bindGroup(this.context.securityManagerImpl, (Group)owner);
        }
    }

    public void reInitOwner() {
        try {
            this.authenticate();
        }
        catch (Exception error) {
            throw new DataspaceException("Dataspace owner re-initialization failed");
        }
    }

    protected abstract String findCurrentOwnerName();

    @Override
    void initIsSecurityEnabled() {
        this.isSecurityEnabled = this.context.isSecurityEnabled();
    }

    private void loadPackageManifest() {
        try {
            this.manifestManager.load();
        }
        catch (Exception exception) {
            throw new DataspaceException("Loading Dataspace Package Manifest failed. ", exception);
        }
    }

    private void unloadPackageManifest() {
        if (this.manifestManager != null) {
            this.manifestManager.destroy();
        }
    }

    protected void createSessionManager() {
        this.sessionManager = new DataspaceSessionManager(this.context, this);
        this.sessionManager.init();
    }

    protected void destroySessionManager() {
        if (this.sessionManager != null) {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
    }

    AbstractSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected abstract void initializeCollectionFactories();

    public StateAdvisoryFactory getAdvisoriesFactory() {
        return this.advisoriesFactory;
    }

    @Override
    public void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        try {
            EventTriggerDefinition triggerDefinition = this.getEventTriggerDefinition(triggerName);
            this.createEventTrigger(triggerDefinition);
            if (triggerDefinition.isAutoEnable()) {
                this.enableEventTrigger(triggerName);
            }
        }
        catch (ServiceConfigurationException error) {
            Trace.logError(this, error.getMessage());
        }
        catch (FabricEventDispatcherException error) {
            Trace.logError(this, error.getMessage());
        }
    }

    public abstract List<StateAdvisoryDefinition> getStateAdvisoryDefinitions();

    protected void createEventTrigger(EventTriggerDefinition definition) throws FabricEventDispatcherException {
        try {
            EventTriggerImpl trigger = new EventTriggerImpl(this, this);
            trigger.init(definition, this.context);
            this.eventTriggers.put(trigger.getName(), trigger);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void enableEventTrigger(String triggerName) {
        EventTrigger trigger = this.eventTriggers.get(triggerName);
        if (trigger == null || trigger.getState() == EventTriggerState.ENABLED) {
            return;
        }
        trigger.enable();
        this.doEnableEventTrigger(triggerName);
        try {
            this.dispatcher.createActionableConsumer(triggerName, (FabricEventListener)((Object)trigger), this.getTriggerActionableEventId(triggerName), trigger.getEventSelector());
        }
        catch (FabricEventDispatcherException ex) {
            Trace.logException(this, ex, true);
        }
    }

    @Override
    public void disableEventTrigger(String triggerName) {
        EventTrigger trigger = this.eventTriggers.get(triggerName);
        if (trigger != null && trigger.getState() == EventTriggerState.ENABLED) {
            trigger.disable();
            try {
                this.dispatcher.dropConsumer(triggerName);
            }
            catch (FabricEventDispatcherException exception) {
                Trace.logException(this, exception, true);
            }
            this.doDisableEventTrigger(triggerName);
        }
    }

    protected abstract void doEnableEventTrigger(String var1);

    protected abstract void doDisableEventTrigger(String var1);

    protected abstract String getTriggerActionableEventId(String var1);

    @Override
    public void raiseSystemAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        super.raiseSystemAdvisory(event);
    }

    @Override
    public void raiseSystemEvent(ImmutableEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        super.raiseSystemEvent(event);
    }

    @Override
    public void raiseAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(this, "raiseAdvisory(" + event.getEventId() + ")");
        super.raiseAdvisory(event);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        super.raiseEvent(event, timeToLive);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, EventScope scope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(this, "raiseEvent(" + event.getEventId() + ")");
        super.raiseEvent(event, scope, timeToLive);
    }

    public void raiseException(ExceptionEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.dispatcher.raiseException(event, EventScope.INHERITED);
    }

    public void raiseActionableEvent(ImmutableEventDatagram event, long timeToLive) throws FabricEventSourceException, FabricEventException {
        Trace.logDebug(this, "raiseActionableEvent(" + event.getEventId() + ")");
        if (event instanceof EventDatagram) {
            try {
                FabricEventSourceFactoryImpl.setEventId(event, "e.action." + event.getEventId());
            }
            catch (SDOFormatException error) {
                error.printStackTrace();
            }
        }
        this.dispatcher.raiseActionableEvent(event, timeToLive);
    }

    public void acknowledgeEvent(EventDatagram sourceEvent, boolean withSourceData, AcknowledgeAction action, String recipientId, EventScope scope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(this, "acknowledgeEvent(" + sourceEvent.getEventId() + "):WithSourceData=" + withSourceData + "; AcknowledgeAction=" + String.valueOf((Object)action) + "; RecipientId=" + recipientId);
        this.dispatcher.acknowledgeEvent(sourceEvent, withSourceData, action, recipientId, scope, timeToLive);
    }

    public void acknowledgeAndForward(EventDatagram sourceEvent, boolean withSourceData, AcknowledgeAction action, String recipientId, long timeToLive) throws FabricEventSourceException {
        Trace.logDebug(this, "acknowledgeAndForward(" + sourceEvent.getEventId() + "):WithSourceData=" + withSourceData + "; AcknowledgeAction=" + String.valueOf((Object)action) + "; RecipientId=" + recipientId);
        this.dispatcher.acknowledgeAndForward(sourceEvent, withSourceData, action, recipientId, timeToLive);
    }

    @Override
    public AcknowledgementEvent raiseRequest(EventDatagram requestEvent, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(this, "raiseRequest(" + requestEvent.getEventId() + "): DistributionStrategy= " + distributionStrategy.toString() + "; MatchStrategy=" + matchStrategy.toString());
        return super.raiseRequest(requestEvent, distributionStrategy, matchStrategy, timeout);
    }

    @Override
    public ImmutableEventDatagram raiseRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        Trace.logDebug(this, "raiseRequest(" + request.getEventId() + "): ");
        return super.raiseRequest(consumer, request, timeout);
    }

    @Override
    public AcknowledgementEvent raiseSystemRequest(EventDatagram requestEvent, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        return super.raiseSystemRequest(requestEvent, distributionStrategy, matchStrategy, timeout);
    }

    public void raiseAcknowledgement(AcknowledgementEvent event, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(AbstractDataspaceComponent.class, "raiseAcknowledgement(" + event.getEventId() + ")");
        this.dispatcher.raiseAcknowledgement(event, EventScope.INHERITED, timeToLive);
    }

    private String resolveSelectorMetasetProperties(String eventSelector) {
        Metaset ms = this.getMetaset();
        if (ms != null) {
            Map<String, Object> vals = ms.getValues();
            for (String key : vals.keySet()) {
                if (!(vals.get(key) instanceof String)) continue;
                vals.put(key, "'" + String.valueOf(vals.get(key)) + "'");
            }
            StrSubstitutor sub = new StrSubstitutor(vals);
            sub.setVariablePrefix("$metaset:{");
            eventSelector = sub.replace(eventSelector);
        }
        return eventSelector;
    }

    public EventConsumer createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope scope, boolean noLocal) throws FabricEventDispatcherException {
        return this.dispatcher.createEventConsumer(consumerName, listener, eventFilter, this.resolveSelectorMetasetProperties(eventSelector), scope, noLocal);
    }

    public EventRequestConsumer createRequestConsumer(String consumerName, FabricRequestListener listener, EventScope scope) throws FabricEventDispatcherException {
        return this.dispatcher.createRequestConsumer(consumerName, listener, scope);
    }

    public EventAsyncConsumer createActionableEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        return this.dispatcher.createActionableAsyncConsumer(consumerName, listener, eventFilter, eventSelector);
    }

    public EventAsyncConsumer createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.dispatcher.createEventAsyncConsumer(consumerName, listener, eventFilter, this.resolveSelectorMetasetProperties(eventSelector), eventScope, noLocal);
    }

    public void dropConsumer(String consumerName) throws FabricEventDispatcherException {
        this.dispatcher.dropConsumer(consumerName);
    }

    public EventAsyncConsumer getEventAsyncConsumer(String consumerName) {
        return this.dispatcher.getEventAsyncConsumer(consumerName);
    }

    @Override
    public void bindProducerFor(String eventId) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, false, false);
    }

    public void bindProducerFor(String eventId, SourceEventFlowData flowData) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, false, false);
        this.addSourceEventFlow(eventId, flowData, false);
    }

    @Override
    public void bindProducerForSystem(String eventId) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, true, false);
    }

    public void bindProducerForSystem(String eventId, SourceEventFlowData flowData) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, true, false);
        this.addSourceEventFlow(eventId, flowData, true);
    }

    private void addSourceEventFlow(String eventId, SourceEventFlowData flowData, boolean isSystem) {
        if (flowData != null) {
            this.addSourceEventFlow(eventId, flowData.getEntity(), flowData.getEntityName(), flowData.getEntityScope(), flowData.getEntityParameters(), isSystem);
        }
    }

    @Override
    public void unbindProducerFor(String eventId) {
        this.boundEventIds.unbindEventId(eventId, false);
    }

    public void unbindProducerFor(String eventId, SourceEventFlowData flowData) {
        this.boundEventIds.unbindEventId(eventId, false);
        if (flowData != null) {
            this.removeSourceEventFlow(eventId, flowData.getEntity(), flowData.getEntityName());
        }
    }

    @Override
    public boolean isBoundEventId(String eventId) {
        return this.boundEventIds.isEventIdBound(eventId);
    }

    public User authenticateUser(String user, String password) throws SecurityManagerException {
        return this.context.securityManagerImpl.authenticate(AuthenticationType.PASSWORD_PLAIN_TEXT, user, password, null, null, this);
    }

    protected void bindAdvisories() throws DataspaceComponentException {
        try {
            this.bindProducerForSystem("advisory.ds.notif", new SourceEventFlowDataImpl(EventFlowEntity.DATASPACE_EVENT_ADVISORY, null, null, null));
            this.bindProducerForSystem("advisory.component.StateChange", new SourceEventFlowDataImpl(EventFlowEntity.DATASPACE_EVENT_ADVISORY, null, null, null));
        }
        catch (FabricEventDispatcherException error) {
            throw new DataspaceComponentException(error.getErrorCode(), (Throwable)error);
        }
        if (this.advisoriesFactory.listAdvisoryNames().size() > 0) {
            // empty if block
        }
    }

    public SourceEventFlowImpl addSourceEventFlow(String eventId, EventFlowEntity entity, String entityName, EventScope entityScope) {
        return this.addSourceEventFlow(eventId, entity, entityName, entityScope, false);
    }

    @Override
    public SourceEventFlowImpl addSourceEventFlow(String eventId, EventFlowEntity entity, String entityName, EventScope entityScope, boolean isSystem) {
        return super.addSourceEventFlow(eventId, entity, entityName, entityScope, isSystem);
    }

    public SourceEventFlowImpl addSourceEventFlow(String eventId, EventFlowEntity entity, String entityName, EventScope entityScope, HashMap<String, String> entityParameters) {
        return this.addSourceEventFlow(eventId, entity, entityName, entityScope, entityParameters, false);
    }

    public SourceEventFlowImpl addSourceEventFlow(String eventId, EventFlowEntity entity, String entityName, EventScope entityScope, HashMap<String, String> entityParameters, boolean isSystem) {
        SourceEventFlowImpl result = this.addSourceEventFlow(eventId, entity, entityName, entityScope, isSystem);
        if (result != null) {
            result.setEntityParameters(entityParameters);
        }
        return result;
    }

    public void addSinkEventFlow(EventFlowEntity entity, String entityName, EventConsumer consumer) {
        this.addSinkEventFlow(entity, entityName, consumer, false);
    }

    public void addSinkEventFlow(EventFlowEntity entity, String entityName, EventConsumer consumer, boolean isSystem) {
        if (consumer instanceof AbstractFabricConsumer) {
            this.addSinkEventFlow(entity, entityName, (AbstractFabricConsumer)((Object)consumer), isSystem);
        }
    }

    @Override
    public void removeSourceEventFlow(String eventId, EventFlowEntity entity, String entityName) {
        super.removeSourceEventFlow(eventId, entity, entityName);
    }

    @Override
    public AccessorsPool getAccessorsPool() {
        return super.getAccessorsPool();
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException {
        return super.createDataspaceAccessor(dataspaceType, dataspaceName);
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException {
        return super.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String serviceType, String serviceName) throws FabricComponentAccessorException {
        return super.createServiceAccessor(serviceType, serviceName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String nodeName, String serviceType, String serviceName) throws FabricComponentAccessorException {
        return super.createServiceAccessor(nodeName, serviceType, serviceName);
    }

    public FabricConnection getSystemConnection() {
        return DataspaceManager.getContext().getSystemConnection();
    }

    public void forwardEvent(EventDatagram event) {
        if (event.getForwardTo() == null || event.getForwardTo().length() == 0) {
            throw new DataspaceException("ForwardTo eventId does not set for event.");
        }
        try {
            FabricEventSourceFactoryImpl.setEventId(event, event.getForwardTo());
            this.bindProducerFor(event.getForwardTo());
            super.raiseEvent(event, -1L);
            this.unbindProducerFor(event.getForwardTo());
        }
        catch (Exception exception) {
            throw new DataspaceException("Raising event on [" + event.getForwardTo() + "]. Cause: " + exception.getMessage());
        }
    }

    @Override
    protected void setState(ComponentState state) {
        super.setState(state);
        this.sendStateChangeAdvisory(state);
    }

    public void onRename() {
    }

    public void sendStateChangeAdvisory(ComponentState state) {
        if (this.dispatcher != null) {
            try {
                ComponentStateChangeAdvisory advisory = new ComponentStateChangeAdvisory();
                advisory.setState(state);
                advisory.setMessage("Dataspace '" + this.getType() + "." + this.getName() + "' state changed to " + state.name() + ".");
                this.dispatcher.raiseSystemAdvisory(advisory, EventScope.INHERITED);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    protected SelectorExternalDataSource getSelectorDataSource() {
        return this.dispatcher.getSelectorDataSource();
    }

    protected void createSLFileRequestConsumerProxy() {
        String fileRequestConsumerName = SLFileMessage.getRequestConsumerName();
        try {
            EventRequestConsumer requestConsumer = this.getSystemRequestConsumer(fileRequestConsumerName);
            if (requestConsumer == null) {
                this.createSystemRequestConsumer(fileRequestConsumerName, new SLFileMessageListenerProxy(), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Creation of file request consumer '" + fileRequestConsumerName + "' for dataspace '" + this.getName() + "' failed.");
        }
    }

    EventRequestConsumer getSystemRequestConsumer(String consumerName) throws FabricConnectionException {
        return this.dispatcher.getSystemRequestConsumer(consumerName);
    }

    EventRequestConsumer createSystemRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws FabricConnectionException, FabricEventDispatcherException {
        return this.dispatcher.createSystemRequestConsumer(consumerName, listener, eventScope);
    }

    protected void createSLAudioRequestConsumerProxy() {
        String audioRequestConsumerName = SLAudioMessage.getRequestConsumerName();
        try {
            EventRequestConsumer requestConsumer = this.getSystemRequestConsumer(audioRequestConsumerName);
            if (requestConsumer == null) {
                this.createSystemRequestConsumer(audioRequestConsumerName, new SLAudioMessageListenerProxy(), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Creation of audio request consumer '" + audioRequestConsumerName + "' for dataspace '" + this.getName() + "' failed.");
        }
    }

    private class EventTriggerImpl
    extends AbstractEventTrigger {
        protected EventTriggerImpl(AbstractDataspaceComponent abstractDataspaceComponent, AbstractFabricComponent component) {
            super(component);
        }

        @Override
        void onBindEvent(String eventId) {
            this.component.addSourceEventFlow(eventId, EventFlowEntity.DATASPACE_EVENT_TRIGGER, this.getName(), this.getEventScope(), false);
        }

        @Override
        void onUnbindEvent(String eventId) {
            this.component.removeSourceEventFlow(eventId, EventFlowEntity.DATASPACE_EVENT_TRIGGER, this.getName());
        }

        @Override
        protected void onDisableException() {
        }

        @Override
        protected void onInvalidateException(String error) {
        }
    }

    class SLFileMessageListenerProxy
    implements FabricRequestListener {
        @Override
        public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
            if (event instanceof OpaqueDatagram) {
                try {
                    SLFileMessage message = (SLFileMessage)((OpaqueDatagram)event).getData();
                    AbstractComponentAccessor accessor = AbstractDataspaceComponent.this.accessors.values().stream().filter(a -> a.getSession() != null && a.getSession().getName().startsWith(message.getResourceName() + ":") && a.getSession().getSessionName().equals(message.getSessionName())).findAny().orElse(null);
                    if (accessor == null) {
                        throw new Exception("Accessor corresponding to session '" + message.getSessionName() + "' on resource '" + message.getResourceName() + "' not found.");
                    }
                    AccessorParentSessionLink accessorParentSessionLink = (AccessorParentSessionLink)((Object)accessor);
                    if (accessorParentSessionLink.getParentSession() == null) {
                        throw new Exception("Accessor corresponding to session '" + message.getSessionName() + "' on resource '" + message.getResourceName() + "' doesn't have parent session link.");
                    }
                    SLFileMessageRaiserRemote raiser = new SLFileMessageRaiserRemote(accessorParentSessionLink.getParentSession().getComponentName(), accessorParentSessionLink.getParentSession().getSLSessionName(), null);
                    raiser.open();
                    SLFileMessage response = raiser.raise(message, message.getTimeout());
                    return SLFileMessageListener.createSLFileMessageResponseEvent(null, response);
                }
                catch (Exception exception) {
                    if (!(exception instanceof FileNotFoundException)) {
                        Trace.logException(this, exception, true);
                    }
                    throw new FabricRequestException(exception);
                }
            }
            throw new FabricRequestException("Wrong event datagram '" + event.getClass().getSimpleName() + "' received (expected 'OpaqueDatagram').");
        }
    }

    class SLAudioMessageListenerProxy
    implements FabricRequestListener {
        @Override
        public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
            if (event instanceof OpaqueDatagram) {
                try {
                    SLAudioMessage message = (SLAudioMessage)((OpaqueDatagram)event).getData();
                    AbstractComponentAccessor accessor = AbstractDataspaceComponent.this.accessors.values().stream().filter(a -> a.getSession() != null && a.getSession().getName().startsWith(message.getResourceName() + ":") && a.getSession().getSessionName().equals(message.getSessionName())).findAny().orElse(null);
                    if (accessor == null) {
                        throw new Exception("Accessor corresponding to session '" + message.getSessionName() + "' on resource '" + message.getResourceName() + "' not found.");
                    }
                    AccessorParentSessionLink accessorParentSessionLink = (AccessorParentSessionLink)((Object)accessor);
                    if (accessorParentSessionLink.getParentSession() == null) {
                        throw new Exception("Accessor corresponding to session '" + message.getSessionName() + "' on resource '" + message.getResourceName() + "' doesn't have parent session link.");
                    }
                    SLAudioMessageRaiserRemote raiser = new SLAudioMessageRaiserRemote(accessorParentSessionLink.getParentSession().getComponentName(), accessorParentSessionLink.getParentSession().getSLSessionName(), null);
                    raiser.open();
                    SLAudioMessage response = raiser.raise(message, message.getTimeout());
                    return SLAudioMessageListener.createSLAudioMessageResponseEvent(null, response);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    throw new FabricRequestException(exception);
                }
            }
            throw new FabricRequestException("Wrong event datagram '" + event.getClass().getSimpleName() + "' received (expected 'OpaqueDatagram').");
        }
    }
}

