/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractDatagramPrototypeCache {
    protected SemanticTypeCache semanticTypeCache;
    protected Map<Prototype, ImmutableEventDatagram> prototypes = new ConcurrentHashMap<Prototype, ImmutableEventDatagram>();
    protected Map<String, Prototype> eventIds = new ConcurrentHashMap<String, Prototype>();
    protected Map<Prototype, String> ancestors = new ConcurrentHashMap<Prototype, String>();

    protected AbstractDatagramPrototypeCache(SemanticTypeCache semanticTypeCache) {
        this.semanticTypeCache = semanticTypeCache;
    }

    protected synchronized void addPrototype(DatagramFactory factory, Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        if (this.prototypes.containsKey(prototype)) {
            throw new DatagramFactoryException(5030, ErrorMessages.format("Event prototype [%1$s] already exists.", prototype.toString()));
        }
        if (this.eventIds.containsKey(event.getEventId())) {
            throw new DatagramFactoryException(5030, ErrorMessages.format("Event prototype [%1$s] already exists.", event.getEventId()));
        }
        this.prototypes.put(prototype, event);
        this.eventIds.put(event.getEventId(), prototype);
        this.ancestors.put(prototype, factory.getAncestorType());
    }

    protected synchronized void removePrototype(Prototype prototype) throws DatagramFactoryException {
        if (!this.prototypes.containsKey(prototype)) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", prototype.toString()));
        }
        ImmutableEventDatagram removedEvent = this.prototypes.remove(prototype);
        this.eventIds.remove(removedEvent.getEventId());
        this.ancestors.remove(prototype);
    }

    protected List<ImmutableEventDatagram> getEventPrototypes() {
        return new ArrayList<ImmutableEventDatagram>(this.prototypes.values());
    }

    protected List<Map.Entry<Prototype, ImmutableEventDatagram>> getPrototypeEntries() {
        return new ArrayList<Map.Entry<Prototype, ImmutableEventDatagram>>(this.prototypes.entrySet());
    }

    boolean hasPrototypesByDataType(SemanticType semanticType) {
        return this.prototypes.entrySet().stream().map(entry -> this.getDataType((Prototype)entry.getKey(), (ImmutableEventDatagram)entry.getValue())).anyMatch(dataType -> dataType != null && dataType.equals(semanticType.getTypeName()));
    }

    protected String getDataType(Prototype prototype, ImmutableEventDatagram event) {
        if (event instanceof PayloadEvent) {
            Class dataClass = ((PayloadEvent)((Object)event)).getPayloadClass();
            return dataClass != null ? this.semanticTypeCache.resolveSemanticClass(dataClass) : (prototype != null ? prototype.getPayloadType() : null);
        }
        return null;
    }

    protected abstract List<Pair<Prototype, ImmutableEventDatagram>> checkEventPrototypes(SemanticType var1);

    protected abstract void getPrototypesByDataType(SemanticType var1, Map<Prototype, ImmutableEventDatagram> var2);
}

