/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.debug.AccessorDebug;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.timer.AbstractFabricTimerTask;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerException;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.accessor.FabricComponentAccessorAdvisory;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.accessor.FabricComponentAccessorState;
import com.streamscape.sef.accessor.FabricComponentAccessorStateListener;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AccessorSessionReferenceImpl;
import com.streamscape.sef.dispatcher.EntityReferenceImpl;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.SLRequestRaiser;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SLSessionMFSession;
import com.streamscape.sef.dispatcher.SessionRequest;
import com.streamscape.sef.dispatcher.SessionResponse;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.enums.SessionState;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ExchangeRole;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.utils.Utils;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.SLSessionDataImpl;
import java.util.Comparator;
import java.util.List;

abstract class AbstractComponentAccessor
extends EntityReferenceImpl
implements FabricComponentAccessor,
AccessorReference,
SLRequestRaiser {
    String nodeName;
    String componentName;
    String componentType;
    ComponentModel componentModel;
    String accessorName;
    String accessorFullName;
    long requestTimeout = 30000L;
    boolean autoSwitching = false;
    String slSessionName;
    boolean isSpecial = false;
    boolean isInstant = false;
    boolean hasStateListener = false;
    boolean isAvailable = false;
    String actualNodeName;
    AccessorSessionReference session;
    final transient AbstractFabricComponent owningComponent;
    transient FabricNodeReference node;
    transient ComponentReference component;
    transient RequestConsumerReference sessionManager;
    transient String sessionEstablisherName;
    transient EventConsumer sessionEstablisherConsumer;
    transient String sessionFinalizerName;
    transient EventConsumer sessionFinalizerConsumer;
    volatile transient boolean sessionEstablishingInProgress = false;
    transient SLSessionImpl slSession;
    volatile transient boolean isOpened = false;
    volatile transient boolean closingInProgress = false;
    private transient String username;
    transient FabricComponentAccessorState state;
    transient FabricComponentAccessorStateListener stateListener;
    transient long stateListenerRepeatInterval = -1L;
    transient FabricTimer stateListenerTimer;
    transient Comparator<FabricNodeReference> clusterComparator;
    private static final LongNumberAllocatorSimple NAME_ALLOCATOR = new LongNumberAllocatorSimple();
    private static final int DEFAULT_REQUEST_TIMEOUT = 30000;
    private static final int DEFAULT_LISTENER_TIMEOUT = 300000;
    private static final String SESSION_ESTABLISHER_NAME = "SessionEstablisher";
    private static final String SESSION_FINALIZER_NAME = "SessionFinalizer";
    private static final String SESSION_MANAGER_CONSUMER_NAME_FOR_SELECTOR = "sys$SessionManager".replace("$", "[$]");
    private static final String STATE_LISTENER_TIMER_GROUP = "sys$AccessorStateListener";

    AbstractComponentAccessor(AbstractFabricComponent owningComponent, String nodeName, String componentType, String componentName, ComponentModel componentModel, SLSessionImpl slSession, String username) throws FabricComponentAccessorException {
        this(owningComponent, nodeName, componentType, componentName, componentModel, slSession, false, username);
    }

    AbstractComponentAccessor(AbstractFabricComponent owningComponent, String nodeName, String componentType, String componentName, ComponentModel componentModel, SLSessionImpl slSession, boolean isInstant, String username) throws FabricComponentAccessorException {
        this(owningComponent);
        this.username = username;
        this.init(nodeName, componentType, componentName, slSession);
        if (!isInstant) {
            this.init(componentModel);
        }
        this.open();
    }

    AbstractComponentAccessor(AbstractFabricComponent owningComponent, FabricNodeReference node, ComponentReference component, RequestConsumerReference sessionManager, SLSessionImpl slSession) throws FabricComponentAccessorException {
        this(owningComponent);
        try {
            List<String> tokens = ModeratorUtils.splitComponentFullName(component.getName());
            this.init(node.getName(), tokens.get(1), tokens.get(2), slSession);
        }
        catch (FabricException fabricException) {
            // empty catch block
        }
        this.init(component.getModel());
        this.node = node;
        this.component = component;
        this.sessionManager = sessionManager;
        this.isSpecial = true;
        this.open();
    }

    private AbstractComponentAccessor(AbstractFabricComponent owningComponent) {
        super(ExchangeRole.ACCESSOR, owningComponent.getFabricAddress(), owningComponent.eventScope);
        this.owningComponent = owningComponent;
        if (this.isClustered()) {
            this.clusterComparator = (node1, node2) -> {
                boolean matches1 = this.matchesCluster((FabricNodeReference)node1);
                boolean matches2 = this.matchesCluster((FabricNodeReference)node2);
                return matches1 && matches2 ? 0 : (matches1 ? -1 : 1);
            };
        }
    }

    private void init(String nodeName, String componentType, String componentName, SLSessionImpl slSession) {
        this.nodeName = nodeName;
        this.componentType = componentType;
        this.componentName = componentName;
        this.slSession = slSession;
        if (slSession != null) {
            this.slSessionName = slSession.getName();
            this.isInstant = slSession.isInstant;
        }
    }

    private void init(ComponentModel componentModel) {
        this.componentModel = componentModel;
        this.accessorName = "Accessor" + NAME_ALLOCATOR.getNumber();
        this.accessorFullName = this.owningComponent.dispatcher.makeConsumerFullName(this.accessorName);
        this.sessionEstablisherName = "SessionEstablisher_" + this.accessorName;
        this.sessionFinalizerName = "SessionFinalizer_" + this.accessorName;
    }

    void open() throws FabricComponentAccessorException {
        this.establishSession(false);
        this.isOpened = true;
        this.raiseAdvisory(FabricComponentAccessorState.ACCESSOR_OPENED, false);
    }

    void reopen() throws FabricComponentAccessorException {
        this.establishSession(false);
        this.isOpened = true;
        this.raiseAdvisory(FabricComponentAccessorState.ACCESSOR_OPENED, false);
    }

    private synchronized void establishSession(boolean reopen) throws FabricComponentAccessorException {
        this.sessionEstablishingInProgress = true;
        try {
            if (!this.isAvailable()) {
                this.logDebug("Establishing session with '" + this.getComponentFullNameWithNode() + "' component...");
                if (this.findSessionManager()) {
                    this.logDeepDebug("Session manager found. " + this.printMetadata() + ".");
                    this.raiseOpenRequest();
                    if (!this.isInstant()) {
                        this.addSessionFinalizer();
                        if (reopen) {
                            this.raiseAdvisory(FabricComponentAccessorState.RESOURCE_RECOVERED, true);
                        } else {
                            this.state = FabricComponentAccessorState.RESOURCE_RECOVERED;
                        }
                        if (this.stateListener != null) {
                            this.stateListener.onResourceAvailable(this);
                            this.destroyStateListenerTimer();
                        }
                        this.logDebug("Session established with '" + (this.component != null ? this.component.getName() : this.getComponentFullName()) + "' component.");
                        this.logDebug("Resource '" + this.getComponentFullNameForMessage() + "' is available.");
                        if (reopen) {
                            this.reOpenSLSession();
                        }
                    }
                } else {
                    this.logDeepDebug("Session manager not found. " + this.printMetadata() + ".");
                    this.onResourceUnavailable();
                    if (this.stateListener != null) {
                        this.stateListener.onResourceUnavailable(this);
                        this.createStateListenerTimer();
                    }
                }
            }
        }
        catch (FabricComponentAccessorException exception) {
            this.logDeepDebug("Establishing session failed. " + this.printMetadata() + ".");
            this.clearSessionData();
            this.raiseAdvisory(FabricComponentAccessorState.SESSION_ESTABLISHING_FAILED, false);
            throw exception;
        }
        finally {
            this.sessionEstablishingInProgress = false;
        }
    }

    private void raiseOpenRequest() throws FabricComponentAccessorException {
        SLSessionMFSession mfSession = this.slSession != null ? this.slSession.mfSession : null;
        String ownerName = this.username;
        if (ownerName == null) {
            ownerName = this.isInstant && mfSession != null ? mfSession.getOwnerName() : this.owningComponent.getOwnerName();
        }
        SessionResponse sessionResponse = this.doRaiseSessionRequest(SessionRequest.createOpenRequest(this.owningComponent.getFullName(), this.accessorName, ownerName, !this.node.isLocal(), this.isInstant(), this.getSLSessionName(), mfSession != null ? mfSession.getSLSessionData() : new SLSessionDataImpl()));
        this.logDeepDebug("SessionResponse received: " + String.valueOf(sessionResponse) + ".");
        if (sessionResponse.getSessionState() == SessionState.OPEN) {
            this.isAvailable = true;
            this.actualNodeName = this.node.getName();
            this.session = (AccessorSessionReference)sessionResponse.getSession();
            this.eventScope = this.session.getEventScope();
            ((FabricNode)this.node).addAccessorSession((AccessorSessionReferenceImpl)this.session);
            if (!this.isRuntimeAccessor()) {
                this.onSessionOpen(sessionResponse);
            }
        }
    }

    private boolean findSessionManager() throws FabricComponentAccessorException {
        return this.isRuntimeAccessor() ? this.findRuntimeSessionManager() : this.findComponentSessionManager();
    }

    private boolean findRuntimeSessionManager() throws FabricComponentAccessorException {
        if (this.nodeName != null && !this.nodeName.equals(this.componentName)) {
            this.throwInvalidComponent("Ambiguous parameters for Runtime component (nodeName = '" + this.nodeName + "' and componentName = '" + this.componentName + "').");
        }
        this.nodeName = this.componentName;
        this.findConcreteNode();
        if (this.node != null) {
            if (this.sessionManager == null && (this.sessionManager = this.lookupConsumer("sys$SessionManager")) == null) {
                this.throwInvalidComponent("Session manager is not available for node '" + this.getComponentName() + "'.");
            }
            return true;
        }
        this.addSessionEstablisher("type = 'NODE_CONNECTED' AND entity = '" + this.nodeName + "'", true);
        return false;
    }

    private boolean findComponentSessionManager() throws FabricComponentAccessorException {
        if (this.isSpecial) {
            return this.findSpecial();
        }
        if (this.node != null && this.component != null && this.sessionManager != null && this.matchesComponentModel(this.component)) {
            if (this.isGeneric() && this.autoSwitching) {
                this.addSessionEstablisherForGenericComponent(false);
            }
            return true;
        }
        this.setComponent(ComponentData.NULL);
        if (this.nodeName == null && this.getEventScope() == EventScope.OBSERVABLE) {
            this.nodeName = this.owningComponent.moderator.getFabricNode().getName();
        }
        String componentFullName = this.getComponentFullName();
        if (this.nodeName != null) {
            this.findConcreteNode();
            if (this.node == null || !this.findConcreteComponent(componentFullName, this.node)) {
                this.addSessionEstablisher(this.makeSelector(this.makeSelectorForConcreteComponent()), true);
                return false;
            }
        } else {
            boolean found = this.findGenericComponent(componentFullName);
            if (!found || this.autoSwitching) {
                this.addSessionEstablisherForGenericComponent(!found);
            }
            return found;
        }
        return true;
    }

    private boolean isValid(ComponentData data) {
        return data.isValid() && this.matchesComponentModel(data.component);
    }

    private void setComponent(ComponentData data) {
        this.node = data.node;
        this.component = data.component;
        this.sessionManager = data.sessionManager;
    }

    private void findConcreteNode() throws FabricComponentAccessorException {
        this.doFindConcreteNode();
        this.checkEventScope();
    }

    private void doFindConcreteNode() {
        this.node = this.owningComponent.moderator.lookupFabricNode(this.nodeName);
        if (this.node != null && !this.node.isLocal() && this.getEventScope() == EventScope.CLUSTER && !this.matchesCluster(this.node)) {
            this.node = null;
        }
    }

    private boolean findConcreteComponent(String componentFullName, FabricNodeReference node) {
        return this.checkFoundComponent(this.doFindConcreteComponent(componentFullName, node));
    }

    private boolean findGenericComponent(String componentFullName) {
        return this.checkFoundComponent(this.doFindGenericComponent(componentFullName, this.getNodes()));
    }

    private List<FabricNodeReference> getNodes() {
        List<FabricNodeReference> fabricNodes = this.owningComponent.moderator.getFabricNodes();
        if (this.getEventScope() == EventScope.CLUSTER) {
            fabricNodes.removeIf(fabricNode -> !this.matchesCluster((FabricNodeReference)fabricNode));
        } else if (this.isClustered()) {
            fabricNodes.sort(this.clusterComparator);
        }
        return fabricNodes;
    }

    private boolean checkFoundComponent(ComponentData data) {
        if (data.isValid()) {
            this.setComponent(data);
            return true;
        }
        return false;
    }

    private ComponentData doFindConcreteComponent(String componentFullName, FabricNodeReference node) {
        ComponentData data = new ComponentData(node, AbstractComponentAccessor.lookupComponent(componentFullName, node));
        if (this.isSuitable(data.component)) {
            data.sessionManager = AbstractComponentAccessor.findSessionManager(data.component);
        }
        return data;
    }

    private ComponentData doFindGenericComponent(String componentFullName, List<FabricNodeReference> nodes) {
        ComponentData result = new ComponentData();
        long maxNodeWeight = Long.MIN_VALUE;
        for (FabricNodeReference fabricNode : nodes) {
            RequestConsumerReference sessionManager;
            ComponentReference component = AbstractComponentAccessor.lookupComponent(componentFullName, fabricNode);
            if (!this.isSuitable(component) || fabricNode.getWeight() <= maxNodeWeight || (sessionManager = AbstractComponentAccessor.findSessionManager(component)) == null) continue;
            result.node = fabricNode;
            result.component = component;
            result.sessionManager = sessionManager;
            maxNodeWeight = fabricNode.getWeight();
        }
        return result;
    }

    private static ComponentReference lookupComponent(String componentName, FabricNodeReference node) {
        return node.lookupComponent(componentName);
    }

    private boolean isSuitable(ComponentReference component) {
        return component != null && this.matchesComponentModel(component);
    }

    private boolean matchesComponentModel(ComponentReference component) {
        return this.componentModel == null || component.getModel().equals((Object)this.componentModel);
    }

    private static RequestConsumerReference findSessionManager(ComponentReference component) {
        return component.lookupRequestConsumer("sys$SessionManager");
    }

    private boolean findSpecial() throws FabricComponentAccessorException {
        if (this.sessionManager == null) {
            this.throwInvalidComponent("Session manager is not available for component '" + this.getComponentFullName() + "'.");
        }
        return true;
    }

    @Override
    public synchronized void setAutoSwitching(boolean autoSwitching) throws FabricComponentAccessorException {
        this.checkOpened();
        this.autoSwitching = autoSwitching;
        if (this.isGeneric()) {
            if (autoSwitching) {
                this.addSessionEstablisherForGenericComponent(false);
            } else if (this.isAvailable()) {
                this.destroySessionEstablisherConsumer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean switchComponent() throws FabricComponentAccessorException {
        this.checkOpened();
        if (this.sessionEstablishingInProgress) return false;
        AbstractComponentAccessor abstractComponentAccessor = this;
        synchronized (abstractComponentAccessor) {
            if (this.sessionEstablishingInProgress) return false;
            this.sessionEstablishingInProgress = true;
            try {
                if (!this.isGeneric()) return false;
                boolean bl = this.doSwitchComponent(false);
                return bl;
            }
            finally {
                this.sessionEstablishingInProgress = false;
            }
        }
    }

    @Override
    public boolean resync() throws FabricComponentAccessorException {
        return this.doResync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doResync(boolean inSeparateThread) throws FabricComponentAccessorException {
        this.checkOpened();
        if (this.sessionEstablishingInProgress) return false;
        AbstractComponentAccessor abstractComponentAccessor = this;
        synchronized (abstractComponentAccessor) {
            if (this.sessionEstablishingInProgress) return false;
            this.sessionEstablishingInProgress = true;
            try {
                if (this.isGeneric()) {
                    boolean bl = this.doSwitchComponent(inSeparateThread);
                    return bl;
                }
                if (this.isAvailable()) return false;
                this.doFindConcreteNode();
                if (this.node != null && this.findConcreteComponent(this.getComponentFullName(), this.node)) {
                    boolean bl = this.doEstablishSession(inSeparateThread, true);
                    return bl;
                }
                this.setComponent(ComponentData.NULL);
            }
            finally {
                this.sessionEstablishingInProgress = false;
            }
            return false;
        }
    }

    private boolean doSwitchComponent(boolean inSeparateThread) {
        ComponentData data;
        List<FabricNodeReference> nodes = this.getNodes();
        if ((!this.isAvailable() || this.getTotalNodeWeights(nodes) > 0L || this.isClustered() && !this.matchesCluster(this.node)) && (data = this.doFindGenericComponent(this.getComponentFullName(), nodes)).isValid()) {
            if (this.isAvailable()) {
                if (this.needToSwitch(data.node)) {
                    this.doSwitch(data);
                    return this.doEstablishSession(inSeparateThread, false);
                }
            } else {
                this.setComponent(data);
                return this.doEstablishSession(inSeparateThread, false);
            }
        }
        return false;
    }

    private long getTotalNodeWeights(List<FabricNodeReference> nodes) {
        return nodes.stream().mapToLong(FabricNodeReference::getWeight).sum();
    }

    private boolean doEstablishSession(boolean inSeparateThread, boolean dropEstablisher) {
        if (inSeparateThread) {
            this.raiseAdvisory(FabricComponentAccessorState.AUTOMATIC_RESYNC, false);
            return this.startSessionEstablisherThread(dropEstablisher);
        }
        return this.doEstablishSession(dropEstablisher);
    }

    private void addSessionEstablisherForGenericComponent(boolean withWarning) throws FabricComponentAccessorException {
        this.addSessionEstablisher(this.makeSelector(this.makeSelectorForGenericComponent()), withWarning);
    }

    private void addSessionEstablisher(String selector, boolean withWarning) throws FabricComponentAccessorException {
        if (withWarning) {
            this.logWarning(this.getNotAvailableMessage());
        }
        if (this.sessionEstablisherConsumer == null) {
            this.sessionEstablisherConsumer = this.createSessionSetupConsumer(this.sessionEstablisherName, new FabricEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
                    AbstractComponentAccessor abstractComponentAccessor = AbstractComponentAccessor.this;
                    synchronized (abstractComponentAccessor) {
                        boolean inSwitchingMode;
                        boolean bl = inSwitchingMode = AbstractComponentAccessor.this.isAvailable() && AbstractComponentAccessor.this.canSwitch();
                        if ((!AbstractComponentAccessor.this.isAvailable() || inSwitchingMode) && this.processEvent(event)) {
                            AbstractComponentAccessor.this.startSessionEstablisherThread(!inSwitchingMode);
                        }
                    }
                }

                private boolean processEvent(ImmutableEventDatagram event) {
                    FabricModeratorAdvisory advisory = (FabricModeratorAdvisory)event;
                    if (advisory.getType() == ModeratorAdvisoryType.NODE_CONNECTED) {
                        FabricNodeReference newNode = AbstractComponentAccessor.this.owningComponent.moderator.lookupFabricNode(advisory.getEntity());
                        if (newNode != null && (AbstractComponentAccessor.this.getEventScope() != EventScope.CLUSTER || AbstractComponentAccessor.this.matchesCluster(newNode))) {
                            if (AbstractComponentAccessor.this.isRuntimeAccessor()) {
                                AbstractComponentAccessor.this.node = newNode;
                                AbstractComponentAccessor.this.sessionManager = AbstractComponentAccessor.this.lookupConsumer("sys$SessionManager");
                                return true;
                            }
                            if (AbstractComponentAccessor.this.isAvailable()) {
                                return AbstractComponentAccessor.this.doSwitch(newNode, null);
                            }
                            return AbstractComponentAccessor.this.findConcreteComponent(AbstractComponentAccessor.this.getComponentFullName(), newNode);
                        }
                    } else if (advisory.getType() == ModeratorAdvisoryType.REQUEST_CONSUMER_ADDED) {
                        if (AbstractComponentAccessor.this.isAvailable()) {
                            return AbstractComponentAccessor.this.doSwitch(null, advisory.getEntity());
                        }
                        ComponentData data = AbstractComponentAccessor.this.findComponent(advisory.getEntity());
                        if (AbstractComponentAccessor.this.isValid(data)) {
                            AbstractComponentAccessor.this.setComponent(data);
                            return true;
                        }
                    }
                    return false;
                }
            }, "advisory.fabric.Moderator", selector);
        }
    }

    private EventConsumer createSessionSetupConsumer(String name, FabricEventListener listener, String eventId, String selector) throws FabricComponentAccessorException {
        try {
            return this.owningComponent.dispatcher.createHiddenEventConsumer(name, listener, eventId, selector);
        }
        catch (FabricEventDispatcherException exception) {
            throw new FabricComponentAccessorException(6011, "Creation of '" + name + "' consumer failed.", exception);
        }
    }

    private boolean doSwitch(FabricNodeReference newNode, String sessionManagerConsumer) {
        ComponentData data;
        if (newNode != null) {
            ComponentData data2;
            if (this.needToSwitch(newNode) && (data2 = this.doFindConcreteComponent(this.getComponentFullName(), newNode)).isValid()) {
                return this.doSwitch(data2);
            }
            return false;
        }
        if (sessionManagerConsumer != null && this.isValid(data = this.findComponent(sessionManagerConsumer)) && this.needToSwitch(data.node)) {
            return this.doSwitch(data);
        }
        return false;
    }

    private boolean needToSwitch(FabricNodeReference newNode) {
        return this.node != null && !this.node.getName().equals(newNode.getName()) && (this.node.getWeight() < newNode.getWeight() || this.isClustered() && this.clusterComparator.compare(this.node, newNode) > 0);
    }

    private boolean doSwitch(ComponentData data) {
        this.logDebug("Switching from '" + this.getComponentActualName() + "' to '" + data.component.getName() + "'...");
        this.closeForSwitching();
        this.setComponent(data);
        return true;
    }

    private ComponentData findComponent(String sessionManagerConsumer) {
        ComponentData result = new ComponentData();
        result.sessionManager = this.owningComponent.moderator.lookupRequestConsumer(sessionManagerConsumer);
        result.component = this.owningComponent.moderator.lookupComponent(result.sessionManager.getComponentAddress());
        result.node = this.owningComponent.moderator.lookupFabricNode(result.component.getAddress().getNodeAddress());
        return this.getEventScope() != EventScope.CLUSTER || this.matchesCluster(result.node) ? result : ComponentData.NULL;
    }

    private boolean isGeneric() {
        return !this.isRuntimeAccessor() && this.nodeName == null;
    }

    private boolean canSwitch() {
        return this.autoSwitching && this.isGeneric();
    }

    private void closeForSwitching() {
        this.raiseCloseRequest();
        this.clearSessionData();
        this.onSessionClose();
    }

    private String makeSelector(String componentSelector) {
        String nodeSelector = this.makeSelectorForNode();
        return nodeSelector != null ? nodeSelector + " OR " + componentSelector : componentSelector;
    }

    private String makeSelectorForNode() {
        return this.getEventScope() != EventScope.OBSERVABLE ? "type = 'NODE_CONNECTED'" + (String)(this.nodeName != null ? " AND entity = '" + this.nodeName + "'" : "") : null;
    }

    private String makeSelectorForConcreteComponent() {
        return "type = 'REQUEST_CONSUMER_ADDED' AND entity = '" + ModeratorUtils.makeConsumerFullName(this.nodeName, this.componentType, this.componentName, "sys$SessionManager") + "'";
    }

    private String makeSelectorForGenericComponent() {
        return "type = 'REQUEST_CONSUMER_ADDED' AND entity MATCHES '.*://" + ModeratorUtils.makeConsumerFullName(this.componentType, this.componentName, SESSION_MANAGER_CONSUMER_NAME_FOR_SELECTOR) + "'";
    }

    private void throwInvalidComponent(String errorMessage) throws FabricComponentAccessorException {
        throw new FabricComponentAccessorException(6020, errorMessage);
    }

    private void checkEventScope() throws FabricComponentAccessorException {
        if (!(this.node != null && this.node.isLocal() || this.getEventScope() != EventScope.OBSERVABLE)) {
            throw new FabricComponentAccessorException(6044, "Accessor with OBSERVABLE event scope cannot access remote node.");
        }
    }

    @Override
    public String getAccessorName() {
        return this.accessorName;
    }

    @Override
    public String getName() {
        return this.accessorFullName;
    }

    @Override
    public EventScope getEventScope() {
        return this.eventScope;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    @Override
    public String getSLSessionName() {
        return this.slSessionName;
    }

    @Override
    public boolean isInstant() {
        return this.isInstant;
    }

    @Override
    public boolean isSpecial() {
        return this.isSpecial;
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    void checkOpened() throws FabricComponentAccessorException {
        if (!this.isOpened) {
            throw new FabricComponentAccessorException(6022, "Accessor '" + this.getName() + "' is not opened.");
        }
    }

    void checkNotOpened() throws FabricComponentAccessorException {
        if (this.isOpened) {
            throw new FabricComponentAccessorException(6021, "Accessor '" + this.getName() + "' is opened.");
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpened) {
            this.closingInProgress = true;
            if (this.isAvailable()) {
                this.raiseCloseRequest();
            }
            if (!this.isInstant()) {
                this.owningComponent.removeAccessor(this);
            }
            this.doCloseSession(false);
            if (!this.isInstant()) {
                if (this.stateListener != null) {
                    this.stateListener.onClose(this);
                }
                this.destroyStateListenerTimer();
                this.stateListener = null;
            }
            this.closingInProgress = false;
            this.isOpened = false;
            this.raiseAdvisory(FabricComponentAccessorState.ACCESSOR_CLOSED, false);
        }
    }

    synchronized void forcedClose() {
        this.clearSessionData();
        this.isOpened = false;
    }

    private void addSessionFinalizer() throws FabricComponentAccessorException {
        if (!this.isLocalRuntimeAccessor() && this.sessionFinalizerConsumer == null) {
            this.sessionFinalizerConsumer = this.createSessionSetupConsumer(this.sessionFinalizerName, event -> {
                if (this.slSession != null) {
                    if (!this.closingInProgress) {
                        SLSessionImpl sLSessionImpl = this.slSession;
                        synchronized (sLSessionImpl) {
                            this.finalizeSession((FabricModeratorAdvisory)event);
                        }
                    }
                } else {
                    this.finalizeSession((FabricModeratorAdvisory)event);
                }
            }, "advisory.fabric.Moderator", this.makeFinalizerSelector());
        }
    }

    String makeFinalizerSelector() {
        return "(type = 'NODE_DISCONNECTED' OR type = 'NODE_DISCONNECTED_FORCIBLY') AND entity = '" + this.getActualNodeName() + "' OR type = 'REQUEST_CONSUMER_REMOVED' AND entity = '" + this.sessionManager.getName() + "'";
    }

    private synchronized void finalizeSession(FabricModeratorAdvisory advisory) {
        if (this.isAvailable()) {
            this.doCloseSession(true);
            this.startSessionEstablisherThread(false);
        }
    }

    private synchronized void doCloseSession(boolean routed) {
        this.clearSessionData();
        if (!this.isInstant()) {
            this.destroySessionEstablisherConsumer();
            this.destroySessionFinalizerConsumer();
            if (routed && this.slSession != null && this.slSession.isRouted()) {
                this.slSession.routedClose();
            }
            if (!this.isRuntimeAccessor()) {
                this.onSessionClose();
            }
        }
    }

    private void raiseCloseRequest() {
        try {
            this.doRaiseSessionRequest(SessionRequest.createCloseRequest(this.owningComponent.getFullName(), this.getSessionName(), this.isInstant(), this.getSLSessionName()));
        }
        catch (Exception exception) {
            this.logException(exception, "Closing session failed.");
        }
    }

    private void clearSessionData() {
        if (this.node != null && this.session != null) {
            ((FabricNode)this.node).removeAccessorSession((AccessorSessionReferenceImpl)this.session);
        }
        this.isAvailable = false;
        this.node = null;
        this.actualNodeName = null;
        this.component = null;
        this.sessionManager = null;
        this.session = null;
        this.eventScope = this.owningComponent.eventScope;
    }

    private void reOpenSLSession() {
        try {
            if (this.slSession != null) {
                this.slSession.open(false, this.nodeName);
            }
        }
        catch (Exception exception) {
            this.logException(exception, "Reopening SLANG session to '" + this.nodeName + "' node failed.");
        }
    }

    void onSessionClose() {
    }

    private boolean startSessionEstablisherThread(boolean dropEstablisher) {
        FabricThreadManager.getInstance().createThread("EXCH:Accessor.SessionEstablisher", "Re-establishes an accessor session.", () -> {
            Utils.sleep(500L);
            AbstractComponentAccessor abstractComponentAccessor = this;
            synchronized (abstractComponentAccessor) {
                this.doEstablishSession(dropEstablisher);
            }
        }).start();
        return true;
    }

    private boolean doEstablishSession(boolean dropEstablisher) {
        try {
            if (dropEstablisher) {
                this.destroySessionEstablisherConsumer();
            } else {
                this.destroySessionFinalizerConsumer();
            }
            if (this.owningComponent.isConnectionValid() && this.owningComponent.existsAccessor(this.accessorName) && (this.slSession == null || !this.slSession.isAvailable())) {
                this.establishSession(true);
            }
            return true;
        }
        catch (FabricComponentAccessorException exception) {
            this.logException(exception, "Establishing session failed.");
            return false;
        }
    }

    private void destroySessionEstablisherConsumer() {
        if (this.sessionEstablisherConsumer != null) {
            if (this.owningComponent.dispatcher != null) {
                this.owningComponent.dispatcher.dropSystemConsumer(this.sessionEstablisherName);
            }
            this.sessionEstablisherConsumer = null;
        }
    }

    private void destroySessionFinalizerConsumer() {
        if (this.sessionFinalizerConsumer != null) {
            if (this.owningComponent.dispatcher != null) {
                this.owningComponent.dispatcher.dropSystemConsumer(this.sessionFinalizerName);
            }
            this.sessionFinalizerConsumer = null;
        }
    }

    private SessionResponse doRaiseSessionRequest(SessionRequest request) throws FabricComponentAccessorException {
        try {
            this.logDeepDebug("Raising SessionRequest: " + String.valueOf(request) + ".");
            ImmutableEventDatagram reply = this.owningComponent.dispatcher.raiseSystemRequest(this.sessionManager, SDOUtils.createOpaqueEvent("e.sys.SessionRequest", request), 30000L);
            if (reply instanceof OpaqueEvent) {
                return (SessionResponse)((OpaqueEvent)reply).getData();
            }
            if (reply instanceof FabricEventSourceException) {
                this.throwSessionEstablishmentError(((FabricEventSourceException)reply).getMessage());
            } else {
                this.throwSessionEstablishmentError(null);
            }
        }
        catch (Exception exception) {
            if (exception instanceof FabricComponentAccessorException) {
                throw (FabricComponentAccessorException)exception;
            }
            throw new FabricComponentAccessorException(6011, "Raising session request failed.", exception);
        }
        return null;
    }

    void onSessionOpen(SessionResponse response) {
    }

    private void throwSessionEstablishmentError(String cause) throws FabricComponentAccessorException {
        throw new FabricComponentAccessorException(6011, "Establishing session with '" + this.getComponentFullName() + "' component failed." + (String)(cause != null ? " Cause: " + cause : ""));
    }

    public String getComponentFullName() {
        return ModeratorUtils.makeComponentFullName(this.componentType, this.componentName);
    }

    public String getComponentFullNameWithNode() {
        return ModeratorUtils.makeComponentFullName(this.nodeName, this.componentType, this.componentName);
    }

    private RequestConsumerReference lookupConsumer(String consumerName) {
        return this.node.lookupRequestConsumer(ModeratorUtils.makeConsumerFullName(this.componentType, this.componentName, consumerName));
    }

    private boolean isRuntimeAccessor() {
        return this.componentType.equalsIgnoreCase("RuntimeContext");
    }

    private boolean isLocalRuntimeAccessor() {
        return this.isRuntimeAccessor() && this.node != null && this.node.isLocal();
    }

    private boolean isClustered() {
        return this.owningComponent.moderator.exchange.isClustered();
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public String getActualNodeName() {
        return this.actualNodeName;
    }

    @Override
    public AccessorSessionReference getSession() {
        return this.session;
    }

    String getSessionName() {
        return this.session != null ? this.session.getSessionName() : null;
    }

    private String getComponentFullNameForMessage() {
        return this.component != null ? this.component.getName() : (this.nodeName != null ? this.getComponentFullNameWithNode() : this.getComponentFullName());
    }

    private String getComponentActualName() {
        return ModeratorUtils.makeComponentFullName(this.getActualNodeName(), this.getComponentType(), this.getComponentName());
    }

    String getNotAvailableMessage() {
        return "Resource '" + this.getComponentFullNameForMessage() + "' is not available.";
    }

    @Override
    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Override
    public boolean autoSwitching() {
        return this.autoSwitching;
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement) throws FabricComponentAccessorException {
        return this.invokeLanguageRequest(statement, this.requestTimeout);
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeLanguageRequest((SLRequestRaiser)this, statement, timeout);
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement) throws FabricComponentAccessorException {
        return this.invokeLanguageRequest(statement, this.requestTimeout);
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeLanguageRequest((SLRequestRaiser)this, statement, timeout);
    }

    @Override
    public SLResponse invokeInterruptRequest(String command) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeInterruptRequest(this, command, 10000L);
    }

    @Override
    public SLResponse invokeCompleteRequest(String command) throws FabricComponentAccessorException {
        return this.invokeCompleteRequest(command, this.requestTimeout);
    }

    @Override
    public SLResponse invokeCompleteRequest(String command, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeCompleteRequest(this, command, timeout);
    }

    SLResponse invokeRequest(String eventId, Object wrapper, long timeout) throws FabricComponentAccessorException {
        this.checkOpened();
        return SLRequestRaiser.invokeRequest(this, eventId, wrapper, timeout);
    }

    public SLResponse setInterruptUnderlyingRequestOnTimeout(boolean isInterruptUnderlyingRequestOnTimeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.setInterruptUnderlyingRequestOnTimeout(this, isInterruptUnderlyingRequestOnTimeout, this.requestTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableEventDatagram raiseSystemRequest(ImmutableEventDatagram request, long timeout) throws Exception {
        AbstractComponentAccessor abstractComponentAccessor = this;
        synchronized (abstractComponentAccessor) {
            if (!this.isAvailable()) {
                this.doEstablishSession(true);
            }
        }
        this.checkAvailable();
        return this.owningComponent.dispatcher.raiseSystemRequest(this.session, request, timeout);
    }

    void checkAvailable() throws FabricComponentAccessorException {
        if (!this.isAvailable() || this.session == null) {
            this.raiseAdvisory(FabricComponentAccessorState.UNAVAILABLE_RESOURCE_ACCESSED, false);
            throw new FabricComponentAccessorException(6023, this.getNotAvailableMessage());
        }
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener) {
        this.setStateListener(listener, 300000L);
    }

    @Override
    public synchronized void setStateListener(FabricComponentAccessorStateListener listener, long repeatInterval) {
        if (this.stateListener != listener || this.stateListenerRepeatInterval != (repeatInterval *= 1000L)) {
            this.stateListener = listener;
            this.stateListenerRepeatInterval = repeatInterval;
            this.destroyStateListenerTimer();
            if (listener != null) {
                this.hasStateListener = true;
                this.createStateListenerTimer();
            } else {
                this.hasStateListener = false;
            }
        }
    }

    private void createStateListenerTimer() {
        if (this.stateListenerTimer == null && this.stateListenerRepeatInterval > 0L) {
            try {
                this.stateListenerTimer = FabricTimerManager.getInstance().createTimer(STATE_LISTENER_TIMER_GROUP, this.accessorName, new AbstractFabricTimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(FabricTimer timer) {
                        AbstractComponentAccessor abstractComponentAccessor = AbstractComponentAccessor.this;
                        synchronized (abstractComponentAccessor) {
                            try {
                                if (!AbstractComponentAccessor.this.isAvailable()) {
                                    AbstractComponentAccessor.this.establishSession(true);
                                }
                            }
                            catch (FabricComponentAccessorException exception) {
                                AbstractComponentAccessor.this.logException(exception, "Session re-establishing failed.");
                                AbstractComponentAccessor.this.onResourceUnavailable();
                                AbstractComponentAccessor.this.stateListener.onResourceUnavailable(AbstractComponentAccessor.this);
                            }
                        }
                    }
                }, this.stateListenerRepeatInterval, -1);
                this.stateListenerTimer.start();
            }
            catch (FabricTimerException exception) {
                this.logException(exception, "Creating state listener timer failed.");
            }
        }
    }

    private void destroyStateListenerTimer() {
        if (this.stateListenerTimer != null) {
            this.stateListenerTimer.stop();
            this.stateListenerTimer = null;
        }
    }

    @Override
    public boolean hasStateListener() {
        return this.hasStateListener;
    }

    private void onResourceUnavailable() {
        if (this.state != FabricComponentAccessorState.RESOURCE_UNAVAILABLE) {
            this.raiseAdvisory(FabricComponentAccessorState.RESOURCE_UNAVAILABLE, true);
        }
    }

    private void raiseAdvisory(FabricComponentAccessorState state, boolean setState) {
        try {
            if (setState) {
                this.state = state;
            }
            if (this.owningComponent.dispatcher != null) {
                this.owningComponent.dispatcher.raiseSystemAdvisory(new FabricComponentAccessorAdvisory(this.getName(), this.getComponentFullNameForMessage(), this.owningComponent.getOwnerName(), state), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    @Override
    public List<String> listBoundEventIds() {
        return null;
    }

    @Override
    public boolean hasSinkEvents() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public List<String> listSinkEvents() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean hasActionableEvents() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public List<String> listActionableEvents() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void disableEventTrigger(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void enableEventTrigger(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean hasEventTriggers() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public List<String> listEventTriggers() {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public String getLastError(String triggerName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public String toString() {
        return super.toString() + " (" + (this.getActualNodeName() != null ? ModeratorUtils.makeComponentFullName(this.getActualNodeName(), this.componentType, this.componentName) : this.getComponentFullNameWithNode()) + ", " + this.getSessionName() + ")";
    }

    SessionResponse raiseOpenRequestForActivator() throws FabricComponentAccessorException {
        SLSessionMFSession mfSession = this.slSession != null ? this.slSession.mfSession : null;
        return this.doRaiseSessionRequest(SessionRequest.createOpenRequest(this.owningComponent.getFullName(), "Activator$" + this.accessorName, this.owningComponent.getOwnerName(), !this.node.isLocal(), false, this.getSLSessionName(), mfSession != null ? mfSession.getSLSessionData() : new SLSessionDataImpl()));
    }

    void raiseCloseRequestForActivator(String sessionName) throws FabricComponentAccessorException {
        this.doRaiseSessionRequest(SessionRequest.createCloseRequest(this.owningComponent.getFullName(), sessionName, false, this.getSLSessionName()));
    }

    private boolean matchesCluster(FabricNodeReference fabricNode) {
        return fabricNode != null && this.getComponentAddress().getNodeAddress().matchesCluster(fabricNode.getFabricAddress());
    }

    String printMetadata() {
        return "Node: " + this.printNode() + ", component: " + String.valueOf(this.component) + ", sessionManager: " + String.valueOf(this.sessionManager);
    }

    String printNode() {
        return this.node != null ? ((FabricNode)this.node).getFullPrintName() : null;
    }

    void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }

    void logException(Throwable exception, String message) {
        this.logException(exception);
        this.logError(message);
    }

    void logError(String message) {
        Trace.logError(this, this.getName() + ": " + message);
    }

    void logInfo(String message) {
        Trace.logInfo(this, this.getName() + ": " + message);
    }

    void logDebug(String message) {
        if (!Trace.logDebug(this, this.getName() + ": " + message)) {
            this.logDeepDebug(message);
        }
    }

    void logDeepDebug(String message) {
        Trace.logDebug(AccessorDebug.class, this.getName() + ": " + message);
    }

    void logWarning(String message) {
        this.logInfo("WARNING: " + message);
    }

    private static class ComponentData {
        FabricNodeReference node = null;
        ComponentReference component = null;
        RequestConsumerReference sessionManager = null;
        static final ComponentData NULL = new ComponentData();

        ComponentData() {
        }

        ComponentData(FabricNodeReference node, ComponentReference component) {
            this.node = node;
            this.component = component;
        }

        boolean isValid() {
            return this.node != null && this.component != null && this.sessionManager != null;
        }
    }
}

