/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSysplexOperation;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;

public abstract class AbstractClientOperation
extends AbstractSysplexOperation {
    AbstractClientOperation(String operationName, boolean administrative) {
        super(administrative);
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName).addActionParameter((SyntaxParameter)new ExpressionParameter("ClientId").setExcludedDelimiters("@="));
        this.syntax.setSyntaxDescription(this.initSyntaxDescription());
        this.syntax.setExamples(this.getExamples());
        this.syntax.addTag(OperationTag.moderator);
    }

    String initSyntaxDescription() {
        return "Parameter ClientId must have the following format: [<NodeName>://]<ComponentType>.<ComponentName>";
    }

    String getExamples() {
        return this.getName() + " Client_SLANG.Client1_TestNode\n" + this.getName() + " TestNode1://Client_SLANG.Client1_TestNode";
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        try {
            RowSet rowSet = response.getRowSet();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    completions.add(ModeratorUtils.makeComponentFullName(rowSet.getString(1), rowSet.getString(2), rowSet.getString(3)));
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return AbstractClientOperation.createDefinition(this.syntax.getName(), statement);
    }

    public static Definition createDefinition(String operationName, DSLStatement statement) throws ParsingException {
        return new Definition(operationName, statement.existsParameter("ClientId") ? statement.getParameter("ClientId").getValue() : null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(ModeratorUtils.extractNodeName(((Definition)statement).clientId), statement, session, timeout, false, false);
    }

    public static class Definition
    extends AbstractSLStatement {
        String clientId;

        public Definition(String operationName, String clientId) {
            super(operationName);
            this.clientId = clientId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }
    }
}

