/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientContextException;
import com.streamscape.cli.ClientContextRuntimeException;
import com.streamscape.sdo.AbstractDatagramFactoryManager;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.cli.ClientComponent;
import com.streamscape.sef.dispatcher.AbstractFabricContext;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.dispatcher.ClientAuthenticationModuleFactory;
import com.streamscape.sef.dispatcher.ClientDatagramPrototypeFactory;
import com.streamscape.sef.dispatcher.ClientDiscoveryModuleFactory;
import com.streamscape.sef.dispatcher.ClientLoaderRegistryImpl;
import com.streamscape.sef.dispatcher.ClientSemanticTypeFactory;
import com.streamscape.sef.dispatcher.DiagnosticSLSessionImpl;
import com.streamscape.sef.security.AuthenticationModule;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.slex.slang.SpecialSLSession;
import com.streamscape.tools.mnode.activator.ActivatorSLSessionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractClientContext
extends AbstractFabricContext {
    public static final String AUTHENTICATION_MODULE_CLASS = "streamscape.authentication.module.class";
    public static final String DISCOVERY_MODULE_CLASS = "streamscape.discovery.module.class";
    protected UUID fabricUid;
    protected ClientLoaderRegistryImpl loaderRegistry;
    protected AuthenticationModule authenticationModule;
    protected Map<String, AbstractSpecialSLSession> specialSessions;

    @Override
    public UUID getFabricUID() {
        return this.fabricUid;
    }

    @Override
    protected void initPackageManifestManager() {
        this.loaderRegistry = new ClientLoaderRegistryImpl(this, this.getClass().getClassLoader());
    }

    @Override
    public ClassLoader getSystemClassLoaderChain() {
        return this.loaderRegistry.getSystemClassLoaderChain();
    }

    protected void initSemanticTypeFactory() {
        this.semanticTypeFactory = new ClientSemanticTypeFactory();
    }

    protected abstract AbstractDatagramFactoryManager createDatagramFactoryManager() throws Exception;

    protected void initDatagramFactories() throws Exception {
        this.datagramPrototypeFactory = new ClientDatagramPrototypeFactory(this);
        this.datagramFactoryManager = this.createDatagramFactoryManager();
        this.addSystemAdvisoryPrototypes();
        this.addSystemEventPrototypes();
        this.addSystemExceptionPrototypes();
        this.addPredefinedEventPrototypes();
    }

    protected ClientDatagramPrototypeFactory getClientDatagramPrototypeFactory() {
        return (ClientDatagramPrototypeFactory)this.datagramPrototypeFactory;
    }

    protected void initDiscoveryModule() {
        try {
            Trace.logInfo(this, "Discovery Module initializing...");
            this.discoveryModuleFactory = new ClientDiscoveryModuleFactory();
            this.discoveryModuleFactory.init();
            this.setDiscoveryModuleParameters("Default");
            this.discoveryModuleFactory.activateModule("Default");
            Trace.logInfo(this, "Discovery Module initialized.");
        }
        catch (Exception exception) {
            throw new ClientContextRuntimeException("Discovery Module initialization failed.", exception);
        }
    }

    protected void initAuthenticationModule() {
        try {
            Trace.logInfo(this, "Authentication Module initializing...");
            this.authenticationModuleFactory = new ClientAuthenticationModuleFactory();
            this.authenticationModuleFactory.init();
            this.authenticationModuleFactory.activateModule("Default");
            Trace.logInfo(this, "Authentication Module initialized.");
        }
        catch (Exception exception) {
            throw new ClientContextRuntimeException("Authentication Module initialization failed.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(ClientComponent component) throws ClientContextException {
        Map map = this.boundComponents;
        synchronized (map) {
            if (this.boundComponents.containsKey(component.getContextId())) {
                throw new ClientContextException("Bind Error: component already bound.");
            }
            this.checkComponentUniqueness(component.getType(), component.getName());
            this.boundComponents.put(component.getContextId(), component);
        }
    }

    void checkComponentUniqueness(String type, String name) throws ClientContextException {
        for (FabricComponent component : this.boundComponents.values()) {
            if (!component.getType().equals(type) || !component.getName().equals(name)) continue;
            throw new ClientContextException("Component with type '" + type + "' and name '" + name + "' already bound.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind(ClientComponent component) {
        Map map = this.boundComponents;
        synchronized (map) {
            this.boundComponents.remove(component.getContextId());
            if (this.boundComponents.isEmpty()) {
                this.domain = null;
                this.fabricUid = null;
            }
        }
    }

    protected List<FabricComponent> getComponents() {
        return new ArrayList<FabricComponent>(this.boundComponents.values());
    }

    protected SpecialSLSession createDiagnosticSession(String url, String userName, String password, long timeout) throws SLSessionException {
        return this.doCreateDiagnosticSession(url, userName, password, timeout, false);
    }

    protected SpecialSLSession doCreateDiagnosticSession(String url, String userName, String password, long timeout, boolean fromSlangTool) throws SLSessionException {
        DiagnosticSLSessionImpl session = new DiagnosticSLSessionImpl(this, url, userName, password, timeout, fromSlangTool);
        this.addSpecialSession(session);
        return session;
    }

    protected SpecialSLSession createActivatorSession(String url, String userName, String password, long timeout) throws SLSessionException {
        return this.doCreateActivatorSession(url, userName, password, timeout, false);
    }

    protected SpecialSLSession doCreateActivatorSession(String url, String userName, String password, long timeout, boolean fromSlangTool) throws SLSessionException {
        ActivatorSLSessionImpl session = new ActivatorSLSessionImpl(this, url, userName, password, timeout, fromSlangTool);
        this.addSpecialSession(session);
        return session;
    }

    private synchronized void addSpecialSession(AbstractSpecialSLSession session) {
        if (this.specialSessions == null) {
            this.specialSessions = new ConcurrentHashMap<String, AbstractSpecialSLSession>();
        }
        this.specialSessions.put(session.getName(), session);
    }

    synchronized void removeSpecialSession(AbstractSpecialSLSession session) {
        if (this.specialSessions != null) {
            this.specialSessions.remove(session.getName());
        }
    }

    protected synchronized void closeSpecialSessions() {
        if (this.specialSessions != null) {
            this.specialSessions.values().forEach(AbstractSpecialSLSession::close);
            this.specialSessions.clear();
        }
    }

    @Override
    protected void logException(Throwable exception, boolean printStackTrace) {
        Trace.logException(ClientContext.class, exception, printStackTrace);
    }

    @Override
    protected void logError(String message) {
        Trace.logError(ClientContext.class, message);
    }

    @Override
    protected void logInfo(String message) {
        Trace.logInfo(ClientContext.class, message);
    }

    @Override
    protected void logDebug(String message) {
        Trace.logDebug(ClientContext.class, message);
    }
}

