/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceWriteMessage;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sef.dispatcher.DataspaceAccessorForJDBC;
import java.io.IOException;

public abstract class AbstractClientConnection {
    protected DataspaceAccessorForJDBC accessor;

    protected void setAccessor(DataspaceAccessor accessor) {
        this.accessor = (DataspaceAccessorForJDBC)((Object)accessor);
    }

    protected byte[] invokeWriteRequest(byte[] bytes, long timeout) throws IOException {
        try {
            OpaqueEvent event = this.accessor.createOpaqueEvent("e.sys.dataspace.write", new DataspaceWriteMessage(bytes));
            ImmutableEventDatagram reply = this.accessor.raiseDataspaceWriteMessage(event, timeout);
            if (reply == null) {
                throw new IOException("Received response is null.");
            }
            if (!(reply instanceof OpaqueEvent)) {
                throw new IOException("Received response has wrong type.");
            }
            return ((DataspaceWriteMessage)((OpaqueEvent)reply).getData()).getBytes();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
    }
}

