/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.file.SLFileOutputStreamFactory;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.mnode.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractBackupNodeOperation<T extends RuntimeContext>
extends AbstractFrmNodeOperation<T> {
    protected static final String TMP_FRM_FILENAME = "tmp.frm";

    protected AbstractBackupNodeOperation(String name) {
        this(name, null);
    }

    protected AbstractBackupNodeOperation(String name, String alias) {
        this.createDSLSyntax(name);
        this.syntax.setAction(name.toUpperCase());
        if (alias != null) {
            this.syntax.setAlias(alias);
        }
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("MANIFEST", false).addParameter(new IdentifierParameter("ManifestName"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("").addPossibleValues("AT", "@").setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("").setName("FrmPathModifier")).addParameter(new SLFilePathParameter("FrmPath"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("NO DATA", false).setName("WithoutData"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("NO DEFRAG", false).setName("WithoutDefrag")).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("MNODE-SCRIPT", false).addParameter(new SLFilePathParameter("MnodeScript")));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TNODE-SCRIPT", false).addParameter(new SLFilePathParameter("TnodeScript"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("PASSWORD", false).addParameter(new StringParameter("Password")));
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = this.createDefinition(statement, statement.getParameter("FrmPath").getValue(), !statement.existsModifier("WithWait"), statement.existsParameter("ManifestName") ? statement.getParameter("ManifestName").getValue() : null, statement.existsModifier("WithoutData"), statement.existsModifier("WithoutDefrag"), statement.existsParameter("Password") ? statement.getParameter("Password").getValue() : null);
        if (statement.existsParameter("MnodeScript")) {
            definition.setMnodeScript(statement.getParameter("MnodeScript").getValue());
        }
        if (statement.existsParameter("TnodeScript")) {
            definition.setTnodeScript(statement.getParameter("TnodeScript").getValue());
        }
        return definition;
    }

    protected static <T extends RuntimeContext> FrmManifest getManifest(T callable, String manifestName) throws Exception {
        if (!StringUtils.isEmpty(manifestName)) {
            String manifestPath = "resources/" + manifestName;
            if (!manifestPath.endsWith(".frmm")) {
                manifestPath = manifestPath + ".frmm";
            }
            if (callable.getRepositoryAccessor().existsFile(manifestPath)) {
                return (FrmManifest)callable.getXSerializer().deserialize(callable.getRepositoryAccessor().getFileContent(manifestPath));
            }
        }
        return new FrmManifest();
    }

    protected static OutputStream openFrmOutputStream(MFSession session, Definition definition) throws Exception {
        return AbstractBackupNodeOperation.openFrmOutputStream(session, AbstractBackupNodeOperation.createFrmPath(definition.getFrmPath()));
    }

    protected static OutputStream openFrmOutputStream(MFSession session, String frmPath) throws Exception {
        SLFileOutputStream outputStream = (SLFileOutputStream)new SLFileOutputStreamFactory().create(session, frmPath);
        try {
            outputStream.create();
        }
        catch (IOException exception) {
            throw new Exception("Creating file '" + frmPath + "' failed.", exception);
        }
        return new BufferedOutputStream(outputStream, session.getSLSessionData().getTransferBufferSize());
    }

    public static OutputStream openFrmOutputStream(File frmFile) throws Exception {
        return new BufferedOutputStream(new FileOutputStream(frmFile));
    }

    protected static void addScripts(Definition definition, MFSession session, FrmFileWriter frmFile) throws Exception {
        if (definition.getMnodeScript() != null) {
            AbstractBackupNodeOperation.sendSLMessage("Adding script '" + definition.getMnodeScript() + "'...\n", session);
            frmFile.addFile("mnode.slang", FileIOUtils.getFileContent(new File(definition.getMnodeScript())));
        }
        if (definition.getTnodeScript() != null) {
            AbstractBackupNodeOperation.sendSLMessage("Adding script '" + definition.getTnodeScript() + "'...\n", session);
            frmFile.addFile("tnode.slang", FileIOUtils.getFileContent(new File(definition.getTnodeScript())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void downloadFrm(MFSession session, File frmFile, String remoteFrmPath) throws Exception {
        AbstractBackupNodeOperation.sendSLMessage("\nDownloading Resource Module...\n\n", session);
        Utils.sleep(50L);
        try (FileInputStream inputFileStream = new FileInputStream(frmFile);){
            ((SLFileUtils)new SLFileUtilsFactory().create(session, remoteFrmPath)).createFile(inputFileStream, inputFileStream.available(), false);
        }
        AbstractBackupNodeOperation.sendSLMessage("\nResource Module Downloaded.\n", session);
    }

    protected static void sendSLMessage(String message, MFSession session) throws FabricException {
        AbstractOperation.raiseSLMessage(new SLMessage(message, session));
    }

    protected static void sendSLMessage(SLMessage message, MFSession session) throws FabricException {
        AbstractOperation.raiseSLMessage(new SLMessage(message, session));
    }

    protected static void sendSLMessageError(String message, MFSession session) throws FabricException {
        AbstractOperation.raiseSLMessage(new SLMessage(message, false, session));
    }

    protected static void sendSLMessageError(Throwable exception, MFSession session) throws FabricException {
        AbstractOperation.raiseSLMessage(new SLMessage(exception, session));
    }

    protected abstract Definition createDefinition(DSLStatement var1, String var2, boolean var3, String var4, boolean var5, boolean var6, String var7);

    public static class Definition
    extends AbstractFrmNodeOperation.Definition {
        private String manifestName;
        private boolean withoutData;
        private boolean withoutDefrag;
        private String mnodeScript;
        private String tnodeScript;
        private String password;

        protected Definition(String operationName, String nodeName, String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
            super(operationName, nodeName, frmPath, isAsync);
            this.manifestName = manifestName;
            this.withoutData = withoutData;
            this.withoutDefrag = withoutDefrag;
            this.password = password;
        }

        public String getManifestName() {
            return this.manifestName;
        }

        public void setManifestName(String name) {
            this.manifestName = name;
        }

        public String getTnodeScript() {
            return this.tnodeScript;
        }

        public void setTnodeScript(String tnodeScript) {
            this.tnodeScript = tnodeScript;
        }

        public String getMnodeScript() {
            return this.mnodeScript;
        }

        public void setMnodeScript(String mnodeScript) {
            this.mnodeScript = mnodeScript;
        }

        public boolean isWithoutData() {
            return this.withoutData;
        }

        public boolean isWithoutDefrag() {
            return this.withoutDefrag;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

