/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.RealmAuthenticator;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.security.SecurityManagerException;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;

public abstract class AbstractAuthenticator
implements Authenticator {
    protected RealmAuthenticator realmAuthenticator;
    protected RuntimeAuthenticator runtimeAuthenticator;

    public RealmAuthenticator getRealmAuthenticator() {
        return this.realmAuthenticator;
    }

    public void setRealmAuthenticator(RealmAuthenticator realmAuthenticator) {
        this.realmAuthenticator = realmAuthenticator;
    }

    public RuntimeAuthenticator getRuntimeAuthenticator() {
        return this.runtimeAuthenticator;
    }

    public void setRuntimeAuthenticator(RuntimeAuthenticator runtimeAuthenticator) {
        this.runtimeAuthenticator = runtimeAuthenticator;
    }

    @Override
    public Authenticator.Authentication authenticate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.realmAuthenticator.isAuthenticationRequired(request) && !AuthenticationHelper.isAuthenticationRequired(request)) {
            return Authenticator.Authentication.NO_NEED;
        }
        HTTPCredentials credentials = this.obtainCredentials(request, response);
        if (credentials == null) {
            return Authenticator.Authentication.FAILED;
        }
        try {
            this.realmAuthenticator.authenticate(credentials, request);
            this.runtimeAuthenticator.authenticate(credentials);
            AbstractAuthenticator.setCredentialsToRequest(request, credentials);
            this.onAuthenticationSucceeded(request, credentials);
            return Authenticator.Authentication.OK;
        }
        catch (Authenticator.AuthenticationFailedException exception) {
            SecurityManagerException sme = exception.getCause() instanceof SecurityManagerException ? (SecurityManagerException)exception.getCause() : new SecurityManagerException(6084, (Throwable)exception, credentials.getUserName());
            this.runtimeAuthenticator.context.exchange.setLastFailedAttemptTimestamp(ComponentModel.REMOTE_CLIENT, null, credentials.getUserName(), sme);
            Trace.logError(this, "Authentication exception: " + exception.getMessage() + ", URI: " + request.getRequestURI() + ", IP: " + request.getRemoteAddr());
            this.onAuthenticationFailed(request, response, exception);
            return Authenticator.Authentication.FAILED;
        }
    }

    public static void setCredentialsToRequest(HttpServletRequest request, final HTTPCredentials credentials) {
        if (request instanceof Request) {
            ((Request)request).setAuthentication((Authentication)new Authentication.User(){

                public String getAuthMethod() {
                    return credentials.getAuthenticationType() != null ? credentials.getAuthenticationType().toString() : "UNKNOWN";
                }

                public UserIdentity getUserIdentity() {
                    return new UserIdentity(){

                        public Subject getSubject() {
                            return null;
                        }

                        public Principal getUserPrincipal() {
                            return credentials::getUserName;
                        }

                        public boolean isUserInRole(String role, UserIdentity.Scope scope) {
                            return false;
                        }
                    };
                }

                public boolean isUserInRole(UserIdentity.Scope scope, String role) {
                    return false;
                }

                public void logout() {
                }
            });
        }
        request.setAttribute(HTTPCredentials.ATTRIBUTE, credentials);
    }

    public void sendAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, exception);
    }

    public void sendSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onSessionExpired(request, response, exception);
    }

    protected void onAuthenticationSucceeded(HttpServletRequest request, HTTPCredentials credentials) {
    }

    protected abstract HTTPCredentials obtainCredentials(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected abstract void onAuthenticationFailed(HttpServletRequest var1, HttpServletResponse var2, Authenticator.AuthenticationFailedException var3) throws IOException;

    protected abstract void onSessionExpired(HttpServletRequest var1, HttpServletResponse var2, Authenticator.AuthenticationFailedException var3) throws IOException;

    public abstract boolean containsAuthentication(HttpServletRequest var1);
}

