/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.EventConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeConsumerReference;
import com.streamscape.sef.dispatcher.ExchangeEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.enums.FlowControlMode;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.exchange.FabricExchangeException;
import com.streamscape.sef.moderator.ExchangeRole;

abstract class AbstractAsyncConsumerReference
extends EventConsumerReferenceImpl
implements ExchangeConsumerReference {
    ExchangeEventAsyncConsumerImpl underlyingConsumer;

    AbstractAsyncConsumerReference(ExchangeRole role, FabricAddress componentAddress, EventScope eventScope, FabricAddress address, boolean noLocal, FabricGroupLinkImpl groupLink, ExchangeEventAsyncConsumerImpl underlyingConsumer) {
        super(role, componentAddress, eventScope, address, noLocal, groupLink);
        this.bind(underlyingConsumer);
    }

    void bind(ExchangeEventAsyncConsumerImpl underlyingConsumer) {
        this.underlyingConsumer = underlyingConsumer;
        underlyingConsumer.bind(this);
    }

    void update(AbstractAsyncConsumerReference reference) {
        this.bind(reference.underlyingConsumer);
    }

    @Override
    public void update(String name, FabricAddress componentAddress, FabricAddress address, AbstractExchange exchange) {
        this.underlyingConsumer.setName(name);
        this.update(componentAddress, address, exchange);
    }

    @Override
    public String getName() {
        return this.underlyingConsumer.getName();
    }

    @Override
    public String getEventFilter() {
        return this.underlyingConsumer.getEventFilter();
    }

    @Override
    public String getEventSelector() {
        return this.underlyingConsumer.getEventSelector();
    }

    public int getMaxDepth() {
        return this.underlyingConsumer.getMaxDepth();
    }

    public FlowControlMode getFlowControlMode() {
        return FlowControlMode.convert(this.underlyingConsumer.getFlowControlMode());
    }

    @Override
    public CompositeFilter getCompositeFilter() {
        return this.underlyingConsumer.getCompositeFilter();
    }

    @Override
    public void initSelectorExpression(SelectorExternalDataSource externalDataSource) {
        this.setEventSelector(this.getEventSelector(), externalDataSource);
    }

    private void setEventSelector(String eventSelector, SelectorExternalDataSource externalDataSource) {
        try {
            this.underlyingConsumer.setEventSelector(eventSelector, eventSelector != null ? SelectorParser.parse(eventSelector, externalDataSource) : null);
        }
        catch (SelectorFormatException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Setting of event selector '" + eventSelector + "' for consumer '" + this.getName() + "' failed.");
        }
    }

    @Override
    public ConsumerState getCurrentState() {
        return this.underlyingConsumer.getCurrentState();
    }

    @Override
    public boolean matchesEventId(String eventId) {
        return this.underlyingConsumer.matchesEventId(eventId);
    }

    public int getCurrentDepth() throws FabricExchangeException {
        if (this.exchange.isLocal(this.address)) {
            return this.underlyingConsumer.getCurrentDepth();
        }
        return (Integer)this.invokeOperation("getCurrentDepth", null, null);
    }

    private Object invokeOperation(String methodName, Class parameterType, Object parameter) throws FabricExchangeException {
        Object[] objectArray;
        Class[] classArray;
        if (parameterType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = parameterType;
        } else {
            classArray = new Class[]{};
        }
        if (parameter != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = parameter;
        } else {
            objectArray = new Object[]{};
        }
        return this.invokeOperation(41, methodName, classArray, objectArray);
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this.exchangeRole) + ": " + super.toString() + ", " + this.getEventFilter();
    }
}

