/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AccessorProxy;
import com.streamscape.sef.dispatcher.SLCompleteRequest;
import com.streamscape.sef.dispatcher.SLInterruptRequest;
import com.streamscape.sef.dispatcher.SLSetInterruptRequest;
import com.streamscape.sef.dispatcher.SLStatementWrapper;
import com.streamscape.sef.dispatcher.SLTextWrapper;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconProcessor;
import com.streamscape.slex.SemanticLexiconProcessorHolder;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractAccessorProxy
implements AccessorProxy {
    protected final SemanticLexiconProcessorHolder lexiconProcessorHolder;
    protected AccessorSessionReference accessorSession;
    protected ScheduledExecutorService interruptThreadPool = Executors.newScheduledThreadPool(1);
    protected final Object interruptThreadPoolMutex = new Object();
    private volatile AtomicLong currentExecutionId = new AtomicLong();
    private boolean isInterruptUnderlyingRequestOnTimeout = false;

    protected AbstractAccessorProxy(SemanticLexiconProcessor lexiconProcessor) {
        this.lexiconProcessorHolder = new SemanticLexiconProcessorHolder<SemanticLexiconProcessor>(lexiconProcessor);
    }

    protected AbstractAccessorProxy(SemanticLexiconProcessorHolder lexiconProcessorHolder) {
        this.lexiconProcessorHolder = lexiconProcessorHolder;
    }

    @Override
    public void close() {
    }

    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram request) throws FabricRequestException {
        try {
            if (request.getEventId().equals("e.sys.sl.TextWrapper")) {
                SLTextWrapper wrapper = (SLTextWrapper)((OpaqueEvent)request).getData();
                return this.executeInterruptableRequest(wrapper.getText(), this.getMFSession(), wrapper.getOperationTimeout(), () -> this.invokeTextRequest(wrapper.getText(), this.getMFSession(), wrapper.getOperationTimeout()));
            }
            if (request.getEventId().equals("e.sys.sl.InterruptRequest")) {
                SLInterruptRequest interruptRequest = (SLInterruptRequest)((OpaqueEvent)request).getData();
                return this.invokeInterruptRequest(interruptRequest.getCommand(), this.getMFSession());
            }
            if (request.getEventId().equals("e.sys.sl.StatementWrapper")) {
                SLStatementWrapper wrapper = (SLStatementWrapper)((OpaqueEvent)request).getData();
                return this.executeInterruptableRequest(wrapper.getStatement().getName(), this.getMFSession(), wrapper.getOperationTimeout(), () -> this.invokeSLStatementRequest(wrapper.getStatement(), this.getMFSession(), wrapper.getOperationTimeout()));
            }
            if (request.getEventId().equals("e.sys.sl.CompleteRequest")) {
                SLCompleteRequest completeRequest = (SLCompleteRequest)((OpaqueEvent)request).getData();
                return this.invokeDSLCompletionRequest(completeRequest.getCommand(), this.getMFSession());
            }
            if (request.getEventId().equals("e.sys.sl.SetInterruptRequest")) {
                SLSetInterruptRequest slSetInterruptRequest = (SLSetInterruptRequest)((OpaqueEvent)request).getData();
                this.isInterruptUnderlyingRequestOnTimeout = slSetInterruptRequest.isInterruptUnderlyingRequestOnTimeout();
                return AbstractAccessorProxy.createResponseEvent(new SLResponse());
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof UnsupportedRequestException || exception instanceof ParsingException || exception instanceof DataspaceException)) {
                this.logError(exception);
            }
            throw new FabricRequestException(exception);
        }
        return this.invokeOtherRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeInterruptableRequest(String statement, MFSession session, long timeout, InvokeInterruptedRequest<T> runnable) throws Exception {
        long currentExecutionIdLocal = this.currentExecutionId.incrementAndGet();
        AtomicBoolean currentExecutionFinished = new AtomicBoolean(false);
        ScheduledFuture<?> scheduledFuture = null;
        if (this.isInterruptUnderlyingRequestOnTimeout && timeout > 0L) {
            scheduledFuture = this.interruptThreadPool.schedule(() -> {
                Object object = this.interruptThreadPoolMutex;
                synchronized (object) {
                    if (!currentExecutionFinished.get()) {
                        if (currentExecutionIdLocal == this.currentExecutionId.get()) {
                            Trace.logInfo(this, "Interrupting command execution, id: {}, command: {}, timeout: {} ms", currentExecutionIdLocal, statement, timeout);
                            try {
                                this.invokeInterruptRequest(statement, session);
                            }
                            catch (Exception e) {
                                Trace.logError(this, "Failed to interrupt command, id: {}", currentExecutionIdLocal);
                                Trace.logException(this, e, true);
                            }
                        } else {
                            Trace.logInfo(this, "Current execution is already finished, don't cancel it, id: {}, command: {}, timeout: {} ms", currentExecutionIdLocal, statement, timeout);
                        }
                    } else {
                        Trace.logDebug(this, "Current execution is already finished, don't cancel it, id: {}, command: {}, timeout: {} ms", currentExecutionIdLocal, statement, timeout);
                    }
                }
            }, timeout + 1000L, TimeUnit.MILLISECONDS);
        }
        try {
            T t = this.formatMissingTypesIfNeeded(runnable.run());
            return t;
        }
        finally {
            Object object = this.interruptThreadPoolMutex;
            synchronized (object) {
                currentExecutionFinished.set(true);
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(true);
                }
            }
        }
    }

    private <T> T formatMissingTypesIfNeeded(T response) throws SDOException {
        SLResponse data;
        SLResponse newData;
        if (this.getMFSession() != null && this.getMFSession().isFromSlangTool() && response instanceof OpaqueEvent && ((OpaqueEvent)response).getData() instanceof SLResponse && (newData = this.formatMissingTypesInSLResponseIfNeeded(data = (SLResponse)((OpaqueEvent)response).getData())) != data) {
            ((OpaqueEvent)response).setData(newData);
        }
        return response;
    }

    private SLResponse formatMissingTypesInSLResponseIfNeeded(SLResponse response) {
        String error;
        if (!response.isOK() && response.getException() != null && (error = this.formatMissingTypesInException(response.getException())) != null) {
            return new SLResponse(error, false);
        }
        return response;
    }

    private String formatMissingTypesInException(Throwable exception) {
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            if (cause.getClass().getSimpleName().equals("KGraphException") || cause.getClass().getSimpleName().equals("VGraphException")) {
                return Utils.formatExceptionWithUnrepeatedCauses(exception);
            }
            if (cause == cause.getCause()) break;
        }
        return null;
    }

    protected ImmutableEventDatagram invokeInterruptRequest(String command, MFSession session) throws Exception {
        this.doInvokeInterruptRequest(command, session);
        return AbstractAccessorProxy.createResponseEvent(new SLResponse());
    }

    protected void doInvokeInterruptRequest(String command, MFSession session) throws Exception {
        throw new Exception("This command cannot be interrupted.");
    }

    protected ImmutableEventDatagram invokeTextRequest(String statement, MFSession session, long timeout) throws Exception {
        return AbstractAccessorProxy.createResponseEvent(this.lexiconProcessorHolder.getSemanticLexiconProcessor().invoke(statement, session, timeout));
    }

    protected ImmutableEventDatagram invokeSLStatementRequest(SLStatement statement, MFSession session, long timeout) throws Exception {
        return AbstractAccessorProxy.createResponseEvent(this.lexiconProcessorHolder.getSemanticLexiconProcessor().invoke(statement, session, timeout));
    }

    protected ImmutableEventDatagram invokeDSLCompletionRequest(String command, MFSession session) throws Exception {
        DSLCompletion completion = this.lexiconProcessorHolder.getSemanticLexiconProcessor().completeDsl(command, session);
        if (completion != null && completion.getException() != null && completion.getCompletion() == null && (completion.getSuggestions() == null || completion.getSuggestions().size() == 0) && this.isHelpCommand(command)) {
            completion = new DSLCompletion();
        }
        SLResponse response = new SLResponse();
        if (completion != null) {
            response.setObject(completion.sort());
        }
        return AbstractAccessorProxy.createResponseEvent(response);
    }

    private boolean isHelpCommand(String command) {
        if (command == null) {
            return false;
        }
        return (command = command.trim()).startsWith("? ") || command.startsWith("help ");
    }

    protected ImmutableEventDatagram invokeOtherRequest(ImmutableEventDatagram request) throws FabricRequestException {
        throw new FabricRequestException("Invocation of request [" + request.getEventId() + "] is not supported.");
    }

    protected static OpaqueEvent createResponseEvent(SLResponse response) throws Exception {
        return SDOUtils.createOpaqueEvent(response.getEventId(), response);
    }

    protected abstract MFSession getMFSession();

    @Override
    public AccessorSessionReference getAccessorSession() {
        return this.accessorSession;
    }

    protected void setAccessorSession(AccessorSessionReference accessorSession) {
        this.accessorSession = accessorSession;
    }

    @Override
    public String getOwner() {
        return this.getMFSession().getOwnerName();
    }

    protected abstract void logError(Throwable var1);

    protected static interface InvokeInterruptedRequest<T> {
        public T run() throws Exception;
    }
}

