/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dispatcher.AccessibleObjectComponentSimple;
import java.lang.reflect.InvocationTargetException;

public class AbstractAccessibleObjectProxy<T extends AccessibleObjectComponentSimple>
implements AccessibleObjectProxy<T> {
    protected long oid = 0L;
    protected transient T accessor = null;

    @Override
    public long getId() {
        return this.oid;
    }

    @Override
    public void setId(long id) {
        this.oid = id;
    }

    @Override
    public void setAccessor(T accessor) {
        this.accessor = accessor;
    }

    protected void invokeMethod(String method, Object[] params) throws InvocationTargetException {
        SLDataspaceCall call = new SLDataspaceCall(this.oid, method, params, this.accessor != null ? this.accessor.getRequestTimeout() : 0L);
        SLResponse response = this.invokeRequest("e.sys.sl.DataspaceCall", call);
        if (!response.isOK()) {
            if (response.getException() != null) {
                throw new InvocationTargetException(response.getException());
            }
            if (response.getText() != null) {
                throw new InvocationTargetException(new Exception(response.getText()));
            }
            throw new InvocationTargetException(new Exception("Error response received."));
        }
    }

    protected <T> T invokeMethodWithReturn(String methodName, Class<T> clazz, Object ... args) throws InvocationTargetException {
        Object result = this.invokeMethodWithReturn(methodName, args);
        if (result == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new InvocationTargetException(null, "Wrong result class received '" + String.valueOf(result.getClass()) + "', expecting '" + String.valueOf(clazz) + "'.");
        }
        return (T)result;
    }

    protected Object invokeMethodWithReturn(String method, Object[] params) throws InvocationTargetException {
        SLDataspaceCall call = new SLDataspaceCall(this.oid, method, params);
        SLResponse response = this.invokeRequest("e.sys.sl.DataspaceCall", call);
        if (!response.isOK()) {
            if (response.getException() != null) {
                throw new InvocationTargetException(response.getException());
            }
            if (response.getText() != null) {
                throw new InvocationTargetException(new Exception(response.getText()));
            }
            throw new InvocationTargetException(new Exception("Error response received."));
        }
        Object result = response.getObject();
        try {
            if (result instanceof AccessibleObjectProxy) {
                ((AccessibleObjectProxy)result).setAccessor(this.accessor);
            } else if (result != null && result instanceof Object[]) {
                Object[] array;
                for (Object o : array = (Object[])result) {
                    if (!(o instanceof AccessibleObjectProxy)) continue;
                    ((AccessibleObjectProxy)o).setAccessor(this.accessor);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SLResponse invokeRequest(String eventId, Object wrapper) {
        try {
            if (this.accessor == null) {
                throw new Exception("Accessor is not set to proxy object.");
            }
            T t = this.accessor;
            synchronized (t) {
                ImmutableEventDatagram reply = this.accessor.raiseSystemRequest(this.accessor.createOpaqueEvent(eventId, wrapper), this.accessor.getRequestTimeout());
                if (reply == null) {
                    return new SLResponse("Received response is null.", false);
                }
                if (!(reply instanceof OpaqueEvent)) {
                    return new SLResponse("Received response has wrong type.", false);
                }
                return (SLResponse)((OpaqueEvent)reply).getData();
            }
        }
        catch (Exception exception) {
            return new SLResponse(exception);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.accessor != null) {
                SLDataspaceCall call = new SLDataspaceCall(0L, "eraseFromObjectCache", new Object[]{this.oid});
                this.invokeRequest("e.sys.sl.DataspaceCall", call);
                this.accessor = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

