/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.AbstractDataCollectionProxy;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.dispatcher.AbstractAccessibleObjectProxy;
import com.streamscape.sef.dispatcher.AccessibleObjectComponent;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractAccessibleObjectForCollectionsProxy
extends AbstractAccessibleObjectProxy<AccessibleObjectComponent> {
    protected void invokeCollectionsMethod(String methodName, Object ... args) {
        try {
            this.invokeMethod(methodName, args);
        }
        catch (InvocationTargetException error) {
            throw this.unwrapInvocationTargetExceptionToDataspace(error);
        }
    }

    protected <T> T invokeCollectionsMethodWithReturn(String methodName, Class<T> clazz, Object ... args) {
        try {
            Object result = this.invokeMethodWithReturn(methodName, args);
            if (result == null) {
                return null;
            }
            if (!clazz.isAssignableFrom(result.getClass())) {
                throw new DataspaceException("Wrong result class received '" + String.valueOf(result.getClass()) + "', expecting '" + String.valueOf(clazz) + "'.");
            }
            return (T)result;
        }
        catch (InvocationTargetException error) {
            throw this.unwrapInvocationTargetExceptionToDataspace(error);
        }
    }

    protected DataspaceException unwrapInvocationTargetExceptionToDataspace(InvocationTargetException error) {
        if (error.getTargetException() instanceof DataspaceException) {
            return (DataspaceException)error.getTargetException();
        }
        if (error.getTargetException() != null) {
            return new DataspaceException(error.getTargetException(), error.getTargetException().getMessage(), "00000", 458);
        }
        return new DataspaceException(error, error.getMessage(), "00000", 458);
    }

    protected <T> T unwrapDataspaceExceptionTo(DataspaceException exception, Class<T> exceptionClazz) {
        if (exception.getCause() != null && exceptionClazz.isAssignableFrom(exception.getCause().getClass())) {
            return (T)exception.getCause();
        }
        throw exception;
    }

    protected <T> T executeRemoteRequest(Object object, RemoteRequestExecutor<T> executor) {
        if (!(object instanceof AbstractAccessibleObjectForCollectionsProxy)) {
            return executor.objectNotProxy();
        }
        AccessibleObjectComponent objectAccessor = (AccessibleObjectComponent)((AbstractAccessibleObjectForCollectionsProxy)object).accessor;
        String objectCollectionName = null;
        if (object instanceof AbstractDataCollectionProxy) {
            objectCollectionName = ((AbstractDataCollectionProxy)object).getCollectionName();
        }
        String thisCollectionName = null;
        if (this instanceof AbstractDataCollectionProxy) {
            thisCollectionName = ((AbstractDataCollectionProxy)this).getCollectionName();
        }
        if (object == this || objectCollectionName != null && thisCollectionName != null && objectCollectionName.equals(thisCollectionName) && objectAccessor.getComponentFullNameWithNode().equals(((AccessibleObjectComponent)this.accessor).getComponentFullNameWithNode())) {
            return executor.objectTheSame();
        }
        if (objectAccessor == this.accessor) {
            return executor.objectInTheSameAccessor();
        }
        if (Utils.equalsNullSafe(objectAccessor.getActualNodeName(), ((AccessibleObjectComponent)this.accessor).getActualNodeName())) {
            return executor.objectInTheSameNode(objectAccessor.getComponentType(), objectAccessor.getComponentName(), objectCollectionName);
        }
        if (((AccessibleObjectComponent)this.accessor).lookupFabricNode(objectAccessor.getActualNodeName()) != null) {
            return executor.objectInTheSameSysplex(objectAccessor.getActualNodeName(), objectAccessor.getComponentType(), objectAccessor.getComponentName(), objectCollectionName);
        }
        return executor.objectInOtherSysplex(objectAccessor.getActualNodeName(), objectAccessor.getComponentType(), objectAccessor.getComponentName(), objectCollectionName);
    }

    protected static interface RemoteRequestExecutor<T> {
        public T objectNotProxy();

        public T objectTheSame();

        public T objectInTheSameAccessor();

        public T objectInTheSameNode(String var1, String var2, String var3);

        public T objectInTheSameSysplex(String var1, String var2, String var3, String var4);

        public T objectInOtherSysplex(String var1, String var2, String var3, String var4);
    }
}

