/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.discovery;

import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.AbstractDiscoveryModule;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.mf.admin.module.ModuleException;
import com.streamscape.sef.network.LinkAddress;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuntimeDiscoveryModule
extends AbstractDiscoveryModule {
    boolean multicastUseAcceptors = false;
    final Set<DiscoveryLink> acceptorLinks = new HashSet<DiscoveryLink>();
    private static byte RUNTIME_REQUESTER = 0;

    @Override
    public void init(FabricContext context, Map<String, String> parameters) throws ModuleException {
        this.macroProcessor = new MacroProcessor();
        super.init(context, parameters);
    }

    @Override
    protected void parseParameters(Map<String, String> parameters) {
        super.parseParameters(parameters);
        if (parameters != null && parameters.containsKey("multicastUseAcceptors")) {
            this.multicastUseAcceptors = Boolean.parseBoolean(parameters.get("multicastUseAcceptors"));
        }
        this.fabricDirectory = this.macroProcessor.process(this.fabricDirectory);
        this.multicastAddress = this.macroProcessor.process(this.multicastAddress);
    }

    @Override
    public void setParameter(String name, String value) throws ModuleException {
        if (name.equalsIgnoreCase("multicastUseAcceptors")) {
            this.multicastUseAcceptors = Boolean.parseBoolean(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    String resolveParameter(String parameter) {
        return this.macroProcessor.process(parameter);
    }

    @Override
    public void onDirectoryTableUpdate() {
        this.writeDirectoryTable();
    }

    public String getFabricDirectory() {
        try {
            return this.fabricDirectory != null && !this.fabricDirectory.isEmpty() ? new File(this.fabricDirectory).getCanonicalPath() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getNodeName() {
        return ((RuntimeContext)this.context).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptor(LinkAddress address) {
        Set<DiscoveryLink> set = this.acceptorLinks;
        synchronized (set) {
            this.acceptorLinks.add(new DiscoveryLink(((RuntimeContext)this.context).getName(), address.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcceptor(LinkAddress address) {
        Set<DiscoveryLink> set = this.acceptorLinks;
        synchronized (set) {
            this.acceptorLinks.remove(new DiscoveryLink(((RuntimeContext)this.context).getName(), address.toString()));
        }
    }

    @Override
    List<DiscoveryLink> getDiscoveryResult() {
        DirectoryTable.Node resultNode = this.compositeDirectoryTable.getNode(this.getNodeName());
        return resultNode != null ? resultNode.getLinks() : new ArrayList<DiscoveryLink>();
    }

    @Override
    byte[] makeMulticastUniqueId() {
        return this.getNodeName().getBytes();
    }

    @Override
    byte getRequesterType() {
        return RUNTIME_REQUESTER;
    }

    @Override
    void processRequest(ByteBuffer buffer) throws Exception {
        byte requesterType = buffer.get();
        byte[] requestUniqueId = new byte[buffer.remaining()];
        buffer.get(requestUniqueId);
        if (!Arrays.equals(this.multicastUniqueId, requestUniqueId)) {
            Map<String, DirectoryTable.Node> nodeMap = this.directoryTable.getNodeMap();
            if (this.multicastUseAcceptors) {
                this.addAcceptorsToResponse(requesterType == RUNTIME_REQUESTER ? new String(requestUniqueId) : "", nodeMap);
            }
            this.multicastConnection.send(this.createResponse(nodeMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAcceptorsToResponse(String nodeName, Map<String, DirectoryTable.Node> nodeMap) {
        DirectoryTable.Node node = nodeMap.get(nodeName);
        if (node == null) {
            node = new DirectoryTable.Node(nodeName);
            nodeMap.put(nodeName, node);
        }
        Set<DiscoveryLink> set = this.acceptorLinks;
        synchronized (set) {
            for (DiscoveryLink link : this.acceptorLinks) {
                node.addLink(link);
            }
        }
    }

    private byte[] createResponse(Map<String, DirectoryTable.Node> nodeMap) throws FabricException {
        byte[] nodeMapBytes = this.serialize(nodeMap);
        ByteBuffer resultBuffer = ByteBuffer.allocate(5 + this.multicastUniqueId.length + nodeMapBytes.length);
        resultBuffer.put((byte)1).putInt(this.multicastUniqueId.length).put(this.multicastUniqueId).put(nodeMapBytes).flip();
        return resultBuffer.array();
    }
}

