/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.discovery;

import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryModule;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.sef.dispatcher.AbstractDiscoveryModuleFactory;
import com.streamscape.sef.mf.admin.module.ModuleFactoryException;
import com.streamscape.sef.utils.Utils;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class DiscoveryModuleFactory
extends AbstractDiscoveryModuleFactory {
    protected DiscoveryModuleFactory(boolean repositoryEnabled) {
        super(repositoryEnabled);
    }

    @Override
    protected Map<String, String> getDefaultModuleParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("fabricDirectory", "DirectoryTable.xdo");
        result.put("multicastEnabled", "false");
        result.put("multicastAddress", "230.0.0.0:8888");
        result.put("multicastWaitingTime", "0");
        return result;
    }

    @Override
    protected String getModuleType() {
        return "Discovery";
    }

    @Override
    protected String getModuleNamespace() {
        return "/sys/discovery/";
    }

    @Override
    protected Class getModuleClass() {
        return DiscoveryModule.class;
    }

    @Override
    protected Class getModuleConfigurationClass() {
        return DiscoveryModuleConfiguration.class;
    }

    @Override
    protected DiscoveryModuleConfiguration createModuleConfiguration(String name, String description, String moduleClass, Map<String, String> parameters) {
        return new DiscoveryModuleConfiguration(name, description, moduleClass, parameters);
    }

    @Override
    public DiscoveryModuleConfiguration getActiveModuleConfiguration() {
        return (DiscoveryModuleConfiguration)super.getActiveModuleConfiguration();
    }

    @Override
    public DiscoveryModuleConfiguration getModuleConfiguration(String name) {
        return (DiscoveryModuleConfiguration)super.getModuleConfiguration(name);
    }

    @Override
    public void activateModule(String name) throws ModuleFactoryException {
        super.activateModule(name);
    }

    public static DirectoryTable readDirectoryTable(String filename) throws FabricException {
        try {
            return (DirectoryTable)Utils.readObjectFromXML(filename);
        }
        catch (ClassCastException exception) {
            throw new FabricException("Reading DirectoryTable failed.", exception);
        }
    }

    static DirectoryTable readDirectoryTable(String filename, FileInputStream stream) throws FabricException {
        try {
            return (DirectoryTable)Utils.readObjectFromXML(filename, new DataInputStream(stream));
        }
        catch (ClassCastException exception) {
            throw new FabricException("Reading DirectoryTable failed.", exception);
        }
    }

    public static void writeDirectoryTable(DirectoryTable directoryTable, String filename) throws FabricException {
        directoryTable.prepareForSerialization();
        Utils.writeObjectToXML(directoryTable, filename);
    }

    static void writeDirectoryTable(DirectoryTable directoryTable, String filename, FileOutputStream stream) throws FabricException {
        directoryTable.prepareForSerialization();
        Utils.writeObjectToXML(directoryTable, filename, stream);
    }
}

