/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.discovery;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.DiscoveryModuleException;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.utils.Utils;

public class DiscoveryLink {
    private String nodeName;
    private String address;
    private Boolean backup;
    private transient LinkAddress linkAddress;
    private transient MacroProcessor macroProcessor;

    public DiscoveryLink(String address) {
        this.address = address;
    }

    public DiscoveryLink(String nodeName, String address) {
        this(address);
        this.nodeName = nodeName;
    }

    public DiscoveryLink(String nodeName, String address, Boolean backup) {
        this(nodeName, address);
        this.backup = backup;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public LinkAddress getLinkAddress() {
        if (this.linkAddress == null && this.address != null) {
            try {
                this.resolveAddress();
            }
            catch (FabricException exception) {
                Trace.logError(DiscoveryLink.class, "Invalid discovery link '" + this.toString() + "': " + exception.getMessage());
            }
        }
        return this.linkAddress;
    }

    public boolean isBackup() {
        return this.backup != null ? this.backup : false;
    }

    void init(MacroProcessor macroProcessor) {
        this.macroProcessor = macroProcessor;
    }

    void resolve(MacroProcessor macroProcessor) throws DiscoveryModuleException {
        this.init(macroProcessor);
        try {
            this.resolveAddress();
        }
        catch (FabricException exception) {
            throw new DiscoveryModuleException(6130, (Throwable)exception);
        }
    }

    private void resolveAddress() throws FabricException {
        String resolvedAddress = this.macroProcessor != null ? this.macroProcessor.process(this.address) : this.address;
        this.linkAddress = resolvedAddress.contains("://") ? new LinkAddress(resolvedAddress) : new LinkAddress(LinkProtocol.TLP, new Address(resolvedAddress));
    }

    String getAddress() {
        return this.address;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DiscoveryLink && Utils.equals(this.nodeName, ((DiscoveryLink)other).nodeName) && Utils.equalsIgnoreCase(this.address, ((DiscoveryLink)other).address);
    }

    public int hashCode() {
        return (this.nodeName + this.address).hashCode();
    }

    public String toString() {
        return this.nodeName + (String)(this.address != null ? "(" + this.address + ")" : "");
    }
}

