/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.discovery;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.discovery.DiscoveryModule;
import com.streamscape.sef.discovery.DiscoveryModuleException;
import com.streamscape.sef.discovery.RuntimeDiscoveryModule;
import com.streamscape.sef.dispatcher.AbstractDirectoryTable;
import com.streamscape.sef.moderator.FabricNodeRole;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class DirectoryTable
extends AbstractDirectoryTable {
    List<Node> nodes = new ArrayList<Node>();
    private transient OrderedMap<String, Node> nodeMap;
    private transient DiscoveryModule module;
    private transient MacroProcessor macroProcessor;

    public DirectoryTable() {
    }

    DirectoryTable(DirectoryTable other) {
        if (other != null) {
            this.init(other.module, other.macroProcessor);
            this.doMerge(other, false);
        }
    }

    void init(DiscoveryModule module, MacroProcessor macroProcessor) {
        if (module != null) {
            this.module = module;
            if (module instanceof RuntimeDiscoveryModule) {
                this.init(((RuntimeDiscoveryModule)module).context);
            }
        }
        if (macroProcessor != null) {
            this.macroProcessor = macroProcessor;
            for (Node node : this.nodes) {
                for (DiscoveryLink link : node.getLinks()) {
                    link.init(macroProcessor);
                }
            }
        }
    }

    protected void replace(DirectoryTable other) throws DiscoveryModuleException {
        if (this.context != null) {
            this.update(REPLACE_METHOD, other);
        } else {
            this.doReplace(other);
        }
    }

    @Override
    protected synchronized boolean doReplace(DirectoryTable other) throws DiscoveryModuleException {
        other.init(this.module, this.macroProcessor);
        other.initNodeMap();
        if (!this.equals(other)) {
            this.nodeMap = other.nodeMap;
            this.prepareForSerialization();
            this.onUpdate();
            return true;
        }
        return false;
    }

    public void addLink(String nodeName, DiscoveryLink link) throws DiscoveryModuleException {
        this.addLink(nodeName, FabricNodeRole.TASK_NODE, link);
    }

    public void addLink(String nodeName, FabricNodeRole nodeRole, DiscoveryLink link) throws DiscoveryModuleException {
        if (this.context != null) {
            this.update(ADD_LINK_METHOD, new Object[]{nodeName, nodeRole, link});
        } else {
            this.doAddLink(nodeName, nodeRole, link);
        }
    }

    @Override
    protected synchronized boolean doAddLink(String nodeName, FabricNodeRole nodeRole, DiscoveryLink link) throws DiscoveryModuleException {
        this.initNodeMap();
        if (nodeName != null && link != null) {
            Node node = (Node)this.nodeMap.get(nodeName);
            if (link.isBackup()) {
                if (node == null || !node.hasLinks()) {
                    throw new DiscoveryModuleException(6130, "First link of the node '" + nodeName + "' cannot be backup.");
                }
                if (node.hasPrimaryLink(link)) {
                    throw new DiscoveryModuleException(6130, "Primary link with the same parameters already exists.");
                }
            }
            link.resolve(this.macroProcessor);
            if (node == null) {
                node = this.doAddNodeCore(nodeName, nodeRole);
            }
            if (node.addLink(link)) {
                this.onUpdate();
                return true;
            }
        }
        return false;
    }

    public void removeLink(String nodeName, DiscoveryLink link) throws DiscoveryModuleException {
        if (this.context != null) {
            this.update(REMOVE_LINK_METHOD, nodeName, link);
        } else {
            this.doRemoveLink(nodeName, link);
        }
    }

    @Override
    protected synchronized boolean doRemoveLink(String nodeName, DiscoveryLink link) throws DiscoveryModuleException {
        this.initNodeMap();
        Node node = (Node)this.nodeMap.get(nodeName);
        if (node != null) {
            boolean update = false;
            if (link.getAddress() != null) {
                update = node.links.remove(link);
            } else {
                Iterator<DiscoveryLink> iter = node.links.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().getNodeName().equals(link.getNodeName())) continue;
                    iter.remove();
                    update = true;
                }
            }
            if (update) {
                this.onUpdate();
                return true;
            }
        }
        return false;
    }

    public synchronized List<DiscoveryLink> getLinks(String nodeName) {
        this.initNodeMap();
        Node node = (Node)this.nodeMap.get(nodeName);
        return node != null ? new ArrayList<DiscoveryLink>(node.links) : new ArrayList();
    }

    public synchronized List<DiscoveryLink> getAllLinks() {
        this.initNodeMap();
        ArrayList<DiscoveryLink> result = new ArrayList<DiscoveryLink>();
        this.nodeMap.values().forEach(node -> node.links.stream().filter(link -> !result.contains(link)).forEach(result::add));
        return result;
    }

    public synchronized List<Node> getAllNodes() {
        this.initNodeMap();
        return new ArrayList<Node>(this.nodeMap.values());
    }

    public void addNode(String name, FabricNodeRole role) throws DiscoveryModuleException {
        if (this.context != null) {
            this.update(ADD_NODE_METHOD, new Object[]{name, role});
        } else {
            this.doAddNode(name, role);
        }
    }

    @Override
    protected synchronized boolean doAddNode(String name, FabricNodeRole role) throws DiscoveryModuleException {
        this.initNodeMap();
        if (!this.nodeMap.containsKey(name)) {
            this.doAddNodeCore(name, role);
            this.onUpdate();
            return true;
        }
        return false;
    }

    private Node doAddNodeCore(String name, FabricNodeRole role) {
        Node result = new Node(name, role);
        this.nodes.add(result);
        this.nodeMap.put(name, result);
        return result;
    }

    public void removeNode(String name) throws DiscoveryModuleException {
        if (this.context != null) {
            this.update(REMOVE_NODE_METHOD, name);
        } else {
            this.doRemoveNode(name);
        }
    }

    @Override
    protected synchronized boolean doRemoveNode(String name) throws DiscoveryModuleException {
        this.initNodeMap();
        Node node = this.nodeMap.remove(name);
        if (node != null) {
            this.nodes.remove(node);
            this.onUpdate();
            return true;
        }
        return false;
    }

    public synchronized Node getNode(String name) {
        this.initNodeMap();
        return (Node)this.nodeMap.get(name);
    }

    public boolean existsNode(String name) {
        this.initNodeMap();
        return this.nodeMap.containsKey(name);
    }

    protected synchronized boolean merge(DirectoryTable other, boolean addOnly) {
        if (this.doMerge(other, addOnly)) {
            this.onUpdate();
            return true;
        }
        return false;
    }

    @Override
    protected boolean merge(DirectoryTable other) {
        return this.merge(other, true);
    }

    private synchronized boolean doMerge(DirectoryTable other, boolean addOnly) {
        other.init(this.module, this.macroProcessor);
        other.initNodeMap();
        if (this.merge(other.getNodeMap(), addOnly)) {
            this.prepareForSerialization();
            return true;
        }
        return false;
    }

    private synchronized void initNodeMap() {
        if (this.nodeMap == null) {
            this.nodeMap = new OrderedMap();
            if (this.nodes == null) {
                this.nodes = new ArrayList<Node>();
            } else {
                ArrayList<Node> invalidNodes = new ArrayList<Node>();
                for (Node node : this.nodes) {
                    if (node.name == null) {
                        invalidNodes.add(node);
                        continue;
                    }
                    node.normalize(this.macroProcessor);
                    this.nodeMap.put(node.name, node);
                }
                this.nodes.removeAll(invalidNodes);
            }
        }
    }

    synchronized Map<String, Node> getNodeMap() {
        return new OrderedMap<String, Node>((Map<String, Node>)this.nodeMap);
    }

    synchronized boolean merge(Map<String, Node> otherNodeMap, boolean addOnly) {
        boolean result = false;
        if (otherNodeMap != null) {
            this.initNodeMap();
            for (Map.Entry<String, Node> entry : otherNodeMap.entrySet()) {
                Node otherNode;
                Node node = (Node)this.nodeMap.get(entry.getKey());
                if (node == null) {
                    otherNode = entry.getValue();
                    for (DiscoveryLink link : otherNode.links) {
                        link.init(this.macroProcessor);
                    }
                    this.nodeMap.put(entry.getKey(), otherNode);
                    result = true;
                    continue;
                }
                if (addOnly) continue;
                otherNode = entry.getValue();
                if (node.role == null && otherNode.role != null) {
                    node.role = otherNode.role;
                    result = true;
                }
                for (DiscoveryLink link : otherNode.links) {
                    link.init(this.macroProcessor);
                    if (!node.addLink(link)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    synchronized void prepareForSerialization() {
        if (this.nodeMap != null) {
            this.nodes.clear();
            this.nodes.addAll(new ArrayList<Node>(this.nodeMap.values()));
        }
    }

    void onUpdate() {
        if (this.module != null) {
            this.module.onDirectoryTableUpdate();
        }
    }

    public String asXML() throws Exception {
        this.prepareForSerialization();
        return XSerializerFactory.getInstance().getDefaultSerializer().serialize(this);
    }

    public String asJSON() throws Exception {
        this.prepareForSerialization();
        return JSONSerializerFactory.getInstance().getDefaultSerializer().serialize(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DirectoryTable) {
            return this.nodes.size() == ((DirectoryTable)other).nodes.size() && IntStream.range(0, this.nodes.size()).allMatch(i -> this.nodes.get(i).equals(((DirectoryTable)other).nodes.get(i)));
        }
        return false;
    }

    public String toString() {
        try {
            return this.asXML();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static class Node
    implements Comparable<Node> {
        private String name;
        private FabricNodeRole role;
        private List<DiscoveryLink> links = new ArrayList<DiscoveryLink>();

        Node(String name) {
            this.name = name;
        }

        public Node(String name, FabricNodeRole role) {
            this(name);
            this.role = role;
        }

        public String getName() {
            return this.name;
        }

        public FabricNodeRole getRole() {
            return this.role;
        }

        public boolean hasLinks() {
            return this.links != null && !this.links.isEmpty();
        }

        public List<DiscoveryLink> getLinks() {
            return this.links != null ? new ArrayList<DiscoveryLink>(this.links) : new ArrayList();
        }

        public boolean hasLink(DiscoveryLink link) {
            return this.links != null && this.links.contains(link);
        }

        boolean hasPrimaryLink(DiscoveryLink link) {
            int index = this.links != null ? this.links.indexOf(link) : -1;
            return index != -1 && !this.links.get(index).isBackup();
        }

        @Override
        public int compareTo(Node other) {
            return this.name.compareTo(other.name);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Node && this.name.equals(((Node)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Node other) {
            return this == other || this.name.equals(other.name) && Utils.equalsNullSafe((Object)this.role, (Object)other.role) && Utils.equalsNullSafe(this.links, other.links);
        }

        boolean addLink(DiscoveryLink link) {
            if (!this.links.contains(link)) {
                this.links.add(link);
                return true;
            }
            return false;
        }

        void normalize(MacroProcessor macroProcessor) {
            if (this.links == null) {
                this.links = new ArrayList<DiscoveryLink>();
            } else {
                ArrayList<DiscoveryLink> newLinks = new ArrayList<DiscoveryLink>();
                for (DiscoveryLink link : this.links) {
                    if (!newLinks.contains(link)) {
                        link.init(macroProcessor);
                        if (link.getNodeName() == null || link.getNodeName().isEmpty()) {
                            Trace.logError(DiscoveryLink.class, "Invalid discovery link '" + String.valueOf(link) + "': node name is absent.");
                            continue;
                        }
                        if (link.getNodeName().equals(this.name)) {
                            Trace.logError(DiscoveryLink.class, "Invalid discovery link '" + String.valueOf(link) + "': node name is the same.");
                            continue;
                        }
                        if (link.getAddress() == null) {
                            Trace.logError(DiscoveryLink.class, "Invalid discovery link '" + String.valueOf(link) + "': address is absent.");
                            continue;
                        }
                        if (link.getLinkAddress() == null) continue;
                        newLinks.add(link);
                        continue;
                    }
                    Trace.logError(DiscoveryLink.class, "Duplicated discovery link '" + String.valueOf(link) + "'.");
                }
                this.links = newLinks;
            }
        }
    }
}

