/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.discovery;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.discovery.DiscoveryModule;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.sef.discovery.DiscoveryModuleException;
import com.streamscape.sef.discovery.DiscoveryModuleFactory;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.mf.admin.module.AbstractModule;
import com.streamscape.sef.mf.admin.module.ModuleException;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.udp.MulticastConnection;
import com.streamscape.sef.network.udp.MulticastConnectionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

abstract class AbstractDiscoveryModule
extends AbstractModule
implements DiscoveryModule {
    String fabricDirectory = "DirectoryTable.xdo";
    boolean multicastEnabled = false;
    String multicastAddress = "230.0.0.0:8888";
    long multicastWaitingTime = 0L;
    FabricContext context;
    DirectoryTable directoryTable;
    DirectoryTable compositeDirectoryTable;
    MacroProcessor macroProcessor;
    MulticastConnection multicastConnection;
    byte[] multicastUniqueId;
    boolean multicastDiscoveryInProgress = false;
    boolean multicastHasResponse = false;
    static final byte REQUEST = 0;
    static final byte RESPONSE = 1;

    AbstractDiscoveryModule() {
    }

    @Override
    public void init(FabricContext context, Map<String, String> parameters) throws ModuleException {
        this.context = context;
        this.parseParameters(parameters);
        DirectoryTable table = this.readDirectoryTable(true);
        this.doSetDirectoryTable(table != null ? table : new DirectoryTable());
        if (this.multicastEnabled) {
            this.startMulticastDiscovery();
        }
    }

    private void doSetDirectoryTable(DirectoryTable directoryTable) {
        directoryTable.init(this, this.macroProcessor);
        this.directoryTable = directoryTable;
    }

    protected void parseParameters(Map<String, String> parameters) {
        if (parameters != null) {
            if (parameters.containsKey("multicastEnabled")) {
                this.multicastEnabled = Boolean.parseBoolean(parameters.get("multicastEnabled"));
            }
            if (parameters.containsKey("multicastAddress")) {
                this.multicastAddress = this.resolveParameter(parameters.get("multicastAddress"));
            }
            if (parameters.containsKey("multicastWaitingTime")) {
                try {
                    this.multicastWaitingTime = Long.parseLong(parameters.get("multicastWaitingTime"));
                }
                catch (NumberFormatException exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Parameter 'multicastWaitingTime' has invalid format.");
                }
            }
            if (parameters.containsKey("fabricDirectory")) {
                this.fabricDirectory = this.resolveParameter(parameters.get("fabricDirectory"));
            }
        }
    }

    @Override
    public void destroy() {
        this.stopMulticastDiscovery();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameter(String name, String value) throws ModuleException {
        if (name.equalsIgnoreCase("fabricDirectory")) {
            String oldFabricDirectory = this.fabricDirectory;
            this.fabricDirectory = this.resolveParameter(value);
            try {
                DirectoryTable table = this.readDirectoryTable(false);
                if (table == null) return;
                this.directoryTable.replace(table);
                return;
            }
            catch (ModuleException exception) {
                this.fabricDirectory = oldFabricDirectory;
                throw exception;
            }
        }
        if (name.equalsIgnoreCase("multicastEnabled")) {
            boolean newMulticastEnabled = Boolean.parseBoolean(value);
            if (newMulticastEnabled && !this.multicastEnabled) {
                this.startMulticastDiscovery();
            } else if (!newMulticastEnabled && this.multicastEnabled) {
                this.stopMulticastDiscovery();
            }
            this.multicastEnabled = newMulticastEnabled;
            return;
        }
        if (name.equalsIgnoreCase("multicastAddress")) {
            this.multicastAddress = this.resolveParameter(value);
            if (!this.multicastEnabled) return;
            this.stopMulticastDiscovery();
            this.startMulticastDiscovery();
            return;
        }
        if (!name.equalsIgnoreCase("multicastWaitingTime")) throw new ModuleException(6008, "Unknown parameter '" + name + "'.");
        try {
            this.multicastWaitingTime = Long.parseLong(value);
            return;
        }
        catch (NumberFormatException exception) {
            throw new ModuleException(6006, "Invalid parameter '" + name + "'.", exception);
        }
    }

    String resolveParameter(String parameter) {
        return parameter;
    }

    @Override
    public DirectoryTable getDirectoryTable() {
        return this.directoryTable;
    }

    @Override
    public void onDirectoryTableUpdate() {
    }

    private DirectoryTable readDirectoryTable(boolean onInit) throws ModuleException {
        DirectoryTable result = null;
        if (!this.fabricDirectory.isEmpty()) {
            File file = new File(this.fabricDirectory);
            if (!AbstractDiscoveryModule.isValidFile(file)) {
                if (onInit) {
                    Trace.logInfo(this, "WARNING: Path '" + this.fabricDirectory + "' is invalid. Parameter 'fabricDirectory' is set to default value.");
                    this.fabricDirectory = "DirectoryTable.xdo";
                    ((DiscoveryModuleConfiguration)this.configuration).doSetParameter("fabricDirectory", this.fabricDirectory);
                    file = new File(this.fabricDirectory);
                } else {
                    throw new DiscoveryModuleException("Path '" + this.fabricDirectory + "' is invalid.");
                }
            }
            if (file.exists()) {
                try {
                    Trace.logDebug(this, "Reading Directory Table from file '" + this.fabricDirectory + "'.");
                    result = DiscoveryModuleFactory.readDirectoryTable(this.fabricDirectory);
                    if (this.isUpdateNeeded(result)) {
                        DiscoveryModuleFactory.writeDirectoryTable(result, this.fabricDirectory);
                    }
                    Trace.logInfo(this, "Directory Table obtained from file '" + this.fabricDirectory + "'.");
                }
                catch (FabricException exception) {
                    Trace.logException(this, exception, !(exception.getCause() instanceof FileNotFoundException));
                    Trace.logError(this, "Reading Directory Table from file '" + this.fabricDirectory + "' failed.");
                }
            } else {
                this.writeNewDirectoryTable();
            }
        }
        return result;
    }

    private boolean isUpdateNeeded(DirectoryTable table) {
        return table != null && table.nodes != null && table.nodes.stream().anyMatch(node -> node.getRole() != null && node.getRole().isOldVersion());
    }

    void writeNewDirectoryTable() {
        try {
            Trace.logInfo(this, "WARNING: File '" + this.fabricDirectory + "' is not found and will be created.");
            Trace.logDebug(this, "Writing " + (this.directoryTable != null ? "existing" : "empty") + " Directory Table to '" + this.fabricDirectory + "'...");
            DiscoveryModuleFactory.writeDirectoryTable(this.directoryTable != null ? this.directoryTable : new DirectoryTable(), this.fabricDirectory);
            Trace.logInfo(this, "Directory Table written to file '" + this.fabricDirectory + "'.");
        }
        catch (FabricException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Writing Directory Table to file '" + this.fabricDirectory + "' failed.");
        }
    }

    private static boolean isValidFile(File file) {
        if (file.exists()) {
            return file.isFile();
        }
        return (file = file.getAbsoluteFile()).getParentFile() != null && file.getParentFile().isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDirectoryTable() {
        RandomAccessFile raf = null;
        FileLock lock = null;
        try {
            if (!this.fabricDirectory.isEmpty()) {
                DirectoryTable newTable = this.directoryTable != null ? this.directoryTable : new DirectoryTable();
                File file = new File(this.fabricDirectory);
                raf = new RandomAccessFile(file, "rw");
                lock = FileIOUtils.tryLock(raf.getChannel(), 5000L);
                if (lock != null) {
                    DirectoryTable oldTable;
                    if (raf.length() > 0L && newTable.equals(oldTable = DiscoveryModuleFactory.readDirectoryTable(file.getCanonicalPath(), new FileInputStream(raf.getFD())))) {
                        newTable = null;
                    }
                    if (newTable != null) {
                        raf.setLength(0L);
                        raf.seek(0L);
                        DiscoveryModuleFactory.writeDirectoryTable(newTable, file.getCanonicalPath(), new FileOutputStream(raf.getFD()));
                    }
                } else {
                    Trace.logError(this, "Access to file '" + file.getCanonicalPath() + "' locked.");
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Writing Directory Table to the file '" + this.fabricDirectory + "' failed.");
        }
        finally {
            try {
                if (lock != null && lock.isValid()) {
                    lock.close();
                }
                if (raf != null && raf.getChannel().isOpen()) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    DirectoryTable getCompositeDirectoryTable() {
        return this.compositeDirectoryTable;
    }

    private void startMulticastDiscovery() {
        try {
            Trace.logDebug(this, "Starting multicast discovery...");
            if (this.multicastUniqueId == null) {
                this.multicastUniqueId = this.makeMulticastUniqueId();
            }
            this.multicastConnection = new MulticastConnection(new Address(this.multicastAddress), new ConnectionHandler());
            this.multicastConnection.open();
            Trace.logInfo(this, "Multicast discovery started.");
        }
        catch (Exception exception) {
            Trace.logException(AbstractDiscoveryModule.class, exception, true);
            Trace.logError(AbstractDiscoveryModule.class, "Starting multicast discovery failed.");
            this.multicastEnabled = false;
        }
    }

    abstract byte[] makeMulticastUniqueId();

    private void stopMulticastDiscovery() {
        if (this.multicastConnection != null) {
            this.multicastConnection.close();
            this.multicastConnection = null;
            Trace.logInfo(this, "Multicast discovery stopped.");
        }
    }

    @Override
    public synchronized List<DiscoveryLink> discover() {
        Trace.logInfo(this, "Locating active fabric nodes...");
        this.compositeDirectoryTable = new DirectoryTable(this.directoryTable);
        try {
            if (this.multicastEnabled && this.multicastWaitingTime > 0L) {
                this.multicastConnection.send(this.createRequest());
                Trace.logDebug(this, "Multicast request sent. Waiting for response...");
                this.doWait(this.multicastWaitingTime);
                if (!this.multicastHasResponse) {
                    Trace.logDebug(this, "No non-empty multicast responses received.");
                }
                this.multicastHasResponse = false;
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Multicast discovery failed.");
        }
        Trace.logInfo(this, "Locating active fabric nodes completed.");
        return this.getDiscoveryResult();
    }

    private synchronized void doWait(long timeout) {
        this.multicastDiscoveryInProgress = true;
        try {
            this.wait(timeout * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.multicastDiscoveryInProgress = false;
    }

    abstract List<DiscoveryLink> getDiscoveryResult();

    private byte[] createRequest() throws FabricException {
        ByteBuffer result = ByteBuffer.allocate(2 + this.multicastUniqueId.length);
        result.put((byte)0).put(this.getRequesterType()).put(this.multicastUniqueId).flip();
        return result.array();
    }

    abstract byte getRequesterType();

    void processRequest(ByteBuffer buffer) throws Exception {
    }

    synchronized void processResponse(ByteBuffer buffer) throws Exception {
        if (this.multicastDiscoveryInProgress) {
            byte[] responseUniqueId = new byte[buffer.getInt()];
            buffer.get(responseUniqueId);
            if (!Arrays.equals(this.multicastUniqueId, responseUniqueId)) {
                byte[] nodeMapBytes = new byte[buffer.remaining()];
                buffer.get(nodeMapBytes);
                this.compositeDirectoryTable.merge((Map)this.deserialize(nodeMapBytes), false);
            }
        }
    }

    byte[] serialize(Object object) throws FabricException {
        try {
            return this.context.getJSerializer().serialize(object);
        }
        catch (Exception exception) {
            throw new FabricException(exception);
        }
    }

    Object deserialize(byte[] bytes) throws FabricException {
        try {
            return this.context.getJSerializer().deserialize(bytes);
        }
        catch (Exception exception) {
            throw new FabricException(exception);
        }
    }

    private class ConnectionHandler
    implements MulticastConnectionHandler {
        private ConnectionHandler() {
        }

        @Override
        public void onOpen(MulticastConnection connection) throws FabricException {
        }

        @Override
        public void onClose(MulticastConnection connection) {
        }

        @Override
        public void onFailure(MulticastConnection connection) {
        }

        @Override
        public void onPacket(byte[] packet) throws FabricException {
            ByteBuffer packetBuffer = ByteBuffer.wrap(packet);
            try {
                byte type = packetBuffer.get();
                switch (type) {
                    case 0: {
                        AbstractDiscoveryModule.this.processRequest(packetBuffer);
                        break;
                    }
                    case 1: {
                        AbstractDiscoveryModule.this.processResponse(packetBuffer);
                    }
                }
            }
            catch (Exception exception) {
                throw new FabricException(exception);
            }
        }
    }
}

