/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dii;

import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dii.AccessibleObjectsCacheException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class AccessibleObjectsCache {
    protected Map<Long, AccessibleObject> objectCache = new ConcurrentHashMap<Long, AccessibleObject>();
    protected Map<AccessibleObject, Long> objectCacheRevert = new ConcurrentHashMap<AccessibleObject, Long>();
    private final Object TREE_MUTEX = new Object();
    private final Map<Long, Set<Long>> parentChildLink = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Long> childParentLink = new ConcurrentHashMap<Long, Long>();
    private final Map<Long, Long> objectLastAccessedTime = new ConcurrentHashMap<Long, Long>();
    public static final AtomicInteger objectsCounter = new AtomicInteger();

    public void putAccessibleObject(long oid, AccessibleObject object) {
        this.objectCache.put(oid, object);
        this.objectCacheRevert.put(object, oid);
    }

    public AccessibleObject getAccessibleObject(long oid) {
        return this.objectCache.get(oid);
    }

    public void removeAccessibleObject(Long oid) {
        AccessibleObject object = this.objectCache.remove(oid);
        if (object != null) {
            this.objectCacheRevert.remove(object);
        }
        this.childParentLink.remove(oid);
        this.parentChildLink.remove(oid);
        this.objectLastAccessedTime.remove(oid);
    }

    public void removeAndCloseAccessibleObjectWithChilds(AccessibleObject object) {
        Long oid = this.objectCacheRevert.get(object);
        if (oid != null) {
            this.removeAndCloseAccessibleObjectWithChilds(oid);
        }
    }

    public void removeAndCloseAccessibleObjectWithChilds(Long oid) {
        AccessibleObject object;
        this.childParentLink.remove(oid);
        this.objectLastAccessedTime.remove(oid);
        Set<Long> childOids = this.parentChildLink.remove(oid);
        if (childOids != null) {
            for (Long childOid : childOids) {
                this.removeAndCloseAccessibleObjectWithChilds(childOid);
            }
        }
        if ((object = this.objectCache.remove(oid)) != null) {
            this.objectCacheRevert.remove(object);
        }
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)object)).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearAndCloseAll() {
        this.objectCache.remove(0L);
        for (AccessibleObject object : this.objectCache.values()) {
            if (!(object instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)object)).close();
            }
            catch (IOException iOException) {}
        }
        this.objectCache.clear();
        this.objectCacheRevert.clear();
        this.parentChildLink.clear();
        this.childParentLink.clear();
        this.objectLastAccessedTime.clear();
    }

    public Object invoke(SLDataspaceCall call) throws AccessibleObjectsCacheException {
        AccessibleObject accessibleObject = this.getAccessibleObject(call.objectId());
        if (accessibleObject == null) {
            throw new AccessibleObjectsCacheException("Unable to find callable object for id '" + call.objectId() + "'.");
        }
        this.resolveArgumentAccessibleObject(call);
        Method method = this.resolveMethod(call, accessibleObject);
        if (method == null) {
            throw new AccessibleObjectsCacheException("Unknown method '" + call.method() + "' specified.");
        }
        return this.invoke(call, method, false);
    }

    public Object invoke(SLDataspaceCall call, Method method, boolean keepParentChildLink) throws AccessibleObjectsCacheException {
        AccessibleObject accessibleObject = this.getAccessibleObject(call.objectId());
        if (accessibleObject == null) {
            throw new AccessibleObjectsCacheException("Unable to find callable object for id '" + call.objectId() + "'.");
        }
        this.resolveArgumentAccessibleObject(call);
        this.touchAccessedObjectWithParent(call.objectId());
        try {
            method.setAccessible(true);
            Object result = method.invoke((Object)accessibleObject, call.params());
            result = this.putAndConvertToProxy(result);
            this.putParentChildLink(call.objectId(), result);
            if (result != null && result.getClass().isArray() && result instanceof Object[]) {
                Object[] arrayResult = (Object[])result;
                for (int i = 0; i < arrayResult.length; ++i) {
                    arrayResult[i] = this.putAndConvertToProxy(arrayResult[i]);
                    this.putParentChildLink(call.objectId(), arrayResult[i]);
                }
            }
            return result;
        }
        catch (Exception exception) {
            Throwable target;
            while (exception instanceof InvocationTargetException && (target = ((InvocationTargetException)exception).getTargetException()) != null && target instanceof Exception) {
                exception = (Exception)target;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AccessibleObjectsCacheException(exception.getMessage(), exception.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchAccessedObjectWithParent(long oid) {
        Object object = this.TREE_MUTEX;
        synchronized (object) {
            long timestamp = System.currentTimeMillis();
            Long parent = oid;
            while (parent != null) {
                this.objectLastAccessedTime.put(parent, timestamp);
                parent = this.childParentLink.get(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putParentChildLink(long parent, Object child) {
        Object object = this.TREE_MUTEX;
        synchronized (object) {
            if (child instanceof AccessibleObjectProxy) {
                Set<Long> childs = this.parentChildLink.get(parent);
                if (childs == null) {
                    childs = Collections.synchronizedSet(new HashSet());
                    this.parentChildLink.put(parent, childs);
                }
                childs.add(((AccessibleObjectProxy)child).getId());
                this.childParentLink.put(((AccessibleObjectProxy)child).getId(), parent);
                this.objectLastAccessedTime.put(parent, System.currentTimeMillis());
                this.objectLastAccessedTime.put(((AccessibleObjectProxy)child).getId(), System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putAndConvertToProxy(Object object) {
        Object object2 = this.TREE_MUTEX;
        synchronized (object2) {
            if (object instanceof AccessibleObject) {
                AccessibleObjectProxy proxy = ((AccessibleObject)object).getProxy();
                proxy.setId(objectsCounter.incrementAndGet());
                this.objectCache.put(proxy.getId(), (AccessibleObject)object);
                this.objectCacheRevert.put((AccessibleObject)object, proxy.getId());
                object = proxy;
            }
            return object;
        }
    }

    public void iterateOverObjectsNotAccessedForTime(long timeout, BiConsumer<Long, Long> consumer) {
        for (Map.Entry<Long, Long> entry : this.objectLastAccessedTime.entrySet()) {
            long inactiveTime = System.currentTimeMillis() - entry.getValue();
            if (inactiveTime <= timeout) continue;
            consumer.accept(entry.getKey(), inactiveTime);
        }
    }

    public Method resolveMethod(SLDataspaceCall call, AccessibleObject accessibleObject) {
        return ClassUtils.getDeclaredOrInheritedMethodCastNumerics(accessibleObject.getClass(), call.method(), this.getArgumentClasses(call.params()));
    }

    public void resolveArgumentAccessibleObject(SLDataspaceCall call) throws AccessibleObjectsCacheException {
        for (int i = 0; i < call.params().length; ++i) {
            if (!(call.params()[i] instanceof AccessibleObjectProxy)) continue;
            call.params()[i] = this.objectCache.get(((AccessibleObjectProxy)call.params()[i]).getId());
            if (call.params()[i] != null) continue;
            throw new AccessibleObjectsCacheException("Accessible object doesn't exist for parameter #" + i);
        }
    }

    public Class<?>[] getArgumentClasses(Object[] arguments) {
        if (arguments == null) {
            arguments = new Object[]{};
        }
        Class[] argumentClasses = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argumentClasses[i] = arguments[i] != null ? arguments[i].getClass() : Object.class;
        }
        return argumentClasses;
    }
}

