/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionsPool;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sef.db.connection.DBConnectionLexiconProcessor;
import com.streamscape.sef.dispatcher.AbstractFactoryConnectionService;
import com.streamscape.sef.factory.connection.FactoryConnectionComponent;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.jdbc.StateNotificationEventListener;
import com.streamscape.slex.SemanticLexiconProcessor;

public class DBFactoryConnectionService
extends AbstractFactoryConnectionService {
    private DBConnectionLexiconProcessor lexiconProcessor;
    private String factoryType;
    private String factoryName;
    private DatabaseConnectionsPool connectionsPool;

    public DBFactoryConnectionService(String factoryType, String factoryName) {
        this.factoryType = factoryType;
        this.factoryName = factoryName;
    }

    @Override
    protected void onInit() throws Exception {
        this.lexiconProcessor = new DBConnectionLexiconProcessor(RuntimeContext.getInstance(), this.getDSLComponent(this));
        this.initConnectionsPool();
    }

    @Override
    public void destroy() {
        this.destroyConnectionsPool();
    }

    @Override
    public SemanticLexiconProcessor getLexiconProcessor() {
        return this.lexiconProcessor;
    }

    public DatabaseConnectionsPool getConnectionsPool() {
        return this.connectionsPool;
    }

    private void initConnectionsPool() throws Exception {
        String packageName = PackageType.jdbc.toString() + "." + this.factoryType;
        if (!PackageLoaderHelper.loadPackageIfRegistered(RuntimeContext.getInstance(), packageName)) {
            throw new Exception("Package '" + packageName + "' not registered.");
        }
        JDBCFactory jdbcFactory = JDBCConfigurationFactory.getJDBCFactory(RuntimeContext.getInstance(), this.factoryName, this.factoryType);
        if (!jdbcFactory.isReliableConnection()) {
            this.logDebug("Setting factory to reliable.");
            jdbcFactory.setReliableConnection(true);
        }
        if (jdbcFactory.getReconnectInterval() <= 10000L) {
            this.logDebug("Setting factory reconnect interval to 10 secs.");
            jdbcFactory.setReconnectInterval(10000L);
        }
        if (jdbcFactory.getConnectionCheckInterval() <= 1000L) {
            this.logDebug("Setting factory connection check interval to 1 sec.");
            jdbcFactory.setConnectionCheckInterval(1000L);
        }
        this.connectionsPool = new DatabaseConnectionsPool();
        this.connectionsPool.setLogger((Logger)((Object)this.component));
        this.connectionsPool.setExceptionEventListener(exception -> this.logError(exception.getMessage()));
        this.connectionsPool.setStateNotificationEventListener(new StateNotificationEventListener(){

            @Override
            public void onEvent(ConnectionStateChangeAdvisory advisory) {
                try {
                    DBFactoryConnectionService.this.logDebug("Connection state changed to " + String.valueOf((Object)advisory.getState()) + " for connection '" + advisory.getConnectionName() + "'.");
                    advisory.setComponentName(DBFactoryConnectionService.this.factoryType + "." + DBFactoryConnectionService.this.factoryName);
                    ((FactoryConnectionComponent)((Object)DBFactoryConnectionService.this.component)).raiseSystemAdvisory(advisory);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Raising advisory failed. Cause: " + exception.getMessage());
                }
            }
        });
        this.connectionsPool.setFactory(jdbcFactory);
        this.connectionsPool.setPoolSize(1);
        this.connectionsPool.setName("DBFactoryService$" + this.factoryType + "." + this.factoryName);
        this.connectionsPool.start();
        this.waitForConnectionPoolOpen(60000L);
    }

    private void waitForConnectionPoolOpen(long timeout) throws Exception {
        this.logDebug("Waiting for start of connection pool, timeout(" + timeout + "ms)...");
        long startTime = System.currentTimeMillis();
        DatabaseSQLException exception = null;
        while (this.connectionsPool.getState() != ConnectionState.CONNECTED && System.currentTimeMillis() - startTime < timeout && (exception = this.connectionsPool.getLastException()) == null) {
            Thread.sleep(100L);
        }
        if (this.connectionsPool.getState() != ConnectionState.CONNECTED) {
            this.logDebug("Connection pool start failed.");
        }
    }

    private void destroyConnectionsPool() {
        if (this.connectionsPool != null) {
            try {
                this.connectionsPool.stop();
            }
            catch (Exception exception) {
                this.logError("Destroying Database Connections Pool failed. Cause: " + exception.getMessage());
            }
        }
    }

    @Override
    public ExternalParser getExternalParser() {
        return null;
    }
}

