/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.db.connection.AbstractDBConnectionOperation;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.lang.DSLStatement;
import java.sql.ResultSet;

class DBConnectionListSchemasOperation
extends AbstractDBConnectionOperation {
    public static final String NAME = "list schemas";

    public DBConnectionListSchemasOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SCHEMAS");
        this.syntax.setDescription("Returns list of schemas.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, DatabaseConnection connection) throws Exception {
        ResultSet resultSet = connection.getMetaData().getSchemas();
        RowSet result = new RowSet(DBConnectionListSchemasOperation.createResultDescriptor());
        try {
            resultSet.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (resultSet.next()) {
            result.addToRowSet(new Object[]{resultSet.getString(1)});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DBConnectionListSchemasOperation.addColumn(result, "Schema Name");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        protected Definition() {
            super(DBConnectionListSchemasOperation.NAME);
        }
    }
}

