/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.db.connection.AbstractDBConnectionOperation;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.sql.ResultSet;

class DBConnectionListCollectionsOperation
extends AbstractDBConnectionOperation {
    public static final String NAME = "list collections";

    public DBConnectionListCollectionsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST COLLECTIONS");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SCHEMA").addParameter(new IdentifierParameter("SchemaName"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TYPE").addParameter(new StringParameter("CollectionType"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALL").setName("all")).setRequired(false));
        this.syntax.setDescription("Returns list of collections.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("SchemaName").getValue(), statement.getParameter("CollectionType").getValue(), statement.existsModifier("all"));
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, DatabaseConnection connection) throws Exception {
        Definition definition = (Definition)statement;
        String excludeType = "SYSTEM TABLE";
        if (definition.all) {
            excludeType = null;
        }
        if (definition.collectionType != null && definition.collectionType.equalsIgnoreCase(excludeType)) {
            excludeType = null;
        }
        ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), definition.schemaName, null, null);
        RowSet result = new RowSet(DBConnectionListCollectionsOperation.createResultDescriptor());
        while (resultSet.next()) {
            String type = resultSet.getString(4);
            if (definition.collectionType != null && !definition.collectionType.equalsIgnoreCase(type) || excludeType != null && excludeType.equals(type)) continue;
            result.addToRowSet(new Object[]{connection.getCatalog(), resultSet.getString(2), resultSet.getString(3), type});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DBConnectionListCollectionsOperation.addColumn(result, "Catalog");
        DBConnectionListCollectionsOperation.addColumn(result, "Schema");
        DBConnectionListCollectionsOperation.addColumn(result, "Name");
        DBConnectionListCollectionsOperation.addColumn(result, "Type");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String schemaName;
        private String collectionType;
        private boolean all;

        protected Definition(String schemaName, String collectionType, boolean all) {
            super(DBConnectionListCollectionsOperation.NAME);
            this.schemaName = schemaName;
            this.collectionType = collectionType;
            this.all = all;
        }
    }
}

