/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.db.connection.AbstractDBConnectionOperation;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.lang.DSLStatement;
import java.sql.ResultSet;
import org.antlr.v4.runtime.misc.OrderedHashSet;

class DBConnectionListCollectionTypesOperation
extends AbstractDBConnectionOperation {
    public static final String NAME = "list collection types";

    public DBConnectionListCollectionTypesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST COLLECTION TYPES");
        this.syntax.setDescription("Returns list of collection types.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, DatabaseConnection connection) throws Exception {
        ResultSet resultSet = connection.getMetaData().getTableTypes();
        RowSet result = new RowSet(DBConnectionListCollectionTypesOperation.createResultDescriptor());
        try {
            resultSet.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        OrderedHashSet types = new OrderedHashSet();
        while (resultSet.next()) {
            types.add(resultSet.getString(1));
        }
        for (String type : types) {
            result.addToRowSet(new Object[]{type});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DBConnectionListCollectionTypesOperation.addColumn(result, "Collection Type");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        protected Definition() {
            super(DBConnectionListCollectionTypesOperation.NAME);
        }
    }
}

