/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.ds.mf.DataspaceAccessorProxy;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionsPool;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetClientFactory;
import com.streamscape.sdo.rowset.RowSetClientResultSetImpl;
import com.streamscape.sef.db.connection.DBConnectionDSLProvider;
import com.streamscape.sef.db.connection.DBFactoryConnectionService;
import com.streamscape.sef.factory.connection.FactoryConnectionMFSession;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.AbstractLexiconProcessor;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnectionLexiconProcessor
extends AbstractLexiconProcessor<DBFactoryConnectionService> {
    public DBConnectionLexiconProcessor(RuntimeContext context, DSLComponent<DBFactoryConnectionService> component) {
        super(context.getLexiconManager(), component);
    }

    @Override
    protected DSLProvider createBaseProvider(DSLComponent<DBFactoryConnectionService> component) {
        return new DBConnectionDSLProvider(component.getCallable());
    }

    @Override
    public SLResponse invoke(String operation, MFSession session, long timeout) throws Exception {
        try {
            return super.invoke(operation, session, timeout);
        }
        catch (UnsupportedRequestException exception) {
            return this.invokeSql(operation, session, timeout);
        }
    }

    private SLResponse invokeSql(String operation, MFSession session, long timeout) throws Exception {
        DBFactoryConnectionService service = (DBFactoryConnectionService)((FactoryConnectionMFSession)session).getComponent().getFactoryService();
        DatabaseConnectionsPool pool = service.getConnectionsPool();
        DatabaseConnection connection = pool.get();
        Statement statement = null;
        try {
            SLResponse response;
            statement = DataspaceAccessorProxy.createStatementAndExecute(connection, operation, session.getSLSessionData().getFetchSize());
            Object result = ((RowSetClientFactory)((RowSetClientFactory)((RowSetClientFactory)new RowSetClientFactory().setFetchSize(session.getSLSessionData().getFetchSize())).setWithBlobs(false)).setNotation(session.getSLSessionData().getDataObjectNotation())).createRowSetClientResponse(statement, operation);
            if (result instanceof RowSetClientResultSetImpl) {
                ((RowSetClientResultSetImpl)result).addCloseableObject(statement);
                statement = null;
                response = new SLResponse();
                response.setObject(result);
            } else {
                response = new SLResponse((RowSet)result);
            }
            SLResponse sLResponse = response;
            return sLResponse;
        }
        catch (SQLException exception) {
            throw new Exception(VirtualServerObject.formatSQLExceptionMessage(connection, exception));
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            pool.release(connection);
        }
    }
}

