/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.db.connection.AbstractDBConnectionOperation;
import com.streamscape.sef.db.connection.DBFactoryConnectionService;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.lang.DSLStatement;
import java.sql.DatabaseMetaData;

class DBConnectionDescribeServerOperation
extends AbstractDBConnectionOperation {
    public static final String NAME = "describe server";

    public DBConnectionDescribeServerOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SERVER");
        this.syntax.setDescription("Returns connected server info.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, DatabaseConnection connection) throws Exception {
        RowSet result = new RowSet(DBConnectionDescribeServerOperation.createResultDescriptor());
        try {
            DatabaseMetaData meta = connection.getMetaData();
            result.addToRowSet(new Object[]{"Database Name", meta.getDatabaseProductName()});
            result.addToRowSet(new Object[]{"Database Version", meta.getDatabaseProductVersion()});
            result.addToRowSet(new Object[]{"Database Major Version", meta.getDatabaseMajorVersion()});
            result.addToRowSet(new Object[]{"Database Minor Version", meta.getDatabaseMinorVersion()});
            result.addToRowSet(new Object[]{"Driver Name", meta.getDriverName()});
            result.addToRowSet(new Object[]{"Driver Version", meta.getDriverVersion()});
            result.addToRowSet(new Object[]{"Driver Major Version", meta.getDriverMajorVersion()});
            result.addToRowSet(new Object[]{"Driver Minor Version", meta.getDriverMinorVersion()});
            result.addToRowSet(new Object[]{"User name", meta.getUserName()});
            result.addToRowSet(new Object[]{"Catalog", connection.getCatalog()});
            result.addToRowSet(new Object[]{"Connection URL", ((DBFactoryConnectionService)this.callable).getConnectionsPool().getFactory().getUrl()});
        }
        catch (Exception exception) {
            result.addToRowSet(new Object[]{"Connection State", connection.getState().toString()});
            result.addToRowSet(new Object[]{"Exception", Utils.formatExceptionWithUnrepeatedCauses(exception)});
            result.addToRowSet(new Object[]{"Connection URL", ((DBFactoryConnectionService)this.callable).getConnectionsPool().getFactory().getUrl()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DBConnectionDescribeServerOperation.addColumn(result, "Property");
        DBConnectionDescribeServerOperation.addColumn(result, "Value");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        protected Definition() {
            super(DBConnectionDescribeServerOperation.NAME);
        }
    }
}

