/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.DatabaseDescriptor;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLTableName;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sef.db.connection.AbstractDBConnectionOperation;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.sql.SQLException;
import java.util.List;

class DBConnectionDescribeCollectionOperation
extends AbstractDBConnectionOperation {
    public static final String NAME = "describe collection";

    public DBConnectionDescribeCollectionOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE COLLECTION");
        this.syntax.addActionParameter(new IdentifierParameter("CollectionName"));
        this.syntax.setDescription("Returns collection columns description.");
        this.syntax.addCompletionCommand("list collections");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("CollectionName").getValue());
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        try {
            while (rowSet.next()) {
                completions.add(rowSet.getString(3));
            }
        }
        catch (SQLException exception) {
            Trace.logError(this, "Failed to extract row set. Cause: " + exception.getMessage());
        }
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, DatabaseConnection connection) throws Exception {
        Definition definition = (Definition)statement;
        SQLTableName tableName = SQLTableName.parse(definition.collectionName);
        List<SQLQueryParameter> columns = DatabaseDescriptor.getTableColumns(tableName, connection, null, 1);
        RowSet result = new RowSet(DBConnectionDescribeCollectionOperation.createResultDescriptor());
        for (SQLQueryParameter column : columns) {
            result.addToRowSet(new Object[]{column.getName(), SQLTypeToken.getTypeById(column.getType()).getName(), column.getPrecision(), column.getScale(), column.isNullable(), column.isSearchable()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DBConnectionDescribeCollectionOperation.addColumn(result, "Name");
        DBConnectionDescribeCollectionOperation.addColumn(result, "Type");
        DBConnectionDescribeCollectionOperation.addColumn(result, "Precision");
        DBConnectionDescribeCollectionOperation.addColumn(result, "Scale");
        DBConnectionDescribeCollectionOperation.addColumn(result, "Nullable");
        DBConnectionDescribeCollectionOperation.addColumn(result, "Searchable");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String collectionName;

        protected Definition(String collectionName) {
            super(DBConnectionDescribeCollectionOperation.NAME);
            this.collectionName = collectionName;
        }
    }
}

