/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.db.connection;

import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.db.connection.DBFactoryConnectionService;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.OperationTag;
import java.sql.SQLException;

abstract class AbstractDBConnectionOperation
extends AbstractDSLOperation<DBFactoryConnectionService> {
    AbstractDBConnectionOperation() {
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.service);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DatabaseConnection connection = ((DBFactoryConnectionService)this.callable).getConnectionsPool().get();
        try {
            SLResponse sLResponse = this.onInvoke(definition, connection);
            return sLResponse;
        }
        catch (SQLException exception) {
            throw new Exception(VirtualServerObject.formatSQLExceptionMessage(connection, exception));
        }
        catch (Exception exception) {
            throw new FabricException("Operation with database connection failed. Cause: " + exception.getMessage());
        }
        finally {
            ((DBFactoryConnectionService)this.callable).getConnectionsPool().release(connection);
        }
    }

    protected abstract SLResponse onInvoke(SLStatement var1, DatabaseConnection var2) throws Exception;
}

