/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dataspace;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import com.streamscape.ds.session.DataspaceSessionInfo;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dataspace.DataspaceManagerException;
import com.streamscape.sef.dataspace.Store;
import com.streamscape.sef.dispatcher.AbstractDataspaceManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.utils.RepositoryUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class DataspaceManager
extends AbstractDataspaceManager {
    public static final String DATASPACE_CONTEXT = "/sys/dataspace/";
    public static final String SYSTEM_DATASPACE = "SDS";
    protected static final String DEFAULT_STORE_NAME = "DataspaceStore";
    protected static final String DEFAULT_STORE_CLASS = "com.streamscape.ds.DataspaceStore";
    protected transient boolean isBound = false;
    protected Store store = null;
    private transient DataspaceLogger defaultLogger = null;

    protected DataspaceManager() {
    }

    public void init() {
        try {
            Trace.logDebug(this, "Initializing dataspace manager...");
            this.checkContext(DATASPACE_CONTEXT, "dataspace");
            this.initStore();
            this.isBound = true;
            Trace.logDebug(this, "Dataspace manager initialized.");
        }
        catch (DataspaceManagerException error) {
            Trace.logException(DataspaceManager.class, error, true);
            Trace.logError(DataspaceManager.class, "Initialization of dataspace manager failed.");
            this.isBound = false;
        }
    }

    public void open() {
        try {
            Trace.logDebug(this, "Opening dataspace store...");
            if (this.store != null) {
                this.store.open();
            }
            Trace.logDebug(this, "Dataspace store opened.");
        }
        catch (DataspaceManagerException error) {
            Trace.logException(DataspaceManager.class, error, true);
            Trace.logError(DataspaceManager.class, "Opening of dataspace store failed.");
            this.isBound = false;
        }
    }

    private void initStore() throws DataspaceManagerException {
        String storeName;
        if (!this.isDataspaceStoreRegistered(DEFAULT_STORE_NAME, false)) {
            Class defaultStoreClass;
            ClassLoader loader = DataspaceManager.getContext().getPackageManifestManager().getManifestClassLoader();
            try {
                defaultStoreClass = ClassUtils.loadClass(DEFAULT_STORE_CLASS, loader);
            }
            catch (ClassNotFoundException error) {
                defaultStoreClass = null;
            }
            if (defaultStoreClass != null) {
                this.store = this.registerStore(defaultStoreClass, false);
            } else {
                throw new DataspaceManagerException(2002, "Registering of default dataspace store failed. Cause: store class is not in CLASSPATH.");
            }
        }
        if ((storeName = this.getStoreName()) == null) {
            storeName = DEFAULT_STORE_NAME;
        }
        this.store = this.loadDataspaceStore(storeName);
        this.store.setDefaultLogger(this.defaultLogger);
        this.store.create();
    }

    private String getStoreName() {
        return null;
    }

    private void checkContext(String contextPath, String name) throws DataspaceManagerException {
        try {
            ReferenceContext ctx = SemanticObjectReferenceStore.lookupReferenceContext(contextPath);
            if (ctx == null) {
                Trace.logDebug(DataspaceManager.class, "Creating " + name + " context...");
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.createSubcontextFromNamespace(contextPath);
                SemanticObjectReferenceStore.commitXact();
                Trace.logDebug(DataspaceManager.class, "Context for " + name + " created.");
            }
        }
        catch (ObjectConfigurationException exception) {
            throw new DataspaceManagerException(2010, (Throwable)exception);
        }
    }

    public void createDataspace(DataspaceType model, String name, EventScope scope) throws DataspaceManagerException {
        this.createDataspace(model, name, scope, null);
    }

    public void createDataspace(DataspaceType model, String name, EventScope scope, String autorization) throws DataspaceManagerException {
        this.assertState();
        try {
            String runtimeUserName = DataspaceManager.getContext().getDeploymentDescriptor().getSecurityPrincipal();
            User runtimeUser = DataspaceManager.getContext().getSecurityManager().lookupUser(runtimeUserName);
            this.createDataspace(model, name, scope, runtimeUser, autorization);
        }
        catch (SecurityManagerException error) {
            throw new DataspaceManagerException(2002, "Creation of dataspace '" + name + "' failed.", error);
        }
    }

    public Connection getJDBCConnection(String username, String password) throws SQLException {
        return this.store.getJDBCConnection(username, password);
    }

    public Connection getJDBCConnection(String dataspaceName, SecurityContext secContext) throws SQLException {
        return this.store.getJDBCConnection(dataspaceName, secContext);
    }

    public Connection getJDBCConnection(String dataspaceName, SecurityContext secContext, BaseStoreProperties props) throws SQLException {
        return this.store.getJDBCConnection(dataspaceName, secContext, props);
    }

    private void createDataspace(DataspaceType model, String name, EventScope scope, User user, String authorization) throws DataspaceManagerException {
        this.assertState();
        this.store.createDataspace(model, name, scope, user, authorization);
    }

    public void dropDataspace(String name) throws DataspaceManagerException {
        this.dropDataspace(name, true, false);
    }

    public void dropDataspace(String name, boolean cascade, boolean force) throws DataspaceManagerException {
        this.assertState();
        try {
            String runtimeUserName = DataspaceManager.getContext().getDeploymentDescriptor().getSecurityPrincipal();
            User runtimeUser = DataspaceManager.getContext().getSecurityManager().lookupUser(runtimeUserName);
            this.dropDataspace(name, runtimeUser, cascade, force);
        }
        catch (SecurityManagerException error) {
            throw new DataspaceManagerException(2002, "Dropping of dataspace '" + name + "' failed.", error);
        }
    }

    private void dropDataspace(String name, User user, boolean cascade, boolean force) throws DataspaceManagerException {
        this.assertState();
        DataspaceComponent dataspace = this.lookup(name);
        if (dataspace == null) {
            throw new DataspaceManagerException(2011, "Dataspace '" + name + "' does not exist.");
        }
        this.store.dropDataspace(name, user, cascade, force);
    }

    public void openDataspace(String dataspaceName, String userName) throws DataspaceManagerException {
        this.assertState();
        this.store.openDataspace(dataspaceName, userName);
    }

    public void closeDataspace(String dataspaceName, String userName) throws DataspaceManagerException {
        this.assertState();
        this.store.closeDataspace(dataspaceName, userName);
    }

    public void initDataspace(String dataspaceName, String userName) throws DataspaceManagerException {
        this.assertState();
        this.store.initDataspace(dataspaceName, userName);
    }

    public void destroyDataspace(String dataspaceName, String userName) throws DataspaceManagerException {
        this.assertState();
        this.store.destroyDataspace(dataspaceName, userName);
    }

    public boolean isDataspaceStoreRegistered(String providerName) throws DataspaceManagerException {
        return this.isDataspaceStoreRegistered(providerName, true);
    }

    protected boolean isDataspaceStoreRegistered(String providerName, boolean check) throws DataspaceManagerException {
        if (check) {
            this.assertState();
        }
        boolean registered = false;
        try {
            SemanticObjectReferenceStore.beginXact();
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext(DATASPACE_CONTEXT);
            SemanticObjectReferenceStore.setReferenceContext(ref);
            Store provider = (Store)SemanticObjectReferenceStore.lookup(providerName);
            if (provider != null) {
                registered = true;
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        return registered;
    }

    public List<String> listRegisteredStores() throws DataspaceManagerException {
        this.assertState();
        try {
            SemanticObjectReferenceStore.beginXact();
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext(DATASPACE_CONTEXT);
            SemanticObjectReferenceStore.setReferenceContext(ref);
            List<String> names = SemanticObjectReferenceStore.listBoundNames(null);
            SemanticObjectReferenceStore.commitXact();
            return names;
        }
        catch (ObjectConfigurationException exception) {
            throw new DataspaceManagerException(2010, (Throwable)exception);
        }
    }

    public DataspaceComponent lookup(String name) throws DataspaceManagerException {
        this.assertState();
        return this.store.lookup(name);
    }

    public boolean existsDataspace(String name) throws DataspaceManagerException {
        return this.lookup(name) != null;
    }

    public Store registerStore(Class<?> providerClass) throws DataspaceManagerException {
        return this.registerStore(providerClass, true);
    }

    protected Store registerStore(Class<?> storeClass, boolean check) throws DataspaceManagerException {
        Store store;
        if (check) {
            this.assertState();
        }
        if (this.isDataspaceStoreRegistered((store = this.instantiateDataspaceStore(storeClass)).getName(), false)) {
            throw new DataspaceManagerException(2013, "Dataspace store '" + storeClass.getSimpleName() + "' already registered.");
        }
        Trace.logDebug(this, "Registering dataspace store class '" + storeClass.getName() + "'...");
        if (Store.class.isAssignableFrom(storeClass)) {
            try {
                SemanticType type = store.getSemanticType();
                if (!DataspaceManager.getContext().getSemanticTypeCache().existsSemanticType(type.getTypeName())) {
                    TypeFactory.addSemanticType(type);
                }
                RepositoryUtils.bindObject(DATASPACE_CONTEXT, store);
                Trace.logDebug(this, "Dataspace store registered: " + store.getName());
            }
            catch (ObjectConfigurationException exception) {
                throw new DataspaceManagerException(2010, (Throwable)exception);
            }
            catch (SemanticTypeFactoryException exception) {
                throw new DataspaceManagerException(2009, (Throwable)exception);
            }
        } else {
            throw new DataspaceManagerException(5008, ErrorMessages.format("Object is not an instance of '%1$s'.", DatagramFactory.class.getName()));
        }
        return store;
    }

    public void unregisterStore(String name) throws DataspaceManagerException {
        this.assertState();
    }

    private void validateStore(String storeName) throws DataspaceManagerException {
        Trace.logDebug(this, "Validating dataspace store version for '" + storeName + "'...");
        SemanticType stype = context.getSemanticTypeCache().lookupSemanticType(storeName);
        try {
            ClassLoader loader = DataspaceManager.getContext().getPackageManifestManager().getManifestClassLoader();
            Class clazz = ClassUtils.loadClass(stype.getClassName(), loader);
            Store provider = this.instantiateDataspaceStore(clazz);
            if (stype.getSerialVersionUID() != provider.getSerialVersionUID()) {
                Trace.logDebug(this, "Warning: Serial Version mismatch for store '" + storeName + "'. Synchronizing...");
                this.unregisterStore(storeName);
                TypeFactory.removeSemanticType(stype.getTypeName(), true);
                TypeFactory.addSemanticType(provider.getSemanticType());
                this.registerStore(clazz);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new DataspaceManagerException(2009, (Throwable)exception);
        }
        catch (SemanticTypeFactoryException exception) {
            throw new DataspaceManagerException(2009, (Throwable)exception);
        }
        Trace.logDebug(this, "Validation complete.");
    }

    protected Store instantiateDataspaceStore(Class storeClass) throws DataspaceManagerException {
        Store store = null;
        if (Store.class.isAssignableFrom(storeClass)) {
            try {
                Trace.logDebug(this, "Instantiating dataspace store class '" + storeClass.getName() + "'...");
                Class[] parms = new Class[]{};
                Constructor c = ClassUtils.getConstructor(storeClass, parms);
                c.setAccessible(true);
                store = (Store)c.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new DataspaceManagerException(2002, "Instantiation of dataspace store failed.", exception);
            }
        }
        return store;
    }

    protected Store loadDataspaceStore(String name) throws DataspaceManagerException {
        Trace.logDebug(this, "Loading dataspace store '" + name + "'...");
        try {
            Store store = (Store)RepositoryUtils.lookupObject(DATASPACE_CONTEXT, name);
            Trace.logDebug(this, "Initializing dataspace store instance...");
            Class[] args = new Class[]{RuntimeContext.class};
            Method init = ClassUtils.getMethod(store.getClass(), "init", args);
            init.setAccessible(true);
            Object[] parameters = new Object[]{DataspaceManager.getContext()};
            ClassUtils.invokeMethod(store, init, parameters);
            Trace.logDebug(this, "Dataspace store initialized: " + store.getName());
            return store;
        }
        catch (InvocationTargetException exception) {
            throw new DataspaceManagerException(2002, "Loading of dataspace store '" + name + "' failed.", exception.getCause());
        }
        catch (UtilitiesException exception) {
            throw new DataspaceManagerException(2002, "Loading of dataspace store '" + name + "' failed.", exception);
        }
        catch (ObjectConfigurationException exception) {
            throw new DataspaceManagerException(2010, "Loading of dataspace store '" + name + "' failed.", exception);
        }
    }

    public DataspaceStoreProperties getDataspaceStoreProperties() {
        return this.store.getProperties();
    }

    public DataspaceStoreState getStoreState() throws DataspaceManagerException {
        this.assertState();
        return this.store.getStoreState();
    }

    public void close() throws DataspaceManagerException {
        Trace.logDebug(DataspaceManager.class, "Closing Dataspace Manager...");
        this.store.close();
        Trace.logDebug(DataspaceManager.class, "Dataspace Manager closed.");
    }

    private void assertState() throws DataspaceManagerException {
        DataspaceManager.checkContext();
        if (!this.isBound) {
            throw new DataspaceManagerException(2007, "Dataspace Framework is not bound.");
        }
    }

    public List<DataspaceComponent> getDataspacesByType(DataspaceType type) {
        ArrayList<DataspaceComponent> dataspaces = new ArrayList<DataspaceComponent>();
        for (DataspaceComponent component : this.store.getDataspaceComponents()) {
            if (component.getDataspaceType() != type) continue;
            dataspaces.add(component);
        }
        return dataspaces;
    }

    public List<String> listDataspacesByType(DataspaceType type) {
        ArrayList<String> names = new ArrayList<String>();
        for (DataspaceComponent component : this.store.getDataspaceComponents()) {
            if (component.getDataspaceType() != type) continue;
            names.add(component.getName());
        }
        return names;
    }

    public List<DataspaceComponent> getDataspaces() {
        ArrayList<DataspaceComponent> dataspaces = new ArrayList<DataspaceComponent>();
        Collections.addAll(dataspaces, this.store.getDataspaceComponents());
        return dataspaces;
    }

    public List<String> listDataspaces() {
        ArrayList<String> names = new ArrayList<String>();
        for (DataspaceComponent component : this.store.getDataspaceComponents()) {
            names.add(component.getName());
        }
        return names;
    }

    public List<String> listRemoteDataspaces() {
        ArrayList<String> names = new ArrayList<String>();
        for (ComponentReference reference : DataspaceManager.getContext().getModerator().getComponents(EventScope.GLOBAL)) {
            if (reference.getModel() != ComponentModel.DATASPACE || reference.getName().startsWith(DataspaceManager.getContext().getName())) continue;
            names.add(reference.getName());
        }
        return names;
    }

    public List<DataspaceSessionInfo> getBlockedSessions() {
        if (this.store != null) {
            return this.store.getBlockedSessions();
        }
        return null;
    }

    public HashMap<Integer, List<String>> getSemanticTypeReferences(SemanticType type) {
        HashMap<Integer, List<String>> references = new HashMap<Integer, List<String>>();
        references.put(3, new ArrayList());
        references.put(17, new ArrayList());
        references.put(32, new ArrayList());
        references.put(9, new ArrayList());
        for (NameManager.ObjectName objectName : this.store.getSemanticTypeReferences(type)) {
            if (!references.containsKey(objectName.type)) continue;
            references.get(objectName.type).add(objectName.getSchemaQualifiedStatementName());
        }
        return references;
    }

    public void addSemanticType(SemanticType type) {
        if (this.store != null) {
            this.store.addSemanticType(type);
        }
    }

    public void removeSemanticType(String typeName) {
        if (this.store != null) {
            this.store.removeSemanticType(typeName);
        }
    }

    public void checkSemanticTypes(List<SemanticType> types, boolean validate) {
        if (this.store != null) {
            this.store.checkSemanticTypes(types, validate);
        }
    }

    public void setDefaultLogger(DataspaceLogger defaultLogger) {
        this.defaultLogger = defaultLogger;
    }

    public TimeZone getTimezone() {
        return this.store.getTimeZone();
    }

    public Charset getCCSID() {
        return this.store.getCCSID();
    }

    @Override
    public void setTimezone(TimeZone timezone) throws DataspaceManagerException {
        super.setTimezone(timezone);
    }

    @Override
    protected void doSetTimezone(TimeZone timezone) {
        this.store.setTimeZone(timezone);
    }

    @Override
    protected Store getStore() {
        return this.store;
    }

    public boolean isAllowedPath(String path) {
        return ((DataspaceStore)this.store).dataspaceLogger.getSecurePath(path) != null;
    }
}

