/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.container;

import com.streamscape.Trace;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.Container;

public class ContainerLoggerParameters {
    private long maxSize = 0L;
    private boolean archive = false;
    private Integer maxFiles = -1;
    private boolean sequence = false;
    private Integer advisoryGeneration = -1;
    private int advisoryThreshold = 0;
    private transient Container container;

    void init(Container container) {
        this.container = container;
        if (this.maxFiles == null) {
            this.maxFiles = -1;
        }
        if (this.advisoryGeneration == null) {
            this.advisoryGeneration = -1;
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long maxSize) {
        if (this.maxSize != maxSize) {
            this.maxSize = maxSize;
            this.container.onUpdate();
        }
    }

    public boolean isArchive() {
        return this.archive;
    }

    public synchronized void setArchive(boolean archive) {
        if (this.archive != archive) {
            this.archive = archive;
            this.container.onUpdate();
        }
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public synchronized void setMaxFiles(int maxFiles) {
        if (this.maxFiles != maxFiles) {
            this.maxFiles = maxFiles;
            this.container.onUpdate();
        }
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public synchronized void setSequence(boolean sequence) {
        if (this.sequence != sequence) {
            this.sequence = sequence;
            this.container.onUpdate();
        }
    }

    public int getAdvisoryGeneration() {
        return this.advisoryGeneration;
    }

    public synchronized void setAdvisoryGeneration(int advisoryGeneration) {
        if (this.advisoryGeneration != advisoryGeneration) {
            this.advisoryGeneration = advisoryGeneration;
            this.container.onUpdate();
        }
    }

    public int getAdvisoryThreshold() {
        return this.advisoryThreshold;
    }

    public synchronized void setAdvisoryThreshold(int advisoryThreshold) throws FabricException {
        if (this.advisoryThreshold != advisoryThreshold) {
            this.advisoryThreshold = Math.min(advisoryThreshold, 100);
            this.container.onUpdate();
        }
    }

    protected void raiseAdvisory(AdvisoryEvent advisory) {
        try {
            this.container.raiseAdvisory(advisory);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Raising '" + advisory.getEventId() + "' failed.");
        }
    }
}

