/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.container;

import com.streamscape.Logger;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.container.ContainerLoggerParameters;
import com.streamscape.sef.container.LogGenerationAdvisory;
import com.streamscape.sef.container.LogThresholdAdvisory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ContainerLogger
implements Logger {
    public static final String FILENAME_SUFFIX = ".log";
    private String filename;
    private File dir;
    private File file;
    private ContainerLoggerParameters parameters;
    private Deque<File> archivedFiles = new ArrayDeque<File>();
    private int sequence = 1;
    private int iRotation = 0;
    private boolean isThresholdAdvisorySent = false;
    private FileOutputStream writer;
    private LoggerPrintStream printStream;
    private boolean isSystemOutputRedirected = false;
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
    private static final Pattern TIMESTAMP_FORMAT_PATTERN = Pattern.compile("^\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d-\\d\\d\\.\\d\\d\\.\\d\\d" + Pattern.quote(".log") + "$");
    private static final Pattern SEQUENCE_FORMAT_PATTERN = Pattern.compile("^\\d+" + Pattern.quote(".log") + "$");

    public ContainerLogger(String filename, String defaultFilename) throws IOException {
        this(filename, defaultFilename, true);
    }

    public ContainerLogger(String filename, String defaultFilename, boolean append) throws IOException {
        try {
            this.init(filename, append);
        }
        catch (IOException exception) {
            if (defaultFilename != null) {
                System.err.println("WARNING: Log file cannot be written: " + exception.toString());
                System.err.println("WARNING: Trying to use default log file '" + defaultFilename + "'.");
                this.init(defaultFilename, append);
            }
            throw exception;
        }
        System.out.println("Log file: " + this.file.getPath() + ".");
    }

    public static void checkLogger(String filename) throws IOException {
        new ContainerLogger(filename).close();
    }

    private ContainerLogger(String filename) throws IOException {
        this.init(filename, true);
    }

    private void init(String filename, boolean append) throws IOException {
        this.file = new File((String)(filename.endsWith(FILENAME_SUFFIX) ? filename : filename + FILENAME_SUFFIX)).getCanonicalFile();
        this.dir = this.file.getParentFile();
        if (this.dir == null) {
            throw new IOException("Invalid log file '" + this.file.getPath() + "'.");
        }
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            throw new IOException("Creating directory '" + this.dir.getPath() + "' for log file failed.");
        }
        this.filename = ContainerLogger.removeSuffix(this.file.getName());
        this.openWriter(append);
    }

    @Override
    public void logDebug(String message) {
        this.write(message);
    }

    @Override
    public void logInfo(String message) {
        this.write(message);
    }

    @Override
    public void logError(String message) {
        this.write(message);
    }

    public ContainerLoggerParameters getParameters() {
        return this.parameters;
    }

    public synchronized void setParameters(ContainerLoggerParameters parameters) {
        this.parameters = parameters;
        this.checkArchivedFiles();
    }

    public void redirectSystemOutput() {
        System.setOut(this.printStream);
        System.setErr(this.printStream);
        this.isSystemOutputRedirected = true;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private synchronized void openWriter(boolean append) throws IOException {
        this.writer = new FileOutputStream(this.file, append);
        this.printStream = new LoggerPrintStream(this.writer);
        if (!append) {
            this.setCreationTime(this.file, System.currentTimeMillis());
        }
    }

    synchronized void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.printStream != null) {
            this.printStream.close();
            this.printStream = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    private String getFullFilename() {
        return this.filename + FILENAME_SUFFIX;
    }

    private synchronized void write(String message) {
        this.printStream.println(message);
    }

    private synchronized void checkSizeLimit() throws IOException {
        if (this.parameters != null && this.parameters.getMaxSize() > 0L) {
            long logSize = this.writer.getChannel().size();
            if (this.parameters.getAdvisoryThreshold() > 0 && !this.isThresholdAdvisorySent) {
                double ratio = (double)this.parameters.getAdvisoryThreshold() / 100.0;
                if ((double)logSize >= (double)this.parameters.getMaxSize() * ratio) {
                    this.parameters.raiseAdvisory(new LogThresholdAdvisory(this.parameters.getAdvisoryThreshold(), logSize));
                    this.isThresholdAdvisorySent = true;
                }
            }
            if (this.parameters.getMaxSize() > 0L && logSize >= this.parameters.getMaxSize()) {
                this.rotate();
            }
        }
    }

    public synchronized void rotate() throws IOException {
        long logSize = this.writer.getChannel().size();
        this.close();
        if (this.parameters != null && this.parameters.isArchive()) {
            if (this.parameters.getMaxFiles() != 0) {
                File archivedFile = new File(this.dir, this.getArchiveFileName(this.filename));
                archivedFile.delete();
                if (this.file.renameTo(archivedFile)) {
                    this.archivedFiles.add(archivedFile);
                }
            }
            this.deleteOldArchivedFiles();
        }
        Utils.sleep(100L);
        this.openWriter(false);
        ++this.iRotation;
        this.isThresholdAdvisorySent = false;
        if (this.parameters != null && this.iRotation > this.parameters.getAdvisoryGeneration()) {
            this.parameters.raiseAdvisory(new LogGenerationAdvisory(this.parameters.getAdvisoryGeneration(), this.iRotation, logSize));
        }
    }

    private void deleteOldArchivedFiles() {
        if (this.parameters.getMaxFiles() >= 0) {
            int removedFilesCount = this.archivedFiles.size() - this.parameters.getMaxFiles();
            for (int i = 0; i < removedFilesCount; ++i) {
                this.archivedFiles.pollFirst().delete();
            }
        }
    }

    private void checkArchivedFiles() {
        try {
            this.archivedFiles.addAll(Arrays.stream(FileIOUtils.directoryList(this.dir.getPath(), null)).filter(file -> file.isFile() && this.isArchive(file.getName())).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList()));
            if (!this.isTimestampFormat()) {
                for (File archivedFile : this.archivedFiles) {
                    String archivedFileSuffix = ContainerLogger.removeSuffix(archivedFile.getName()).substring(this.filename.length() + 1);
                    int archivedFileSequence = Integer.parseInt(archivedFileSuffix);
                    if (this.sequence >= archivedFileSequence) continue;
                    this.sequence = archivedFileSequence + 1;
                }
            }
        }
        catch (UtilitiesException utilitiesException) {
            // empty catch block
        }
    }

    public synchronized void resetSequence() {
        this.sequence = 1;
    }

    public boolean isArchive(String rotationFilename) {
        return rotationFilename.startsWith(this.filename + ".") && (this.isTimestampFormat() ? TIMESTAMP_FORMAT_PATTERN : SEQUENCE_FORMAT_PATTERN).matcher(rotationFilename.substring(this.filename.length() + 1)).matches();
    }

    public static boolean isArchive(String filename, String rotationFilename) {
        if (rotationFilename.startsWith((filename = ContainerLogger.removeSuffix(filename)) + ".")) {
            String suffix = rotationFilename.substring(filename.length() + 1);
            return TIMESTAMP_FORMAT_PATTERN.matcher(suffix).matches() || SEQUENCE_FORMAT_PATTERN.matcher(suffix).matches();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getArchiveFileName(String filename) {
        filename = ContainerLogger.removeSuffix(filename);
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMAT;
        synchronized (simpleDateFormat) {
            return filename + "." + (this.isTimestampFormat() ? TIMESTAMP_FORMAT.format(new Date()) : Integer.toString(this.sequence++)) + FILENAME_SUFFIX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getArchiveFileNameWithTimestamp(String filename) {
        filename = ContainerLogger.removeSuffix(filename);
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMAT;
        synchronized (simpleDateFormat) {
            return filename + "." + TIMESTAMP_FORMAT.format(new Date()) + FILENAME_SUFFIX;
        }
    }

    private static String removeSuffix(String filename) {
        return filename.endsWith(FILENAME_SUFFIX) ? filename.substring(0, filename.length() - FILENAME_SUFFIX.length()) : filename;
    }

    private boolean isTimestampFormat() {
        return this.parameters == null || !this.parameters.isSequence();
    }

    private void setCreationTime(File file, long time) {
        try {
            Files.setAttribute(file.toPath(), "creationTime", FileTime.fromMillis(time), new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LoggerPrintStream
    extends PrintStream {
        LoggerPrintStream(FileOutputStream writer) {
            super(writer, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(String message) {
            ContainerLogger containerLogger = ContainerLogger.this;
            synchronized (containerLogger) {
                block10: {
                    super.println(message);
                    try {
                        ContainerLogger.this.checkSizeLimit();
                    }
                    catch (ClosedChannelException exception) {
                        try {
                            ContainerLogger.this.openWriter(true);
                            super.println("Trace log file reopened.");
                        }
                        catch (Exception exception1) {
                            exception1.printStackTrace(System.err);
                            if (ContainerLogger.this.isSystemOutputRedirected) {
                                super.println("ERROR: Reopening trace log file failed.");
                                break block10;
                            }
                            System.err.println("ERROR: Reopening trace log file failed.");
                        }
                    }
                    catch (IOException exception) {
                        exception.printStackTrace(System.err);
                        if (ContainerLogger.this.isSystemOutputRedirected) {
                            super.println("ERROR: Checking log size in ContainerLogger failed.");
                        }
                        System.err.println("ERROR: Checking log size in ContainerLogger failed.");
                    }
                }
            }
        }
    }
}

