/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.container;

import com.streamscape.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ContainerLockSupport {
    public static final String RESTART_REQUIRED = "RESTART REQUIRED";

    public static CurrentNodeLock getCurrentNodeLock() {
        return CurrentNodeLockHolder.currentNodeLock;
    }

    public static RemoteNodeLock getRemoteNodeLock(String remoteNodeStartupDir) {
        return new RemoteNodeLock(remoteNodeStartupDir);
    }

    private static class CurrentNodeLockHolder {
        private static CurrentNodeLock currentNodeLock = new CurrentNodeLock();

        private CurrentNodeLockHolder() {
        }
    }

    public static class CurrentNodeLock
    extends AbstractNodeLock {
        private RandomAccessFile file;
        private FileChannel channel;
        private FileLock lock;

        CurrentNodeLock() {
            super(".");
        }

        public boolean isInitialized() {
            return this.file != null;
        }

        public synchronized void lock() throws IOException {
            if (this.file == null) {
                try {
                    if (!Files.isDirectory(this.lockFilePath.getParent(), new LinkOption[0])) {
                        throw new IOException("Directory '" + String.valueOf(this.lockFilePath) + "' does not exist. Lock file locking failed.");
                    }
                    this.file = new RandomAccessFile(this.lockFilePath.toFile(), "rw");
                    this.channel = this.file.getChannel();
                }
                catch (IOException exception) {
                    this.file = null;
                    this.channel = null;
                    throw exception;
                }
            }
            try {
                this.lock = this.channel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
        }

        public synchronized void writePidToLockFile() {
            try {
                String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                this.writeToLockFile(jvmName.substring(0, jvmName.indexOf(64)).getBytes());
            }
            catch (Exception exception) {
                Trace.logError(this, "Obtaining JVM process id failed.");
            }
        }

        public synchronized void writeToLockFile(byte[] data) {
            try {
                this.lock();
                this.file.setLength(0L);
                this.file.write(data);
                this.file.getFD().sync();
            }
            catch (IOException exception) {
                Trace.logError(this, "Writing to lock file failed. Cause: " + exception.getMessage());
            }
        }

        public synchronized void writeRestartRequired() {
            this.writeToLockFile(ContainerLockSupport.RESTART_REQUIRED.getBytes());
        }

        public synchronized void unlock() throws IOException {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.file = null;
        }

        @Override
        protected synchronized boolean isLocked(boolean isByAnotherVM) throws IOException {
            if (this.lock != null) {
                return !isByAnotherVM;
            }
            return super.isLocked(isByAnotherVM);
        }

        @Override
        public synchronized void removeLockFile() {
            this.removeLockFileInternal(false);
        }

        public synchronized void removeLockFileIfNoRestartRequired() {
            this.removeLockFileInternal(true);
        }

        private void removeLockFileInternal(boolean ifNoRestartRequired) {
            try {
                this.unlock();
            }
            catch (IOException exception) {
                Trace.logError(this, "Releasing lock file failed.");
            }
            if (!ifNoRestartRequired || !this.isLockFileRestartRequired()) {
                super.removeLockFile();
            }
        }

        public void writeToLockFailFile(String error) {
            try (BufferedWriter writer = Files.newBufferedWriter(this.lockFailFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(error, 0, error.length());
            }
            catch (IOException exception) {
                Trace.logError(this, "Writing lock file failed. Cause: " + exception.getMessage());
            }
        }
    }

    public static class RemoteNodeLock
    extends AbstractNodeLock {
        RemoteNodeLock(String remoteNodeStartupDir) {
            super(remoteNodeStartupDir);
        }
    }

    static class AbstractNodeLock {
        protected Path lockFilePath;
        protected Path lockFailFilePath;

        AbstractNodeLock(String dir) {
            this.setUpDir(dir);
        }

        public void setUpDir(String dir) {
            this.lockFilePath = FileSystems.getDefault().getPath(dir, ".tfcache", AbstractNodeLock.getLockFileName());
            this.lockFailFilePath = FileSystems.getDefault().getPath(dir, ".tfcache", AbstractNodeLock.getLockFailFileName());
        }

        public static String getLockFileName() {
            return "lock";
        }

        public static String getLockFailFileName() {
            return "lock.fail";
        }

        public boolean existsLockFileDirectory() {
            return Files.isDirectory(this.lockFilePath.getParent(), new LinkOption[0]);
        }

        public boolean existsLockFile() {
            return Files.exists(this.lockFilePath, new LinkOption[0]);
        }

        public boolean existsLockFailFile() {
            return Files.exists(this.lockFailFilePath, new LinkOption[0]);
        }

        public boolean isLockedByAnotherVM() throws IOException {
            return this.isLocked(true);
        }

        public boolean isLocked() throws IOException {
            return this.isLocked(false);
        }

        /*
         * Loose catch block
         * Enabled aggressive exception aggregation
         */
        protected synchronized boolean isLocked(boolean isByAnotherVM) throws IOException {
            if (!this.existsLockFile()) {
                return false;
            }
            try (RandomAccessFile file = new RandomAccessFile(this.lockFilePath.toFile(), "rw");){
                boolean bl;
                FileLock lock;
                FileChannel channel;
                block25: {
                    block24: {
                        channel = file.getChannel();
                        lock = channel.tryLock();
                        boolean bl2 = bl = lock == null;
                        if (lock == null) break block24;
                        lock.close();
                    }
                    if (channel == null) break block25;
                    channel.close();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (lock != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (OverlappingFileLockException exception) {
                                boolean bl3;
                                boolean bl4 = bl3 = !isByAnotherVM;
                                if (channel != null) {
                                    channel.close();
                                }
                                file.close();
                                return bl3;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            catch (FileNotFoundException exception) {
                return false;
            }
        }

        public void removeLockFile() {
            try {
                if (!this.isLockedByAnotherVM()) {
                    Files.deleteIfExists(this.lockFilePath);
                }
            }
            catch (IOException exception) {
                Trace.logError(this, "Removing lock file '" + String.valueOf(this.lockFilePath) + "' failed.");
            }
        }

        public void removeLockFailFile() {
            try {
                Files.deleteIfExists(this.lockFailFilePath);
            }
            catch (IOException exception) {
                Trace.logError(this, "Removing lock file '" + String.valueOf(this.lockFailFilePath) + "' failed.");
            }
        }

        public String getLockFailFileError() {
            return this.getContent(this.lockFailFilePath);
        }

        public String getLockFileContent() {
            return this.getContent(this.lockFilePath);
        }

        public boolean isLockFileRestartRequired() {
            String content = this.getLockFileContent();
            return content != null && content.equals(ContainerLockSupport.RESTART_REQUIRED);
        }

        private String getContent(Path path) {
            StringBuilder builder = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(1024);
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                while (reader.read(buffer) != -1) {
                    buffer.flip();
                    for (int i = 0; i < buffer.length(); ++i) {
                        builder.append(buffer.get(i));
                    }
                    buffer.clear();
                }
            }
            catch (IOException exception) {
                Trace.logError(this, "Reading lock file failed. Cause: " + exception.getMessage());
            }
            return builder.toString();
        }
    }
}

