/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.container;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.lib.concurrent.worker.SingleTaskDaemonWorker;
import com.streamscape.lib.utils.Banner;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.ShutdownListener;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.ContainerFactory;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.container.ContainerLoggerParameters;
import com.streamscape.sef.container.FabricContainer;
import com.streamscape.sef.dispatcher.AbstractContainer;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.sef.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class Container
extends AbstractContainer
implements FabricContainer {
    public static final String NO_JOIN_PARAMETER = "-no-join";
    protected static ContainerFactory containerFactory;
    protected ContainerLoggerParameters loggerParameters = new ContainerLoggerParameters();
    protected transient ContainerLauncher launcher;
    protected transient StdinShutdownInitiator shutdownInitiator;
    protected transient boolean isInitialized = false;
    protected transient boolean isUpdated = false;
    protected transient boolean isStarted = false;

    public static void main(String[] args) {
        new ContainerLauncher().launch(args);
    }

    protected Container() {
        this.logInfo("Container created.");
    }

    public synchronized void relaunch() {
        if (!this.isInitialized && this.launcher != null) {
            this.launcher.run();
        }
    }

    public void init() throws FabricException {
        this.init(null);
    }

    protected void init(ContainerLauncher launcher) throws FabricException {
        if (!this.isInitialized) {
            this.launcher = launcher;
            this.doInit();
            if (this.isUpdated) {
                this.onUpdate();
            }
            this.isInitialized = true;
        }
    }

    protected void doInit() throws FabricException {
        if (this.loggerParameters == null) {
            this.loggerParameters = new ContainerLoggerParameters();
            this.isUpdated = true;
        }
        this.loggerParameters.init(this);
        Logger logger = TraceConfigurator.getInstance().getLogger();
        if (logger instanceof ContainerLogger) {
            ((ContainerLogger)logger).setParameters(this.loggerParameters);
        }
        Container.getContext().setShutdownListener(new ContainerShutdownListener());
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
    }

    private void initShutdownInitiator() {
        this.shutdownInitiator = this.createShutdownInitiator();
        Trace.logInfo(this, "Stdin Shutdown Initiator enabled.");
    }

    protected StdinShutdownInitiator createShutdownInitiator() {
        return new StdinShutdownInitiator();
    }

    @Override
    public void printBanner(PrintStream stream) {
        if (this.launcher != null) {
            this.launcher.printBanner(stream);
        }
    }

    public void start() {
        if (!this.isStarted) {
            this.logDebug("Container starting...");
            this.doStart();
            this.isStarted = true;
            this.logInfo("Container started.");
        }
    }

    protected void doStart() {
        if (this.shutdownInitiator != null) {
            this.shutdownInitiator.start();
        }
    }

    public void stop() {
        if (this.isStarted) {
            this.logDebug("Container stopping...");
            this.doStop();
            this.isStarted = false;
            this.logInfo("Container stopped.");
        }
    }

    protected void doStop() {
    }

    public void destroy() {
        if (this.isInitialized) {
            this.logDebug("Container destroying...");
            this.doDestroy();
            if (containerFactory != null) {
                containerFactory.destroy();
            }
            this.isInitialized = false;
            this.logInfo("Container destroyed.");
        }
    }

    protected void doDestroy() {
    }

    protected void onContextUnload() {
    }

    @Override
    public ContainerLoggerParameters getLoggerParameters() {
        return this.loggerParameters;
    }

    public static void doShutdown(Class cls, String command) {
        Trace.logInfo(cls, "Command '" + command + "' received. Shutdown initiated...");
        System.exit(0);
    }

    public static String getDefaultLogFilename(String nodeName) {
        return nodeName + ".log";
    }

    protected void logError(String message) {
        Trace.logError(Container.class, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(Container.class, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(Container.class, message);
    }

    protected void logException(Throwable exception) {
        Trace.logException(Container.class, exception, true);
    }

    public static class ContainerLauncher {
        protected LaunchMode launchMode;
        protected String deploymentDir;
        protected CtxDeploymentDescriptor deploymentDescriptor;
        protected String traceConfigFilename;
        protected String logFilename;
        protected boolean logEnabled = false;
        protected boolean logRedirectSystemOutput = true;
        protected boolean logBroadcast = false;
        protected boolean initShutdownInitiator = false;

        public void launch() {
            this.launch(null, null);
        }

        public void launch(String traceConfigFilename, String logFilename) {
            this.traceConfigFilename = traceConfigFilename;
            if (logFilename != null) {
                this.logFilename = logFilename;
                this.logEnabled = true;
                this.logRedirectSystemOutput = false;
            }
            this.checkLockFile();
            try {
                this.initTracesAndPrintBanner();
                this.initRuntime(LaunchMode.START);
                this.initContainer().start();
            }
            catch (Throwable exception) {
                exception.printStackTrace();
                System.err.println("Container exiting...");
                System.exit(1);
            }
        }

        public void launch(String[] args) {
            this.parseArgs(args);
            if (this.launchMode != LaunchMode.HELP && this.launchMode != LaunchMode.VERSION) {
                this.checkLockFile();
            }
            this.run();
        }

        protected void checkLockFile() {
            try {
                ContainerLockSupport.CurrentNodeLock lock = ContainerLockSupport.getCurrentNodeLock();
                lock.setUpDir(RuntimeContext.getStartupDir(this.getDeploymentDescriptor()));
                if (lock.existsLockFileDirectory()) {
                    if (lock.isLockedByAnotherVM()) {
                        this.exit("Lock file is locked by another application.");
                    }
                    lock.removeLockFile();
                    lock.removeLockFailFile();
                    if (lock.existsLockFile()) {
                        this.exit("Lock file is locked by another application.");
                    }
                    lock.lock();
                    lock.writePidToLockFile();
                }
            }
            catch (Exception exception) {
                this.exit("Acquiring lock file failed. Cause: " + exception.getMessage());
            }
        }

        protected void parseArgs(String[] args) {
            if (args.length == 0) {
                this.exit();
            }
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].toLowerCase();
                if (arg.equals("-h") || arg.equals("-help")) {
                    this.checkLaunchMode();
                    this.launchMode = LaunchMode.HELP;
                    break;
                }
                if (arg.equals("-version")) {
                    this.checkLaunchMode();
                    this.launchMode = LaunchMode.VERSION;
                    break;
                }
                if (arg.equals("-init")) {
                    this.checkLaunchMode();
                    this.launchMode = LaunchMode.INIT;
                    continue;
                }
                if (arg.equals("-maintain")) {
                    this.checkLaunchMode();
                    this.launchMode = LaunchMode.MAINTAIN;
                    continue;
                }
                if (arg.equals("-start")) {
                    this.checkLaunchMode();
                    this.launchMode = LaunchMode.START;
                    continue;
                }
                if (arg.equals("-no-tlp")) {
                    RuntimeContext.setNoTlpMode(true);
                    continue;
                }
                if (arg.equals(Container.NO_JOIN_PARAMETER)) {
                    RuntimeContext.setNoJoinMode(true);
                    continue;
                }
                if (arg.equals("-admin")) {
                    if (++i >= args.length) {
                        this.exit("Parsing error: value of '-admin' parameter missed.");
                    }
                    RuntimeContext.setAdminMode(true, args[i]);
                    continue;
                }
                if (arg.equals("-ddx")) {
                    if (this.deploymentDir != null) {
                        this.exit("Parsing error: several '-ddx' parameters specified.");
                    }
                    if (++i >= args.length) {
                        this.exit("Parsing error: value of '-ddx' parameter missed.");
                    }
                    this.deploymentDir = args[i];
                    continue;
                }
                if (arg.equals("-log")) {
                    if (this.logEnabled) {
                        this.exit("Parsing error: several '-log' parameters specified.");
                    }
                    if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                        this.logFilename = args[++i];
                    }
                    this.logEnabled = true;
                    continue;
                }
                if (arg.equals("-log-broadcast")) {
                    if (this.logBroadcast) {
                        this.exit("Parsing error: several 'log-broadcast' parameters specified.");
                    }
                    this.logBroadcast = true;
                    continue;
                }
                if (arg.equals("-c") || arg.equals("-console")) {
                    if (this.initShutdownInitiator) {
                        this.exit("Parsing error: several '-c' or '-console' parameters specified.");
                    }
                    this.initShutdownInitiator = true;
                    continue;
                }
                i = this.parseOtherArg(arg, args, i);
            }
            this.checkArgs();
        }

        protected int parseOtherArg(String arg, String[] args, int index) {
            this.exit("Parsing error: unknown parameter '" + args[index] + "'.");
            return index;
        }

        protected void checkArgs() {
            if (this.launchMode == null) {
                this.launchMode = LaunchMode.HELP;
            }
            if ((this.launchMode == LaunchMode.INIT || this.launchMode == LaunchMode.START) && this.deploymentDir == null) {
                this.exit("Error: Mandatory parameter '-ddx' missed.");
            }
        }

        protected void checkLaunchMode() {
            if (this.launchMode != null) {
                this.exit("Parsing error: only one of the parameters '-h[elp]', '-version', '-init', '-maintain' or '-start' must be specified.");
            }
        }

        protected void run() {
            try {
                switch (this.launchMode.ordinal()) {
                    case 0: {
                        this.printUsage();
                        break;
                    }
                    case 1: {
                        this.printBanner();
                        break;
                    }
                    case 2: {
                        this.initTracesAndPrintBanner();
                        this.initRuntime(LaunchMode.INIT);
                        this.getContainerFactory().create();
                        System.exit(0);
                    }
                    case 3: {
                        this.initTracesAndPrintBanner();
                        this.initRuntime(LaunchMode.MAINTAIN);
                        Container container = this.initContainer();
                        if (this.initShutdownInitiator) {
                            container.initShutdownInitiator();
                        }
                        container.start();
                        break;
                    }
                    case 4: {
                        this.initTracesAndPrintBanner();
                        this.initRuntime(LaunchMode.START);
                        Container container = this.initContainer();
                        if (this.initShutdownInitiator) {
                            container.initShutdownInitiator();
                        }
                        container.start();
                        break;
                    }
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
                System.err.println("Container exiting...");
                System.exit(1);
            }
        }

        protected Container initContainer() throws FabricException {
            containerFactory = this.getContainerFactory();
            Container container = (Container)containerFactory.create();
            container.init(this);
            return container;
        }

        protected ContainerFactory getContainerFactory() {
            return new ContainerFactory(RuntimeContext.getInstance());
        }

        protected void printUsage() {
            this.printDescription(System.out);
            System.out.println("\n    " + Version.getVersionString() + "\n    Copyright (c) 2015-2025 StreamScape Technologies\n");
            this.printParametersList();
            this.printParametersDescription();
        }

        protected void initTracesAndPrintBanner() throws Exception {
            this.printBanner();
            this.initTraces();
            this.printBannerInLog();
        }

        protected void printBannerInLog() {
            if (this.logEnabled) {
                this.printBanner();
            }
        }

        protected void printBanner() {
            this.printBanner(System.out);
        }

        public void printBanner(PrintStream stream) {
            this.printDescription(stream);
            Banner.printBanner(stream);
        }

        protected void printDescription(PrintStream stream) {
            stream.println("\n    TruFabric Task Node");
        }

        protected void printParametersList() {
            System.out.println("    Usage: " + this.getExecutableName() + " -version | -init | -maintain | -start\n\n                 -ddx <location_of_deployment_descriptor>\n               [ -dir <working_directory> ]\n" + this.getJavaParametersHelp() + "               [ -java-home <java_home_directory> ]\n               [ -log [<log_filename>] ]\n               [ -log-broadcast]\n               [ -no-tlp ]\n               [ -c | -console ]\n               [ -admin <URL> ]\n               [ -debug ]\n               [ -h | -help ]");
        }

        protected String getJavaParametersHelp() {
            return "               [ -java-cfg <jvm_options_filename> ]\n               [ -java-args \"<jvm_options>\" ]\n";
        }

        protected void printParametersDescription() {
            System.out.println("\n    -version       Displays version information.\n");
            System.out.println("    -init          Initializes the node persistence cache.\n");
            System.out.println("    -maintain      Starts the node without a start-up of HTTP and XMPP Acceptors, Discovery Module, Services.\n");
            System.out.println("    -start         Starts the node.\n");
            System.out.println("    -ddx           Location of the deployment descriptor archive (i.e. stdeploy.jar).\n                   Values containing spaces must be quoted.\n");
            System.out.println("    -dir           Working directory of the node.\n                   Default is the current directory. Values containing spaces must be quoted.\n                   This parameter is only supported when used with a platform-specific launcher.\n");
            this.printJavaParametersDescription();
            System.out.println("    -java-home     Path to Java Home directory (e.g. \"C:/Program Files/Java/jre8\").\n                   If this parameter is not specified, $STROOT/platform/jre is checked at first.\n                   If it is absent then a standard Java installation will be searched.\n                   $JAVA_HOME is used first and then the registry is used on the Windows platform.\n                   This parameter is only supported when used with a platform-specific launcher.\n                   Values containing spaces must be quoted.\n");
            System.out.println("    -log           Allows the node to write trace messages to a specified log file.\n                   Default is <NodeName>.log. Values containing spaces must be quoted.\n");
            System.out.println("    -log-broadcast Allows the node to broadcast trace messages as events (with event id [event.log.Trace]).\n");
            System.out.println("    -no-tlp        Starts the node without starting TLP acceptors.\n");
            System.out.println("    -c             Starts the node in console mode, allowing for 'shutdown' command to be typed into\n    -console       the standard input stream. This will shut down the node in an orderly fashion.\n");
            System.out.println("    -admin         Initializes and starts a special HTTP acceptor that can be used for administrative purposes.\n                   URL must have the following format: [$hostname:[(<NetworkInterface>):]]<Port>.\n                   Examples: 9999, $hostname:9999, $hostname:(eth0):9999, $hostname:(1):9999.\n");
            System.out.println("    -debug         Prints launcher debug information to a debug.log file.\n");
            System.out.println("    -h             Displays help information.\n    -help");
        }

        protected void printJavaParametersDescription() {
            System.out.println("    -java-cfg      Path to the file containing JVM options.\n                   Default is " + this.getExecutableName() + ".conf. Values containing spaces must be quoted.\n                   This parameter is only supported when used with a platform-specific launcher.\n");
            System.out.println("    -java-args     List of JVM options (e.g. \"-Xmx256m\"). Options must be quoted.\n                   This parameter is only supported when used with a platform-specific launcher.\n");
        }

        protected String getExecutableName() {
            return "tnode";
        }

        protected void initTraces() throws Exception {
            this.getDeploymentDescriptor();
            Object startupDir = "";
            try {
                startupDir = RuntimeContext.getStartupDir(this.deploymentDescriptor) + "/";
            }
            catch (IOException exception) {
                System.err.println("Invalid startup directory '" + exception.getMessage() + ". Current directory will be used for Traces.\n");
            }
            if (this.logEnabled) {
                if (this.logFilename == null) {
                    this.logFilename = this.getLogFilename();
                }
                TraceConfigurator.getInstance().enableLog((String)(new File(this.logFilename).isAbsolute() ? this.logFilename : (String)startupDir + this.logFilename));
            }
            if (this.traceConfigFilename == null) {
                this.traceConfigFilename = this.getTraceFilename();
            }
            TraceConfigurator.getInstance().init(this.logRedirectSystemOutput, (String)startupDir + this.traceConfigFilename);
        }

        protected String getTraceFilename() {
            return "tnode.traces";
        }

        protected String getLogFilename() {
            return Container.getDefaultLogFilename(this.deploymentDescriptor.getContextName());
        }

        protected CtxDeploymentDescriptor getDeploymentDescriptor() throws Exception {
            return this.deploymentDescriptor != null ? this.deploymentDescriptor : this.readDeploymentDescriptor();
        }

        private CtxDeploymentDescriptor readDeploymentDescriptor() throws Exception {
            if (this.deploymentDir == null) {
                this.deploymentDir = System.getProperty("streamscape.runtime.deployment.dir");
            }
            this.deploymentDescriptor = DeployUtils.getDeploymentDescriptor(this.deploymentDir + "/stdeploy.jar", XSerializerFactory.getInstance().getDefaultSerializer());
            XSerializerFactory.getInstance().destroy();
            return this.deploymentDescriptor;
        }

        protected void initRuntime(LaunchMode launchMode) {
            System.setProperty("streamscape.runtime.deployment.dir", this.deploymentDir);
            if (launchMode == LaunchMode.INIT) {
                RuntimeContext.setInitMode(true);
            } else if (launchMode == LaunchMode.MAINTAIN) {
                RuntimeContext.setMaintainMode(true);
            }
            RuntimeContext.setPrintBanner(false);
            this.initRuntimeInstance();
            if (this.logBroadcast) {
                TraceConfigurator.getInstance().setBroadcastAll(true);
            }
        }

        protected void initRuntimeInstance() {
            RuntimeContext.getInstance();
        }

        protected void exit(String message) {
            System.err.println(message);
            try {
                if (!ContainerLockSupport.getCurrentNodeLock().isLockedByAnotherVM()) {
                    ContainerLockSupport.getCurrentNodeLock().writeToLockFailFile(message);
                    ContainerLockSupport.getCurrentNodeLock().removeLockFileIfNoRestartRequired();
                }
            }
            catch (IOException exception) {
                System.err.println("Checking lock file failed.");
            }
            this.exit();
        }

        protected void exit() {
            ContainerLockSupport.getCurrentNodeLock().removeLockFile();
            this.printUsage();
            System.exit(1);
        }

        protected static enum LaunchMode {
            HELP,
            VERSION,
            INIT,
            MAINTAIN,
            START;

        }
    }

    protected class ContainerShutdownListener
    implements ShutdownListener {
        protected ContainerShutdownListener() {
            Container.this.logDebug("Container Shutdown Listener enabled.");
        }

        @Override
        public void onShutdown() {
            Container.this.logInfo("Container Shutdown initiated...");
            Container.this.stop();
            Container.this.destroy();
            AbstractRuntimeFactory.getContext().unload();
            Container.this.onContextUnload();
            ContainerLockSupport.getCurrentNodeLock().removeLockFileIfNoRestartRequired();
            Utils.sleep(100L);
            System.out.println();
            Container.this.logInfo("Container shut down.");
        }
    }

    public static class StdinShutdownInitiator
    extends SingleTaskDaemonWorker {
        protected StdinShutdownInitiator() {
            super("FSYS:ShutdownInitiator.Stdin", "Initiates shutdown of the node (after receiving of 'shutdown' command).");
        }

        @Override
        protected void doExecute() throws FabricException {
            while (this.canWork()) {
                try {
                    int available = System.in.available();
                    if (available == 0) {
                        Utils.sleep(500L);
                        continue;
                    }
                    byte[] buffer = new byte[32];
                    System.in.read(buffer);
                    String command = new String(buffer).trim().toLowerCase();
                    if (command.equals("shutdown")) {
                        this.doShutdown(command);
                        continue;
                    }
                    this.processOtherCommand(command);
                }
                catch (IOException exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Waiting of 'shutdown' command interrupted.");
                    break;
                }
            }
        }

        protected void doShutdown(String command) {
            Container.doShutdown(StdinShutdownInitiator.class, command);
        }

        protected void processOtherCommand(String command) {
        }
    }
}

