/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.coherence;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.coherence.CoherenceAgent;
import com.streamscape.sef.dispatcher.AbstractExclusionList;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ReplicationRules
extends CloneableDataObject {
    private transient CoherenceAgent coherenceAgent;
    private ExclusionList exclusionList = new ExclusionList();
    private static final Method ADD_OBJECT_METHOD;
    private static final Method REMOVE_OBJECT_METHOD;

    void init(CoherenceAgent coherenceAgent) {
        this.coherenceAgent = coherenceAgent;
        if (this.exclusionList == null) {
            this.exclusionList = new ExclusionList();
        }
        this.exclusionList.init();
        this.exclusionList.replicationRules = this;
    }

    public ExclusionList getExclusionList() {
        return this.exclusionList;
    }

    protected void setExclusionList(ExclusionList exclusionList) {
        this.exclusionList = exclusionList;
        this.exclusionList.replicationRules = this;
        this.coherenceAgent.updateInRepository();
    }

    static {
        try {
            ADD_OBJECT_METHOD = AbstractExclusionList.class.getDeclaredMethod("doAddObject", Set.class, String.class);
            ADD_OBJECT_METHOD.setAccessible(true);
            REMOVE_OBJECT_METHOD = AbstractExclusionList.class.getDeclaredMethod("doRemoveObject", Set.class, String.class);
            REMOVE_OBJECT_METHOD.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of ReplicationRules failed.");
        }
    }

    public static class ExclusionList
    extends AbstractExclusionList {
        private transient ReplicationRules replicationRules;

        public void addExtensionArchive(String jarName) {
            this.addObject(this.extensionArchives, jarName);
        }

        public void removeExtensionArchive(String jarName) {
            this.removeObject(this.extensionArchives, jarName);
        }

        public boolean containsExtensionArchive(String jarName) {
            return this.extensionArchives.contains(jarName);
        }

        public synchronized Set<String> getExtensionArchives() {
            return new HashSet<String>(this.extensionArchives);
        }

        public void addPackage(String pkgName) {
            this.addObject(this.packages, pkgName);
        }

        public void removePackage(String pkgName) {
            this.removeObject(this.packages, pkgName);
        }

        public boolean containsPackage(String pkgName) {
            return this.packages.contains(pkgName);
        }

        public synchronized Set<String> getPackages() {
            return new HashSet<String>(this.packages);
        }

        public void addSemanticType(String typeName) {
            this.addObject(this.semanticTypes, typeName);
        }

        public void removeSemanticType(String typeName) {
            this.removeObject(this.semanticTypes, typeName);
        }

        public boolean containsSemanticType(String typeName) {
            return this.semanticTypes.contains(typeName);
        }

        public synchronized Set<String> getSemanticTypes() {
            return new HashSet<String>(this.semanticTypes);
        }

        public void addEventPrototype(String eventId) {
            this.addObject(this.eventPrototypes, eventId);
        }

        public void removeEventPrototype(String eventId) {
            this.removeObject(this.eventPrototypes, eventId);
        }

        public boolean containsEventPrototype(String eventId) {
            return this.eventPrototypes.contains(eventId);
        }

        public synchronized Set<String> getEventPrototypes() {
            return new HashSet<String>(this.eventPrototypes);
        }

        public void merge(ExclusionList other) {
            other.extensionArchives.forEach(this::addExtensionArchive);
            other.packages.forEach(this::addPackage);
            other.semanticTypes.forEach(this::addSemanticType);
            other.packages.forEach(this::addEventPrototype);
        }

        private void addObject(Set<String> objects, String objectName) {
            this.doAddObject(objects, objectName);
        }

        private void removeObject(Set<String> objects, String objectName) {
            this.doRemoveObject(objects, objectName);
        }

        @Override
        protected void init() {
            super.init();
        }
    }
}

