/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.vcard;

import com.streamscape.sdo.vcard.Address;
import com.streamscape.sdo.vcard.AddressType;
import com.streamscape.sdo.vcard.EMail;
import com.streamscape.sdo.vcard.Name;
import com.streamscape.sdo.vcard.Org;
import com.streamscape.sdo.vcard.Phone;
import com.streamscape.sdo.vcard.PhoneType;
import com.streamscape.sdo.vcard.PhoneUse;
import com.streamscape.sdo.vcard.Photo;
import com.streamscape.sdo.vcard.Updatable;
import java.util.ListIterator;
import java.util.Vector;

public class vCard {
    private String xmlns = "vcard-temp";
    private String FN = "";
    private Name N = new Name();
    private String NICKNAME = "";
    private String URL = "";
    private String BDAY = null;
    private Org ORG = new Org();
    private String TITLE = "";
    private String ROLE = null;
    private Vector<Phone> HomePhoneList = new Vector();
    private Vector<Address> HomeAddress = new Vector();
    private Vector<Phone> WorkPhoneList = new Vector();
    private Vector<Address> WorkAddress = new Vector();
    private Vector<EMail> HomeEmail = null;
    private Vector<EMail> WorkEmail = null;
    private String JABBERID = "";
    private String DESC = null;
    private String AGE = null;
    private String GENDER = null;
    private String MARITALSTATUS = null;
    private String LOCATION = null;
    private String WORKCELL = null;
    private String HOMECELL = null;
    private Photo PHOTO = new Photo();

    public vCard() {
        PhoneUse[] uses;
        for (PhoneUse use : uses = new PhoneUse[]{PhoneUse.VOICE, PhoneUse.FAX, PhoneUse.MSG, PhoneUse.PAGER, PhoneUse.CELL}) {
            this.WorkPhoneList.add(new Phone(PhoneType.WORK, use));
            this.HomePhoneList.add(new Phone(PhoneType.HOME, use));
        }
        this.WorkAddress.add(new Address(AddressType.WORK));
        this.HomeAddress.add(new Address(AddressType.HOME));
    }

    public void update(vCard other) {
        if (other != null) {
            this.FN = vCard.update(this.FN, other.FN);
            this.N = vCard.update(this.N, other.N);
            this.NICKNAME = vCard.update(this.NICKNAME, other.NICKNAME);
            this.URL = vCard.update(this.URL, other.URL);
            this.BDAY = vCard.update(this.BDAY, other.BDAY);
            this.ORG = vCard.update(this.ORG, other.ORG);
            this.TITLE = vCard.update(this.TITLE, other.TITLE);
            this.ROLE = vCard.update(this.ROLE, other.ROLE);
            this.HomePhoneList = vCard.update(this.HomePhoneList, other.HomePhoneList);
            this.HomeAddress = vCard.update(this.HomeAddress, other.HomeAddress);
            this.WorkPhoneList = vCard.update(this.WorkPhoneList, other.WorkPhoneList);
            this.WorkAddress = vCard.update(this.WorkAddress, other.WorkAddress);
            this.HomeEmail = vCard.update(this.HomeEmail, other.HomeEmail);
            this.WorkEmail = vCard.update(this.WorkEmail, other.WorkEmail);
            this.JABBERID = vCard.update(this.JABBERID, other.JABBERID);
            this.DESC = vCard.update(this.DESC, other.DESC);
            this.AGE = vCard.update(this.AGE, other.AGE);
            this.GENDER = vCard.update(this.GENDER, other.GENDER);
            this.MARITALSTATUS = vCard.update(this.MARITALSTATUS, other.MARITALSTATUS);
            this.LOCATION = vCard.update(this.LOCATION, other.LOCATION);
            this.WORKCELL = vCard.update(this.WORKCELL, other.WORKCELL);
            this.HOMECELL = vCard.update(this.HOMECELL, other.HOMECELL);
            this.PHOTO = vCard.update(this.PHOTO, other.PHOTO);
        }
    }

    static String update(String destination, String source) {
        return source != null ? source : destination;
    }

    static <T extends Updatable<T>> T update(T destination, T source) {
        if (destination == null) {
            return source;
        }
        destination.update(source);
        return destination;
    }

    static <T extends Updatable<T>> Vector<T> update(Vector<T> destination, Vector<T> source) {
        if (destination == null) {
            return source;
        }
        if (source != null) {
            for (int i = 0; i < source.size(); ++i) {
                if (destination.size() <= i) {
                    destination.add((Updatable)source.get(i));
                    continue;
                }
                ((Updatable)destination.get(i)).update((Updatable)source.get(i));
            }
        }
        return destination;
    }

    public void setFullName(String fullName) {
        this.FN = fullName;
    }

    public String getFullName() {
        return this.FN;
    }

    public Name getName() {
        return this.N;
    }

    public void setNickName(String nickName) {
        this.NICKNAME = nickName;
    }

    public String getNickName() {
        return this.NICKNAME;
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public String getURL() {
        return this.URL;
    }

    public void setBirthday(String birthday) {
        if (birthday != null && birthday.length() != 0) {
            this.BDAY = birthday;
        }
    }

    public void setAge(String age) {
        if (age != null && age.length() != 0) {
            this.AGE = age;
        }
    }

    public void setGender(String gender) {
        if (gender != null && gender.length() != 0) {
            this.GENDER = gender;
        }
    }

    public void setMaritalStatus(String status) {
        if (status != null && status.length() != 0) {
            this.MARITALSTATUS = status;
        }
    }

    public void setLocation(String location) {
        if (location != null && location.length() != 0) {
            this.LOCATION = location;
        }
    }

    public void setWorkCell(String workCell) {
        if (workCell != null && workCell.length() != 0) {
            this.WORKCELL = workCell;
        }
    }

    public void setHomeCell(String homeCell) {
        if (homeCell != null && homeCell.length() != 0) {
            this.HOMECELL = homeCell;
        }
    }

    public String getBirthday() {
        return this.BDAY;
    }

    public String getAge() {
        return this.AGE;
    }

    public String getGender() {
        return this.GENDER;
    }

    public String getMaritalStatus() {
        return this.MARITALSTATUS;
    }

    public String getLocation() {
        return this.LOCATION;
    }

    public String getWorkCell() {
        return this.WORKCELL;
    }

    public String getHomeCell() {
        return this.HOMECELL;
    }

    public void setTitle(String title) {
        this.TITLE = title;
    }

    public String getTitle() {
        return this.TITLE;
    }

    public void setRole(String role) {
        if (role != null && role.length() != 0) {
            this.ROLE = role;
        }
    }

    public String getRole() {
        return this.ROLE;
    }

    public Org getOrganization() {
        return this.ORG;
    }

    public void updateOrganization(String unit) {
        if (this.ORG == null) {
            this.ORG = new Org();
        }
        this.ORG.setOrganizationUnit(unit);
    }

    public Phone getWorkPhone(PhoneUse use) {
        if (this.WorkPhoneList != null) {
            return this.WorkPhoneList.stream().filter(phone -> phone.getUse().equals((Object)use)).findFirst().orElse(null);
        }
        return null;
    }

    public Phone getHomePhone(PhoneUse use) {
        if (this.HomePhoneList != null) {
            return this.HomePhoneList.stream().filter(phone -> phone.getUse().equals((Object)use)).findFirst().orElse(null);
        }
        return null;
    }

    public Address getWorkAddress() {
        return this.WorkAddress != null && this.WorkAddress.size() > 0 ? this.WorkAddress.elementAt(0) : null;
    }

    public Address getHomeAddress() {
        return this.HomeAddress != null && this.HomeAddress.size() > 0 ? this.HomeAddress.elementAt(0) : null;
    }

    public EMail getWorkEMail() {
        return this.WorkEmail != null && this.WorkEmail.size() > 0 ? this.WorkEmail.elementAt(0) : null;
    }

    public EMail getHomeEMail() {
        return this.HomeEmail != null && this.HomeEmail.size() > 0 ? this.HomeEmail.elementAt(0) : null;
    }

    public void setHomeEMail(String email) {
        if (email == null || email.length() == 0) {
            return;
        }
        if (this.HomeEmail == null) {
            this.HomeEmail = new Vector();
        }
        if (this.HomeEmail.size() == 0) {
            this.HomeEmail.add(new EMail(true));
        }
        this.HomeEmail.firstElement().setUserId(email);
    }

    public void setWorkEMail(String email) {
        if (email == null || email.length() == 0) {
            return;
        }
        if (this.WorkEmail == null) {
            this.WorkEmail = new Vector();
        }
        if (this.WorkEmail.size() == 0) {
            this.WorkEmail.add(new EMail(false));
        }
        this.WorkEmail.firstElement().setUserId(email);
    }

    public void setJID(String jid) {
        this.JABBERID = jid;
    }

    public String getJID() {
        return this.JABBERID;
    }

    public void setDescription(String desc) {
        if (desc != null && desc.length() != 0) {
            this.DESC = desc;
        }
    }

    public String getDescription() {
        return this.DESC;
    }

    public Photo getPhoto() {
        return this.PHOTO;
    }

    public void setPhoto(Photo photo) {
        this.PHOTO = photo;
    }

    public boolean hasPhoto() {
        return this.PHOTO.hasPhoto();
    }

    private Object readResolve() {
        EMail email;
        Address address;
        Phone phone;
        if (this.WorkPhoneList == null) {
            this.WorkPhoneList = new Vector();
        }
        if (this.HomePhoneList == null) {
            this.HomePhoneList = new Vector();
        }
        if (this.WorkAddress == null) {
            this.WorkAddress = new Vector();
        }
        if (this.HomeAddress == null) {
            this.HomeAddress = new Vector();
        }
        if (this.HomeEmail == null) {
            this.HomeEmail = new Vector();
        }
        if (this.WorkEmail == null) {
            this.WorkEmail = new Vector();
        }
        ListIterator<Updatable<Phone>> iterator = this.WorkPhoneList.listIterator();
        while (iterator.hasNext()) {
            phone = iterator.next();
            if (!phone.getType().equals((Object)PhoneType.HOME)) continue;
            this.HomePhoneList.add(phone);
            iterator.remove();
        }
        iterator = this.HomePhoneList.listIterator();
        while (iterator.hasNext()) {
            phone = iterator.next();
            if (!phone.getType().equals((Object)PhoneType.WORK)) continue;
            this.WorkPhoneList.add(phone);
            iterator.remove();
        }
        iterator = this.WorkAddress.listIterator();
        while (iterator.hasNext()) {
            address = (Address)iterator.next();
            if (!address.getType().equals((Object)AddressType.HOME)) continue;
            this.HomeAddress.add(address);
            iterator.remove();
        }
        iterator = this.HomeAddress.listIterator();
        while (iterator.hasNext()) {
            address = (Address)iterator.next();
            if (!address.getType().equals((Object)AddressType.WORK)) continue;
            this.WorkAddress.add(address);
            iterator.remove();
        }
        iterator = this.WorkEmail.listIterator();
        while (iterator.hasNext()) {
            email = (EMail)iterator.next();
            if (!email.isHome()) continue;
            this.HomeEmail.add(email);
            iterator.remove();
        }
        iterator = this.HomeEmail.listIterator();
        while (iterator.hasNext()) {
            email = (EMail)iterator.next();
            if (email.isHome()) continue;
            this.WorkEmail.add(email);
            iterator.remove();
        }
        return this;
    }
}

