/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.vcard;

import com.streamscape.sdo.vcard.PhoneType;
import com.streamscape.sdo.vcard.PhoneUse;
import com.streamscape.sdo.vcard.Updatable;
import com.streamscape.sdo.vcard.vCard;

public class Phone
implements Updatable<Phone> {
    private String HOME = "";
    private String WORK = null;
    private String VOICE = "";
    private String FAX = null;
    private String MSG = null;
    private String PAGER = null;
    private String CELL = null;
    private String NUMBER = "";
    private transient PhoneType type = PhoneType.HOME;
    private transient PhoneUse use = PhoneUse.VOICE;

    public Phone() {
    }

    public Phone(PhoneType type, PhoneUse use) {
        this.setType(type);
        this.setUse(use);
    }

    @Override
    public void update(Phone other) {
        if (other != null) {
            this.HOME = other.HOME;
            this.WORK = other.WORK;
            this.VOICE = other.VOICE;
            this.FAX = other.FAX;
            this.MSG = other.MSG;
            this.PAGER = other.PAGER;
            this.CELL = other.CELL;
            this.NUMBER = vCard.update(this.NUMBER, other.NUMBER);
            this.readResolve();
        }
    }

    public void setType(PhoneType type) {
        this.type = type;
        if (type.equals((Object)PhoneType.HOME)) {
            this.HOME = "";
            this.WORK = null;
        } else if (type.equals((Object)PhoneType.WORK)) {
            this.HOME = null;
            this.WORK = "";
        }
    }

    public PhoneType getType() {
        return this.type;
    }

    public void setUse(PhoneUse use) {
        this.use = use;
        this.VOICE = null;
        this.FAX = null;
        this.MSG = null;
        this.PAGER = null;
        this.CELL = null;
        switch (use) {
            case VOICE: {
                this.VOICE = "";
                break;
            }
            case FAX: {
                this.FAX = "";
                break;
            }
            case MSG: {
                this.MSG = "";
                break;
            }
            case PAGER: {
                this.PAGER = "";
                break;
            }
            case CELL: {
                this.CELL = "";
            }
        }
    }

    public PhoneUse getUse() {
        return this.use;
    }

    public void setNumber(String number) {
        this.NUMBER = number;
    }

    public String getNumber() {
        return this.NUMBER;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + " " + String.valueOf((Object)this.use) + " Phone=" + this.NUMBER;
    }

    private Object readResolve() {
        int i;
        this.type = this.HOME != null ? PhoneType.HOME : PhoneType.WORK;
        String[] fields = new String[]{this.VOICE, this.FAX, this.MSG, this.PAGER, this.CELL};
        PhoneUse[] uses = new PhoneUse[]{PhoneUse.VOICE, PhoneUse.FAX, PhoneUse.MSG, PhoneUse.PAGER, PhoneUse.CELL};
        for (i = 0; i < uses.length && fields[i] == null; ++i) {
        }
        this.use = i < uses.length ? uses[i] : PhoneUse.VOICE;
        return this;
    }
}

