/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.vcard;

import com.streamscape.sdo.vcard.AddressType;
import com.streamscape.sdo.vcard.Updatable;
import com.streamscape.sdo.vcard.vCard;

public class Address
implements Updatable<Address> {
    private String HOME = "";
    private String WORK = null;
    private String EXTADR = null;
    private String EXTADD = null;
    private String STREET = "";
    private String LOCALITY = "";
    private String REGION = "";
    private String PCODE = "";
    private String CTRY = null;
    private String COUNTRY = null;
    private transient AddressType type = AddressType.HOME;

    public Address() {
    }

    public Address(AddressType type) {
        this.setType(type);
    }

    @Override
    public void update(Address other) {
        if (other != null) {
            this.HOME = other.HOME;
            this.WORK = other.WORK;
            this.EXTADR = vCard.update(this.EXTADR, other.EXTADR);
            this.EXTADD = vCard.update(this.EXTADD, other.EXTADD);
            this.STREET = vCard.update(this.STREET, other.STREET);
            this.LOCALITY = vCard.update(this.LOCALITY, other.LOCALITY);
            this.REGION = vCard.update(this.REGION, other.REGION);
            this.PCODE = vCard.update(this.PCODE, other.PCODE);
            this.CTRY = vCard.update(this.CTRY, other.CTRY);
            this.COUNTRY = vCard.update(this.COUNTRY, other.COUNTRY);
            this.readResolve();
        }
    }

    public void setType(AddressType type) {
        this.type = type;
        if (type.equals((Object)AddressType.HOME)) {
            this.HOME = "";
            this.WORK = null;
        } else {
            this.HOME = null;
            this.WORK = "";
        }
    }

    public AddressType getType() {
        return this.type;
    }

    public void setExtendedAddress(String address) {
        if (address != null && address.length() != 0) {
            this.EXTADD = address;
        }
    }

    public String getExtendedAddress() {
        return this.EXTADD != null ? this.EXTADD : this.EXTADR;
    }

    public void setStreet(String street) {
        this.STREET = street;
    }

    public String getStreet() {
        return this.STREET;
    }

    public void setLocality(String locality) {
        this.LOCALITY = locality;
    }

    public String getLocality() {
        return this.LOCALITY;
    }

    public void setRegion(String region) {
        this.REGION = region;
    }

    public String getRegion() {
        return this.REGION;
    }

    public void setPostalCode(String postalCode) {
        this.PCODE = postalCode;
    }

    public String getPostalCode() {
        return this.PCODE;
    }

    public void setCountry(String country) {
        if (country != null && country.length() != 0) {
            this.CTRY = country;
        }
    }

    public String getCountry() {
        return this.CTRY;
    }

    public void setCountry2(String country) {
        if (country != null && country.length() != 0) {
            this.COUNTRY = country;
        }
    }

    public String getCountry2() {
        return this.COUNTRY;
    }

    public String toString() {
        return this.type.name() + ":Address:Street=" + this.STREET + ", " + this.type.name() + ":Address:Extended=" + this.EXTADD + ", " + this.type.name() + ":Address:Locality=" + this.LOCALITY + ", " + this.type.name() + ":Address:Region=" + this.REGION + ", " + this.type.name() + ":Address:PostalCode=" + this.PCODE + ", " + this.type.name() + ":Address:Country=" + this.CTRY;
    }

    private Object readResolve() {
        this.type = this.HOME != null ? AddressType.HOME : AddressType.WORK;
        return this;
    }
}

