/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.validation;

import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sdo.validation.FieldValidationException;
import com.streamscape.sdo.validation.ValidationClasses;
import java.util.List;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static void validate(String fieldName, Object value, Class<?> clazz) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.SemanticTypeFieldValidator()).validate(fieldName, value, clazz);
    }

    public static void validate(String fieldName, Object value, Class<?> keyClass, Class<?> valueClass) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.SemanticTypeFieldValidator()).validate(fieldName, value, keyClass, valueClass);
    }

    public static void validateNotNull(String fieldName, Object value) throws Exception {
        new ValidationClasses.NotNullFieldValidator().validate(fieldName, value, new Object[0]);
    }

    public static void validateEnum(String fieldName, Object value, Class<?> clazz) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.InEnumFieldValidator()).validate(fieldName, value, clazz);
    }

    public static void validateInDomain(String fieldName, Object value, List domain) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.InDomainFieldValidator()).validate(fieldName, value, domain);
    }

    public static void validateInRange(String fieldName, Object value, List range) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.InRangeFieldValidator()).validate(fieldName, value, range);
    }

    public static void validateRegexp(String fieldName, Object value, Pattern regexp) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.RegexpFieldValidator()).validate(fieldName, value, regexp);
    }

    public static void validateInNamedDomain(String fieldName, Object value, String domainName) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.InNamedDomainFieldValidator()).validate(fieldName, value, domainName);
    }

    public static void validateInNamedRange(String fieldName, Object value, String rangeName) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.InNamedRangeFieldValidator()).validate(fieldName, value, rangeName);
    }

    public static void validatePrecisionAndScale(String fieldName, Object value, int precision, int scale) throws Exception {
        ValidationClasses.AbstractFieldValidator.createValidator(value, new ValidationClasses.PrecisionAndScaleValidator()).validate(fieldName, value, precision, scale);
    }

    public static void validateLength(String fieldName, String value, int length) throws Exception {
        if (value == null) {
            return;
        }
        if (value.length() > length) {
            throw new FieldValidationException(fieldName, value, "exceed maximum allowed length(" + length + ").");
        }
    }

    public static void validateLength(String fieldName, byte[] value, int length) throws Exception {
        if (value == null) {
            return;
        }
        if (value.length > length) {
            throw new FieldValidationException(fieldName, value, "exceed maximum allowed length(" + length + ").");
        }
    }

    public static void validateLength(String fieldName, byte[][] value, int length) throws Exception {
        if (value == null) {
            return;
        }
        if (value.length > length) {
            throw new FieldValidationException(fieldName, value, "exceed maximum allowed length(" + length + ").");
        }
    }

    public static void validateLength(String fieldName, List value, int length) throws Exception {
        if (value == null) {
            return;
        }
        if (value.size() > length) {
            throw new FieldValidationException(fieldName, "list size exceed maximum allowed size (" + length + ").");
        }
    }

    public static void validateLength(String fieldName, Object[] value, int length) throws Exception {
        if (value == null) {
            return;
        }
        if (value.length > length) {
            throw new FieldValidationException(fieldName, "array size exceed maximum allowed size (" + length + ").");
        }
    }

    public static ValidationException mergeExceptions(ValidationException validationException, Exception exception, String validatedClassFullName) {
        if (validationException == null) {
            validationException = new ValidationException(5076, "Validation of instance of class '" + validatedClassFullName + "' failed.");
        }
        ValidationUtils.addLeafErrors(validationException, exception);
        return validationException;
    }

    protected static void addLeafErrors(ValidationException objectException, Exception exception) {
        if (exception instanceof FieldValidationException) {
            FieldValidationException fieldException = (FieldValidationException)exception;
            if (fieldException.getFieldsExceptions().size() > 0) {
                for (Exception e : fieldException.getFieldsExceptions()) {
                    ValidationUtils.addLeafErrors(objectException, e);
                }
            } else {
                objectException.addError(fieldException.getFieldName(), fieldException.getError());
            }
        } else {
            objectException.addError("NOT_A_FIELD", exception.toString());
        }
    }
}

