/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.validation;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.validation.Validator;

public class ValidationFactory {
    private SemanticTypeResolver semanticTypeResolver;

    public ValidationFactory() {
        this.semanticTypeResolver = new SemanticTypeResolver();
    }

    public ValidationFactory(ClassLoader loader, SemanticTypeCache cache) {
        this.semanticTypeResolver = new SemanticTypeResolver(loader, cache);
    }

    public ValidationFactory(SemanticTypeResolver semanticTypeResolver) {
        this.semanticTypeResolver = semanticTypeResolver;
    }

    public boolean existsValidatorForType(String semanticType) {
        try {
            Class<?> clazz = this.semanticTypeResolver.resolveSemanticType(semanticType);
            return this.existsValidatorForClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean existsValidatorForType(SemanticType semanticType) {
        return this.existsValidatorForClass(semanticType.getClassName());
    }

    public boolean existsValidatorForClass(String className) {
        return this.existsValidatorForType(className);
    }

    public boolean existsValidatorForClass(Class<?> clazz) {
        String validatorClassName = SdoUtils.getValidatorClassName(clazz.getName());
        try {
            Class validatorClass = ClassUtils.loadClass(validatorClassName, this.semanticTypeResolver.getClassLoader());
            if (validatorClass != null && Validator.class.isAssignableFrom(validatorClass)) {
                return true;
            }
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to load validator class '" + validatorClassName + "' for class '" + clazz.getName() + "', cause: " + String.valueOf(exception));
        }
        return false;
    }

    public Validator lookupValidatorForType(String semanticType) {
        try {
            Class<?> clazz = this.semanticTypeResolver.resolveSemanticType(semanticType);
            return this.lookupValidatorForClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Validator lookupValidatorForType(SemanticType semanticType) {
        return this.lookupValidatorForClass(semanticType.getClassName());
    }

    public Validator lookupValidatorForClass(String className) {
        return this.lookupValidatorForType(className);
    }

    public Validator lookupValidatorForClass(Class<?> clazz) {
        String validatorClassName = SdoUtils.getValidatorClassName(clazz.getName());
        try {
            Class validatorClass = ClassUtils.loadClass(validatorClassName, this.semanticTypeResolver.getClassLoader());
            if (validatorClass != null && Validator.class.isAssignableFrom(validatorClass)) {
                return (Validator)validatorClass.newInstance();
            }
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to load validator class '" + validatorClassName + "' for class '" + clazz.getName() + "', cause: " + String.valueOf(exception));
        }
        return null;
    }
}

