/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.validation;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.excp.ValidationError;
import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sdo.validation.FieldValidationException;
import com.streamscape.sdo.validation.ValidationFactory;
import com.streamscape.sdo.validation.Validator;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.sef.moderator.DomainConstraintReference;
import com.streamscape.sef.moderator.RangeConstraintReference;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationClasses {
    protected static String makeArrayFieldName(String name, Object key) {
        return name + "[" + String.valueOf(key) + "]";
    }

    public static class SemanticTypeFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            Class clazz = (Class)params[0];
            try {
                ValidationFactory factory = new ValidationFactory();
                Validator validator = factory.lookupValidatorForClass(clazz);
                if (validator != null) {
                    validator.validate(value);
                }
            }
            catch (ValidationException exception) {
                FieldValidationException fieldValidationException = new FieldValidationException(fieldName, exception.getMessage());
                for (ValidationError error : exception.getErrors()) {
                    fieldValidationException.addFieldException(new FieldValidationException(fieldName + "/" + error.name, error.value));
                }
                throw fieldValidationException;
            }
        }
    }

    public static class RegexpFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, Pattern.class);
            Pattern regexp = (Pattern)params[0];
            String s = value.toString();
            Matcher matcher = regexp.matcher(s);
            if (!matcher.find() || !matcher.group().equals(s)) {
                throw new FieldValidationException(fieldName, value, "doesn't match to regexp '" + regexp.pattern() + "'.");
            }
        }
    }

    public static class PrecisionAndScaleValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, Integer.class, Integer.class);
            Integer precision = (Integer)params[0];
            Integer scale = (Integer)params[1];
            if (!(value instanceof Number)) {
                return;
            }
            BigDecimal b = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
            if (precision > 0 && b.precision() > precision) {
                throw new FieldValidationException(fieldName, value, " precision is more then max " + precision + ".");
            }
            if (scale > 0 && b.scale() > scale) {
                throw new FieldValidationException(fieldName, value, " scale is more then max " + scale + ".");
            }
        }
    }

    public static class InNamedRangeFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, String.class);
            String rangeName = (String)params[0];
            if (!(value instanceof Number) && !(value instanceof Date)) {
                throw new FieldValidationException(fieldName, value, "of class '" + String.valueOf(value.getClass()) + "' not allowed in range '" + rangeName + "'.");
            }
            InNamedRangeFieldValidator.validateInNamedRange(fieldName, value, rangeName);
        }

        protected static void validateInNamedRange(String fieldName, Object value, String rangeName) throws FieldValidationException {
            RangeConstraintReference rangeReference = null;
            rangeReference = RuntimeContext.getInstance().getModerator().lookupRangeConstraint(rangeName);
            if (rangeReference == null) {
                throw new FieldValidationException(fieldName, "range constraint '" + rangeName + "' does not exist.");
            }
            if (!rangeReference.matchesValue(value)) {
                throw new FieldValidationException(fieldName, value, "is out of range '" + rangeReference.getName() + "'.");
            }
        }
    }

    public static class InRangeFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, List.class);
            List range = (List)params[0];
            if (!(value instanceof Comparable)) {
                new FieldValidationException(fieldName, value, "of class '" + String.valueOf(value.getClass()) + "' not comparable.");
            }
            boolean inRange = false;
            for (Map.Entry entry : range) {
                if (((Comparable)value).compareTo((Comparable)entry.getKey()) < 0 || ((Comparable)value).compareTo((Comparable)entry.getValue()) > 0) continue;
                inRange = true;
                break;
            }
            if (!inRange) {
                throw new FieldValidationException(fieldName, value, "is out of range.");
            }
        }
    }

    public static class InNamedDomainFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, String.class);
            String domainName = (String)params[0];
            DomainConstraintReference domainReference = InNamedDomainFieldValidator.lookupDomain(fieldName, domainName);
            boolean ok = false;
            if (!(value instanceof Integer || value instanceof Double || value instanceof Long || value instanceof BigDecimal || value instanceof String || value instanceof Date)) {
                throw new FieldValidationException(fieldName, value, "of class '" + String.valueOf(value.getClass()) + "' not allowed in domain '" + domainName + "'.");
            }
            ok = domainReference.matchesValue(value);
            if (!ok) {
                throw new FieldValidationException(fieldName, value, "is not in domain '" + domainName + "'.");
            }
        }

        protected static DomainConstraintReference lookupDomain(String fieldName, String domainName) throws FieldValidationException {
            DomainConstraintReference domainReference = null;
            domainReference = RuntimeContext.getInstance().getModerator().lookupDomainConstraint(domainName);
            if (domainReference == null) {
                throw new FieldValidationException(fieldName, "domain constraint '" + domainName + "' does not exist.");
            }
            return domainReference;
        }
    }

    public static class InDomainFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, List.class);
            List domain = (List)params[0];
            if (!domain.contains(value)) {
                throw new FieldValidationException(fieldName, value, "is not in domain.");
            }
        }
    }

    public static class InEnumFieldValidator
    extends AbstractFieldValidator {
        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertParamType(fieldName, params, Class.class);
            Class clazz = (Class)params[0];
            if (!(value instanceof String)) {
                throw new FieldValidationException(fieldName, value, "is not String and cannot be in Enum '" + clazz.getName() + "'.");
            }
            if (!EnumType.isValueFromEnum(clazz, (String)value)) {
                throw new FieldValidationException(fieldName, value, " is not in Enum '" + clazz.getName() + "'.");
            }
        }
    }

    public static class MapValuesFieldValidator
    extends AbstractFieldValidator {
        private FieldValidator fieldValidator;

        public MapValuesFieldValidator(FieldValidator fieldValidator) {
            this.fieldValidator = fieldValidator;
        }

        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertValueType(fieldName, value, Map.class);
            this.assertParamType(fieldName, params, Class.class, Class.class);
            Map map = (Map)value;
            Class keyClass = (Class)params[0];
            Class valueClass = (Class)params[1];
            FieldValidationException exception = null;
            for (Map.Entry entry : map.entrySet()) {
                try {
                    this.fieldValidator.validate(ValidationClasses.makeArrayFieldName(fieldName, entry.getKey()), entry.getValue(), valueClass);
                }
                catch (FieldValidationException exception1) {
                    if (exception == null) {
                        exception = new FieldValidationException(fieldName);
                    }
                    exception.addFieldException(exception1);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public static class ArrayFieldValidator
    extends AbstractFieldValidator {
        private FieldValidator fieldValidator;

        public ArrayFieldValidator(FieldValidator fieldValidator) {
            this.fieldValidator = fieldValidator;
        }

        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertValueType(fieldName, value, Object[].class);
            Object[] array = (Object[])value;
            FieldValidationException exception = null;
            for (int i = 0; i < array.length; ++i) {
                try {
                    this.fieldValidator.validate(ValidationClasses.makeArrayFieldName(fieldName, i), array[i], params);
                    continue;
                }
                catch (FieldValidationException exception1) {
                    if (exception == null) {
                        exception = new FieldValidationException(fieldName);
                    }
                    exception.addFieldException(exception1);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public static class ListFieldValidator
    extends AbstractFieldValidator {
        private FieldValidator fieldValidator;

        public ListFieldValidator(FieldValidator fieldValidator) {
            this.fieldValidator = fieldValidator;
        }

        @Override
        void onValidate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            this.assertValueType(fieldName, value, List.class);
            List list = (List)value;
            FieldValidationException exception = null;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    this.fieldValidator.validate(ValidationClasses.makeArrayFieldName(fieldName, i), list.get(i), params);
                    continue;
                }
                catch (FieldValidationException exception1) {
                    if (exception == null) {
                        exception = new FieldValidationException(fieldName);
                    }
                    exception.addFieldException(exception1);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public static class NotNullFieldValidator
    implements FieldValidator {
        @Override
        public void validate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            if (value == null) {
                throw new FieldValidationException(fieldName, "null value is not allowed for this field.");
            }
        }
    }

    public static abstract class AbstractFieldValidator
    implements FieldValidator {
        public static FieldValidator createValidator(Object value, FieldValidator validator) {
            if (value == null) {
                return validator;
            }
            if (value instanceof List) {
                return new ListFieldValidator(validator);
            }
            if (value.getClass().isArray()) {
                return new ArrayFieldValidator(validator);
            }
            if (value instanceof Map) {
                return new MapValuesFieldValidator(validator);
            }
            return validator;
        }

        @Override
        public void validate(String fieldName, Object value, Object ... params) throws FieldValidationException {
            if (value == null) {
                return;
            }
            this.onValidate(fieldName, value, params);
        }

        abstract void onValidate(String var1, Object var2, Object ... var3) throws FieldValidationException;

        protected void assertValueType(String fieldName, Object value, Class<?> clazz) throws FieldValidationException {
            if (value == null) {
                return;
            }
            if (!clazz.isAssignableFrom(value.getClass())) {
                String message = "System exception: wrong value parameter passed in validator for field " + fieldName + ", expected " + clazz.getName() + " instead of " + value.getClass().getName() + ".";
                Trace.logError(this, message);
                throw new FieldValidationException(fieldName, message);
            }
        }

        protected void assertParamType(String fieldName, Object[] params, Class<?> ... expected) throws FieldValidationException {
            if (params.length != expected.length) {
                String message = "System exception: wrong parameters count passed to validator for field " + fieldName + ", expected " + expected.length + " instead of " + params.length + ".";
                Trace.logError(this, message);
                throw new FieldValidationException(fieldName, message);
            }
            for (int i = 0; i < params.length; ++i) {
                if (expected[i] == null || params[i] == null || expected[i].isAssignableFrom(params[i].getClass())) continue;
                String message = "System exception: wrong parameter parameter[" + i + "] passed in validator for field " + fieldName + ", expected " + expected[i].getName() + " instead of " + params[i].getClass().getName() + ".";
                Trace.logError(this, message);
                throw new FieldValidationException(fieldName, message);
            }
        }
    }

    public static interface FieldValidator {
        public void validate(String var1, Object var2, Object ... var3) throws FieldValidationException;
    }
}

