/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.validation;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FieldValidationException
extends Exception {
    private String fieldName;
    private String error;
    protected List<Exception> exceptions = new ArrayList<Exception>();

    public FieldValidationException(String fieldName) {
        this(fieldName, (String)null);
    }

    public FieldValidationException(String fieldName, String error) {
        this.fieldName = fieldName;
        this.error = error;
    }

    public FieldValidationException(String fieldName, Object value, String error) {
        this(fieldName, "value " + FieldValidationException.escapeValue(value) + " " + error);
    }

    public void addFieldException(Exception exception) {
        this.exceptions.add(exception);
    }

    public List<Exception> getFieldsExceptions() {
        return this.exceptions;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getPrefix() {
        return "Validation failed for field '" + this.fieldName + "'.";
    }

    public String getError() {
        return this.error;
    }

    @Override
    public String getMessage() {
        Object message = this.getPrefix();
        if (this.getError() != null && this.getError().length() > 0) {
            message = (String)message + " " + this.getError();
        }
        for (Exception exception : this.exceptions) {
            message = (String)message + " " + exception.getMessage();
        }
        return message;
    }

    public static String escapeValue(Object value) {
        if (value == null) {
            return "[null]";
        }
        if (value instanceof String || value instanceof Date || value instanceof java.sql.Date || value instanceof Timestamp) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof BigDecimal) {
            return value.toString();
        }
        if (value instanceof byte[]) {
            Object data = "0x";
            for (byte b : (byte[])value) {
                data = (String)data + String.format("%02X ", b);
            }
            return data;
        }
        return "'" + value.toString() + "'";
    }
}

