/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class TaskModelCategory {
    public static final String TASKMODELCATEGORY_NAMESPACE = "/shared/scheduler/task/categories";
    private String categoryName;
    private String displayName;
    private byte[] icon;
    private List<String> taskModels = new ArrayList<String>();
    private String description;
    private CategoryColor color = new CategoryColor(212, 208, 200, 255);

    public TaskModelCategory() {
    }

    public TaskModelCategory(String categoryName) {
        this.categoryName = categoryName;
    }

    public TaskModelCategory(String categoryName, byte[] icon) {
        this.categoryName = categoryName;
        this.icon = icon;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public void setIcon(byte[] icon) {
        this.icon = icon;
    }

    public List<String> listTaskModels() {
        if (this.taskModels == null) {
            this.taskModels = new ArrayList<String>();
        }
        return this.taskModels;
    }

    public void clearTaskModels() {
        this.taskModels.clear();
    }

    public void addTaskModel(String taskModel) {
        if (this.taskModels == null) {
            this.taskModels = new ArrayList<String>();
        }
        this.taskModels.add(taskModel);
    }

    public void removeTaskModel(String taskModel) {
        if (this.taskModels == null) {
            this.taskModels = new ArrayList<String>();
        }
        this.taskModels.remove(taskModel);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Color getColor() {
        return this.color == null ? new Color(212, 208, 200, 255) : new Color(this.color.red, this.color.green, this.color.blue, this.color.alpha);
    }

    public void setColor(Color color) {
        this.color = new CategoryColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static class CategoryColor {
        public int red;
        public int green;
        public int blue;
        public int alpha;

        public CategoryColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }
    }
}

