/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.utils;

import com.streamscape.Trace;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.CloneableObject;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.SystemAdvisories;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.SystemEvents;
import com.streamscape.sdo.excp.SystemExceptions;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.dispatcher.ReservedSubjects;
import com.streamscape.sef.mf.admin.FabricContext;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SDOUtils
extends AbstractFabricContextFactory {
    public static Object clone(Object object) throws SDOException {
        if (object instanceof CloneableObject) {
            return ((CloneableObject)object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object == null || object instanceof Boolean || object instanceof Number || object instanceof String || object instanceof Enum) {
            return object;
        }
        if (object.getClass().isArray()) {
            Object[] src = (Object[])object;
            Object[] result = (Object[])Array.newInstance(object.getClass().getComponentType(), src.length);
            for (int i = 0; i < src.length; ++i) {
                result[i] = SDOUtils.clone(src[i]);
            }
            return result;
        }
        return SDOUtils.cloneByJSerializer(object);
    }

    public static Object cloneByJSerializer(Object object) throws SDOException {
        try {
            JSerializer serializer = JSerializerFactory.getInstance().getDefaultSerializer();
            byte[] objectBytes = serializer.serialize(object);
            return serializer.deserialize(objectBytes);
        }
        catch (Exception exception) {
            throw new SDOException("Cloning of object using JSerializer failed.", exception);
        }
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            try {
                Method method = obj1.getClass().getMethod("equals", Object.class);
                if (!method.getDeclaringClass().equals(Object.class)) {
                    return obj1.equals(obj2);
                }
                return SDOUtils.equalsByJSerializer(obj1, obj2);
            }
            catch (NoSuchMethodException exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean equalsByJSerializer(Object obj1, Object obj2) {
        try {
            JSerializer serializer = JSerializerFactory.getInstance().getDefaultSerializer();
            return Arrays.equals(serializer.serialize(obj1), serializer.serialize(obj2));
        }
        catch (Exception exception) {
            Trace.logException(SDOUtils.class, exception, true);
            Trace.logError(SDOUtils.class, "Comparison of objects using JSerializer failed.");
            return false;
        }
    }

    public static void validateEventId(String eventId) throws SDOFormatException {
        if (!StringUtils.validateEventId(eventId)) {
            throw new SDOFormatException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
    }

    public static void addAdvisoryPrototype(String model, String eventId) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addAdvisoryPrototype(model, eventId);
        }
    }

    public static void addAdvisoryPrototype(String eventId, AdvisoryEventDatagram event) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addAdvisoryPrototype(eventId, event);
        }
    }

    public static void addEventPrototype(String model, String eventId) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addEventPrototype(model, eventId);
        }
    }

    public static void addEventPrototype(String eventId, EventDatagram event) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addEventPrototype(eventId, event);
        }
    }

    public static void addDataEventPrototype(String eventId, String dataType) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addDataEventPrototype(eventId, dataType);
        }
    }

    public static void addDataEventPrototype(String eventId, CloneableDataObject data) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addDataEventPrototype(eventId, data);
        }
    }

    public static void addDataEventPrototype(String eventId, DataEvent event) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addDataEventPrototype(eventId, event);
        }
    }

    public static void addDeltaEventPrototype(String eventId, String dataType) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addDeltaEventPrototype(eventId, dataType);
        }
    }

    public static void addDeltaEventPrototype(String eventId, CloneableDataObject data) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addDeltaEventPrototype(eventId, data);
        }
    }

    public static void addDeltaEventPrototype(String eventId, DeltaEvent event) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addDeltaEventPrototype(eventId, event);
        }
    }

    public static void addOpaqueEventPrototype(String eventId, String dataType) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addOpaqueEventPrototype(eventId, dataType);
        }
    }

    public static void addOpaqueEventPrototype(String eventId, CloneableDataObject data) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addOpaqueEventPrototype(eventId, data);
        }
    }

    public static void addOpaqueEventPrototype(String eventId, OpaqueEvent event) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addOpaqueEventPrototype(eventId, event);
        }
    }

    public static void addExceptionPrototype(String model, String eventId) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addExceptionPrototype(model, eventId);
        }
    }

    public static void addExceptionPrototype(String eventId, ExceptionEventDatagram event) throws DatagramFactoryException {
        if (!PrototypeFactory.existsPrototype(eventId)) {
            PrototypeFactory.addExceptionPrototype(eventId, event);
        }
    }

    public static DataEvent createDataEvent(String eventId, Object data) throws DatagramFactoryException, SDOException, SecurityViolationException {
        DataEvent result = (DataEvent)EventDatagramFactory.getInstance().createEvent(eventId);
        result.setData(data);
        return result;
    }

    public static OpaqueEvent createOpaqueEvent(String eventId, Object data) throws DatagramFactoryException, SDOException, SecurityViolationException {
        OpaqueEvent result = (OpaqueEvent)OpaqueDatagramFactory.getInstance().createEvent(eventId);
        result.setData(data);
        return result;
    }

    public static Object createDataObject(String semanticType) throws DatagramFactoryException {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticType(semanticType);
        if (type == null) {
            throw new DatagramFactoryException(5014, ErrorMessages.format("Semantic type [%1$s] does not exist.", semanticType));
        }
        SDOUtils.checkSemanticType(type);
        return SDOUtils.createDataObject(type);
    }

    public static Object createDataObject(SemanticType type) throws DatagramFactoryException {
        try {
            return ClassUtils.createFromClassName(SDOUtils.class, type.getClassName(), context.getSystemClassLoaderChain());
        }
        catch (UtilitiesException exception) {
            throw new DatagramFactoryException(5040, "Creation of payload instance failed.", exception);
        }
    }

    public static void checkDataClass(FabricContext context, Class dataClass) throws DatagramFactoryException {
        if (dataClass == null) {
            throw new DatagramFactoryException(5004, ErrorMessages.format("%1$s is null.", "Payload class"));
        }
        SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(dataClass);
        if (type == null) {
            throw new DatagramFactoryException(5040, "Semantic type does not exist for payload class '" + dataClass.getName() + "'.");
        }
        SDOUtils.checkSemanticType(type);
    }

    private static void checkSemanticType(SemanticType semanticType) throws DatagramFactoryException {
        String ancestorType = semanticType.getAncestorType();
        if (ancestorType != null && (ancestorType.equals("event") || ancestorType.equals("datagram") || ancestorType.equals("opaque") || ancestorType.equals("advisory") || ancestorType.equals("exception"))) {
            throw new DatagramFactoryException(5040, "Semantic type of event payload cannot be a descendant of ImmutableEventDatagram.");
        }
    }

    public static boolean isSystemEventId(String eventId) {
        return ReservedSubjects.isReserved(eventId) || SystemEvents.isSystem(eventId) || SystemAdvisories.isSystem(eventId) || SystemExceptions.isSystem(eventId);
    }

    public static Map<String, String> findSDOElements(final Object object, final String regex, final String pathPrefix, final ReferencePathManager sdrManager, final TypeAnalyzer typeAnalyzer) throws TypeAnalyzerException {
        final LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        typeAnalyzer.getTypeGraph(object.getClass()).traverse(new TypeGraphVisitor(){

            @Override
            public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
                String path = node.getPath();
                Object fullPath = pathPrefix + path;
                fullPath = StringUtils.removeEnd((String)fullPath, "/");
                try {
                    Object value = sdrManager.getValueAtPath("/" + path, object);
                    if (value instanceof String) {
                        String str = (String)value;
                        if (str.matches(regex)) {
                            String p = StringUtils.removeEnd((String)fullPath, "/");
                            result.put(p, str);
                        }
                    } else {
                        if (value instanceof List) {
                            List l = (List)value;
                            for (int i = 0; i < l.size(); ++i) {
                                result.putAll(SDOUtils.findSDOElements(l.get(i), regex, (String)fullPath + "[" + i + "]/", sdrManager, typeAnalyzer));
                            }
                            return false;
                        }
                        if (value instanceof Map) {
                            Iterator iterator = ((Map)value).entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry o;
                                Map.Entry e = o = iterator.next();
                                result.putAll(SDOUtils.findSDOElements(e.getValue(), regex, (String)fullPath + "[key=" + String.valueOf(e.getKey()) + "]/", sdrManager, typeAnalyzer));
                            }
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
            }
        });
        return result;
    }
}

