/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.utils;

import com.streamscape.Trace;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import java.util.Set;

public class EventPrototypeComparator {
    private static RuntimeContext runtimeCtx = null;

    public static void compare(String eventId1, String eventId2) throws UtilitiesException {
        if (runtimeCtx == null) {
            runtimeCtx = RuntimeContext.getInstance();
        }
        try {
            Prototype proto1 = EventPrototypeComparator.getPrototype(eventId1);
            Prototype proto2 = EventPrototypeComparator.getPrototype(eventId2);
            if (!proto1.getModelName().equals(proto2.getModelName())) {
                throw new UtilitiesException("Event prototypes '" + eventId1 + "' and '" + eventId2 + "' have different models.");
            }
            ImmutableEventDatagram event1 = EventPrototypeComparator.getPrototypeInstance(eventId1, proto1);
            ImmutableEventDatagram event2 = EventPrototypeComparator.getPrototypeInstance(eventId2, proto2);
            if (event1 instanceof EventDatagram && event2 instanceof EventDatagram) {
                EventDatagram datagram1 = (EventDatagram)event1;
                EventDatagram datagram2 = (EventDatagram)event2;
                Set<String> propSet1 = datagram1.getEventPropertyNames();
                Set<String> propSet2 = datagram2.getEventPropertyNames();
                if (propSet1.size() != propSet2.size() || !propSet1.containsAll(propSet2) || !propSet2.containsAll(propSet1)) {
                    throw new UtilitiesException("Event prototypes '" + eventId1 + "' and '" + eventId2 + "' have different sets of properties.");
                }
                Set<String> annotationsSet1 = datagram1.getAnnotatedProperties();
                Set<String> annotationsSet2 = datagram2.getAnnotatedProperties();
                if (annotationsSet1.size() != annotationsSet2.size() || !annotationsSet1.containsAll(annotationsSet2) || !annotationsSet2.containsAll(annotationsSet1)) {
                    throw new UtilitiesException("Event prototypes '" + eventId1 + "' and '" + eventId2 + "' have different sets of annotations.");
                }
                if (event1 instanceof DataEvent && event2 instanceof DataEvent) {
                    Object value1 = ((DataEvent)event1).getData();
                    Object value2 = ((DataEvent)event1).getData();
                    if (value1 != null ? value2 == null || !value1.getClass().getName().equals(value2.getClass().getName()) : value2 != null) {
                        throw new UtilitiesException("DataEvent prototypes '" + eventId1 + "' and '" + eventId2 + "' have different payloads.");
                    }
                }
            }
        }
        catch (SDOException error) {
            Trace.logException(EventPrototypeComparator.class, error, true);
            throw new UtilitiesException(error.getMessage());
        }
        catch (SecurityViolationException error) {
            Trace.logException(EventPrototypeComparator.class, error, true);
            throw new UtilitiesException(error.getMessage());
        }
    }

    public static void setRuntimeContext(RuntimeContext ctx) {
        runtimeCtx = ctx;
    }

    private static Prototype getPrototype(String proto) throws UtilitiesException {
        Prototype eventPrototype = runtimeCtx.getDatagramPrototypeCache().lookupPrototype(proto);
        if (eventPrototype == null) {
            throw new UtilitiesException("Event prototype [" + proto + "] does not exist.");
        }
        return eventPrototype;
    }

    private static ImmutableEventDatagram getPrototypeInstance(String proto, Prototype eventPrototype) throws UtilitiesException {
        DatagramFactory factory = runtimeCtx.getDatagramFactoryManager().lookupDatagramFactoryByModel(eventPrototype.getModelName());
        if (factory == null) {
            throw new UtilitiesException("Unable to resolve Datagram Factory for specified prototype [" + String.valueOf(eventPrototype) + "].");
        }
        try {
            return factory.createEvent(proto);
        }
        catch (Exception error) {
            Trace.logError(EventPrototypeComparator.class, error.getMessage());
            throw new UtilitiesException(error);
        }
    }
}

